/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.profilecard.base;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AnchorLevelConfig;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.bean.RoomlistEventBean;
import com.yy.hiyo.channel.base.hiido.FollowStatisHelper;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IChannelHonorService;
import com.yy.hiyo.channel.base.service.IOperationCallback;
import com.yy.hiyo.channel.base.service.IProfileCardHonorCallback;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.bottombar.BottomPresenter;
import com.yy.hiyo.channel.component.profile.fanslv.FansGroupConfig;
import com.yy.hiyo.channel.component.profile.fanslv.FansGroupData;
import com.yy.hiyo.channel.component.profile.giftwall.GiftWallPresenter;
import com.yy.hiyo.channel.component.profile.giftwall.IGiftWallCallback;
import com.yy.hiyo.channel.component.profile.honor.HonorPresenter;
import com.yy.hiyo.channel.component.profile.profilecard.MiniCardBgInfo;
import com.yy.hiyo.channel.component.profile.profilecard.base.FunctionInterceptor;
import com.yy.hiyo.channel.component.profile.profilecard.base.IBaseCallback;
import com.yy.hiyo.channel.component.profile.profilecard.base.IDataProvider;
import com.yy.hiyo.channel.component.profile.profilecard.base.IOperationStrategy;
import com.yy.hiyo.channel.component.profile.profilecard.base.InterceptCallback;
import com.yy.hiyo.channel.component.profile.profilecard.base.SeatUpdateNotifier;
import com.yy.hiyo.channel.component.profile.profilecard.helper.ProfileCardStatistics;
import com.yy.hiyo.channel.component.setting.report.ChannelReportPresenter;
import com.yy.hiyo.channel.plugins.general.innerpresenter.GameOpenChannelPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.multivideo.IMultiVideoPresenter;
import com.yy.hiyo.relation.base.follow.FollowMsgDef;
import com.yy.hiyo.user.base.NavigationUtils;
import com.yy.hiyo.user.base.profilecard.OpenProfileFrom;
import com.yy.webservice.WebEnvSettings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public class ProfileCardPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements IBaseCallback,
IDataProvider {
    private static final String TAG = "ProfileCardPresenter";
    private static final String KEY_FAMILY_ID = "familyId";
    private static final String UID = "uid";
    protected IOperationStrategy mOperationStrategy;
    private FunctionInterceptor mFunctionInterceptor;

    public void showProfileCard(long uid, @Nonnull OpenProfileFrom from) {
        if (this.isDestroyed()) {
            return;
        }
        ArrayList<Long> uids = new ArrayList<Long>();
        uids.add(uid);
        this.showProfileCard(uid, true, from);
    }

    public void showProfileCard(long uid, boolean inChannel, @Nonnull OpenProfileFrom from) {
    }

    public void showProfileCard(long uid, boolean inChannel, @Nonnull OpenProfileFrom from, @Nullable Boolean isShowMention, @Nullable String targetCid, @Nullable Long targetChannelOwnerUid) {
        this.showProfileCard(uid, inChannel, from);
    }

    public void setOperationStrategy(IOperationStrategy operationStrategy) {
        this.mOperationStrategy = operationStrategy;
    }

    public void setFunctionInterceptor(@NonNull FunctionInterceptor functionInterceptor) {
        this.mFunctionInterceptor = functionInterceptor;
    }

    protected SeatUpdateNotifier createSeatUpdateNotifier() {
        return new SeatUpdateNotifier(){

            @Override
            protected void registerListeners(List<ISeatUpdateListener> listeners) {
                if (!ProfileCardPresenter.this.isDestroyed() && !FP.empty(listeners)) {
                    ISeatService seatService2 = ProfileCardPresenter.this.getChannel().getSeatService();
                    for (ISeatUpdateListener listener2 : listeners) {
                        seatService2.addSeatUpdateListener(listener2);
                    }
                }
            }

            @Override
            protected void removeListeners(List<ISeatUpdateListener> listeners) {
                if (!ProfileCardPresenter.this.isDestroyed() && !FP.empty(listeners)) {
                    ISeatService seatService2 = ProfileCardPresenter.this.getChannel().getSeatService();
                    for (ISeatUpdateListener listener2 : listeners) {
                        seatService2.removeSeatUpdateListener(listener2);
                    }
                }
            }
        };
    }

    @Override
    public void onAvatarClick(long uid) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        MLog.info((Object)TAG, (String)"open profile window:%s", (Object[])new Object[]{this.getChannel().getChannelId()});
        NavigationUtils.navigateToProfilePage((long)uid, (String)this.getChannel().getChannelId());
        ProfileCardStatistics.INSTANCE.reportAvatarClick((IChannel)this.getChannel());
    }

    @Override
    public void onMentioned(UserInfoKS userInfo) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        if (userInfo == null) {
            return;
        }
        String channelId = this.getChannel().getChannelId();
        BottomPresenter inputPresenter = (BottomPresenter)this.getPresenter(BottomPresenter.class);
        if (inputPresenter != null) {
            RoomTrack.INSTANCE.reportAtPeopleClick(channelId, userInfo.uid + "", "2");
            FeatureLog.i((String)"FTMention", (String)"showInputDialog, name:%s, uid:%s", (Object[])new Object[]{userInfo.nick, userInfo.uid});
            inputPresenter.showInputDialog("@" + userInfo.nick, true, userInfo.nick, userInfo.uid);
        }
        ChannelTrack.INSTANCE.onProfileCardAtClick();
    }

    @Override
    public void onReport(long uid, String targetChannelId, long targetChannelOwnerId) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        ((ChannelReportPresenter)this.getPresenter(ChannelReportPresenter.class)).showUserReportPopup((Context)((IChannelPageContext)this.getMvpContext()).getContext(), uid, targetChannelId, targetChannelOwnerId);
    }

    @Override
    public void onSetting(long uid, String targetChannelId, long targetChannelOwnerId, String roomSource) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        Message msg = Message.obtain();
        msg.what = this.getPluginId().equals("base") ? AppbaseMsgDef.ChannelMsgDef.OPEN_WINDOW_MINI_MEMBER_SETTING : AppbaseMsgDef.ChannelMsgDef.OPEN_ROOM_MINI_MEMBER_SETTING;
        Bundle bundle = new Bundle();
        bundle.putString("currentGroupId", this.getChannel().getChannelId());
        bundle.putLong("otherUserUid", uid);
        bundle.putString("userGroupId", targetChannelId);
        bundle.putLong("otherOwnerUid", targetChannelOwnerId);
        bundle.putString("room_source", roomSource);
        msg.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(msg);
        ChannelTrack.INSTANCE.onMiniProfileSettingClick();
    }

    @Override
    public void onKickOut(final long uid) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        InterceptCallback callback2 = () -> {
            if (this.isDestroyed()) {
                return;
            }
            this.getChannel().kickoff(uid, new IChannel.IKickOffCallBack(){

                public void onSuccess(String channelId, long uid2, long onlineNum) {
                    ToastUtils.showToast((Context)((IChannelPageContext)ProfileCardPresenter.this.getMvpContext()).getContext(), (String)ResourceUtils.getString((int)R.string.short_tips_kick_off_success), (int)0);
                    MLog.info((Object)ProfileCardPresenter.TAG, (String)"kickOutUser uid=%d success", (Object[])new Object[]{uid2});
                }

                public void onNoPermission() {
                    ToastUtils.showToast((Context)((IChannelPageContext)ProfileCardPresenter.this.getMvpContext()).getContext(), (String)ResourceUtils.getString((int)R.string.short_tips_kick_off_no_permission), (int)0);
                    MLog.info((Object)ProfileCardPresenter.TAG, (String)"kickOutUser onNoPermission", (Object[])new Object[]{uid});
                }

                public void onError(int errorCode, String errorTips, Exception e) {
                    ToastUtils.showToast((Context)((IChannelPageContext)ProfileCardPresenter.this.getMvpContext()).getContext(), (String)ResourceUtils.getString((int)R.string.short_tips_kick_off_failed), (int)0);
                }
            });
        };
        if (this.mFunctionInterceptor != null) {
            this.mFunctionInterceptor.onKickOut(uid, callback2);
        } else {
            callback2.done();
        }
    }

    @Override
    public void onChangeMic(final long uid, final boolean open) {
        InterceptCallback callback2 = () -> {
            if (this.isDestroyed()) {
                return;
            }
            EnterParam enterParam = ((IChannelPageContext)this.getMvpContext()).getEnterChannelParams();
            RoomlistEventBean listBean = (RoomlistEventBean)enterParam.getExtra("ROOM_LIST_EVENT", null);
            String token = null;
            if (listBean != null && !TextUtils.isEmpty((CharSequence)listBean.getToken())) {
                token = listBean.getToken();
            }
            if (TextUtils.isEmpty(token)) {
                token = (String)enterParam.getExtra("token", null);
            }
            if (uid == AccountUtil.getUid()) {
                if (open) {
                    this.getChannel().getMediaService().enablePublishMic(1);
                    RoomTrack.INSTANCE.onVoiceRoomClickOpenMic(this.getChannelId(), "1", token);
                } else {
                    this.getChannel().getMediaService().disablePublishMic(1);
                    RoomTrack.INSTANCE.onVoiceRoomClickCloseMic(this.getChannelId(), "1", token);
                }
            } else {
                if (open) {
                    RoomTrack.INSTANCE.onVoiceRoomClickOpenMic(this.getChannelId(), "3", token);
                } else {
                    RoomTrack.INSTANCE.onVoiceRoomClickCloseMic(this.getChannelId(), "3", token);
                }
                this.getChannel().getMediaService().changeMicByOwner(uid, open, new IOperationCallback(){

                    public void onSuccess() {
                        MLog.info((Object)ProfileCardPresenter.TAG, (String)"\u9891\u9053\u4e3b/\u7ba1\u7406\u5458\u64cd\u4f5cuid:%d\u7528\u6237\u7684\u9ea6\u72b6\u6001\u4e3a%b\u6210\u529f", (Object[])new Object[]{uid, open});
                    }

                    public void onFail(long reason) {
                        if (reason == 1L) {
                            ToastUtils.showToast((Context)((IChannelPageContext)ProfileCardPresenter.this.getMvpContext()).getContext(), (String)ResourceUtils.getString((int)R.string.tips_channel_notice_no_permit), (int)0);
                        }
                        MLog.error((Object)ProfileCardPresenter.TAG, (String)"\u9891\u9053\u4e3b/\u7ba1\u7406\u5458\u64cd\u4f5cuid:%d\u7528\u6237\u7684\u9ea6\u72b6\u6001\u72b6\u6001\u4e3a%b\u5931\u8d25", (Object[])new Object[]{uid, open});
                    }
                });
            }
        };
        if (this.mFunctionInterceptor != null) {
            this.mFunctionInterceptor.onChangeMic(uid, open, callback2);
        } else {
            callback2.done();
        }
    }

    @Override
    public void onRemoveMember(final long uid) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        InterceptCallback callback2 = () -> {
            DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)((IChannelPageContext)this.getMvpContext()).getContext());
            OkCancelDialog dialog2 = new OkCancelDialog.Builder().message((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_remove_manager)).okLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_ok)).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_cancel)).cancelable(true).outSideCancelable(true).listener(new OkCancelDialogListener(){

                public void onCancel() {
                }

                public void onOk() {
                    ProfileCardPresenter.this.realRemoveMember(uid);
                }
            }).build();
            dialogLinkManager.showDialog((BaseDialog)dialog2);
        };
        if (this.mFunctionInterceptor != null) {
            this.mFunctionInterceptor.onRemoveMember(uid, callback2);
        } else {
            callback2.done();
        }
    }

    private void realRemoveMember(final long uid) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        ChannelTrack.INSTANCE.onMemberDeleteClick("1");
        final Runnable command = new Runnable(){

            @Override
            public void run() {
                ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(uid, new OnProfileCallback(){

                    public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                        if (!FP.empty(userInfoKSList)) {
                            UserInfoKS userInfoKS = userInfoKSList.get(0);
                            ToastUtils.showToast((Context)((IChannelPageContext)ProfileCardPresenter.this.getMvpContext()).getContext(), (String)ResourceUtils.getString((int)R.string.tips_channel_remove_manager_success, (Object[])new Object[]{userInfoKS.nick}), (int)1);
                        }
                    }

                    public void onFail(int id2, String msg, String response) {
                        MLog.error((Object)ProfileCardPresenter.TAG, (String)"onRemoveMember getUserInfo error", (Object[])new Object[0]);
                    }
                });
            }
        };
        this.getChannel().getRoleService().setRole(uid, 1, "0", new IRoleService.ISetRoleCallBack(){

            public void onSuccess(String channelId, long uid, boolean waitForAccept) {
                command.run();
            }

            public void onNoPermissionError(String cId) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_channel_no_permission), (int)0);
            }

            public void onFailByAlreadyIsThisRole(String cId) {
                command.run();
            }

            public void onFailByMemberReachLimit() {
            }

            public void onFailByJoinedChannelLimit() {
            }

            public void onHaveJoinedFamily(String channelId) {
            }

            public void onFailByJoinedLvLimit(String applyCId) {
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                MLog.error((Object)ProfileCardPresenter.TAG, (String)"setRole error, code=%d, msg=%s", (Object[])new Object[]{errorCode, errorTips});
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_channel_join_net_error), (int)0);
            }
        });
    }

    @Override
    public void onFollowingListClicked(long uid) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)((IChannelPageContext)this.getMvpContext()).getContext())) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            return;
        }
        Message message = Message.obtain();
        message.what = FollowMsgDef.OPEN_FOLLOW_LIST;
        Bundle bundle = new Bundle();
        bundle.putLong(UID, uid);
        message.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(message);
        FollowStatisHelper.reportFollowListEntranceClick((String)this.getChannel().getChannelId());
    }

    @Override
    public void onFansListClicked(long uid) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)((IChannelPageContext)this.getMvpContext()).getContext())) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            return;
        }
        Message message = Message.obtain();
        message.what = FollowMsgDef.OPEN_FANS_LIST;
        Bundle bundle = new Bundle();
        bundle.putLong(UID, uid);
        message.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(message);
        FollowStatisHelper.reportFansListEntranceClick();
    }

    @Override
    public boolean onMedalClick(int id2, long ownerUid) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return false;
        }
        return ((IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)).onMedalClick(id2, ownerUid);
    }

    @Override
    public void onMedalsClick(long uid, String url) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).loadUrl(this.getMedalsWallUrl(uid, url), "");
        ChannelTrack.INSTANCE.onHonorMedalClick(this.getChannelId(), 2, 0);
    }

    private String getMedalsWallUrl(long uid, String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            url = URLUtils.addParam((String)url, (String)UID, (String)("" + uid));
            return url;
        }
        return UriProvider.getMedalsWallUrl((long)uid);
    }

    @Override
    public void onAnchorLevelClick(long uid) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        AnchorLevelConfig config2 = (AnchorLevelConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.ANCHOR_LEVEL);
        if (config2 != null && config2.getAnchorLevelData() != null) {
            WebEnvSettings settings = new WebEnvSettings();
            settings.url = config2.getAnchorLevelData().getJumpUrl();
            settings.isFullScreen = false;
            settings.isShowBackBtn = true;
            settings.webViewBackgroundColor = -1;
            settings.usePageTitle = true;
            ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).loadUrl(settings);
        }
    }

    @Override
    public void onFamilyLevelClick(String fid) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(this.appendFamilyId(fid));
    }

    @Override
    public void onFansGroupClick(FansGroupData data2) {
        if (data2.getFansGroupConfig().getValue() == null) {
            return;
        }
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        ChannelTrack.INSTANCE.onMiniFansClick(data2.getAnchor(), data2.getLv(), data2.getTypeId());
        String url = URLUtils.addParam((String)((FansGroupConfig)data2.getFansGroupConfig().getValue()).getTypeConfigInfo().getJumpUrl(), (String)UID, (String)String.valueOf(data2.getAnchor()));
        ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(url);
    }

    @Override
    public void onGiftWallClick(String jumpUrl) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(jumpUrl);
    }

    @Override
    public void onChangeVideo(long uid, boolean open) {
    }

    @Override
    public void onCameraFlip(long uid) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        if (((IChannelPageContext)this.getMvpContext()).hasPresenter(IMultiVideoPresenter.class)) {
            ((IMultiVideoPresenter)this.getPresenter(IMultiVideoPresenter.class)).switchCamera();
        }
    }

    @Override
    public boolean interceptClick() {
        return ((GameOpenChannelPresenter)this.getPresenter(GameOpenChannelPresenter.class)).isOpenByGame();
    }

    private String appendFamilyId(String fid) {
        return URLUtils.addParam((String)UriProvider.getFamilyDetailUrl(), (String)KEY_FAMILY_ID, (String)fid);
    }

    @Override
    public void onGoldBeanClick() {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        String url = UriProvider.getRadioIncomeUrl((long)AccountUtil.getUid(), (String)this.getChannelId());
        WebEnvSettings settings = new WebEnvSettings();
        settings.url = url;
        settings.isShowBackBtn = false;
        settings.isFullScreen = true;
        settings.disablePullRefresh = true;
        settings.usePageTitle = false;
        settings.webViewBackgroundColor = ResourceUtils.getColor((int)R.color.transparent);
        settings.webWindowAnimator = false;
        settings.hideLastWindow = false;
        ((IWebService)ServiceManagerProxy.getService(IWebService.class)).loadUrl(settings);
    }

    @Override
    public void requestHonorList(long uid, @NotNull IProfileCardHonorCallback callback2) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            callback2.onFailed(-1L, "page has been destroyed");
            return;
        }
        IChannelHonorService honorService = (IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class);
        if (honorService == null) {
            return;
        }
        honorService.reqProfileCardHonor(uid, callback2);
    }

    @Override
    public void requestGiftWallEntrance(long uid, @NotNull IGiftWallCallback callback2) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        ((GiftWallPresenter)this.getPresenter(GiftWallPresenter.class)).requestGiftWallEntrance(uid, callback2);
    }

    @Override
    public void requestFansGroup(long uid, @NotNull ICommonCallback<FansGroupData> iCommonCallback) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
    }

    private boolean gamingInterceptClick() {
        if (this.interceptClick()) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_can_not_click_in_game);
            return true;
        }
        return false;
    }

    @Override
    public void requestBgInfo(long uid, @NotNull ICommonCallback<MiniCardBgInfo> iCommonCallback) {
        if (this.isDestroyed() || this.gamingInterceptClick()) {
            return;
        }
        ((HonorPresenter)this.getPresenter(HonorPresenter.class)).reqMiniCardBgInfo(uid, iCommonCallback);
    }
}

