/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.profilecard.base;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.framework.core.ui.svga.YYSvgaImageView;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.bean.FamilyInfoBean;
import com.yy.hiyo.channel.base.bean.HonorBean;
import com.yy.hiyo.channel.base.bean.TeamUpGameInfoBean;
import com.yy.hiyo.channel.base.bean.UserTagInfo;
import com.yy.hiyo.channel.base.bean.UserTagLocation;
import com.yy.hiyo.channel.base.callback.IUserTagItemClickListener;
import com.yy.hiyo.channel.base.utils.NationalFlagUtils;
import com.yy.hiyo.channel.base.widget.UserTagsLayout;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.component.base.util.PrivilegeHelper;
import com.yy.hiyo.channel.component.profile.fanslv.FansGroupConfig;
import com.yy.hiyo.channel.component.profile.fanslv.FansGroupData;
import com.yy.hiyo.channel.component.profile.giftwall.GiftWallEntranceData;
import com.yy.hiyo.channel.component.profile.giftwall.GiftWallInfo;
import com.yy.hiyo.channel.component.profile.profilecard.MiniCardBgInfo;
import com.yy.hiyo.channel.component.profile.profilecard.base.DialogUiCallback;
import com.yy.hiyo.channel.component.profile.profilecard.base.LeftAction;
import com.yy.hiyo.channel.component.profile.profilecard.base.TeamUpCardCallback;
import com.yy.hiyo.channel.component.profile.profilecard.base.ViewProvider;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.medals.MedalItemBean;
import com.yy.hiyo.channel.component.profile.profilecard.widget.HorFunctionListView;
import com.yy.hiyo.channel.component.profile.profilecard.widget.ProfileCardGiftWallView;
import com.yy.hiyo.channel.component.profile.profilecard.widget.ProfileCardMedalsView;
import com.yy.hiyo.channel.component.profile.profilecard.widget.ProfileFamilyView;
import com.yy.hiyo.channel.component.profile.profilecard.widget.ProfileTeamUpView;
import com.yy.hiyo.channel.module.recommend.base.widget.MaxHeightScrollView;
import com.yy.hiyo.wallet.base.IUserIDView;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ProfileCardDialog
implements BaseDialog,
ProfileFamilyView.IProfileFamilyListener {
    private static final String TAG = "ProfileCardDialog";
    private Context mContext;
    private DialogUiCallback mDialogUiCallback;
    private View mContentView;
    private HeadFrameImageView mIvAvatar;
    private YYView mTopSpaceView;
    private YYTextView mTvUserName;
    private RecycleImageView mIvLeftAction;
    private YYTextView mReportTip;
    private TextView mTvMention;
    private YYTextView mTvSexAndAge;
    private YYTextView mTvLocation;
    private RecycleImageView mRoleIcon;
    private YYTextView mRoleName;
    private YYLinearLayout mRoleInfoLl;
    private HorFunctionListView mLiteBrowserListView;
    private HorFunctionListView mBrowserListView;
    private HorFunctionListView mBtnListView;
    private View mOperationView;
    private YYTextView mGoldenBean;
    private HorFunctionListView mOperationListView;
    private ViewProvider mViewProvider;
    private ProfileCardMedalsView mProfileCardMedalsView;
    private ProfileCardGiftWallView mProfileCardGiftWallView;
    private YYView divideLine;
    private LinearLayout mOtherFansView;
    private YYTextView mTvOtherFans;
    private RecycleImageView mNationFlagIv;
    private YYFrameLayout mNationFlagLayout;
    private YYLinearLayout mAnchorLevelLayout;
    private YYFrameLayout mFansGroupLayout;
    private YYTextView mFansGroupName;
    private RecycleImageView mFansGroupImg;
    private RecycleImageView mAnchorLevelIcon;
    private YYTextView mAnchorLevelName;
    private IUserIDView mIUserIDView;
    private ViewGroup llTop;
    private FansGroupData fansGroupData;
    private UserTagsLayout mUserTagsLayout;
    private YYTextView mTvChannelNick;
    private Animation mAnimation;
    private YYSvgaImageView bgBodyImg;
    private YYSvgaImageView bgHeadImg;
    private View defaultBgView;
    private RecycleImageView mIvStatusBadge;
    private ProfileFamilyView mProfileFamilyView;
    private YYPlaceHolderView mFamilyHolderView;
    private ProfileTeamUpView mProfileTeamUpView;
    private YYPlaceHolderView mTeamUpHolderView;
    private Dialog mDialog;
    private View mGiftMedalContainer;
    private MaxHeightScrollView mMhSlInfoView;

    public ProfileCardDialog(@NonNull Context context, @NonNull ViewProvider viewProvider, @NonNull DialogUiCallback callback2) {
        this.mContext = context;
        this.mViewProvider = viewProvider;
        this.mDialogUiCallback = callback2;
    }

    public void init(Dialog dialog2) {
        this.createViews(dialog2);
        this.initDialog(dialog2);
        this.initView();
    }

    public int getId() {
        return 0;
    }

    private void initDialog(Dialog dialog2) {
        Window dialogWindow = dialog2.getWindow();
        WindowManager.LayoutParams dialogLp = dialogWindow.getAttributes();
        dialogLp.gravity = 80;
        dialogLp.width = -1;
        dialogLp.horizontalMargin = 0.0f;
        dialogLp.verticalMargin = 0.0f;
        dialogWindow.setAttributes(dialogLp);
        dialogWindow.getDecorView().setPadding(0, 0, 0, 0);
        dialogWindow.setWindowAnimations(R.style.bottom_dialog_anim);
        dialog2.setOnDismissListener(dismissDialog -> this.onDialogDismiss());
    }

    private void createViews(final Dialog dialog2) {
        this.mDialog = dialog2;
        this.mContentView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.dialog_bottom_profile_card_channel, null);
        dialog2.setContentView(this.mContentView);
        this.mFamilyHolderView = (YYPlaceHolderView)this.mContentView.findViewById(R.id.family_data);
        this.mTeamUpHolderView = (YYPlaceHolderView)this.mContentView.findViewById(R.id.teamup_data);
        this.mTopSpaceView = (YYView)this.mContentView.findViewById(R.id.view_top_space);
        this.mTvUserName = (YYTextView)this.mContentView.findViewById(R.id.tv_nick);
        this.mTvSexAndAge = (YYTextView)this.mContentView.findViewById(R.id.tv_sex_age);
        FontUtils.setFontType((TextView)this.mTvSexAndAge, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mTvLocation = (YYTextView)this.mContentView.findViewById(R.id.tv_location);
        FontUtils.setFontType((TextView)this.mTvLocation, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mIvStatusBadge = (RecycleImageView)this.mContentView.findViewById(R.id.iv_status_badge);
        this.mIvLeftAction = (RecycleImageView)this.mContentView.findViewById(R.id.iv_left_action);
        this.mReportTip = (YYTextView)this.mContentView.findViewById(R.id.profile_report);
        this.mIvAvatar = (HeadFrameImageView)this.mContentView.findViewById(R.id.iv_avatar);
        this.mLiteBrowserListView = (HorFunctionListView)this.mContentView.findViewById(R.id.list_lite_browser);
        this.mBrowserListView = (HorFunctionListView)this.mContentView.findViewById(R.id.list_data);
        this.mOperationListView = (HorFunctionListView)this.mContentView.findViewById(R.id.list_function);
        this.mOperationView = this.mContentView.findViewById(R.id.ll_function);
        this.mBtnListView = (HorFunctionListView)this.mContentView.findViewById(R.id.list_btn);
        this.mTvMention = (TextView)this.mContentView.findViewById(R.id.tv_profile_mention);
        this.mRoleIcon = (RecycleImageView)this.mContentView.findViewById(R.id.iv_role_icon);
        this.mRoleName = (YYTextView)this.mContentView.findViewById(R.id.tv_role_name);
        this.mRoleInfoLl = (YYLinearLayout)this.mContentView.findViewById(R.id.ll_role_info);
        this.mGoldenBean = (YYTextView)this.mContentView.findViewById(R.id.tv_golden_bean);
        FontUtils.setFontType((TextView)this.mGoldenBean, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        this.mGiftMedalContainer = this.mContentView.findViewById(R.id.gift_medal_container);
        this.mProfileCardMedalsView = (ProfileCardMedalsView)this.mContentView.findViewById(R.id.profile_card_medals);
        this.mProfileCardGiftWallView = (ProfileCardGiftWallView)this.mContentView.findViewById(R.id.profile_gift_wall);
        this.divideLine = (YYView)this.mContentView.findViewById(R.id.gift_divide_line);
        this.mOtherFansView = (LinearLayout)this.mContentView.findViewById(R.id.ll_other_followings);
        this.mTvOtherFans = (YYTextView)this.mContentView.findViewById(R.id.tv_other_followings);
        this.mNationFlagIv = (RecycleImageView)this.mContentView.findViewById(R.id.iv_nation_flag);
        this.mNationFlagLayout = (YYFrameLayout)this.mContentView.findViewById(R.id.layout_nation_flag);
        this.mAnchorLevelLayout = (YYLinearLayout)this.mContentView.findViewById(R.id.ll_anchor_level);
        this.mFansGroupLayout = (YYFrameLayout)this.mContentView.findViewById(R.id.ll_fans_group);
        this.mFansGroupImg = (RecycleImageView)this.mContentView.findViewById(R.id.fans_group_icon);
        this.mFansGroupName = (YYTextView)this.mContentView.findViewById(R.id.fans_group_name);
        this.mAnchorLevelIcon = (RecycleImageView)this.mContentView.findViewById(R.id.level_icon);
        this.mAnchorLevelName = (YYTextView)this.mContentView.findViewById(R.id.level_name);
        this.defaultBgView = this.mContentView.findViewById(R.id.rl_content);
        this.bgBodyImg = (YYSvgaImageView)this.mContentView.findViewById(R.id.imgBodyBg);
        this.bgHeadImg = (YYSvgaImageView)this.mContentView.findViewById(R.id.imgHeadBg);
        this.llTop = (ViewGroup)this.mContentView.findViewById(R.id.ll_top);
        this.mTvChannelNick = (YYTextView)this.mContentView.findViewById(R.id.tv_channel_nick);
        this.mUserTagsLayout = (UserTagsLayout)this.mContentView.findViewById(R.id.userTagLayout);
        this.mUserTagsLayout.setOnItemClickListener(new IUserTagItemClickListener(){

            public void onClick(int location) {
                dialog2.dismiss();
            }
        });
        this.mFansGroupLayout.setOnClickListener(v -> this.mDialogUiCallback.onFansGroupClick(this.fansGroupData));
        this.mMhSlInfoView = (MaxHeightScrollView)this.mContentView.findViewById(R.id.mh_sl_info);
        this.mMhSlInfoView.setMaxHeight(ResolutionUtils.dip2Px((float)210.0f));
    }

    private void initView() {
        this.initLeftAction();
        this.initLiteBrowserViews();
        this.initBrowserViews();
        this.initBtnViews();
        this.initOperationViews();
        this.initTopRightActions();
        this.initGiftWallView();
        this.initMedalsView();
        int h = (int)((double)ScreenUtils.getInstance().getWidthPixels() * 0.853);
        ViewGroup.LayoutParams param2 = this.bgHeadImg.getLayoutParams();
        param2.height = h;
        if (param2 instanceof RelativeLayout.LayoutParams) {
            ((RelativeLayout.LayoutParams)param2).topMargin = (int)((double)(-h) * 0.153);
        }
        this.bgHeadImg.setLayoutParams(param2);
        ViewGroup.LayoutParams bgBodyImgParam = this.bgBodyImg.getLayoutParams();
        bgBodyImgParam.height = h;
        if (bgBodyImgParam instanceof RelativeLayout.LayoutParams) {
            ((RelativeLayout.LayoutParams)bgBodyImgParam).topMargin = (int)((double)(-h) * 0.153);
        }
        this.bgBodyImg.setLayoutParams(bgBodyImgParam);
        this.mTopSpaceView.setOnClickListener(v -> this.mDialogUiCallback.onOutsideClick());
        if (this.mViewProvider.avatarNeedShake()) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProfileCardDialog.this.mAnimation = AnimationUtils.loadAnimation((Context)ProfileCardDialog.this.mContext, (int)R.anim.profile_avatar_shake);
                    ProfileCardDialog.this.mIvAvatar.startAnimation(ProfileCardDialog.this.mAnimation);
                    if (ProfileCardDialog.this.mDialogUiCallback != null) {
                        MLog.infoIfDebug((Object)ProfileCardDialog.TAG, (String)"onAvatarGuideShow", (Object[])new Object[0]);
                        ProfileCardDialog.this.mDialogUiCallback.onAvatarGuideShow();
                    }
                }
            }, (long)500L);
        }
        this.mIvAvatar.setOnClickListener(v -> this.mDialogUiCallback.onAvatarClick());
        this.mTvMention.setOnClickListener(v -> this.mDialogUiCallback.onMentioned());
        this.mGoldenBean.setOnClickListener(v -> this.mDialogUiCallback.onGoldBeanClick());
        if (this.mViewProvider != null) {
            this.mViewProvider.onViewInit();
        }
    }

    private void initLeftAction() {
        LeftAction leftAction = this.mViewProvider.createLeftAction();
        if (leftAction.isShow) {
            this.mIvLeftAction.setVisibility(0);
            this.mIvLeftAction.setImageResource(leftAction.icon);
            this.mIvLeftAction.setOnClickListener(leftAction.clickListener);
            this.mReportTip.setOnClickListener(leftAction.clickListener);
            this.mReportTip.setVisibility(0);
        } else {
            this.mIvLeftAction.setVisibility(8);
            this.mReportTip.setVisibility(8);
        }
    }

    private void initTopRightActions() {
        boolean showMentions = this.mViewProvider.showMentioned();
        if (showMentions) {
            this.mTvMention.setVisibility(0);
            this.mGoldenBean.setVisibility(8);
        } else {
            this.mTvMention.setVisibility(8);
        }
    }

    private void initLiteBrowserViews() {
        if (this.mLiteBrowserListView == null) {
            return;
        }
        List<HorFunctionListView.ViewItem> itemViews = this.mViewProvider.createLiteBrowserViews();
        if (FP.empty(itemViews)) {
            this.mLiteBrowserListView.setVisibility(8);
        } else {
            this.mLiteBrowserListView.setVisibility(0);
            this.mLiteBrowserListView.setData(itemViews);
        }
    }

    private void initBrowserViews() {
        if (this.mBrowserListView == null) {
            return;
        }
        List<HorFunctionListView.ViewItem> itemViews = this.mViewProvider.createBrowserViews();
        if (FP.empty(itemViews)) {
            this.mBrowserListView.setVisibility(8);
        } else {
            this.mBrowserListView.setVisibility(0);
            this.mBrowserListView.setData(itemViews);
        }
    }

    private void initMedalsView() {
        if (this.mProfileCardMedalsView == null) {
            return;
        }
        boolean showMedals = this.mViewProvider.showMedals();
        if (showMedals) {
            this.mGiftMedalContainer.setVisibility(0);
        }
        this.mProfileCardMedalsView.setVisibility(showMedals ? 0 : 8);
    }

    private void initGiftWallView() {
        if (this.mProfileCardGiftWallView == null) {
            return;
        }
        boolean show = this.mViewProvider.showGiftWall();
        if (show) {
            this.mGiftMedalContainer.setVisibility(0);
        }
        this.divideLine.setVisibility(show && this.mViewProvider.showMedals() ? 0 : 8);
        this.mProfileCardGiftWallView.setVisibility(show ? 0 : 8);
    }

    public void initBtnViews() {
        List<HorFunctionListView.ViewItem> viewItems = this.mViewProvider.createBtnViews();
        this.mBtnListView.setData(viewItems);
        this.mBtnListView.getLayoutParams().width = -1;
        if (FP.empty(viewItems)) {
            this.mBtnListView.setVisibility(8);
        } else {
            this.mBtnListView.setVisibility(0);
        }
    }

    private void initOperationViews() {
        List<HorFunctionListView.ViewItem> itemViews = this.mViewProvider.createOperationViews();
        if (!FP.empty(itemViews)) {
            this.mOperationView.setVisibility(0);
            this.mOperationListView.setData(itemViews);
        } else {
            this.mOperationView.setVisibility(8);
        }
    }

    private void onDialogDismiss() {
        if (this.mAnimation != null) {
            this.mAnimation.cancel();
        }
        this.mViewProvider.onViewDestroy();
    }

    public void updateRole(int roleType, boolean isMember, boolean isAnchor) {
        if (this.mRoleInfoLl == null || this.mRoleIcon == null || this.mRoleName == null) {
            return;
        }
        if (15 == roleType) {
            this.mRoleInfoLl.setVisibility(0);
            this.mRoleIcon.setImageResource(R.drawable.icon_profile_card_administorter);
            this.mRoleName.setText((CharSequence)ResourceUtils.getString((int)R.string.title_channel_owner));
        } else if (10 == roleType) {
            this.mRoleInfoLl.setVisibility(0);
            this.mRoleIcon.setImageResource(R.drawable.icon_profile_card_administorter);
            this.mRoleName.setText((CharSequence)ResourceUtils.getString((int)R.string.title_manage_administrator));
        } else if (isMember) {
            this.mRoleInfoLl.setVisibility(0);
            if (isAnchor) {
                this.mRoleIcon.setImageResource(R.drawable.icon_room_host);
                this.mRoleName.setText((CharSequence)ResourceUtils.getString((int)R.string.title_channel_party_host));
            } else {
                this.mRoleIcon.setImageResource(R.drawable.icon_profile_card_common_member);
                this.mRoleName.setText((CharSequence)ResourceUtils.getString((int)R.string.title_manage_member));
            }
        } else {
            this.mRoleInfoLl.setVisibility(8);
        }
    }

    public void updateStatusBadge(final Drawable drawable2) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProfileCardDialog.this.mIvStatusBadge.setBackgroundDrawable(drawable2);
            }
        });
    }

    public void updateUserInfo(UserInfoKS userInfo) {
        if (userInfo == null) {
            return;
        }
        this.setAvatar(userInfo);
        this.setNickName(userInfo);
        this.setLocation(userInfo);
        this.setSexAge(userInfo);
        this.setNationFlag(userInfo);
    }

    private void setNickName(UserInfoKS userInfo) {
        if (this.mTvUserName == null) {
            return;
        }
        this.mTvUserName.setText((CharSequence)userInfo.nick);
        PrivilegeHelper.INSTANCE.tryChangeNicknameColor((TextView)this.mTvUserName, userInfo.uid);
    }

    private void setLocation(UserInfoKS userInfo) {
        if (this.mTvLocation == null) {
            return;
        }
        if (userInfo.hideLocation == 1L) {
            this.mTvLocation.setVisibility(8);
        } else {
            this.mTvLocation.setVisibility(0);
            if (!StringUtils.isEmpty((String)userInfo.lastLoginLocation)) {
                this.mTvLocation.setText((CharSequence)userInfo.lastLoginLocation);
            } else {
                this.mTvLocation.setText((CharSequence)ResourceUtils.getString((int)R.string.profile_no_location));
            }
        }
    }

    private void setAvatar(UserInfoKS userInfo) {
        if (this.mIvAvatar == null) {
            return;
        }
        int size = ScreenUtils.getInstance().dip2px(75);
        ImageLoader.with((ImageView)this.mIvAvatar.getCircleImageView(), (String)userInfo.avatar).useHeif(true).setOverride(false).placeholder(AvatarUtils.getDefaultAvatar((int)userInfo.sex)).setSize(size, size).load();
    }

    private void setSexAge(UserInfoKS userInfo) {
        if (this.mTvSexAndAge == null) {
            return;
        }
        if (AccountUtil.getUid() == userInfo.uid && (userInfo.flatBit & 3L) > 0L) {
            this.mTvSexAndAge.setVisibility(8);
        } else {
            this.mTvSexAndAge.setVisibility(0);
            if (userInfo.sex == 0) {
                if (Build.VERSION.SDK_INT >= 17) {
                    this.mTvSexAndAge.setCompoundDrawablesRelativeWithIntrinsicBounds(ResourceUtils.getDrawable((int)R.drawable.icon_profile_card_female), null, null, null);
                }
                this.mTvSexAndAge.setCompoundDrawablesWithIntrinsicBounds(ResourceUtils.getDrawable((int)R.drawable.icon_profile_card_female), null, null, null);
            } else {
                if (Build.VERSION.SDK_INT >= 17) {
                    this.mTvSexAndAge.setCompoundDrawablesRelativeWithIntrinsicBounds(ResourceUtils.getDrawable((int)R.drawable.icon_profile_card_male), null, null, null);
                }
                this.mTvSexAndAge.setCompoundDrawablesWithIntrinsicBounds(ResourceUtils.getDrawable((int)R.drawable.icon_profile_card_male), null, null, null);
            }
            this.mTvSexAndAge.setText((CharSequence)String.valueOf(DateUtils.getAge((String)userInfo.birthday)));
        }
    }

    private void setNationFlag(UserInfoKS userInfo) {
        if (this.mNationFlagIv == null || userInfo == null) {
            return;
        }
        String url = NationalFlagUtils.INSTANCE.getNationalFlag(userInfo.country);
        if (StringUtils.isNotEmpty((String)url)) {
            this.mNationFlagIv.setVisibility(0);
            ImageLoader.loadImage((ImageView)this.mNationFlagIv, (String)url);
            if (userInfo.hideLocation == 1L) {
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mNationFlagLayout.getLayoutParams();
                lp.setMarginStart(ResolutionUtils.dip2Px((float)5.0f));
                this.mNationFlagLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        }
    }

    public void updateHeadFrame(String url) {
        if (this.mIvAvatar != null) {
            this.mIvAvatar.setHeadFrame(url);
        }
    }

    public void addBrowserItemView(HorFunctionListView.ViewItem viewItem) {
        if (this.mBrowserListView != null && viewItem != null) {
            this.mBrowserListView.addView(viewItem);
        }
    }

    public void updateGoldenBeansCount(boolean hasHistoryBean, long count) {
        if (this.mGoldenBean == null) {
            return;
        }
        if (hasHistoryBean && !this.mViewProvider.showMentioned()) {
            this.mGoldenBean.setVisibility(0);
            this.mGoldenBean.setText((CharSequence)StringUtils.getFormatedNumber((long)count, (int)1));
        } else {
            this.mGoldenBean.setVisibility(8);
        }
    }

    public void updateGiftWallEntrance(GiftWallEntranceData giftWallEntranceData) {
        if (this.mProfileCardGiftWallView == null) {
            return;
        }
        ArrayList<MedalItemBean> list2 = new ArrayList<MedalItemBean>(giftWallEntranceData.getGiftWallList().size());
        for (GiftWallInfo giftWallInfo : giftWallEntranceData.getGiftWallList()) {
            MedalItemBean medalItemBean = new MedalItemBean(giftWallInfo.getStaticIcon());
            medalItemBean.setLitup(giftWallInfo.isLitup());
            list2.add(medalItemBean);
        }
        this.mProfileCardGiftWallView.updateMedals(list2, (int)giftWallEntranceData.getLitupNum(), (int)giftWallEntranceData.getGiftNum());
        this.mProfileCardGiftWallView.setOnClickListener(v -> {
            ChannelTrack.INSTANCE.onGiftWallClick();
            if (this.mDialogUiCallback != null) {
                this.mDialogUiCallback.onGiftWallClick(giftWallEntranceData.getJumpUrl());
            }
        });
    }

    public void updateMedals(List<HonorBean> lightHonorBeans, List<HonorBean> grayHonorBeans, int lightUpAmount, final String url) {
        if (this.mProfileCardMedalsView != null) {
            ArrayList<MedalItemBean> honorBeanUrls = new ArrayList<MedalItemBean>();
            ArrayList<Integer> honorIds = new ArrayList<Integer>();
            for (HonorBean lightHonorBean : lightHonorBeans) {
                if (lightHonorBean == null) continue;
                honorBeanUrls.add(new MedalItemBean(lightHonorBean.getBigUrl()));
                honorIds.add(lightHonorBean.getId());
            }
            for (HonorBean grayHonorBean : grayHonorBeans) {
                if (grayHonorBean == null) continue;
                honorBeanUrls.add(new MedalItemBean(grayHonorBean.getGrayUrl()));
                honorIds.add(grayHonorBean.getId());
            }
            this.mProfileCardMedalsView.updateMedals(honorBeanUrls, lightUpAmount, 0);
            this.mProfileCardMedalsView.setClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ProfileCardDialog.this.mDialogUiCallback != null) {
                        ProfileCardDialog.this.mDialogUiCallback.onMedalsClick(url);
                    }
                }
            });
        }
    }

    public void updateOtherFans(long fans) {
        if (this.mViewProvider.showOtherFollowings() && this.mOtherFansView != null && this.mTvOtherFans != null) {
            this.mOtherFansView.setVisibility(0);
            this.mTvOtherFans.setText((CharSequence)StringUtils.formatWitUSLocal((String)"%s %s", (Object[])new Object[]{StringUtils.getFormatedNumber((long)fans, (int)1), ResourceUtils.getString((int)R.string.title_profile_card_fans)}));
        }
    }

    public void updateBgImg(MiniCardBgInfo info) {
        if (!info.getHas()) {
            return;
        }
        SvgaLoader.load((SVGAImageView)this.bgHeadImg, (String)info.getBgHeadUrl(), (boolean)true);
        SvgaLoader.load((SVGAImageView)this.bgBodyImg, (String)info.getBgBodyUrl(), (boolean)true);
    }

    public void updateAnchorLevel(String iconUrl, String name) {
        this.mAnchorLevelLayout.setVisibility(0);
        this.llTop.setVisibility(0);
        ImageLoader.loadImage((ImageView)this.mAnchorLevelIcon, (String)iconUrl);
        this.mAnchorLevelName.setText((CharSequence)name);
    }

    public void updateFansGroup(FansGroupData fansGroupData) {
        if (fansGroupData.getFansGroupConfig().getValue() == null) {
            return;
        }
        ChannelTrack.INSTANCE.onMiniFansShow(fansGroupData.getAnchor(), fansGroupData.getLv(), fansGroupData.getTypeId());
        this.fansGroupData = fansGroupData;
        this.mFansGroupLayout.setVisibility(0);
        this.llTop.setVisibility(0);
        this.mFansGroupName.setText((CharSequence)fansGroupData.getName());
        ImageLoader.loadImage((ImageView)this.mFansGroupImg, (String)(((FansGroupConfig)fansGroupData.getFansGroupConfig().getValue()).getLvConfig().getIcon() + YYImageUtils.getThumbnailPostfix((int)75)));
    }

    public void notifyBtnsUpdate(List<HorFunctionListView.ViewItem> viewItems) {
        this.mBtnListView.setData(viewItems);
        this.mBtnListView.getLayoutParams().width = viewItems.size() == 1 ? ResolutionUtils.dip2Px((float)200.0f) : -1;
        if (FP.empty(viewItems)) {
            this.mBtnListView.setVisibility(8);
        } else {
            this.mBtnListView.setVisibility(0);
        }
    }

    public void updateFamilyInfo(ChannelInfo channelItem, FamilyInfoBean data2) {
        if (this.mProfileFamilyView == null) {
            this.mProfileFamilyView = new ProfileFamilyView(this.mContext);
            this.mProfileFamilyView.setListener(this);
        }
        if (!this.mFamilyHolderView.isInflated()) {
            this.mFamilyHolderView.inflate((View)this.mProfileFamilyView);
        }
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mFamilyHolderView.getLayoutParams();
        layoutParams.bottomMargin = ResolutionUtils.dip2Px((float)10.0f);
        this.mProfileFamilyView.setVisibility(0);
        this.mProfileFamilyView.updateFamilyChannelInfo(channelItem, data2);
    }

    public void updateTeamUpInfo(TeamUpGameInfoBean data2, final TeamUpCardCallback callback2) {
        if (this.mProfileTeamUpView == null) {
            this.mProfileTeamUpView = new ProfileTeamUpView(this.mContext);
        }
        if (!this.mTeamUpHolderView.isInflated()) {
            this.mTeamUpHolderView.inflate((View)this.mProfileTeamUpView);
        }
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mTeamUpHolderView.getLayoutParams();
        layoutParams.bottomMargin = ResolutionUtils.dip2Px((float)10.0f);
        this.mProfileTeamUpView.setVisibility(0);
        this.mProfileTeamUpView.updateTeamUpInfo(data2);
        this.mProfileTeamUpView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view2) {
                if (callback2 != null) {
                    callback2.onClick();
                }
            }
        });
    }

    public void setMentionVisible(boolean visible) {
        if (visible) {
            this.mTvMention.setVisibility(0);
        } else {
            this.mTvMention.setVisibility(8);
        }
    }

    public void updateChannelMemberInfo(ChannelUser user) {
        if (user == null || FP.empty((CharSequence)user.remark)) {
            this.mTvChannelNick.setVisibility(8);
            MLog.info((Object)TAG, (String)"updateChannelMemberInfo user null or remark null", (Object[])new Object[0]);
            return;
        }
        if (!user.isShowChannelNick) {
            MLog.info((Object)TAG, (String)"updateChannelMemberInfo user isShowChannelNick false", (Object[])new Object[0]);
            this.mTvChannelNick.setVisibility(8);
            return;
        }
        MLog.info((Object)TAG, (String)"updateChannelMemberInfo user remark:%s", (Object[])new Object[]{user.remark});
        this.mTvChannelNick.setVisibility(0);
        this.mTvChannelNick.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_profilke_card_channel_nick, (Object[])new Object[]{user.remark}));
    }

    public void setUserTags(List<UserTagInfo> userTagInfos, long uid) {
        if (userTagInfos.size() > 0) {
            this.mUserTagsLayout.setVisibility(0);
        } else {
            this.mUserTagsLayout.setVisibility(8);
        }
        this.mUserTagsLayout.setData(userTagInfos, UserTagLocation.LOCATION_MINI_CARD.getLocation(), uid, DpToPxDef.RESOLUTION_25_DP);
    }

    @Override
    public void onJump(@Nullable String fid) {
        if (FP.empty((CharSequence)fid)) {
            return;
        }
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
        String url = URLUtils.addParam((String)UriProvider.getFamilyDetailUrl(), (String)"familyId", (String)fid);
        ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(url);
    }

    public void hideFamilyInfo() {
        if (this.mProfileFamilyView != null) {
            this.mProfileFamilyView.setVisibility(8);
        }
        if (this.mFamilyHolderView != null) {
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mFamilyHolderView.getLayoutParams();
            layoutParams.bottomMargin = 0;
        }
    }
}

