/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.headFrame;

import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.mvp.base.INotifyDispatchService;

public class HeadFramePresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>> {
    private INotifyDispatchService.INotifyHandler<ChannelNotify> mNotifyHandler = new INotifyDispatchService.INotifyHandler<ChannelNotify>(){

        public void onHandleNotify(ChannelNotify notify2) {
            if (notify2 == null) {
                FeatureLog.i((String)"FTHeadFrame", (String)"onHandleNotify notify null", (Object[])new Object[0]);
                return;
            }
            if (!StringUtils.equal((String)HeadFramePresenter.this.getChannel().getChannelId(), (String)notify2.cid)) {
                FeatureLog.i((String)"FTHeadFrame", (String)"onHandleNotify roomId not right, currentRoomId:%s, service roomId:%s", (Object[])new Object[]{HeadFramePresenter.this.getChannel().getChannelId(), notify2.cid});
                if (VersionUtil.isLocalDevBuild()) {
                    throw new RuntimeException("onHandleNotify roomId not right, notifyRoomId " + notify2.cid + ",\n roomData" + HeadFramePresenter.this.getChannel().toString());
                }
                return;
            }
            if (notify2.uri == ChannelNotify.Uri.UriJoinNotify) {
                HeadFramePresenter.this.checkHeadFrame(notify2.notify.join);
                HeadFramePresenter.this.handleEnterRoom(notify2.notify.join);
            }
        }
    };

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        FeatureLog.i((String)"FTHeadFrame", (String)"onPageAttach", (Object[])new Object[0]);
        FeatureLog.i((String)"FTHeadFrame", (String)"NotifyDispatcher addHandler", (Object[])new Object[0]);
        if (this.getNotifyDispatcher() != null) {
            this.getNotifyDispatcher().addHandler(this.mNotifyHandler);
        }
    }

    private void checkHeadFrame(NotifyDataDefine.JoinNotify joinNotify) {
        boolean hasFrame;
        if (joinNotify == null || joinNotify.user < 0L || joinNotify.iconframeID <= 0L) {
            FeatureLog.e((String)"FTHeadFrame", (String)"checkHeadFrame notify null", (Object[])new Object[0]);
            return;
        }
        FeatureLog.d((String)"FTHeadFrame", (String)"uid:%s enter room, headFrame:%s", (Object[])new Object[]{joinNotify.user, joinNotify.iconframeID});
        ((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).addHeadFrameIntoCache(joinNotify.user, (int)joinNotify.iconframeID);
        if (joinNotify.iconframeID != 0L && !(hasFrame = ((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).hasFrame((int)joinNotify.iconframeID))) {
            ((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).requestHeadFrameConfig();
        }
    }

    private void handleEnterRoom(NotifyDataDefine.JoinNotify notify2) {
        if (notify2 == null) {
            FeatureLog.i((String)"FTHeadFrame", (String)"handleEnterRoom notify null", (Object[])new Object[0]);
            return;
        }
        IHonorService honorService = (IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class);
        if (!honorService.hasCache()) {
            FeatureLog.i((String)"FTHeadFrame", (String)"voice room cache null, requestConfig", (Object[])new Object[0]);
            honorService.requestHeadFrameConfig();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.getNotifyDispatcher() != null) {
            FeatureLog.i((String)"FTHeadFrame", (String)"onDestroy removeHandler", (Object[])new Object[0]);
            this.getNotifyDispatcher().removeHandler(this.mNotifyHandler);
        }
    }
}

