/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.entranceshow;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.opensource.svgaplayer.hago.SVGACallback;
import com.opensource.svgaplayer.hago.SVGADrawable;
import com.opensource.svgaplayer.hago.SVGADynamicEntity;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.callback.SimpleSVGACallback;
import com.yy.appbase.degrade.DiscardResult;
import com.yy.appbase.degrade.ISceneDegradedService;
import com.yy.appbase.degrade.ISceneOptLimiter;
import com.yy.appbase.degrade.SimpleSceneOptLimiterCallback;
import com.yy.appbase.eventobserver.EventObserver;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.dres.ResDownloadUtils;
import com.yy.appbase.unifyconfig.config.ScenePerfOptSceneDef;
import com.yy.appbase.util.ShortNameUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.alphaplayer.AlphaVideoPlayer;
import com.yy.hiyo.channel.base.bean.HonorBean;
import com.yy.hiyo.channel.base.bean.UserTagInfo;
import com.yy.hiyo.channel.base.service.IChannelHonorService;
import com.yy.hiyo.channel.base.service.IFamilyLuckyBagService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.publicscreen.callback.OnChatViewLocationChangeListener;
import com.yy.hiyo.channel.component.profile.entranceshow.EntranceShowManager;
import com.yy.hiyo.channel.component.profile.entranceshow.EntranceShowTest;
import com.yy.hiyo.channel.component.profile.entranceshow.EntranceShowView;
import com.yy.hiyo.channel.component.profile.entranceshow.VideoFlashView;
import com.yy.hiyo.channel.component.profile.entranceshow.data.EntranceShowConfigBean;
import com.yy.hiyo.channel.component.profile.entranceshow.data.EntranceShowNotify;
import com.yy.hiyo.channel.component.profile.entranceshow.listener.IEntranceShowAddListener;
import com.yy.hiyo.channel.component.profile.entranceshow.listener.IEntranceShowViewCallback;
import com.yy.hiyo.video.base.player.IVideoPlayListener;
import com.yy.hiyo.video.base.player.IVideoPlayer;
import com.yy.hiyo.video.base.player.SimpleVideoPlayListener;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Unit;
import net.ihago.money.api.family.CallEffectStyle;
import net.ihago.money.api.family.FamilyCallNotify;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntranceShowPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements IEntranceShowViewCallback {
    private static final String TAG = "FTEntranceShow_EntranceShowPresenter";
    private final Queue<EntranceShowNotify> mEntranceShowQueue = new LinkedList<EntranceShowNotify>();
    private EntranceShowView mEntranceShowView;
    private VideoFlashView mVideoFlashView;
    private ViewGroup mRootView;
    private OnChatViewLocationChangeListener mChatViewLocationChangeListener;
    private volatile int[] mChatViewLocation = new int[2];
    private boolean hadChatViewLocation = false;
    private int mFlashGap;
    private int mScreenHeight;
    private int mMaxMarginTop;
    private int mMaxMarginBottom;
    private int mChatViewMarginTop;
    private boolean mEntranceShow;
    private YYFrameLayout svgaBgLayout;
    private AlphaVideoPlayer mVideoPlayer;
    private boolean mIsSettingListener = false;
    private ResDownloadUtils mResDownloadUtils;
    private boolean canAnimate = true;
    private EntranceShowTest mEntranceShowTest;
    private static Comparator<EntranceShowNotify> discardComparator = (o1, o2) -> o1.getDiscardPriority() - o2.getDiscardPriority();
    private ISceneOptLimiter<EntranceShowNotify> mSceneOptLimiter = null;
    private SimpleSceneOptLimiterCallback<EntranceShowNotify> limterCallback = new SimpleSceneOptLimiterCallback<EntranceShowNotify>(){

        public void onAppendItem(EntranceShowNotify item) {
            EntranceShowPresenter.this.mEntranceShowQueue.offer(item);
            EntranceShowPresenter.this.next();
        }

        @NotNull
        public DiscardResult onDiscard(EntranceShowNotify item, float discardRatio, int discardMinRemain, int maxRemain) {
            List remove = ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).findDiscardList((Collection)EntranceShowPresenter.this.mEntranceShowQueue, discardRatio, discardMinRemain, maxRemain, discardComparator);
            if (remove != null) {
                EntranceShowPresenter.this.mEntranceShowQueue.removeAll(remove);
            }
            return DiscardResult.DISCARD_ALSO_NEW;
        }

        @Nullable
        public List<EntranceShowNotify> needDiscardWhenOnDiscard(@NotNull List<? extends EntranceShowNotify> items, float discardRatio, int discardMinRemain, int maxRemain) {
            return ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).findDiscardList(items, discardRatio, discardMinRemain, maxRemain, discardComparator);
        }

        public boolean needSkip(EntranceShowNotify item) {
            return item.uid == AccountUtil.getUid();
        }

        public void onStopAnimate() {
            EntranceShowPresenter.this.canAnimate = false;
        }

        public void onRecoverAnimate() {
            EntranceShowPresenter.this.canAnimate = true;
            EntranceShowPresenter.this.next();
        }
    };
    private Runnable mStayRunnable = new Runnable(){

        @Override
        public void run() {
            EntranceShowPresenter.this.mEntranceShowView.startExitAnim();
        }
    };
    private IEntranceShowAddListener mEntranceShowAddListener = new IEntranceShowAddListener(){

        @Override
        public void onEntranceShowAdd(EntranceShowNotify notify2) {
            EntranceShowPresenter.this.addEntranceShow(notify2);
        }
    };

    private ISceneOptLimiter<EntranceShowNotify> getSceneOptLimiter() {
        if (this.mSceneOptLimiter == null) {
            this.mSceneOptLimiter = ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).createLimiter("entrance_show", this.limterCallback);
        }
        return this.mSceneOptLimiter;
    }

    public void onInit(IChannelPageContext mvpContext) {
        super.onInit(mvpContext);
        this.init(this.getChannel().getChannelId());
        ((IPublicScreenModulePresenter)((IChannelPageContext)this.getMvpContext()).getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter().registerOnChatViewLocationListener(this.getOnChatViewListener());
        this.mFlashGap = ResolutionUtils.dip2Px((float)50.0f);
        this.mScreenHeight = ResolutionUtils.getScreenHeight((Context)RuntimeContext.sApplicationContext);
        this.mMaxMarginBottom = ResolutionUtils.dip2Px((float)80.0f);
        this.mMaxMarginTop = this.mScreenHeight - this.mMaxMarginBottom - this.mFlashGap;
    }

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (!isReAttach) {
            this.setRootView((ViewGroup)this.getWindow().getExtLayer());
            this.setEntranceShowAddListener();
            this.setFamilyObserve();
            if (ScenePerfOptSceneDef.isScenePressure((String)"entrance_show") && this.mEntranceShowTest == null) {
                this.mEntranceShowTest = new EntranceShowTest(this.mEntranceShowAddListener);
                this.mEntranceShowTest.startTest();
            }
        }
    }

    public void init(String channelId) {
        this.requestEntranceShowConfig(channelId);
        this.mChatViewLocationChangeListener = new OnChatViewLocationChangeListener(){

            public void onChatViewLocationChange(int[] loction) {
                boolean isChange = false;
                if (loction == null || loction.length != 2) {
                    EntranceShowPresenter.access$402(EntranceShowPresenter.this, new int[]{-1, -1});
                    isChange = true;
                } else {
                    MLog.debug((Object)EntranceShowPresenter.TAG, (String)"onChatViewLocationChange x: %d, y: %d", (Object[])new Object[]{loction[0], loction[1]});
                    for (int index = 0; index < loction.length; ++index) {
                        if (loction[index] == EntranceShowPresenter.this.mChatViewLocation[index]) continue;
                        isChange = true;
                        break;
                    }
                    if (isChange) {
                        EntranceShowPresenter.access$402(EntranceShowPresenter.this, loction);
                    }
                }
                if (isChange && loction != null && loction.length == 2) {
                    EntranceShowPresenter.this.mChatViewMarginTop = EntranceShowPresenter.this.mChatViewLocation[1];
                }
                if (!EntranceShowPresenter.this.hadChatViewLocation) {
                    EntranceShowPresenter.this.hadChatViewLocation = true;
                    EntranceShowPresenter.this.setEntranceShowAddListener();
                }
            }
        };
    }

    public void setRootView(ViewGroup rootView) {
        this.mRootView = rootView;
    }

    public void requestEntranceShowConfig(String roomId) {
        EntranceShowManager.INSTANCE.requestEntranceShowConfig(roomId);
    }

    private void addEntranceShow(EntranceShowNotify notify2) {
        if (!this.getPage().isPageVisible()) {
            MLog.error((Object)TAG, (String)"addEntranceShow page is not visible", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"addEntranceShow %s", (Object[])new Object[]{notify2});
        this.getSceneOptLimiter().addItem((Object)notify2, this.mEntranceShowQueue.size());
    }

    private void next() {
        FeatureLog.i((String)TAG, (String)"next", (Object[])new Object[0]);
        if (this.isDestroyed()) {
            this.mEntranceShowQueue.clear();
            return;
        }
        if (this.mEntranceShow) {
            FeatureLog.i((String)TAG, (String)"mEntranceShow is true ,return", (Object[])new Object[0]);
            return;
        }
        if (!this.canAnimate) {
            FeatureLog.i((String)TAG, (String)"mEntranceShow canAnimate is false ,return %d", (Object[])new Object[]{this.mEntranceShowQueue.size()});
            return;
        }
        this.showEntranceView();
    }

    public void showEntranceView() {
        if (this.mRootView == null) {
            return;
        }
        EntranceShowNotify notify2 = this.mEntranceShowQueue.poll();
        if (notify2 == null) {
            return;
        }
        MLog.info((Object)TAG, (String)"showEntranceView %s", (Object[])new Object[]{notify2});
        if (notify2.isFamily) {
            int familyEffectStyle = notify2.familyEffectStyle;
            if (familyEffectStyle == CallEffectStyle.CALL_EFFECT_STYLE_MIDDLE.getValue()) {
                this.showSvgaMount(notify2, 0.4722222f, notify2.effectUrl);
            } else if (familyEffectStyle == CallEffectStyle.CALL_EFFECT_STYLE_BIG.getValue()) {
                this.showSvgaMount(notify2, 0.6111111f, notify2.effectUrl);
            } else {
                this.setEntranceShowView(true, notify2.avatar, notify2.userName, notify2.effectUrl, null, ResourceUtils.getString((int)R.string.tips_family_call_content), true, ResolutionUtils.dip2Px((float)307.0f), this.getUserTagsFromConfig(notify2), notify2.uid);
            }
            return;
        }
        EntranceShowConfigBean.ShowType showType = EntranceShowManager.INSTANCE.getShowType(notify2.inShowIds);
        switch (showType) {
            case ShowTypeSide: 
            case ShowTypeBigArea: {
                boolean isBigArea = showType == EntranceShowConfigBean.ShowType.ShowTypeBigArea;
                this.setEntranceShowView(isBigArea, notify2.avatar, notify2.userName, EntranceShowManager.INSTANCE.getEnShowBgUrl(notify2.inShowIds), this.getHonorBean(notify2.medalIds), null, false, 0, this.getUserTagsFromConfig(notify2), notify2.uid);
                break;
            }
            case ShowTypeMount: {
                this.showSvgaMount(notify2, 0.4722222f, EntranceShowManager.INSTANCE.getEnShowBgUrl(notify2.inShowIds));
                break;
            }
            case ShowTypeBigMount: {
                this.showBigMount(notify2);
                break;
            }
        }
    }

    private void setEntranceShowView(boolean isBigArea, String avatar2, String userName, String bgUrl, HonorBean honorBean, String tips, boolean isBigAvatar, int newTopMargin, List<UserTagInfo> userTagsFromConfig, long uid) {
        if (this.mRootView == null) {
            return;
        }
        if (this.mEntranceShowView == null) {
            this.mEntranceShowView = new EntranceShowView(this.mRootView.getContext());
            this.mEntranceShowView.setEntranceShowViewCallback(this);
        }
        this.mEntranceShowView.updateLayoutParams(newTopMargin > 0 ? this.topMargin(newTopMargin) : this.topMargin(this.mChatViewMarginTop), 0, isBigArea, isBigAvatar);
        this.mEntranceShowView.setAlpha(0.0f);
        this.mEntranceShow = true;
        this.mRootView.removeView((View)this.mEntranceShowView);
        this.mRootView.addView((View)this.mEntranceShowView);
        this.mEntranceShowView.updateView(avatar2, userName, bgUrl, honorBean, tips, userTagsFromConfig, uid);
    }

    private List<UserTagInfo> getUserTagsFromConfig(EntranceShowNotify notify2) {
        if (ServiceManagerProxy.getServiceManager() == null) {
            return null;
        }
        return ((IChannelHonorService)ServiceManagerProxy.getServiceManager().getService(IChannelHonorService.class)).getUserTagsFromConfig(notify2.cardInfoList);
    }

    private void showBigMount(EntranceShowNotify notify2) {
        EntranceShowConfigBean bean2 = EntranceShowManager.INSTANCE.getEntranceShowConfigById(notify2.inShowIds);
        if (bean2 == null) {
            MLog.error((Object)TAG, (String)"config is null %d", (Object[])new Object[]{notify2.inShowIds});
            this.next();
            return;
        }
        String url = bean2.getUrl();
        if (!TextUtils.isEmpty((CharSequence)url) && url.endsWith(".svga")) {
            this.showSvgaMount(notify2, 0.6111111f, url);
        } else if (AlphaVideoPlayer.isSupport() && !TextUtils.isEmpty((CharSequence)url)) {
            this.showVideo(notify2, 0.6111111f, url, bean2.getBackgroundUrl());
        } else if (!TextUtils.isEmpty((CharSequence)bean2.getBackupUrl())) {
            this.showSvgaMount(notify2, 0.6111111f, bean2.getBackupUrl());
        } else {
            this.next();
            MLog.error((Object)TAG, (String)"config illegal %d", (Object[])new Object[]{notify2.inShowIds});
        }
    }

    private void showVideo(final EntranceShowNotify notify2, float ratio, String videoUrl, final String bgUrl) {
        this.createContainer(ratio, false);
        this.mEntranceShow = true;
        ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).startHighPerfScene("entrance_show");
        if (this.mVideoPlayer != null) {
            MLog.error((Object)TAG, (String)"showVideo last play is not finish?", (Object[])new Object[0]);
            this.mVideoPlayer.destroy();
        }
        this.mVideoPlayer = new AlphaVideoPlayer();
        this.mVideoPlayer.setForeTextureView(true);
        this.mVideoPlayer.play((ViewGroup)this.svgaBgLayout, videoUrl, (IVideoPlayListener)new SimpleVideoPlayListener(){

            public void onPlayFirstFrameShow(@NotNull IVideoPlayer player, int p1, int p2, int p3) {
                MLog.info((Object)EntranceShowPresenter.TAG, (String)"onPlayFirstFrameShow ", (Object[])new Object[0]);
                EntranceShowPresenter.this.showInfoFlash((ViewGroup)EntranceShowPresenter.this.svgaBgLayout, notify2, bgUrl);
            }

            public void onPlayComplete(@NotNull IVideoPlayer player) {
                MLog.info((Object)EntranceShowPresenter.TAG, (String)"onPlayComplete ", (Object[])new Object[0]);
                if (EntranceShowPresenter.this.mVideoFlashView != null) {
                    EntranceShowPresenter.this.mVideoFlashView.endAnim();
                }
                EntranceShowPresenter.this.mVideoFlashView = null;
                YYTaskExecutor.postToMainThread(() -> EntranceShowPresenter.this.destroyVideo(), (long)500L);
            }

            public void onPlayerError(@NotNull IVideoPlayer player, int what, int extra) {
                MLog.info((Object)EntranceShowPresenter.TAG, (String)"onPlayerError what: %d, extra: %d", (Object[])new Object[]{what, extra});
                EntranceShowPresenter.this.destroyVideo();
            }
        });
    }

    private void destroyVideo() {
        if (this.mVideoFlashView != null) {
            this.mVideoFlashView.endAnim();
        }
        this.mVideoFlashView = null;
        if (this.mVideoPlayer != null) {
            this.mVideoPlayer.destroy();
        }
        this.mVideoPlayer = null;
        this.removeShowView();
        ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).stopHighPerfScene("entrance_show");
    }

    private void showInfoFlash(ViewGroup container, EntranceShowNotify notify2, String bgUrl) {
        this.mVideoFlashView = new VideoFlashView(container.getContext());
        this.mVideoFlashView.setData(notify2, bgUrl);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(ResolutionUtils.dip2Px((float)280.0f), ResolutionUtils.dip2Px((float)34.0f));
        lp.gravity = 81;
        lp.bottomMargin = ResolutionUtils.dip2Px((float)13.0f);
        this.mVideoFlashView.setAlpha(0.0f);
        container.addView((View)this.mVideoFlashView, (ViewGroup.LayoutParams)lp);
        this.mVideoFlashView.startAnim();
    }

    private void showSvgaMount(final EntranceShowNotify notify2, float ratio, final String svgaUrl) {
        this.createContainer(ratio, notify2.isFamily);
        final SVGAImageView svgaImageView = new SVGAImageView(this.mRootView.getContext());
        svgaImageView.setLoopCount(1);
        FrameLayout.LayoutParams svgLp = new FrameLayout.LayoutParams(-1, -1);
        this.svgaBgLayout.addView((View)svgaImageView, (ViewGroup.LayoutParams)svgLp);
        this.mEntranceShow = true;
        if (this.mResDownloadUtils == null) {
            String path = FileStorageUtils.getInstance().getInternalCacheDir("svga-gift").getAbsolutePath();
            this.mResDownloadUtils = new ResDownloadUtils(path);
        }
        this.mResDownloadUtils.fetchFile(svgaUrl, (ICommonCallback)new ICommonCallback<String>(){

            public void onSuccess(String s, Object ... ext) {
                EntranceShowPresenter.this.loadSvga(notify2, s, svgaImageView);
            }

            public void onFail(int errCode, String msg, Object ... ext) {
                EntranceShowPresenter.this.loadSvga(notify2, svgaUrl, svgaImageView);
            }
        });
    }

    private void loadSvga(final EntranceShowNotify notify2, final String svgaUrl, final SVGAImageView svgaImageView) {
        SvgaLoader.load((SVGAImageView)svgaImageView, (String)svgaUrl, (ISvgaLoadCallback)new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                if (svgaVideoEntity == null) {
                    return;
                }
                EntranceShowPresenter.this.setDynamicSvga(svgaVideoEntity, notify2, svgaImageView);
            }

            public void onFailed(Exception e) {
                MLog.error((Object)EntranceShowPresenter.TAG, (String)"loadSvga onFailed", (Throwable)e, (Object[])new Object[0]);
                ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).stopHighPerfScene("entrance_show");
                EntranceShowPresenter.this.removeBadCache(svgaUrl);
                svgaImageView.stopAnimation();
                EntranceShowPresenter.this.removeShowView();
            }
        });
    }

    private void removeBadCache(final String path) {
        if (!TextUtils.isEmpty((CharSequence)path) && !path.startsWith("http")) {
            MLog.error((Object)TAG, (String)"removeBadCache maybe file bad delete cache file %s", (Object[])new Object[]{path});
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    YYFileUtils.delete((File)new File(path));
                }
            });
        }
    }

    private void createContainer(float ratio, boolean centerInParent) {
        if (this.mRootView == null) {
            return;
        }
        if (this.svgaBgLayout != null) {
            this.mRootView.removeView((View)this.svgaBgLayout);
            this.svgaBgLayout = null;
        }
        this.svgaBgLayout = new YYFrameLayout(this.mRootView.getContext());
        int height = (int)((float)ScreenUtils.getInstance().getWidthPixels() * ratio);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, height);
        if (centerInParent) {
            lp.addRule(15);
        } else {
            lp.topMargin = DpToPxDef.RESOLUTION_100_DP;
        }
        this.mRootView.addView((View)this.svgaBgLayout, (ViewGroup.LayoutParams)lp);
    }

    private void setDynamicSvga(SVGAVideoEntity svgaVideoEntity, EntranceShowNotify notify2, SVGAImageView svgaImageView) {
        HonorBean honorBean;
        SVGADynamicEntity dynamicEntity = new SVGADynamicEntity();
        String keyHead = "head";
        String keyContent = "nickname";
        String valueContent = notify2.userName;
        String valueHead = notify2.avatar;
        if (notify2.isFamily) {
            keyHead = "cover";
            keyContent = "title";
            valueContent = ShortNameUtils.getShortNameWithoutColon((String)notify2.userName, (int)6) + " " + ResourceUtils.getString((int)R.string.tips_family_call_content);
        }
        if (!TextUtils.isEmpty((CharSequence)valueHead)) {
            dynamicEntity.setDynamicImage(valueHead + YYImageUtils.getThumbnailPostfix((int)75), keyHead);
        }
        if ((honorBean = this.getHonorBean(notify2.medalIds)) != null && StringUtils.isNotEmpty((String)honorBean.getUrl())) {
            dynamicEntity.setDynamicImage(honorBean.getUrl(), "medal");
        }
        TextPaint textPaint = new TextPaint();
        textPaint.setColor(-1);
        textPaint.setTextSize((float)ResolutionUtils.dip2Px((float)9.0f));
        float width = ResolutionUtils.dip2Px((float)60.0f);
        if (notify2.isFamily) {
            width = ResolutionUtils.dip2Px((float)150.0f);
        }
        String ellipsizeStr = (String)TextUtils.ellipsize((CharSequence)valueContent, (TextPaint)textPaint, (float)width, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
        dynamicEntity.setDynamicText(new StaticLayout((CharSequence)ellipsizeStr, 0, ellipsizeStr.length(), textPaint, 0, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false), keyContent);
        SVGADrawable drawable2 = new SVGADrawable(svgaVideoEntity, dynamicEntity);
        svgaImageView.setImageDrawable((Drawable)drawable2);
        svgaImageView.startAnimation();
        ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).startHighPerfScene("entrance_show");
        svgaImageView.setCallback((SVGACallback)new SimpleSVGACallback(){

            public void onFinished() {
                ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).stopHighPerfScene("entrance_show");
                YYTaskExecutor.postToMainThread(() -> EntranceShowPresenter.this.removeShowView());
            }
        });
    }

    private int topMargin(int top) {
        if ((top += this.mFlashGap) > this.mMaxMarginTop) {
            top = this.mMaxMarginTop;
        }
        return top;
    }

    private HonorBean getHonorBean(int medalId) {
        IChannelHonorService channelCenterService = (IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class);
        if (channelCenterService != null) {
            return channelCenterService.getHonorsByIds(medalId);
        }
        return null;
    }

    public OnChatViewLocationChangeListener getOnChatViewListener() {
        return this.mChatViewLocationChangeListener;
    }

    @Override
    public void removeStayRunnable() {
        YYTaskExecutor.postToMainThread((Runnable)this.mStayRunnable, (long)1670L);
    }

    @Override
    public void removeShowView() {
        MLog.info((Object)TAG, (String)"removeShowView %s", (Object[])new Object[]{this.getChannelId()});
        YYTaskExecutor.removeTask((Runnable)this.mStayRunnable);
        this.removeView();
        this.mEntranceShow = false;
        this.next();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mEntranceShowTest != null) {
            this.mEntranceShowTest.onDestroy();
        }
        this.getSceneOptLimiter().destroy();
        if (this.mVideoPlayer != null) {
            this.mVideoPlayer.destroy();
        }
        this.mVideoPlayer = null;
        YYTaskExecutor.postToMainThread(this::removeView);
        EntranceShowManager.INSTANCE.setEntranceShowAddListener(this.getChannelId(), null);
        YYTaskExecutor.removeTask((Runnable)this.mStayRunnable);
    }

    private void removeView() {
        block4: {
            try {
                if (this.mRootView != null && this.mEntranceShowView != null) {
                    this.mRootView.removeView((View)this.mEntranceShowView);
                }
                if (this.mRootView != null && this.svgaBgLayout != null) {
                    this.mRootView.removeView((View)this.svgaBgLayout);
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"removeView", (Throwable)e, (Object[])new Object[0]);
                if (!SystemUtils.isShowEnvSetting()) break block4;
                throw e;
            }
        }
    }

    private void setEntranceShowAddListener() {
        if (!this.mIsSettingListener && !this.isDestroyed() && this.hadChatViewLocation) {
            EntranceShowManager.INSTANCE.setEntranceShowAddListener(this.getChannelId(), new MyEntranceShowAddListener(this.mEntranceShowAddListener));
            this.mIsSettingListener = true;
        }
    }

    private void setFamilyObserve() {
        if (ServiceManagerProxy.getServiceManager() != null) {
            ((IFamilyLuckyBagService)ServiceManagerProxy.getServiceManager().getService(IFamilyLuckyBagService.class)).getFamilyCallNotify().observe((LifecycleOwner)this.getLifeCycleOwner(), (Observer)new EventObserver(familyCallNotify -> {
                if (this.isDestroyed() || familyCallNotify == null) {
                    return Unit.INSTANCE;
                }
                this.showFamilyCallEvent((FamilyCallNotify)familyCallNotify);
                return Unit.INSTANCE;
            }));
        }
    }

    private void showFamilyCallEvent(FamilyCallNotify notify2) {
        if (this.mRootView != null) {
            this.addEntranceShow(EntranceShowNotify.from(notify2));
            HiidoEvent event = HiidoEvent.obtain().eventId("60080028").put("function_id", "call_special_effects_show").put("level", "" + notify2.family_lv);
            HiidoStatis.reportEvent((HiidoEvent)event);
        }
    }

    static /* synthetic */ int[] access$402(EntranceShowPresenter x0, int[] x1) {
        x0.mChatViewLocation = x1;
        return x1;
    }

    private static class MyEntranceShowAddListener
    implements IEntranceShowAddListener {
        private WeakReference<IEntranceShowAddListener> callBack;

        public MyEntranceShowAddListener(IEntranceShowAddListener entranceShowAddListener) {
            this.callBack = new WeakReference<IEntranceShowAddListener>(entranceShowAddListener);
        }

        @Override
        public void onEntranceShowAdd(EntranceShowNotify notify2) {
            IEntranceShowAddListener entranceShowAddListener;
            if (this.callBack != null && (entranceShowAddListener = (IEntranceShowAddListener)this.callBack.get()) != null) {
                entranceShowAddListener.onEntranceShowAdd(notify2);
            }
        }
    }
}

