/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.play.activity;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.service.IHomePlanService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.BasePanel;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.ChannelTagItem;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.tools.IRevenueToolsModulePresenter;
import com.yy.hiyo.channel.component.bottombar.BottomPresenter;
import com.yy.hiyo.channel.component.play.RoomGameAndActivityListPresenter;
import com.yy.hiyo.channel.component.play.activity.OnRoomActivityItemClick;
import com.yy.hiyo.channel.component.play.activity.RoomActivityListMvp;
import com.yy.hiyo.channel.component.redpoint.ChannelRedPointManager;
import com.yy.hiyo.channel.module.floatplay.ChannelFloatPlayPresenter;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.channelgame.IChannelGameListModel;
import com.yy.hiyo.game.base.channelgame.IRoomGameListCallback;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.wallet.base.IActivityService;
import com.yy.hiyo.wallet.base.action.ActionManager;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.ActivityActionList;
import com.yy.hiyo.wallet.base.action.ActivityTagInfo;
import com.yy.hiyo.wallet.base.action.PrivilegeAction;
import com.yy.hiyo.wallet.base.floatplay.IFloatPlayService;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.ihago.money.api.appconfigcenter.PluginSubType;
import org.jetbrains.annotations.NotNull;

public class RoomActivityListPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements RoomActivityListMvp.IPresenter,
OnRoomActivityItemClick,
ISeatUpdateListener {
    private static final String TAG = RoomActivityListPresenter.class.getSimpleName();
    private static final int ROOM_ACTIVITY_TOOLBAR_LOCATION = 5;
    private static final int ROOM_PRIVILEGE_CENTER_LOCATION = 7;
    private static final String TURN_PANEL_LINK_URL = "dazhuanpan";
    private int lastMySeatIndex = -1;
    private BasePanel mBasePanel;
    private RoomActivityListMvp.IView mIView;
    private List<ActivityAction> mActionList;
    private List<GameInfo> mFloatGameInfoList;
    private List<ActivityAction> mFloatGameList;
    private List<ActivityAction> mFloatActList;
    private int myRole = Integer.MIN_VALUE;
    private List<ActivityAction> mPrivilegeActionList;
    private RoomActivityListMvp.IPresenter.OnActivityListHideListener mOnActivityListHideListener;
    private final FetchActivityCallback myCallback = new FetchActivityCallback(this);
    private final PrivilegeActivityCallback myPrivilegeCallback = new PrivilegeActivityCallback(this);
    private final FetchFloatActCallback mFloatActCallback = new FetchFloatActCallback(this);
    private IPluginService.IPluginDataChangedCallBack mPluginChangedListener = new IPluginService.IPluginDataChangedCallBack(){

        public void onVideoModeChanged(String channelId, boolean isVideoMode) {
            RoomActivityListPresenter.this.requestActivities(true);
            RoomActivityListPresenter.this.requestPrivilegeCenters(true);
        }
    };

    private void handleActionListRedState(RoomActivityListPresenter presenter, List<ActivityAction> actionList) {
        RoomActivityListPresenter.checkActionListReadStatus(actionList, presenter);
        RoomActivityListPresenter.filterMinorDisabled(actionList);
        if (presenter.mIView != null) {
            presenter.updateActionList();
            presenter.reportHiido(actionList, "activity_id", "revenue_act_pannel_show");
        }
        ((BottomPresenter)presenter.getPresenter(BottomPresenter.class)).updatePluginView();
    }

    private static void filterMinorDisabled(List<ActivityAction> actionList) {
        IHomePlanService homePlanService;
        if (!FP.empty(actionList) && (homePlanService = (IHomePlanService)ServiceManagerProxy.getServiceManager().getService(IHomePlanService.class)).isMyselfMinorProtect()) {
            Iterator<ActivityAction> it = actionList.iterator();
            while (it.hasNext()) {
                ActivityAction action = it.next();
                if (!homePlanService.isHideActivity(String.valueOf(action.id))) continue;
                it.remove();
            }
        }
    }

    private static void checkActionListReadStatus(List<ActivityAction> list2, BaseChannelPresenter presenter) {
        if (list2 == null) {
            return;
        }
        for (ActivityAction action : list2) {
            if (action == null || action.linkType == ActivityAction.LinkShowType.APP) continue;
            MLog.debug((Object)"zwb", (String)"checkActionListReadStatus, %s, %s\uff0c %s", (Object[])new Object[]{action.title, action.originType, action.hasShowRed});
            if (action.hasShowRed) {
                ChannelRedPointManager.INSTANCE.setKey(action.originType, false);
                action.hasRead = false;
                continue;
            }
            action.hasRead = ChannelRedPointManager.INSTANCE.checkKey(action.originType, false);
        }
        if (presenter != null) {
            ((BottomPresenter)presenter.getPresenter(BottomPresenter.class)).checkPluginShow();
        }
    }

    public void onInit(IChannelPageContext mvpContext) {
        super.onInit(mvpContext);
        this.getChannel().getSeatService().addSeatUpdateListener((ISeatUpdateListener)this);
        this.lastMySeatIndex = this.getChannel().getSeatService().getSeatIndex(AccountUtil.getUid());
        this.requestActivities(false);
        this.requestFloatActivities();
        this.requestPrivilegeCenters(false);
        this.fetchFloatGameInfo();
        if (ChannelDefine.isRadioMode((int)this.getChannel().getPluginService().getCurPluginData().mode)) {
            this.getChannel().getPluginService().addPluginDataListener(this.mPluginChangedListener);
        }
    }

    public void onMyRoleChanged(String channelId, int newRoleType) {
        super.onMyRoleChanged(channelId, newRoleType);
        if (this.myRole != Integer.MIN_VALUE && this.myRole != newRoleType) {
            this.requestActivities(true);
            this.requestFloatActivities();
            this.requestPrivilegeCenters(true);
        }
        this.myRole = newRoleType;
    }

    private void requestActivities(boolean force) {
        ActivityTagInfo tag = this.getRoomTag();
        ((IActivityService)((IChannelPageContext)this.getMvpContext()).getServiceManager().getService(IActivityService.class)).fetchActivityBannerInfo(this.getChannel().getChannelId(), tag, 5, (Callback)this.myCallback, force);
    }

    private void requestFloatActivities() {
        ((IFloatPlayService)((IChannelPageContext)this.getMvpContext()).getServiceManager().getService(IFloatPlayService.class)).fetchActList(this.getChannel().getRoleService().getMyRoleCache(), true, (Callback)this.mFloatActCallback);
    }

    public ActivityAction getFloatAction(String gid) {
        if (this.mFloatActList != null) {
            for (ActivityAction activityAction : this.mFloatActList) {
                if (!gid.equals("" + activityAction.originType)) continue;
                return activityAction;
            }
        }
        if (this.mFloatGameList != null) {
            for (ActivityAction activityAction : this.mFloatGameList) {
                if (!activityAction.linkUrl.equals(gid)) continue;
                return activityAction;
            }
        }
        return null;
    }

    private void requestPrivilegeCenters(boolean force) {
        ActivityTagInfo tag = this.getRoomTag();
        ((IActivityService)((IChannelPageContext)this.getMvpContext()).getServiceManager().getService(IActivityService.class)).fetchActivityBannerInfo(this.getChannel().getChannelId(), tag, 7, (Callback)this.myPrivilegeCallback, force);
    }

    private void fetchFloatGameInfo() {
        final IGameInfoService service = (IGameInfoService)((IChannelPageContext)this.getMvpContext()).getServiceManager().getService(IGameInfoService.class);
        List list2 = service.getFloatGameInfoList();
        if (list2 != null && !list2.isEmpty()) {
            this.mFloatGameInfoList = list2;
            this.loadFloatGame();
        } else {
            IChannelGameListModel listModel = ((IGameService)ServiceManagerProxy.getService(IGameService.class)).getChannelGameListModel();
            listModel.requestInVoiceRoomGameList(new IRoomGameListCallback(){

                public void onSuccess(int code) {
                    RoomActivityListPresenter.this.mFloatGameInfoList = service.getFloatGameInfoList();
                    RoomActivityListPresenter.this.loadFloatGame();
                }
            });
        }
    }

    private void loadFloatGame() {
        if (this.isDestroyed() || FP.empty(this.mFloatGameInfoList)) {
            return;
        }
        if (this.mFloatGameList != null) {
            this.mFloatGameList.clear();
        }
        for (GameInfo info : this.mFloatGameInfoList) {
            if (this.mFloatGameList == null) {
                this.mFloatGameList = new ArrayList<ActivityAction>(this.mFloatGameInfoList.size());
            }
            ActivityAction action = new ActivityAction();
            action.iconUrl = info.getIconUrl();
            action.title = info.getGname();
            action.activityType = ActivityAction.ActivityType.FLOAT_GAME.type;
            action.linkType = ActivityAction.LinkShowType.FLOAT_GAME;
            action.pictureType = ActivityAction.PictureType.IMAGE;
            action.linkUrl = info.gid;
            action.hasShowRed = false;
            action.hasRead = true;
            this.mFloatGameList.add(action);
        }
        this.updateActionList();
    }

    private void updateActionList() {
        int size = FP.size(this.mActionList) + FP.size(this.mFloatActList) + FP.size(this.mFloatGameList) + FP.size(this.mPrivilegeActionList);
        if (size <= 0 || this.mIView == null) {
            return;
        }
        ArrayList<ActivityAction> actionAllList = new ArrayList<ActivityAction>(size);
        if (!FP.empty(this.mActionList)) {
            actionAllList.addAll(this.mActionList);
        }
        if (!FP.empty(this.mFloatActList)) {
            actionAllList.addAll(this.mFloatActList);
        }
        if (!FP.empty(this.mFloatGameList)) {
            actionAllList.addAll(this.mFloatGameList);
        }
        this.mIView.setActivityList(actionAllList, this.mPrivilegeActionList);
    }

    @NotNull
    private ActivityTagInfo getRoomTag() {
        ChannelTagItem tag = this.getChannelDetailInfo().baseInfo.tag.getFirstTag();
        ActivityTagInfo info = new ActivityTagInfo("" + tag.getTagId(), tag.getName(), this.getChannel().getSeatService().getSeatIndex(AccountUtil.getUid()));
        info.setPluginType(this.getChannel().getPluginService().getCurPluginData().getMode());
        info.setPluginSubType(this.getChannel().getPluginService().getCurPluginData().isVideoMode() ? PluginSubType.PluginSubTypeVideo.getValue() : PluginSubType.PluginSubTypeAudio.getValue());
        info.setChannelRole(this.getChannel().getRoleService().getMyRoleCache());
        return info;
    }

    @Override
    @Nullable
    public List<ActivityAction> getActivityList() {
        return this.mActionList;
    }

    @Override
    public void setIView(RoomActivityListMvp.IView iView) {
        this.mIView = iView;
        if (this.mIView == null) {
            return;
        }
        this.mIView.setOnItemClick(this);
        if (FP.empty(this.mActionList)) {
            this.requestActivities(false);
        } else {
            this.reportHiido(this.mActionList, "activity_id", "revenue_act_pannel_show");
        }
        if (FP.empty(this.mFloatActList)) {
            this.requestFloatActivities();
        } else {
            this.reportHiido(this.mActionList, "activity_id", "revenue_act_pannel_show");
        }
        if (FP.empty(this.mPrivilegeActionList)) {
            this.requestPrivilegeCenters(false);
        } else {
            this.reportHiido(this.mPrivilegeActionList, "privilege_id", "privilege_pannel_show");
        }
        if (FP.empty(this.mFloatGameList)) {
            this.fetchFloatGameInfo();
        }
        this.updateActionList();
    }

    @Override
    public void hidePanel() {
        this.getWindow().getPanelLayer().hidePanel(this.mBasePanel, true);
        this.removePanel();
        this.mOnActivityListHideListener.onHide();
    }

    @Override
    public boolean isHaveActivityList() {
        return !FP.empty(this.mActionList) || !FP.empty(this.mPrivilegeActionList) || !FP.empty(this.mFloatActList) || !FP.empty(this.mFloatGameList);
    }

    @Override
    public void setOnActivityListHideListener(RoomActivityListMvp.IPresenter.OnActivityListHideListener listener2) {
        this.mOnActivityListHideListener = listener2;
    }

    private void removePanel() {
        this.mBasePanel = null;
        this.setIView(null);
    }

    public void onDestroy() {
        super.onDestroy();
        this.getChannel().getPluginService().removePluginDataListener(this.mPluginChangedListener);
        this.getChannel().getSeatService().removeSeatUpdateListener((ISeatUpdateListener)this);
        this.mActionList = null;
        this.mFloatActList = null;
        this.mFloatGameList = null;
        this.mFloatGameInfoList = null;
    }

    @Override
    public void onClick(@Nullable ActivityAction action) {
        if (action == null || action.linkType == null) {
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)((IChannelPageContext)this.getMvpContext()).getContext())) {
            ToastUtils.showToast((Context)((IChannelPageContext)this.getMvpContext()).getContext(), (int)R.string.check_network_and_retry);
            return;
        }
        this.hidePanel();
        String id2 = "activity_id";
        String functionId = "revenue_act_pannel_click";
        if (action instanceof PrivilegeAction) {
            id2 = "privilege_id";
            functionId = "privilege_pannel_click";
        }
        ChannelTrack.INSTANCE.reportRevenueActPanelClick(String.valueOf(action.id), id2, functionId, action.linkUrl);
        action.hasRead = true;
        this.updateRedState(action);
        if (action.linkType == ActivityAction.LinkShowType.APP && TextUtils.equals((CharSequence)action.linkUrl, (CharSequence)TURN_PANEL_LINK_URL)) {
            this.startTurnTable();
            return;
        }
        if (action.linkType == ActivityAction.LinkShowType.APP && StringUtils.equal((String)action.linkUrl, (String)"mora")) {
            this.startMora();
            return;
        }
        if (action.linkType == ActivityAction.LinkShowType.FLOAT_GAME) {
            ((ChannelFloatPlayPresenter)this.getPresenter(ChannelFloatPlayPresenter.class)).startFloatGame(action);
            ChannelTrack.INSTANCE.ongGameClick();
            return;
        }
        if (action.linkType == ActivityAction.LinkShowType.FLOAT_WEB) {
            ((ChannelFloatPlayPresenter)this.getPresenter(ChannelFloatPlayPresenter.class)).startFloatWeb(action);
            ChannelTrack.INSTANCE.ongGameClick();
            return;
        }
        ActionManager.obtain().onAction(action);
    }

    private void updateRedState(ActivityAction action) {
        if (!(action instanceof PrivilegeAction)) {
            ChannelRedPointManager.INSTANCE.setKey(action.originType, true);
        }
        ((RoomGameAndActivityListPresenter)this.getPresenter(RoomGameAndActivityListPresenter.class)).checkRoomActivityReadStatus();
        ((BottomPresenter)this.getPresenter(BottomPresenter.class)).checkPluginShow();
    }

    private void startTurnTable() {
        RoomTrack.INSTANCE.reportRouBtnClick(this.getChannel().getChannelId());
        IRevenueToolsModulePresenter turnTablePresenter = (IRevenueToolsModulePresenter)this.getPresenter(IRevenueToolsModulePresenter.class);
        if (turnTablePresenter != null) {
            turnTablePresenter.start();
        }
    }

    private void startMora() {
        RoomTrack.INSTANCE.reportRouBtnClick(this.getChannel().getChannelId());
        IRevenueToolsModulePresenter moraPresenter = (IRevenueToolsModulePresenter)this.getPresenter(IRevenueToolsModulePresenter.class);
        if (moraPresenter != null) {
            moraPresenter.openStartMoraPanel(1);
        }
    }

    public void onSeatUpdate(List<SeatUser> seatUserList) {
        boolean isMySeatChanged = this.isMySeatChanged();
        if (isMySeatChanged) {
            this.requestActivities(true);
            this.requestPrivilegeCenters(true);
        }
    }

    private boolean isMySeatChanged() {
        int myIndex = this.getChannel().getSeatService().getSeatIndex(AccountUtil.getUid());
        if (myIndex >= 0) {
            MLog.debug((Object)TAG, (String)"my seat changed, not leave seat, before : %d after: %d ", (Object[])new Object[]{this.lastMySeatIndex, myIndex});
            this.lastMySeatIndex = myIndex;
            return true;
        }
        if (this.lastMySeatIndex >= 0) {
            MLog.debug((Object)TAG, (String)"my seat changed, leave seat, before : %d after: %d ", (Object[])new Object[]{this.lastMySeatIndex, myIndex});
            this.lastMySeatIndex = myIndex;
            return true;
        }
        return false;
    }

    private void reportHiido(List<ActivityAction> actionList, String actId, String functionId) {
        if (StringUtils.isNotEmpty((String)this.getChannel().getChannelId()) && !FP.empty(actionList)) {
            StringBuilder builder = new StringBuilder();
            for (ActivityAction action : actionList) {
                if (action == null) continue;
                ChannelTrack.INSTANCE.reportRevenueActPanelShow("" + action.id, functionId, actId, action.linkUrl);
            }
        }
    }

    private static class PrivilegeActivityCallback
    implements Callback<ActivityActionList> {
        private final WeakReference<RoomActivityListPresenter> ref;

        PrivilegeActivityCallback(RoomActivityListPresenter presenter) {
            this.ref = new WeakReference<RoomActivityListPresenter>(presenter);
        }

        public void onResponse(ActivityActionList data2) {
            RoomActivityListPresenter presenter = (RoomActivityListPresenter)this.ref.get();
            if (presenter == null) {
                return;
            }
            if (presenter.isDestroyed()) {
                return;
            }
            if (data2 == null || FP.empty((Collection)data2.list)) {
                return;
            }
            ArrayList<PrivilegeAction> list2 = new ArrayList<PrivilegeAction>();
            for (ActivityAction action : data2.list) {
                list2.add(new PrivilegeAction(action));
            }
            presenter.mPrivilegeActionList = list2;
            RoomActivityListPresenter.filterMinorDisabled(presenter.mPrivilegeActionList);
            if (presenter.mIView != null) {
                presenter.updateActionList();
                presenter.reportHiido(presenter.mPrivilegeActionList, "privilege_id", "privilege_pannel_show");
            }
            ((BottomPresenter)presenter.getPresenter(BottomPresenter.class)).updatePluginView();
        }
    }

    private static class FetchActivityCallback
    implements Callback<ActivityActionList> {
        private final WeakReference<RoomActivityListPresenter> ref;

        FetchActivityCallback(RoomActivityListPresenter presenter) {
            this.ref = new WeakReference<RoomActivityListPresenter>(presenter);
        }

        public void onResponse(ActivityActionList data2) {
            RoomActivityListPresenter presenter = (RoomActivityListPresenter)this.ref.get();
            if (presenter == null) {
                return;
            }
            if (presenter.isDestroyed()) {
                return;
            }
            if (data2 == null) {
                presenter.mActionList = Collections.emptyList();
            } else {
                presenter.mActionList = data2.list;
            }
            presenter.handleActionListRedState(presenter, presenter.mActionList);
        }
    }

    private static class FetchFloatActCallback
    implements Callback<List<ActivityAction>> {
        private final WeakReference<RoomActivityListPresenter> ref;

        FetchFloatActCallback(RoomActivityListPresenter presenter) {
            this.ref = new WeakReference<RoomActivityListPresenter>(presenter);
        }

        public void onResponse(List<ActivityAction> data2) {
            MLog.info((Object)TAG, (String)"requestFloatActivities size: %s", (Object[])new Object[]{FP.size(data2)});
            RoomActivityListPresenter presenter = (RoomActivityListPresenter)this.ref.get();
            if (presenter == null) {
                return;
            }
            if (presenter.isDestroyed()) {
                return;
            }
            if (presenter.mFloatActList == null) {
                presenter.mFloatActList = Collections.emptyList();
            } else {
                presenter.mFloatActList = data2;
            }
            presenter.handleActionListRedState(presenter, presenter.mFloatActList);
        }
    }
}

