/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatSeekBar;
import com.yy.base.utils.ResolutionUtils;

public class VolumeSeekBar
extends AppCompatSeekBar {
    private Paint mPaint;
    private float mTextWidth;
    private float mTextHeight;
    private String mText = "";

    public VolumeSeekBar(Context context) {
        super(context);
        this.init();
    }

    public VolumeSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public VolumeSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextSize((float)ResolutionUtils.spToPx((float)11.0f));
        this.mPaint.setColor(Color.parseColor((String)"#333333"));
        this.mPaint.setTypeface(Typeface.DEFAULT_BOLD);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setThumbOffset(0);
        }
    }

    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.calTextWH();
        if (Build.VERSION.SDK_INT >= 16) {
            Rect rectSeek = this.getThumb().getBounds();
            float textX = (float)(rectSeek.left + rectSeek.width()) - this.mTextWidth / 2.0f;
            float textY = (float)rectSeek.height() / 2.0f + this.mTextHeight / 2.0f - 5.0f;
            canvas.drawText(this.mText, textX, textY, this.mPaint);
        } else {
            Rect rectSeek = this.getProgressDrawable().getBounds();
            float textX = (float)(rectSeek.width() * this.getProgress()) / 100.0f - this.mTextWidth / 2.0f + (float)this.getPaddingLeft();
            float textY = (float)rectSeek.top + this.mTextHeight / 2.0f;
            canvas.drawText(this.mText, textX, textY, this.mPaint);
        }
    }

    public void setText(String text) {
        this.mText = text;
    }

    private void calTextWH() {
        this.mText = this.getProgress() + "%";
        Paint.FontMetrics fm = this.mPaint.getFontMetrics();
        this.mTextWidth = this.mPaint.measureText(this.mText);
        this.mTextHeight = fm.descent - fm.ascent;
    }
}

