/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music.musicplayer;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.dialog.OkCancelTitleDialog;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.AbsChannelWindow;
import com.yy.hiyo.channel.component.music.MusicHelper;
import com.yy.hiyo.channel.component.music.musicplayer.MusicPlayerMvp;
import com.yy.hiyo.channel.component.music.widget.VolumeSeekBar;
import com.yy.hiyo.mvp.base.ICustomView;
import java.util.List;

public class MusicPLayerPanel
extends YYConstraintLayout
implements MusicPlayerMvp.IView,
ICustomView,
View.OnClickListener {
    private Context mContext;
    private MusicPlayerMvp.IPresenter mPresenter;
    private View mView;
    private VolumeSeekBar volumeSeekbar;
    private YYTextView musicNameTv;
    private CommonStatusLayout statusLayout;
    private YYImageView playIv;
    private BasePanel mMusicPanel;
    private BasePanel.SimplePanelListener mPanelListener;

    public MusicPLayerPanel(@NonNull Context context) {
        super(context);
        this.mContext = context;
        this.createView(null);
    }

    public void createView(@Nullable AttributeSet attrs) {
        this.mView = View.inflate((Context)this.mContext, (int)R.layout.layout_music_player_panel_channel, (ViewGroup)this);
        this.volumeSeekbar = (VolumeSeekBar)this.mView.findViewById(R.id.seekbar_volume);
        this.volumeSeekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (null != MusicPLayerPanel.this.mPresenter) {
                    MusicPLayerPanel.this.mPresenter.setVolume(progress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.statusLayout = (CommonStatusLayout)this.mView.findViewById(R.id.layout_status);
        this.musicNameTv = (YYTextView)this.mView.findViewById(R.id.tv_name);
        this.playIv = (YYImageView)this.mView.findViewById(R.id.iv_play);
        this.mView.findViewById(R.id.iv_play).setOnClickListener((View.OnClickListener)this);
        this.mView.findViewById(R.id.iv_next).setOnClickListener((View.OnClickListener)this);
        this.mView.findViewById(R.id.iv_pre).setOnClickListener((View.OnClickListener)this);
        this.mView.findViewById(R.id.iv_playlist).setOnClickListener((View.OnClickListener)this);
        this.mView.findViewById(R.id.tv_add_music).setOnClickListener((View.OnClickListener)this);
        this.mView.findViewById(R.id.layout_status).setOnClickListener((View.OnClickListener)this);
    }

    private void initData() {
        this.statusLayout.showLoading();
        this.mPresenter.requestPlaylist(new MusicHelper.PlaylistCallback(){

            @Override
            public void playlistGetted(List<MusicPlaylistDBBean> playList) {
                MusicPLayerPanel.this.statusLayout.hideAllStatus();
                if (null == playList || playList.isEmpty()) {
                    MusicPLayerPanel.this.findViewById(R.id.layout_empty).setVisibility(0);
                    MusicPLayerPanel.this.findViewById(R.id.layout_player).setVisibility(8);
                } else {
                    MusicPLayerPanel.this.findViewById(R.id.layout_empty).setVisibility(8);
                    MusicPLayerPanel.this.findViewById(R.id.layout_player).setVisibility(0);
                }
            }
        });
    }

    @Override
    public void setMusicName(String name) {
        this.musicNameTv.setText((CharSequence)name);
        this.musicNameTv.setSelected(true);
    }

    @Override
    public void setVolume(int volume) {
        this.volumeSeekbar.setProgress(volume);
    }

    @Override
    public void setPlayView(boolean isPlay) {
        if (isPlay) {
            this.playIv.setImageResource(R.drawable.music_player_pause);
        } else {
            this.playIv.setImageResource(R.drawable.music_player_play);
        }
    }

    public void onClick(View v) {
        if (null == this.mPresenter) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.iv_play) {
            this.mPresenter.clickPlay();
        } else if (id2 == R.id.iv_next) {
            this.mPresenter.clickNext();
        } else if (id2 == R.id.iv_pre) {
            this.mPresenter.clickPre();
        } else if (id2 == R.id.iv_playlist) {
            this.mPresenter.clickPlaylist();
        } else if (id2 == R.id.tv_add_music) {
            this.mPresenter.clickAddMusic();
        } else if (id2 == R.id.layout_status) {
            // empty if block
        }
    }

    public void setPresenter(MusicPlayerMvp.IPresenter presenter) {
        this.mPresenter = presenter;
        this.initData();
    }

    @Override
    public void setPanelListener(BasePanel.SimplePanelListener listener2) {
        this.mPanelListener = listener2;
    }

    @Override
    public void hidePanel(AbsChannelWindow window) {
        if (null != this.mMusicPanel) {
            window.getPanelLayer().hidePanel(this.mMusicPanel, true);
            this.mMusicPanel = null;
        }
    }

    @Override
    public void showPanel(AbsChannelWindow window) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(12);
        if (this.mMusicPanel == null) {
            this.mMusicPanel = new BasePanel(this.getContext());
            this.mMusicPanel.setShowAnim(this.mMusicPanel.createBottomShowAnimation());
            this.mMusicPanel.setHideAnim(this.mMusicPanel.createBottomHideAnimation());
            this.mMusicPanel.setListener((BasePanel.IPanelListener)this.mPanelListener);
        }
        this.mMusicPanel.setContent(this.getPanel(), params);
        window.getPanelLayer().showPanel(this.mMusicPanel, true);
    }

    @Override
    public View getPanel() {
        return this;
    }

    @Override
    public void showOthersSongPlayingDialog(AbsChannelWindow window, String userName) {
        DialogLinkManager dialogLinkManager = window.getDialogLinkManager();
        String content = ResourceUtils.getString((int)R.string.bgm_pause_tip, (Object[])new Object[]{userName});
        OkCancelTitleDialog dialog2 = new OkCancelTitleDialog.Builder().cancelable(true).okLabel((CharSequence)ResourceUtils.getString((int)R.string.stop_music)).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.cancel)).message((CharSequence)content).listener(new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                MusicPLayerPanel.this.mPresenter.pauseOthersSongAndPlayMySong();
            }
        }).build();
        dialogLinkManager.showDialog((BaseDialog)dialog2);
    }

    @Override
    public void requestUpdateView() {
        this.initData();
    }
}

