/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music.addmusic.mvp;

import android.content.Context;
import android.view.View;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.music.addmusic.AddMusicPage;
import com.yy.hiyo.channel.component.music.addmusic.IAddMusicCallback;
import com.yy.hiyo.channel.component.music.addmusic.mvp.AddMusicMvp;
import com.yy.hiyo.channel.component.music.addmusic.utils.ScanMusicManager;
import com.yy.hiyo.mvp.base.BasePresenter;
import com.yy.hiyo.mvp.base.IMvpContext;
import java.util.ArrayList;
import java.util.List;

public class AddMusicPresenter
extends BasePresenter
implements AddMusicMvp.IPresenter {
    private static final String TAG = "AddMusicPresenter";
    private IMvpContext mMvpContext;
    private IAddMusicCallback mAddMusicCallback;
    private AddMusicPage mAddMusicPage;
    private boolean mNeedShowToast = false;
    private boolean mIsExit = false;
    private MutableLiveData<List<MusicPlaylistDBBean>> mMusicFileList;
    private DialogLinkManager mDialogLinkManager;

    public AddMusicPresenter(IMvpContext mvpContext, IAddMusicCallback callback2) {
        super(mvpContext);
        this.mMvpContext = mvpContext;
        this.mAddMusicCallback = callback2;
        this.mIsExit = false;
    }

    @Override
    public LiveData<List<MusicPlaylistDBBean>> getLocalMusicFiles(boolean isRefresh) {
        if (this.mMusicFileList == null) {
            this.mMusicFileList = new MutableLiveData();
        }
        if (isRefresh) {
            this.mNeedShowToast = true;
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (AddMusicPresenter.this.mAddMusicPage != null && AddMusicPresenter.this.mNeedShowToast) {
                        ToastUtils.showToast((Context)AddMusicPresenter.this.getMvpContext().getContext(), (String)ResourceUtils.getString((int)R.string.short_tips_wait_proceeding_files), (int)0);
                    }
                }
            }, (long)8000L);
            ScanMusicManager.INSTANCE.updateMedia(this.mMvpContext.getContext(), new IUpdateMediaCallback(){

                @Override
                public void updateMediaSucceed() {
                    AddMusicPresenter.this.mNeedShowToast = false;
                    if (!AddMusicPresenter.this.mIsExit) {
                        AddMusicPresenter.this.scanMusicFiles();
                    }
                }
            });
        } else {
            this.scanMusicFiles();
        }
        return this.mMusicFileList;
    }

    @Override
    public void updateSelectedList(List<MusicPlaylistDBBean> list2) {
        if (this.mMusicFileList != null && list2 != null) {
            ArrayList<MusicPlaylistDBBean> newList = new ArrayList<MusicPlaylistDBBean>(list2);
            this.mMusicFileList.setValue(newList);
        }
    }

    @Override
    public void addingMusic(List<MusicPlaylistDBBean> list2) {
        if (this.mAddMusicCallback != null) {
            this.mAddMusicCallback.addingMusic(list2);
        }
    }

    @Override
    public void toSearchPage(List<MusicPlaylistDBBean> list2) {
        if (this.mAddMusicCallback != null) {
            this.mAddMusicCallback.toSearchPage(list2);
        }
    }

    @Override
    public void showExitDialog() {
        OkCancelDialog dialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.tips_add_music_dialog), (CharSequence)ResourceUtils.getString((int)R.string.dialog_ok), (CharSequence)ResourceUtils.getString((int)R.string.str_button_cancel), true, false, new OkCancelDialogListener(){

            public void onCancel() {
                AddMusicPresenter.this.getDialogLinkManager().dismissDialog();
                if (AddMusicPresenter.this.mAddMusicCallback != null) {
                    AddMusicPresenter.this.mAddMusicCallback.exit();
                }
            }

            public void onOk() {
                AddMusicPresenter.this.getDialogLinkManager().dismissDialog();
                if (AddMusicPresenter.this.mAddMusicCallback != null) {
                    AddMusicPresenter.this.mAddMusicCallback.addingMusic(AddMusicPresenter.this.mAddMusicPage.getSelectedMusicList());
                }
            }
        });
        this.getDialogLinkManager().showDialog((BaseDialog)dialog2);
    }

    @Override
    public void setPageView(View view2) {
        this.mAddMusicPage = (AddMusicPage)view2;
    }

    private void scanMusicFiles() {
        final List<MusicPlaylistDBBean> localList = ScanMusicManager.INSTANCE.getMusicData(this.mMvpContext.getContext());
        MLog.info((Object)TAG, (String)"scanMusicFiles localList=%d", (Object[])new Object[]{localList.size()});
        MyBox musicPlaylistMyBox = ((IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class)).boxForCurUser(MusicPlaylistDBBean.class);
        if (musicPlaylistMyBox != null) {
            musicPlaylistMyBox.getAll((MyBox.IGetItemsCallBack)new MyBox.IGetItemsCallBack<MusicPlaylistDBBean>(){

                public void onLoaded(ArrayList<MusicPlaylistDBBean> datas) {
                    if (localList != null && datas != null) {
                        for (MusicPlaylistDBBean playlistDBBean : datas) {
                            if (!localList.contains(playlistDBBean)) continue;
                            localList.remove(playlistDBBean);
                        }
                        MLog.info((Object)AddMusicPresenter.TAG, (String)"scanMusicFiles after localList=%d", (Object[])new Object[]{localList.size()});
                        if (AddMusicPresenter.this.mMusicFileList != null) {
                            AddMusicPresenter.this.mMusicFileList.setValue((Object)localList);
                        }
                    }
                }
            });
        }
    }

    public void backKeyEvent() {
        if (this.mAddMusicPage.getSelectCount() > 0) {
            this.showExitDialog();
        } else {
            this.exit();
        }
    }

    @Override
    public void exit() {
        this.mNeedShowToast = false;
        this.mIsExit = true;
        if (this.mAddMusicCallback != null) {
            this.mAddMusicCallback.exit();
        }
        ScanMusicManager.INSTANCE.stopScan();
    }

    @Override
    public void clearData() {
        this.mMusicFileList = null;
    }

    private DialogLinkManager getDialogLinkManager() {
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager(this.getMvpContext().getContext());
        }
        return this.mDialogLinkManager;
    }

    public static interface IUpdateMediaCallback {
        public void updateMediaSucceed();
    }
}

