/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music.addmusic;

import android.app.Activity;
import android.os.Message;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.IDBService;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.ChannelMsgDef;
import com.yy.hiyo.channel.component.music.MusicHelper;
import com.yy.hiyo.channel.component.music.addmusic.AddMusicWindow;
import com.yy.hiyo.channel.component.music.addmusic.ChannelAddMusicMsgDef;
import com.yy.hiyo.channel.component.music.addmusic.IAddMusicCallback;
import com.yy.hiyo.channel.component.music.addmusic.mvp.AddMusicMvp;
import com.yy.hiyo.channel.component.music.addmusic.mvp.AddMusicPresenter;
import com.yy.hiyo.channel.component.music.searchmusic.ChannelSearchMusicMsgDef;
import com.yy.hiyo.mvp.base.MvpController;
import java.util.List;

public class AddMusicController
extends MvpController
implements IAddMusicCallback {
    private AddMusicWindow mAddMusicWindow;
    private AddMusicPresenter mAddMusicPresenter = new AddMusicPresenter(this.getMvpContext(), this);

    public AddMusicController(Environment env) {
        super(env);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_ENTERED, (INotify)this);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == ChannelAddMusicMsgDef.OPEN_ADD_MUSIC_PAGE) {
            this.showAddMusicPage();
        } else if (msg.what == ChannelAddMusicMsgDef.ADD_MUSIC_FORM_SEARCH) {
            if (msg.obj instanceof List) {
                List list2 = (List)msg.obj;
                if (this.mAddMusicPresenter != null) {
                    this.mAddMusicPresenter.updateSelectedList(list2);
                }
            }
        } else if (msg.what == ChannelAddMusicMsgDef.CLOSE_ADD_MUSIC_PAGE) {
            this.exit();
        }
    }

    private void showAddMusicPage() {
        this.mAddMusicWindow = this.getAddMusicWindow();
        this.mWindowMgr.pushWindow((AbstractWindow)this.mAddMusicWindow, true);
    }

    public AddMusicWindow getAddMusicWindow() {
        if (this.mAddMusicWindow != null) {
            return this.mAddMusicWindow;
        }
        this.mAddMusicWindow = new AddMusicWindow(this.getMvpContext(), this);
        return this.mAddMusicWindow;
    }

    @Override
    public AddMusicMvp.IPresenter getAddMusicPresenter() {
        if (this.mAddMusicPresenter == null) {
            this.mAddMusicPresenter = new AddMusicPresenter(this.getMvpContext(), this);
        }
        return this.mAddMusicPresenter;
    }

    @Override
    public void addingMusic(List<MusicPlaylistDBBean> list2) {
        long currentTimestamp = System.currentTimeMillis();
        for (int i = 0; i < list2.size(); ++i) {
            MusicPlaylistDBBean bean2 = list2.get(i);
            bean2.setAddTimestamp(currentTimestamp + (long)list2.size() - (long)i);
        }
        MyBox musicPlaylistMyBox = ((IDBService)this.getServiceManager().getService(IDBService.class)).boxForCurUser(MusicPlaylistDBBean.class);
        if (musicPlaylistMyBox != null) {
            musicPlaylistMyBox.updateItems(list2, true);
            MusicHelper.reloadList();
        }
        ToastUtils.showToast((Activity)this.getContext(), (int)R.string.tips_succeed, (int)0);
        this.exit();
        this.sendMessage(ChannelMsgDef.OPEN_MUSIC_PLAYLIST_WITHOUT_ANIM);
    }

    @Override
    public void toSearchPage(List<MusicPlaylistDBBean> list2) {
        Message message = Message.obtain();
        message.what = ChannelSearchMusicMsgDef.OPEN_SEARCH_MUSIC;
        message.obj = list2;
        message.arg1 = 3;
        this.sendMessage(message);
    }

    @Override
    public void exit() {
        if (this.mAddMusicWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mAddMusicWindow);
            this.mAddMusicWindow = null;
        }
        if (this.mAddMusicPresenter != null) {
            this.mAddMusicPresenter.clearData();
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        this.mAddMusicPresenter = null;
    }

    protected boolean onWindowBackKeyEvent() {
        if (this.mAddMusicPresenter != null) {
            this.mAddMusicPresenter.backKeyEvent();
        }
        return true;
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationIdDef.CHANNEL_ENTERED) {
            this.exit();
        }
    }
}

