/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.lock;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYButton;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.component.lock.gridpasswordview.GridPasswordView;

public class RoomCreateLockDialog
extends YYDialog
implements View.OnClickListener {
    private View mView;
    private Context mContext;
    private GridPasswordView mPasswordView;
    private YYButton okBtn;
    private YYTextView titleTv;
    private YYTextView contentTv;
    private YYLinearLayout mSelectPassword;
    private RecycleImageView rvLockModeSelect;
    private IRoomCreateLockListener listener;
    private int lockEnterMode = 1;

    public RoomCreateLockDialog(@NonNull Context context) {
        super(context, R.style.normal_yydialog);
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.mView = View.inflate((Context)this.mContext, (int)R.layout.dialog_lock_room_channel, null);
        ViewGroup.LayoutParams contentLp = new ViewGroup.LayoutParams(ResolutionUtils.dip2Px((float)275.0f), -2);
        this.setContentView(this.mView, contentLp);
        this.getWindow().clearFlags(131072);
        this.titleTv = (YYTextView)this.mView.findViewById(R.id.tv_title);
        this.contentTv = (YYTextView)this.mView.findViewById(R.id.tv_content);
        this.okBtn = (YYButton)this.mView.findViewById(R.id.btn_ok);
        this.mPasswordView = (GridPasswordView)this.mView.findViewById(R.id.gpv_pwd);
        this.mSelectPassword = (YYLinearLayout)this.mView.findViewById(R.id.ll_password_select);
        this.rvLockModeSelect = (RecycleImageView)this.mView.findViewById(R.id.rv_password_select);
        this.mPasswordView.togglePasswordVisibility();
        this.mView.findViewById(R.id.iv_close).setOnClickListener((View.OnClickListener)this);
        this.okBtn.setOnClickListener((View.OnClickListener)this);
        this.mPasswordView.setOnPasswordChangedListener(new GridPasswordView.OnPasswordChangedListener(){

            @Override
            public void onTextChanged(String psw) {
                if (StringUtils.isEmpty((String)psw) || psw.length() < 4) {
                    RoomCreateLockDialog.this.okBtn.setActivated(false);
                } else {
                    RoomCreateLockDialog.this.okBtn.setActivated(true);
                }
                RoomCreateLockDialog.this.setContentTxt("");
            }

            @Override
            public void onInputFinish(String psw) {
            }
        });
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (RoomCreateLockDialog.this.mPasswordView != null) {
                    RoomCreateLockDialog.this.mPasswordView.forceInputViewGetFocus();
                }
            }
        }, (long)150L);
        this.rvLockModeSelect.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (RoomCreateLockDialog.this.lockEnterMode == 1) {
                    RoomCreateLockDialog.this.rvLockModeSelect.setBackgroundResource(R.drawable.bbs_icon_tag_selected);
                    RoomCreateLockDialog.this.lockEnterMode = 2;
                    ChannelTrack.INSTANCE.channelNoPsClick();
                } else {
                    RoomCreateLockDialog.this.rvLockModeSelect.setBackgroundResource(R.drawable.bg_channel_setting);
                    RoomCreateLockDialog.this.lockEnterMode = 1;
                    ChannelTrack.INSTANCE.channelNeedPsClick();
                }
            }
        });
    }

    public void initMode(int mode) {
        if (mode == 1) {
            this.rvLockModeSelect.setBackgroundResource(R.drawable.bbs_icon_tag_selected);
            this.lockEnterMode = 2;
        } else {
            this.rvLockModeSelect.setBackgroundResource(R.drawable.bg_channel_setting);
            this.lockEnterMode = 1;
        }
    }

    public void showNoLockDialog() {
        this.mSelectPassword.setVisibility(4);
        this.show();
    }

    public void showDialog() {
        this.show();
        this.okBtn.setActivated(false);
        this.mPasswordView.setVisibility(0);
        this.mPasswordView.clearPassword();
        this.okBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_lock_room_dialog));
        this.titleTv.setText((CharSequence)ResourceUtils.getString((int)R.string.title_lock_channel));
        this.mPasswordView.setInputShowable(true);
        this.mPasswordView.setItemBackground(ResourceUtils.getDrawable((int)R.drawable.shape_eeeeee_3dp));
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                RoomCreateLockDialog.this.mPasswordView.forceInputViewGetFocus();
            }
        }, (long)150L);
        this.setContentTxt("");
    }

    private void setContentTxt(String errorTxt) {
        this.contentTv.setTextColor(ColorUtils.parseColor((String)"#0b0505"));
        this.contentTv.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_set_password));
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_close) {
            this.dismiss();
            if (this.listener != null) {
                this.listener.onClose();
            }
        } else if (v.getId() == R.id.btn_ok) {
            if ((null == this.mPasswordView.getPassWord() || this.mPasswordView.getPassWord().length() != 4) && this.mPasswordView.getVisibility() == 0) {
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.tips_room_lock_invalid_pwd), (int)0);
                return;
            }
            if (this.listener != null) {
                this.dismiss();
                this.listener.onLock(this.mPasswordView.getPassWord(), this.lockEnterMode);
            }
        }
    }

    public void setListener(IRoomCreateLockListener listener2) {
        this.listener = listener2;
    }

    public static interface IRoomCreateLockListener {
        public void onClose();

        public void onLock(@NonNull String var1, int var2);
    }
}

