/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.lock;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.base.env.TargetBuildConstant;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYButton;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.component.lock.LockMvp;
import com.yy.hiyo.channel.component.lock.LockPresenter;
import com.yy.hiyo.channel.component.lock.gridpasswordview.GridPasswordView;

public class LockDialog
extends YYDialog
implements LockMvp.IView,
View.OnClickListener {
    private View mView;
    private Context mContext;
    private LockPresenter mPresenter;
    private GridPasswordView mPasswordView;
    private YYButton okBtn;
    private YYButton autoTestBtn;
    private RecycleImageView rvLockModeSelect;
    private YYTextView titleTv;
    private YYTextView contentTv;
    private YYLinearLayout lockTipsLayuout;
    private ButtonItem.OnClickListener mCloseListner;
    private int lockEnterMode = 2;
    private int mType;

    public LockDialog(@NonNull Context context) {
        super(context, R.style.normal_yydialog);
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.mView = View.inflate((Context)this.mContext, (int)R.layout.dialog_lock_room_channel, null);
        ViewGroup.LayoutParams contentLp = new ViewGroup.LayoutParams(ResolutionUtils.dip2Px((float)275.0f), ResolutionUtils.dip2Px((float)246.0f));
        this.setContentView(this.mView, contentLp);
        this.getWindow().clearFlags(131072);
        this.titleTv = (YYTextView)this.mView.findViewById(R.id.tv_title);
        this.contentTv = (YYTextView)this.mView.findViewById(R.id.tv_content);
        this.okBtn = (YYButton)this.mView.findViewById(R.id.btn_ok);
        this.mPasswordView = (GridPasswordView)this.mView.findViewById(R.id.gpv_pwd);
        this.mPasswordView.togglePasswordVisibility();
        this.rvLockModeSelect = (RecycleImageView)this.mView.findViewById(R.id.rv_password_select);
        this.lockTipsLayuout = (YYLinearLayout)this.mView.findViewById(R.id.ll_password_select);
        this.mView.findViewById(R.id.iv_close).setOnClickListener((View.OnClickListener)this);
        this.okBtn.setOnClickListener((View.OnClickListener)this);
        if (TargetBuildConstant.auto_test) {
            this.autoTestBtn = (YYButton)this.mView.findViewById(R.id.btn_auto_test);
            this.autoTestBtn.setVisibility(0);
            this.autoTestBtn.setOnClickListener((View.OnClickListener)this);
        }
        this.mPasswordView.setOnPasswordChangedListener(new GridPasswordView.OnPasswordChangedListener(){

            @Override
            public void onTextChanged(String psw) {
                if (StringUtils.isEmpty((String)psw) || psw.length() < 4) {
                    LockDialog.this.okBtn.setActivated(false);
                } else {
                    LockDialog.this.okBtn.setActivated(true);
                }
                LockDialog.this.setContentTxt("");
            }

            @Override
            public void onInputFinish(String psw) {
            }
        });
        this.rvLockModeSelect.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LockDialog.this.lockEnterMode == 1) {
                    LockDialog.this.rvLockModeSelect.setBackgroundResource(R.drawable.bbs_icon_tag_selected);
                    LockDialog.this.lockEnterMode = 2;
                    ChannelTrack.INSTANCE.channelNoPsClick();
                } else {
                    LockDialog.this.rvLockModeSelect.setBackgroundResource(R.drawable.bg_channel_setting);
                    LockDialog.this.lockEnterMode = 1;
                    ChannelTrack.INSTANCE.channelNeedPsClick();
                }
            }
        });
    }

    public void setPresenter(LockMvp.IPresenter presenter) {
        this.mPresenter = (LockPresenter)presenter;
    }

    @Override
    public void showDialog(final int type) {
        FeatureLog.i((String)"FTVoiceRoom", (String)"\u8bed\u97f3\u623f\u9501\u5f39\u7a97 type: %s", (Object[])new Object[]{type});
        this.mType = type;
        this.show();
        this.okBtn.setActivated(false);
        this.mPasswordView.setVisibility(0);
        this.mPasswordView.clearPassword();
        this.mPasswordView.setInputShowable(true);
        this.mPasswordView.setItemBackground(ResourceUtils.getDrawable((int)R.drawable.shape_eeeeee_3dp));
        if (type == 2) {
            this.okBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_lock_room_dialog_lowercase));
            this.titleTv.setText((CharSequence)ResourceUtils.getString((int)R.string.title_lock_channel));
            this.lockTipsLayuout.setVisibility(0);
        } else if (type == 4) {
            this.okBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_lock_room_dialog_lowercase));
            this.titleTv.setText((CharSequence)ResourceUtils.getString((int)R.string.title_lock_channel));
            this.lockTipsLayuout.setVisibility(8);
            this.lockEnterMode = 1;
        } else if (type == 3) {
            if (this.mPresenter != null && !this.mPresenter.getPassword().isEmpty()) {
                this.mPasswordView.setPassword(this.mPresenter.getPassword());
            } else {
                this.mPasswordView.setVisibility(8);
            }
            this.okBtn.setActivated(true);
            this.mPasswordView.setInputShowable(false);
            this.okBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_unlock_room_dialog_lowercase));
            this.titleTv.setText(R.string.title_unlock_channel);
            this.lockTipsLayuout.setVisibility(8);
        } else if (type == 1) {
            this.okBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_unlock_enter_room_dialog_lowercase));
            this.titleTv.setText((CharSequence)ResourceUtils.getString((int)R.string.title_unlock_channel_by_user));
            this.lockTipsLayuout.setVisibility(8);
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (type != 3) {
                    LockDialog.this.mPasswordView.forceInputViewGetFocus();
                }
            }
        }, (long)150L);
        this.setContentTxt("");
    }

    private void setContentTxt(String errorTxt) {
        if (StringUtils.isEmpty((String)errorTxt)) {
            this.contentTv.setTextColor(Color.parseColor((String)"#0b0505"));
            if (this.mType == 2) {
                this.contentTv.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_set_password));
            } else {
                this.contentTv.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_unlock_room_audience));
            }
        } else {
            this.contentTv.setTextColor(Color.parseColor((String)"#ff4a6d"));
            this.contentTv.setText((CharSequence)errorTxt);
        }
    }

    @Override
    public void showError(String errorInfo) {
        FeatureLog.i((String)"FTVoiceRoom", (String)"\u8bed\u97f3\u623f\u89e3\u9501\u5f39\u7a97 showError", (Object[])new Object[0]);
        this.setContentTxt(errorInfo);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_close) {
            this.dismiss();
            if (null != this.mCloseListner) {
                this.mCloseListner.onClick();
            }
        } else if (v.getId() == R.id.btn_ok) {
            if ((null == this.mPasswordView.getPassWord() || this.mPasswordView.getPassWord().length() != 4) && this.mPasswordView.getVisibility() == 0) {
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.tips_room_lock_invalid_pwd), (int)0);
                return;
            }
            this.mPresenter.clickOk(this.mPasswordView.getPassWord(), this.lockEnterMode);
        } else if (v.getId() == R.id.btn_auto_test && TargetBuildConstant.auto_test) {
            this.mPresenter.clickOk("9998", this.lockEnterMode);
        }
    }

    @Override
    public void setOnCloseClickListener(ButtonItem.OnClickListener listener2) {
        this.mCloseListner = listener2;
    }
}

