/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.voiceroom;

import android.graphics.Color;
import android.widget.TextView;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IOperationCallback;
import com.yy.hiyo.channel.component.invite.base.OnlineBean;
import com.yy.hiyo.channel.component.invite.online.handler.AbsOnlineInviteHandler;
import java.util.Collection;
import java.util.List;

public class SeatInviteHandler
extends AbsOnlineInviteHandler {
    private static final String TAG = "SeatInviteHandler";
    private static final int COLOR_SEATED;
    private static final int COLOR_INVITED;
    private IChannel mChannel;
    private int mSeatIndex = -1;

    public SeatInviteHandler(IChannel channel) {
        this.mChannel = channel;
    }

    public SeatInviteHandler(IChannel channel, int seatIndex) {
        this.mChannel = channel;
        this.mSeatIndex = seatIndex;
    }

    @Override
    public String getInviteTitle() {
        return ResourceUtils.getString((int)R.string.short_title_channel_invite_to_seat);
    }

    @Override
    public List<OnlineBean> filterOnlineData(List<OnlineBean> data2) {
        List uidInSeat = this.mChannel.getSeatService().getSeatUidsList();
        if (!FP.empty((Collection)uidInSeat) && data2 != null) {
            for (OnlineBean onlineBean : data2) {
                if (!uidInSeat.contains(onlineBean.uid)) continue;
                onlineBean.inivteStatus = 3;
            }
        }
        return data2;
    }

    @Override
    public void onInviteClick(final OnlineBean onlineBean) {
        this.mChannel.getSeatService().makeSitDown(this.mSeatIndex, onlineBean.uid, new IOperationCallback(){

            public void onSuccess() {
                onlineBean.inivteStatus = 1;
                SeatInviteHandler.this.notifyInviteStatusChange(onlineBean);
            }

            public void onFail(long reason) {
                MLog.error((Object)SeatInviteHandler.TAG, (String)("onInviteClick makeSitDown fail reason = " + reason), (Object[])new Object[0]);
            }
        });
    }

    @Override
    public void updateActionBtn(OnlineBean onlineBean, TextView actionBtn) {
        if (onlineBean.uid == AccountUtil.getUid()) {
            actionBtn.setVisibility(8);
        } else if (onlineBean.inivteStatus == 3) {
            actionBtn.setVisibility(0);
            actionBtn.setTextColor(COLOR_SEATED);
            actionBtn.setText(R.string.btn_room_user_sitted);
            actionBtn.setBackgroundResource(0);
            actionBtn.setOnClickListener(null);
        } else if (onlineBean.inivteStatus == 1) {
            actionBtn.setVisibility(0);
            actionBtn.setTextColor(COLOR_INVITED);
            actionBtn.setText(R.string.invited);
            actionBtn.setBackgroundResource(0);
            actionBtn.setOnClickListener(null);
        } else if (onlineBean.inivteStatus == 0) {
            actionBtn.setVisibility(0);
            actionBtn.setTextColor(-1);
            actionBtn.setText(R.string.btn_profile_card_sit);
            actionBtn.setBackgroundResource(R.drawable.bg_sit_profile_card);
            actionBtn.setOnClickListener(v -> this.onInviteClick(onlineBean));
        } else {
            actionBtn.setVisibility(8);
        }
    }

    static {
        COLOR_INVITED = COLOR_SEATED = Color.parseColor((String)"#999999");
    }
}

