/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.friend.share;

import android.content.Context;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.appbase.util.RegionUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.URLUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.invite.friend.data.InviteData;
import com.yy.hiyo.channel.component.invite.friend.share.RadioShareReport;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.IShareResultCallback;
import com.yy.hiyo.share.base.OnDataReadyCallback;
import com.yy.hiyo.share.base.ShareBundle;
import com.yy.hiyo.share.base.dataprovider.DataProgressListener;
import com.yy.hiyo.share.base.dataprovider.ShareDataProvider;
import com.yy.socialplatformbase.data.HagoShareData;
import java.util.List;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChannelPlatformShareHelper {
    private IMvpContext mvpContext;
    private ShareDataProvider shareDataProvider;
    private DialogLinkManager mDialogLinkManager;
    private long lastShareTime = 0L;

    public ChannelPlatformShareHelper(@NotNull IMvpContext mvpContext, ShareDataProvider provider) {
        this.mvpContext = mvpContext;
        this.shareDataProvider = provider;
    }

    private void showLoading() {
        if (this.mvpContext == null) {
            return;
        }
        DialogLinkManager dialogLinkManager = this.getDialogLinkManager();
        dialogLinkManager.showDialog((BaseDialog)new ProgressDialog());
    }

    private void hideLoading() {
        if (this.mvpContext == null) {
            return;
        }
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
    }

    public void shareToNativeChannel(InviteData inviteData, String toCId) {
        IIntlShareService shareService = (IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class);
        if (shareService == null) {
            return;
        }
        this.shareDataProvider.waitDataReady(shareBundle -> this.doHagoShare(16, inviteData, shareBundle, toCId));
    }

    public void share(final int channelId, final InviteData inviteData) {
        if (System.currentTimeMillis() - this.lastShareTime < 2000L) {
            MLog.error((Object)"FTVoiceRoom", (String)"share too frequent", (Object[])new Object[0]);
            return;
        }
        this.lastShareTime = System.currentTimeMillis();
        IIntlShareService shareService = (IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class);
        if (shareService == null) {
            return;
        }
        if (channelId != 10 && channelId != 5 && channelId != 9 && channelId != 13 && !shareService.checkAppNeedInstalledOrToast(channelId)) {
            return;
        }
        this.shareDataProvider.reset();
        this.shareDataProvider.setDataBuildProgressListener(new DataProgressListener(){

            public void onStart() {
                ChannelPlatformShareHelper.this.showLoading();
            }

            public void onEnd() {
                ChannelPlatformShareHelper.this.hideLoading();
            }
        });
        this.shareDataProvider.waitDataReady(new OnDataReadyCallback(){

            public void onDataReady(ShareBundle shareBundle) {
                if (channelId == 13) {
                    ChannelPlatformShareHelper.this.doHagoShare(channelId, inviteData, shareBundle, null);
                } else {
                    ChannelPlatformShareHelper.this.shareReal(channelId, shareBundle);
                }
            }
        });
    }

    private void shareReal(final int channelId, ShareBundle shareBundle) {
        if (shareBundle != null) {
            IIntlShareService shareService = (IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class);
            shareService.share(channelId, shareBundle, new IShareResultCallback(){
                private boolean hasReported = false;

                public void onResult(int code, @NotNull String msg) {
                    MLog.info((Object)"shareReal", (String)"onResult, code %d, msg %s, hasReported %b", (Object[])new Object[]{code, msg, this.hasReported});
                    if (code == 1 && !this.hasReported && ChannelPlatformShareHelper.this.mvpContext instanceof IChannelPageContext) {
                        this.hasReported = true;
                        new RadioShareReport((IChannel)((IChannelPageContext)ChannelPlatformShareHelper.this.mvpContext).getChannel()).onShareSuccess(channelId);
                    }
                }
            });
        }
    }

    private DialogLinkManager getDialogLinkManager() {
        if (this.mDialogLinkManager == null && this.mvpContext != null) {
            this.mDialogLinkManager = new DialogLinkManager(this.mvpContext.getContext());
        }
        return this.mDialogLinkManager;
    }

    private void doHagoShare(int channelId, final InviteData inviteData, ShareBundle bundle, @Nullable String toCid) {
        String deepLink = "hago://channel/exactlyChannel?channelId=%s&show_guide=false&channel_token=%s&targetShare=%s";
        deepLink = URLUtils.addParam((String)deepLink, (String)"channel_entry", (String)String.valueOf(154));
        if ("hago.amongus".equals(inviteData.channelSource)) {
            deepLink = URLUtils.addParam((String)deepLink, (String)"isamongus", (String)"1");
        }
        String channelType = this.buildChannelType(inviteData.roomType);
        String title = this.buildTitle(inviteData.roomType);
        String content = this.buildContent(inviteData.roomType);
        String finalDeepLink = deepLink;
        inviteData.tokenProvider.getToken((DataCallback<String>)((DataCallback)token -> {
            AConfigData config2;
            String avatar2 = "";
            if ("text_channel".equalsIgnoreCase(channelType)) {
                avatar2 = inviteData.channelCover == null ? "" : inviteData.channelCover;
            } else {
                UserInfoKS user = ((IUserInfoService)ServiceManagerProxy.getInstance().getService(IUserInfoService.class)).getUserInfo(inviteData.ownerUid);
                if (user != null && user.ver > 0L) {
                    avatar2 = user.avatar;
                }
            }
            String familyDetailUrl = "";
            if (inviteData.isFamily && (config2 = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG)) instanceof CommonConfig) {
                CommonConfigData commonConfigData = ((CommonConfig)config2).getData();
                familyDetailUrl = StringUtils.format((String)commonConfigData.familyDetailUrl, (Object[])new Object[]{inviteData.channelId});
            }
            String jumpUrl = "";
            jumpUrl = StringUtils.isNotEmpty((String)familyDetailUrl) ? URLUtils.addParam((String)familyDetailUrl, (String)"useNativeDetail", (String)"true") : StringUtils.format((String)finalDeepLink, (Object[])new Object[]{inviteData.channelId, token, channelId});
            HagoShareData data2 = HagoShareData.build((int)1, (String)channelType, (long)AccountUtil.getUid(), (String)inviteData.channelId, (String)title, (String)inviteData.channelName, (String)content, (String)jumpUrl, (String)avatar2, builder -> {
                builder.setCardType(0);
                builder.setPluginId(inviteData.pluginId);
                builder.setSelectInterceptor((uid, callback2) -> {
                    if (inviteData.inviteInterceptor == null || inviteData.inviteInterceptor.canCrossRegionInvite()) {
                        callback2.onResult(true);
                        return;
                    }
                    ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).requestUserInfoFromServer(uid, new OnKSProfileListCallback(){

                        public void onUISuccess(List<UserInfoKS> userInfo) {
                            UserInfoKS uinfo;
                            UserInfoKS userInfoKS = uinfo = userInfo != null && !userInfo.isEmpty() ? userInfo.get(0) : null;
                            if (uinfo != null && uinfo.ver > 0L && RegionUtils.isNotSame((String)inviteData.channelRegion, (String)uinfo.region)) {
                                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_cross_region_invite_channel), (int)0);
                                callback2.onResult(false);
                            } else {
                                callback2.onResult(true);
                            }
                        }

                        public void onError(String reason, long code) {
                            callback2.onResult(true);
                        }
                    });
                });
                if (channelId == 16 && toCid != null) {
                    builder.setSharePlatform(2);
                    builder.setToId(toCid);
                }
                return Unit.INSTANCE;
            });
            bundle.setHagoShareData(data2);
            this.shareReal(channelId, bundle);
        }));
    }

    private String buildChannelType(int roomType) {
        if (roomType == 3) {
            return "text_channel";
        }
        if (roomType == 1) {
            return "voice_channel";
        }
        if (roomType == 2) {
            return "live_channel";
        }
        if (roomType == 4) {
            return "team_up_room";
        }
        return "voice_channel";
    }

    private String buildTitle(int roomType) {
        if (roomType == 3) {
            return ResourceUtils.getString((int)R.string.title_share_invite_to_group);
        }
        if (roomType == 1) {
            return ResourceUtils.getString((int)R.string.title_share_invite_to_party);
        }
        if (roomType == 2) {
            return ResourceUtils.getString((int)R.string.title_share_invite_to_live_room);
        }
        if (roomType == 4) {
            return ResourceUtils.getString((int)R.string.title_share_invite_to_team_up);
        }
        return ResourceUtils.getString((int)R.string.title_share_invite_to_party);
    }

    private String buildContent(int roomType) {
        if (roomType == 3) {
            return ResourceUtils.getString((int)R.string.desc_join_group_room);
        }
        if (roomType == 1) {
            return ResourceUtils.getString((int)R.string.desc_join_party_room);
        }
        if (roomType == 2) {
            return ResourceUtils.getString((int)R.string.desc_join_live_room);
        }
        if (roomType == 4) {
            return ResourceUtils.getString((int)R.string.tip_share_team_up_content);
        }
        return ResourceUtils.getString((int)R.string.desc_join_party_room);
    }
}

