/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.familygroup.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import androidx.annotation.AnimRes;
import com.yy.base.memoryrecycle.views.YYFrameLayout;

public class ViewAnimator
extends YYFrameLayout {
    int mWhichChild = 0;
    boolean mFirstTime = true;
    boolean mAnimateFirstTime = true;
    Animation mInAnimation;
    Animation mOutAnimation;

    public ViewAnimator(Context context) {
        super(context);
    }

    public ViewAnimator(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean setDisplayedChild(int whichChild) {
        this.mWhichChild = whichChild;
        if (whichChild >= this.getChildCount()) {
            return false;
        }
        if (whichChild < 0) {
            this.mWhichChild = this.getChildCount() - 1;
        }
        boolean hasFocus = this.getFocusedChild() != null;
        this.showOnly(this.mWhichChild);
        if (hasFocus) {
            this.requestFocus(2);
        }
        return true;
    }

    public int getDisplayedChild() {
        return this.mWhichChild;
    }

    public boolean showNext() {
        return this.setDisplayedChild(this.mWhichChild + 1);
    }

    public void showPrevious() {
        this.setDisplayedChild(this.mWhichChild - 1);
    }

    void showOnly(int childIndex, boolean animate) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (i == childIndex) {
                if (animate && this.mInAnimation != null) {
                    child.startAnimation(this.mInAnimation);
                }
                child.setVisibility(0);
                this.mFirstTime = false;
                continue;
            }
            if (animate && this.mOutAnimation != null && child.getVisibility() == 0) {
                child.startAnimation(this.mOutAnimation);
            } else if (child.getAnimation() == this.mInAnimation) {
                child.clearAnimation();
            }
            child.setVisibility(8);
        }
    }

    void showOnly(int childIndex) {
        this.showOnly(childIndex, true);
    }

    public void removeAllViews() {
        super.removeAllViews();
        this.mWhichChild = 0;
        this.mFirstTime = true;
    }

    public void removeView(View view2) {
        int index = this.indexOfChild(view2);
        if (index >= 0) {
            this.removeViewAt(index);
        }
    }

    public void removeViewAt(int index) {
        super.removeViewAt(index);
        int childCount = this.getChildCount();
        if (childCount == 0) {
            this.mWhichChild = 0;
            this.mFirstTime = true;
        } else if (this.mWhichChild >= childCount) {
            this.setDisplayedChild(childCount - 1);
        } else if (this.mWhichChild == index) {
            this.setDisplayedChild(this.mWhichChild);
        }
    }

    public void removeViewInLayout(View view2) {
        this.removeView(view2);
    }

    public void removeViews(int start, int count) {
        super.removeViews(start, count);
        if (this.getChildCount() == 0) {
            this.mWhichChild = 0;
            this.mFirstTime = true;
        } else if (this.mWhichChild >= start && this.mWhichChild < start + count) {
            this.setDisplayedChild(this.mWhichChild);
        }
    }

    public void removeViewsInLayout(int start, int count) {
        this.removeViews(start, count);
    }

    public View getCurrentView() {
        return this.getChildAt(this.mWhichChild);
    }

    public Animation getInAnimation() {
        return this.mInAnimation;
    }

    public void setInAnimation(Animation inAnimation) {
        this.mInAnimation = inAnimation;
    }

    public Animation getOutAnimation() {
        return this.mOutAnimation;
    }

    public void setOutAnimation(Animation outAnimation) {
        this.mOutAnimation = outAnimation;
    }

    public void setInAnimation(Context context, @AnimRes int resourceID) {
        this.setInAnimation(AnimationUtils.loadAnimation((Context)context, (int)resourceID));
    }

    public void setOutAnimation(Context context, @AnimRes int resourceID) {
        this.setOutAnimation(AnimationUtils.loadAnimation((Context)context, (int)resourceID));
    }

    public boolean getAnimateFirstView() {
        return this.mAnimateFirstTime;
    }

    public void setAnimateFirstView(boolean animate) {
        this.mAnimateFirstTime = animate;
    }

    public int getBaseline() {
        return this.getCurrentView() != null ? this.getCurrentView().getBaseline() : super.getBaseline();
    }

    public CharSequence getAccessibilityClassName() {
        return ViewAnimator.class.getName();
    }
}

