/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.contribution;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.degrade.DiscardResult;
import com.yy.appbase.degrade.ISceneDegradedService;
import com.yy.appbase.degrade.ISceneOptLimiter;
import com.yy.appbase.degrade.ISceneOptLimiterCallback;
import com.yy.appbase.degrade.SimpleSceneOptLimiterCallback;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.webview.WebViewPanel;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.IHolderPresenter;
import com.yy.hiyo.channel.cbase.utils.ChannelUtils;
import com.yy.hiyo.channel.component.contribution.ContributionData;
import com.yy.hiyo.channel.component.contribution.ContributionDataManager;
import com.yy.hiyo.channel.component.contribution.GiftContributionModel;
import com.yy.hiyo.channel.component.contribution.GiftContributionNotifyDispatchService;
import com.yy.hiyo.channel.component.contribution.GiftContributionView;
import com.yy.hiyo.channel.component.contribution.GiftContributionWeekNotifyDispatchService;
import com.yy.hiyo.channel.component.contribution.IGiftContributionMvp;
import com.yy.hiyo.channel.component.contribution.rolling.RollingManager;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.webservice.WebEnvSettings;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.ihago.money.api.contribrank.ContribNotify;
import net.ihago.money.api.contribrank.DayContribNotify;
import net.ihago.money.api.contribrank.TopUsersUpdatedNotify;
import net.ihago.money.api.contribrank.Uri;
import net.ihago.money.api.contribrank.WeekContribNotify;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GiftContributionPresenter
extends BaseChannelPresenter
implements IGiftContributionMvp.IPresenter,
INotifyDispatchService.INotifyHandler,
IHolderPresenter {
    public static final String TAG = "GiftContributionPresenter";
    private GiftContributionModel model;
    private GiftContributionNotifyDispatchService mGiftContributionNotifyService;
    private GiftContributionWeekNotifyDispatchService mGiftContributionWeekNotifyService;
    private GiftContributionView mGiftContributionView;
    private String mChannelId = null;
    private boolean hideGiftContributeView = false;
    private Long mOriginGiftNum = -1L;
    private RollingManager mRollingManager;
    private ISceneOptLimiter<ContributionData> sceneOptLimiter = null;
    private ISceneOptLimiterCallback<ContributionData> mSceneOptLimiterCallback = new SimpleSceneOptLimiterCallback<ContributionData>(){

        public boolean needSkip(ContributionData item) {
            return false;
        }

        public void onAppendItem(ContributionData item) {
            GiftContributionPresenter.this.setNumStringInner(item);
        }

        public boolean isDisCardOldDataFrequency() {
            return true;
        }

        @NotNull
        public DiscardResult onDiscard(ContributionData item, float discardRatio, int discardMinRemain, int maxRemain) {
            return DiscardResult.NONE;
        }

        @Nullable
        public List<ContributionData> needDiscardWhenOnDiscard(@NotNull List<? extends ContributionData> items, float discardRatio, int discardMinRemain, int maxRemain) {
            return null;
        }
    };
    private IGiftContributionMvp.ITopDayContributionsCallback mTopDayContributionsCallback = new IGiftContributionMvp.ITopDayContributionsCallback(){

        @Override
        public void onSuccess(long num, List<Long> uids) {
            if (GiftContributionPresenter.this.isDestroyed()) {
                return;
            }
            GiftContributionPresenter.this.setNumString(num);
            GiftContributionPresenter.this.updateDayTopAvatar(uids);
        }

        @Override
        public void onFail(long errorCode, String reason) {
        }
    };

    private ISceneOptLimiter<ContributionData> getSceneOptLimiter() {
        if (this.sceneOptLimiter == null) {
            this.sceneOptLimiter = ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).createLimiter("contribution", this.mSceneOptLimiterCallback);
        }
        return this.sceneOptLimiter;
    }

    public void setHideGiftContributeView(boolean hideGiftContributeView) {
        this.hideGiftContributeView = hideGiftContributeView;
    }

    public void onInit(IChannelPageContext mvpContext) {
        super.onInit(mvpContext);
        this.model = new GiftContributionModel((IDestroyable)this);
        if (this.getChannel() != null && !TextUtils.isEmpty((CharSequence)this.getChannel().getChannelId())) {
            this.mChannelId = this.getChannel().getChannelId();
        }
        YYTaskExecutor.postToMainThread(() -> this.initView(mvpContext));
        this.mGiftContributionNotifyService = new GiftContributionNotifyDispatchService();
        this.mGiftContributionWeekNotifyService = new GiftContributionWeekNotifyDispatchService();
        this.mGiftContributionNotifyService.addHandler(this);
        this.mGiftContributionWeekNotifyService.addHandler(this);
        MLog.info((Object)TAG, (String)("enterRoom:channelId: " + this.mChannelId), (Object[])new Object[0]);
        if (!TextUtils.isEmpty((CharSequence)this.mChannelId)) {
            this.mGiftContributionNotifyService.setRoomId(this.mChannelId);
            this.mGiftContributionWeekNotifyService.setRoomId(this.mChannelId);
            this.getWeekContributions(this.mChannelId);
            ContributionDataManager.Instance.clear();
            ContributionDataManager.Instance.requestData();
            ProtoManager.getInstance().registerNotify((IProtoNotify)this.mGiftContributionNotifyService);
            ProtoManager.getInstance().registerNotify((IProtoNotify)this.mGiftContributionWeekNotifyService);
            this.getContributionUserInfo(this.mChannelId);
        }
    }

    private void initView(IChannelPageContext mvpContext) {
        this.checkViewTree(null);
        if (this.mGiftContributionView == null) {
            this.mGiftContributionView = new GiftContributionView((Context)mvpContext.getContext());
            this.mGiftContributionView.setPresenter(this);
        }
        this.mGiftContributionView.setRoomId(this.mChannelId);
        if (this.mGiftContributionView != null) {
            this.mRollingManager = new RollingManager(this.mGiftContributionView.getGiftRollingTv(), (TextView)this.mGiftContributionView.getGiftUnitTv(), (TextView)this.mGiftContributionView.getGiftContributeTv(), (TextView)this.mGiftContributionView.getBigTv(), () -> {
                if (this.mGiftContributionView != null && !this.hideGiftContributeView) {
                    this.mGiftContributionView.updateLayout();
                }
            });
        }
    }

    @Override
    public void getDayContributions(String rid) {
    }

    @Override
    public void setBlocked(boolean isBlocked) {
        MLog.info((Object)TAG, (String)("setBlocked: " + isBlocked), (Object[])new Object[0]);
        if (this.mGiftContributionNotifyService != null) {
            // empty if block
        }
    }

    @Override
    public void onContributionClick() {
        View.OnClickListener titleBtnClick = new View.OnClickListener(){

            public void onClick(View view2) {
                GiftContributionPresenter.this.openFullWbView(UriProvider.getContributionExplainUrl());
            }
        };
        this.openContributionRankPanel();
        RoomTrack.INSTANCE.giftContributionClick(this.mChannelId);
    }

    private void openContributionRankPanel() {
        WebViewPanel webViewPanel = new WebViewPanel(this.getMvpContext().getContext());
        int heightPixels = ScreenUtils.getInstance().getHeightPixels() / 4 * 3;
        String initUrl = UriProvider.getContributionUrl();
        String url = initUrl + "&roomId=" + this.mChannelId;
        this.openFullWbView(url);
    }

    private void openFullWbView(String url) {
        WebEnvSettings settings = new WebEnvSettings();
        settings.url = url;
        settings.isShowBackBtn = false;
        settings.isFullScreen = true;
        settings.disablePullRefresh = true;
        settings.usePageTitle = false;
        settings.webViewBackgroundColor = ResourceUtils.getColor((int)R.color.transparent);
        settings.webWindowAnimator = false;
        settings.hideLastWindow = false;
        ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).loadUrl(settings);
    }

    public GiftContributionView getView() {
        return this.mGiftContributionView;
    }

    public void onDestroy() {
        MLog.info((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
        if (this.mRollingManager != null) {
            this.mRollingManager.onDestroy();
        }
        this.getSceneOptLimiter().destroy();
        ProtoManager.getInstance().unregisterNotify((IProtoNotify)this.mGiftContributionNotifyService);
        ProtoManager.getInstance().unregisterNotify((IProtoNotify)this.mGiftContributionWeekNotifyService);
        this.mGiftContributionNotifyService.setRoomId("");
        this.mGiftContributionNotifyService.removeHandler(this);
        this.mGiftContributionWeekNotifyService.setRoomId("");
        this.mGiftContributionWeekNotifyService.removeHandler(this);
        if (this.isPageSupportReuse() && this.mGiftContributionView != null) {
            this.mGiftContributionView.resetViewState();
        }
        this.mGiftContributionView = null;
        this.mOriginGiftNum = -1L;
        super.onDestroy();
    }

    @NotNull
    public void setContainer(@NonNull View container) {
        if (container instanceof YYPlaceHolderView) {
            if (this.mGiftContributionView == null) {
                this.mGiftContributionView = new GiftContributionView(container.getContext());
            }
            ((YYPlaceHolderView)container).inflate((View)this.mGiftContributionView);
        } else {
            this.checkViewTree(container);
        }
        if (this.mGiftContributionView != null) {
            this.mGiftContributionView.setRoomId(this.mChannelId);
            this.mGiftContributionView.setPresenter(this);
            this.mGiftContributionView.setVisibility(8);
        }
        if (this.mOriginGiftNum > 0L) {
            this.getSceneOptLimiter().addItem((Object)new ContributionData(0L, this.mOriginGiftNum), this.mRollingManager != null ? this.mRollingManager.getSize() : 0);
        }
    }

    private void checkViewTree(@Nullable View container) {
        if (!this.isPageSupportReuse()) {
            return;
        }
        if (container == null) {
            container = this.getPage().findViewById(R.id.giftContributeHolder);
        }
        if (this.mGiftContributionView == null && container instanceof GiftContributionView) {
            ChannelUtils.checkReuseViewType(container.getClass());
            this.mGiftContributionView = (GiftContributionView)container;
            this.mGiftContributionView.setRoomId(this.mChannelId);
            this.mGiftContributionView.setPresenter(this);
        }
    }

    public void onHandleNotify(Object data2) {
        if (this.isDestroyed()) {
            return;
        }
        if (data2 instanceof ContribNotify) {
            MLog.info((Object)TAG, (String)"\u6536\u5230\u8d21\u732e\u503c\u5e7f\u64ad step1", (Object[])new Object[0]);
            ContribNotify contribNotify = (ContribNotify)data2;
            Uri faceUri = contribNotify.uri;
            DayContribNotify dayContribNotify = contribNotify.day_notify;
            if (faceUri == Uri.UriDayContribNotify && dayContribNotify != null) {
                MLog.info((Object)TAG, (String)"\u6536\u5230\u8d21\u732e\u503c\u5e7f\u64ad step2", (Object[])new Object[0]);
                long number = dayContribNotify.contributions;
                if (null != this.mGiftContributionNotifyService) {
                    MLog.info((Object)TAG, (String)"\u6536\u5230\u8d21\u732e\u503c\u5e7f\u64ad step3", (Object[])new Object[0]);
                    this.setNumString(number);
                }
            } else if (faceUri == Uri.UriTopUsersUpdatedNotify) {
                TopUsersUpdatedNotify topUsersUpdatedNotify = contribNotify.top_updated_notify;
                if (topUsersUpdatedNotify != null) {
                    int i;
                    int size;
                    ContributionDataManager.Instance.clear();
                    List topDayUids = topUsersUpdatedNotify.top_day_uids;
                    MLog.info((Object)TAG, (String)("\u6536\u5230\u8d21\u732e\u699c\u7528\u6237\u53d8\u5316:" + topDayUids), (Object[])new Object[0]);
                    List topWeekUids = topUsersUpdatedNotify.top_week_uids;
                    this.updateDayTopAvatar(topDayUids);
                    if (topDayUids != null) {
                        size = topDayUids.size();
                        for (i = 0; i < size; ++i) {
                            ContributionDataManager.Instance.addDayTopUser((Long)topDayUids.get(i), i);
                        }
                    }
                    if (topWeekUids != null) {
                        size = topWeekUids.size();
                        for (i = 0; i < size; ++i) {
                            ContributionDataManager.Instance.addWeekTopUser((Long)topWeekUids.get(i), i);
                        }
                    }
                }
            } else if (faceUri == Uri.UriWeekContribNotify) {
                WeekContribNotify weekContribNotify = contribNotify.week_notify;
                if (weekContribNotify.contributions != 0L) {
                    if (this.mGiftContributionView != null && !this.hideGiftContributeView) {
                        this.mGiftContributionView.setVisibility(0);
                    }
                } else if (this.mGiftContributionView != null) {
                    this.mGiftContributionView.setVisibility(8);
                }
            }
        }
    }

    private void updateDayTopAvatar(final List<Long> topDayUids) {
        if (topDayUids == null || topDayUids.size() == 0) {
            if (this.mGiftContributionView != null && !this.hideGiftContributeView) {
                this.mGiftContributionView.setTopAvatar(null);
            }
            return;
        }
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(topDayUids, new OnProfileCallback(){
            List<Long> mTopDayUids;
            {
                this.mTopDayUids = topDayUids;
            }

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                if (GiftContributionPresenter.this.isDestroyed()) {
                    return;
                }
                if (userInfoKSList != null && this.mTopDayUids != null) {
                    ArrayList<String> avatarList = new ArrayList<String>();
                    for (long uid : this.mTopDayUids) {
                        for (UserInfoKS userInfoKS : userInfoKSList) {
                            if (userInfoKS.uid != uid) continue;
                            avatarList.add(userInfoKS.avatar);
                        }
                    }
                    if (GiftContributionPresenter.this.mGiftContributionView != null && !GiftContributionPresenter.this.hideGiftContributeView) {
                        GiftContributionPresenter.this.mGiftContributionView.setTopAvatar(avatarList);
                    }
                }
            }

            public void onFail(int id2, String msg, String response) {
            }

            public int id() {
                return 0;
            }
        });
    }

    protected void getContributionUserInfo(String roomId) {
        this.model.getContributionsInfo(roomId, this.mTopDayContributionsCallback);
    }

    private void setNumString(long num) {
        ContributionData data2 = null;
        data2 = this.mOriginGiftNum == -1L ? new ContributionData(num, num) : new ContributionData(this.mOriginGiftNum, num);
        this.getSceneOptLimiter().addItem((Object)data2, this.mRollingManager != null ? this.mRollingManager.getSize() : 0);
        this.mOriginGiftNum = num;
    }

    private void setNumStringInner(ContributionData data2) {
        if (null != this.mGiftContributionView && !this.hideGiftContributeView) {
            MLog.info((Object)TAG, (String)("\u6536\u5230\u8d21\u732e\u503c\u5e7f\u64ad step4 " + data2.getNewNum()), (Object[])new Object[0]);
            if (data2.getNewNum() > 0L && this.mGiftContributionView.getVisibility() != 0) {
                this.mGiftContributionView.setVisibility(0);
            }
            if (data2.getOldNum() == 0L || data2.getOldNum().equals(data2.getNewNum())) {
                this.mRollingManager.addText(this.getNumStr(data2.getNewNum()));
            } else if (!this.getNumStr(data2.getOldNum()).equals(this.getNumStr(data2.getNewNum()))) {
                this.mRollingManager.addText(data2.getOldNum(), data2.getNewNum());
            }
            this.mGiftContributionView.setGiftContributeNum(this.getNumStr(data2.getNewNum()));
            this.mGiftContributionView.updateRollingLayout();
        }
    }

    private String getNumStr(Long num) {
        String strNum = "";
        if (num >= 1000L && num < 1000000L) {
            double d = (double)num.longValue() / 1000.0;
            BigDecimal bd = new BigDecimal(d);
            double d1 = bd.setScale(1, 4).doubleValue();
            strNum = String.valueOf(d1) + ResourceUtils.getString((int)R.string.tips_contribution_k);
        } else if (num >= 1000000L) {
            double d = (double)num.longValue() / 1000000.0;
            BigDecimal bd = new BigDecimal(d);
            double d1 = bd.setScale(1, 4).doubleValue();
            strNum = String.valueOf(d1) + ResourceUtils.getString((int)R.string.tips_contribution_m);
        } else {
            strNum = num == 0L ? "" : String.valueOf(num);
        }
        return strNum;
    }

    private void getWeekContributions(String roomId) {
        this.model.getWeekContributions(roomId, new IGiftContributionMvp.CallBack(){

            @Override
            public void onSuccess(long num) {
                if (GiftContributionPresenter.this.isDestroyed()) {
                    return;
                }
                if (num == 0L) {
                    MLog.info((Object)GiftContributionPresenter.TAG, (String)"getWeekContributions num 0", (Object[])new Object[0]);
                    if (GiftContributionPresenter.this.mGiftContributionView != null) {
                        GiftContributionPresenter.this.mGiftContributionView.setVisibility(8);
                    }
                } else {
                    MLog.info((Object)GiftContributionPresenter.TAG, (String)("getWeekContributions num:" + num), (Object[])new Object[0]);
                    if (GiftContributionPresenter.this.mGiftContributionView != null && !GiftContributionPresenter.this.hideGiftContributeView) {
                        GiftContributionPresenter.this.mGiftContributionView.setVisibility(0);
                    }
                }
            }

            @Override
            public void onError(int errorCode, String errorMSg) {
            }
        });
    }

    private void setTopAvatar(List<String> avatarList) {
        if (null != this.mGiftContributionView && !this.hideGiftContributeView && avatarList != null) {
            this.mGiftContributionView.setTopAvatar(avatarList);
        }
    }

    public static interface BlockedChangeListener {
        public void onBlockedChange(boolean var1);
    }
}

