/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.bottombar;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.BuildConfig;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.bottombar.BottomMvp;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.singlegame.indie.GameAction;
import com.yy.hiyo.game.base.singlegame.indie.IndieGamePlayContext;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class BottomEnterGamePresenter {
    private static final String TAG = "BottomEnterGamePresente";
    @Nullable
    private BottomMvp.IView mView;
    private BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>> mHost;

    public BottomEnterGamePresenter(BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>> host) {
        this.mHost = host;
    }

    public void bindView(@Nullable BottomMvp.IView view2) {
        this.mView = view2;
    }

    public void downloadAndOpenGame(@Nullable String gid) {
        if (TextUtils.isEmpty((CharSequence)gid)) {
            MLog.warn((Object)TAG, (String)"gid is null or empty", (Object[])new Object[0]);
            return;
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "launch_fishing_game_click").put("gameid", gid));
        IGameInfoService gameInfoService = (IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class);
        if (gameInfoService == null) {
            return;
        }
        GameInfo gameInfo = gameInfoService.getGameInfoByGid(gid);
        if (gameInfo == null) {
            return;
        }
        if (gameInfo.downloadInfo.isDownloading()) {
            return;
        }
        IGameService gameService = (IGameService)ServiceManagerProxy.getService(IGameService.class);
        if (gameService == null) {
            return;
        }
        if (gameService.isGameValid(gameInfo)) {
            this.openGame(gid);
        } else {
            Kvo.autoBindingTo((KvoSource)gameInfo.downloadInfo, (Object)this);
            gameService.downloadGame(gameInfo, GameDownloadInfo.DownloadType.no_pause);
        }
    }

    private void openGame(String gid) {
        IndieGamePlayContext gameContext;
        IGameInfoService gameInfoService = (IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class);
        if (gameInfoService == null) {
            return;
        }
        GameInfo gameInfo = gameInfoService.getGameInfoByGid(gid);
        if (gameInfo == null) {
            return;
        }
        switch (gameInfo.getGameMode()) {
            case 6: {
                gameContext = new IndieGamePlayContext.Builder(GameContextDef.JoinFrom.FROM_GAME_GROUP).gameAction(gid.equals("diaoyu_dl") ? new GameAction(1) : GameAction.getDEFAULT()).build();
                ChannelDetailInfo channelDetailInfo = this.mHost.getChannelDetailInfo();
                String channelId = "";
                if (channelDetailInfo != null && channelDetailInfo.baseInfo != null) {
                    channelId = channelDetailInfo.baseInfo.gid;
                }
                gameContext.addExtendValue("extend_channel_id", (Object)channelId);
                break;
            }
            default: {
                if (BuildConfig.DEBUG) {
                    throw new UnsupportedOperationException("game mode " + gameInfo.getGameMode() + " unsupported now");
                }
                return;
            }
        }
        IGameCenterService gameCenterService = (IGameCenterService)ServiceManagerProxy.getService(IGameCenterService.class);
        if (gameCenterService == null) {
            return;
        }
        gameCenterService.joinGame(gameInfo, (GamePlayContext)gameContext);
    }

    @KvoMethodAnnotation(name="state", sourceClass=GameDownloadInfo.class, thread=1)
    public void onDownloadGame(KvoEventIntent event) {
        if (event == null || this.mView == null) {
            return;
        }
        GameDownloadInfo gameDownloadInfo = (GameDownloadInfo)event.source();
        switch (gameDownloadInfo.getState()) {
            case downloading: {
                this.mView.gameEntryDownloadProgress(1.0f);
                break;
            }
            case download_finish: {
                this.mView.gameEntryDownloadProgress(0.0f);
                Kvo.autoUnbindingFrom((KvoSource)gameDownloadInfo, (Object)this);
                this.openGame(gameDownloadInfo.gameId);
                break;
            }
        }
    }

    @KvoMethodAnnotation(name="progress", sourceClass=GameDownloadInfo.class, thread=1)
    public void onUpdateProgress(KvoEventIntent event) {
        if (event == null || this.mView == null) {
            return;
        }
        GameDownloadInfo info = (GameDownloadInfo)event.source();
        if (info.getState() != GameDownloadInfo.DownloadState.downloading) {
            this.mView.gameEntryDownloadProgress(0.0f);
            return;
        }
        this.mView.gameEntryDownloadProgress((float)info.getProgress() * 1.0f / (float)info.getTotalBytes() * 100.0f);
    }
}

