/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.bigface.adpater;

import android.content.Context;
import android.graphics.PointF;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.data.FaceDbBean;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.bigface.FacePreviewWindow;
import java.util.ArrayList;
import java.util.List;

public class FaceItemAdapter
extends RecyclerView.Adapter<MyViewHolder> {
    private static final String TAG = "FaceItemAdapter";
    private List<FaceDbBean> mDatas = new ArrayList<FaceDbBean>();
    private Context mContext;
    private FacePreviewWindow window;
    private FaceClickListener mListener;

    public void setmListener(FaceClickListener mListener) {
        this.mListener = mListener;
    }

    public FaceItemAdapter(Context context, List<FaceDbBean> list2) {
        this.mContext = context;
        this.mDatas = new ArrayList<FaceDbBean>();
        this.mDatas.addAll(list2);
        this.window = new FacePreviewWindow(context);
    }

    @NonNull
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view2 = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_face_channel, parent, false);
        return new MyViewHolder(view2);
    }

    public void onBindViewHolder(@NonNull MyViewHolder holder, int position) {
        final FaceDbBean bean2 = this.mDatas.get(position);
        String loadUrl = bean2.getThumbnail() + YYImageUtils.getThumbnailPostfixPx((int)ResolutionUtils.dip2Px((float)50.0f), (int)ResolutionUtils.dip2Px((float)50.0f), (boolean)true);
        if (!bean2.isAvailable()) {
            holder.imageView.setAlpha(0.3f);
        } else {
            holder.imageView.setAlpha(1.0f);
        }
        ImageLoader.loadImage((ImageView)holder.imageView, (String)loadUrl, (int)R.drawable.icon_default_big_face);
        holder.imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view2) {
                if (FaceItemAdapter.this.mListener != null) {
                    FaceItemAdapter.this.mListener.onClickFace(bean2);
                }
            }
        });
        holder.imageView.setOnTouchListener((View.OnTouchListener)new FaceViewTouchListener(bean2));
    }

    public int getItemCount() {
        return this.mDatas.size();
    }

    public void update(List<FaceDbBean> tempDatas) {
        if (tempDatas != null && tempDatas.size() > 0) {
            this.mDatas.clear();
            this.mDatas.addAll(tempDatas);
            this.notifyDataSetChanged();
        }
    }

    public void updateIndex(int index, FaceDbBean tempData) {
        if (tempData != null && index >= 0 && index < this.mDatas.size()) {
            this.mDatas.set(index, tempData);
        }
    }

    private class FaceViewTouchListener
    implements View.OnTouchListener {
        private static final int POINT_OFFSET = 150;
        private float mDownX;
        private float mDownY;
        private boolean isLongClick = false;
        private boolean isCancel = false;
        final FaceDbBean faceData;

        FaceViewTouchListener(FaceDbBean data2) {
            this.faceData = data2;
        }

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case 0: {
                    this.isLongClick = false;
                    this.isCancel = false;
                    this.mDownX = event.getX();
                    this.mDownY = event.getY();
                    if (!this.pointInView(new PointF(event.getX(), event.getY()), v) || v.getHandler() == null) break;
                    v.getHandler().postDelayed(() -> {
                        this.isCancel = false;
                        this.isLongClick = true;
                        FaceItemAdapter.this.window.showPopupWindow(v, this.faceData);
                    }, 800L);
                    break;
                }
                case 2: {
                    if (this.isCancel || !this.isLongClick || this.pointInView(new PointF(event.getX(), event.getY()), v)) break;
                    if (v.getHandler() != null) {
                        v.getHandler().removeCallbacksAndMessages(null);
                    }
                    FaceItemAdapter.this.window.dismiss();
                    this.isCancel = true;
                    break;
                }
                case 1: 
                case 3: {
                    if (this.isCancel) {
                        return true;
                    }
                    if (v.getHandler() != null) {
                        v.getHandler().removeCallbacksAndMessages(null);
                    }
                    if (!this.isLongClick && this.isSingleArea(event, this.mDownX, this.mDownY)) {
                        v.performClick();
                    }
                    FaceItemAdapter.this.window.dismiss();
                    break;
                }
            }
            return true;
        }

        private boolean isSingleArea(MotionEvent event, float startX, float startY) {
            return Math.abs(startX - event.getX()) < 10.0f && Math.abs(startY - event.getY()) < 10.0f;
        }

        private boolean pointInView(PointF point, View view2) {
            int left = view2.getLeft() - 150;
            int right = view2.getRight() + 150;
            int top = view2.getTop() - 150;
            int bottom = view2.getBottom() + 150;
            return (float)left <= point.x && point.x <= (float)right && (float)top <= point.y && point.y <= (float)bottom;
        }
    }

    public static interface FaceClickListener {
        public void onClickFace(FaceDbBean var1);
    }

    static class MyViewHolder
    extends RecyclerView.ViewHolder {
        private RecycleImageView imageView;
        private RecycleImageView ivPrivilegeFlag;

        public MyViewHolder(View itemView) {
            super(itemView);
            this.imageView = (RecycleImageView)itemView.findViewById(R.id.iv_face_view);
            this.ivPrivilegeFlag = (RecycleImageView)itemView.findViewById(R.id.iv_privilege_flag);
        }
    }
}

