/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.bigface;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountRelatedSetting;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.data.FaceDbBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.bigface.IRoomBigFaceServices;
import com.yy.hiyo.bigface.base.BigFaceUtil;
import com.yy.hiyo.channel.component.bigface.ICommonFaceMvp;
import com.yy.hiyo.channel.component.bigface.IFaceMvp;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.ihago.room.api.bigemoji.BCInfo;
import net.ihago.room.api.bigemoji.SendRequest;
import net.ihago.room.api.bigemoji.SendResponse;

@Deprecated
enum FaceCommonModel implements ICommonFaceMvp.IModel
{
    INSTANCE;

    private static final String FACE_VERSION = "face_version";
    private static final String TAG = "FTVoiceRoomFaceModel";
    private List<FaceDbBean> mCacheFb = new CopyOnWriteArrayList<FaceDbBean>();
    private boolean hadReadData = false;
    private Map<String, List<ICommonFaceMvp.IModel.CallBack<FaceDbBean>>> pendingCallbackList;

    @Override
    public void requestFaceData(final ICommonFaceMvp.IModel.CallBack<List<FaceDbBean>> callback2, final String roomId) {
        this.requestDbFaceData(new IFaceMvp.IModel.CallBack<List<FaceDbBean>>(){

            @Override
            public void onSuccess(List<FaceDbBean> data2) {
                if (data2 != null) {
                    if (callback2 != null) {
                        callback2.onSuccess(data2);
                    }
                    FaceCommonModel.this.mCacheFb.clear();
                    FaceCommonModel.this.mCacheFb.addAll(data2);
                    FaceCommonModel.this.hadReadData = true;
                    FaceCommonModel.this.checkPendingCallback();
                }
                FaceCommonModel.this.requestFromServe(roomId, callback2);
            }

            @Override
            public void onFail() {
                FaceCommonModel.this.requestFromServe(roomId, callback2);
            }
        }, roomId);
    }

    void requestFromServe(String roomId, final ICommonFaceMvp.IModel.CallBack<List<FaceDbBean>> callback2) {
        IRoomBigFaceServices services = (IRoomBigFaceServices)ServiceManagerProxy.getService(IRoomBigFaceServices.class);
        if (services != null) {
            services.requestDataService(roomId, false, (ICommonCallback)new ICommonCallback<List<FaceDbBean>>(){

                public void onSuccess(List<FaceDbBean> faceDbBeans, Object ... ext) {
                    if (callback2 != null) {
                        callback2.onSuccess(faceDbBeans);
                    }
                }

                public void onFail(int errCode, String msg, Object ... ext) {
                    if (callback2 != null) {
                        callback2.onFail();
                    }
                }
            });
        }
    }

    @Override
    public FaceDbBean getCacheFaceDb(String id2) {
        if (StringUtils.isEmpty((String)id2)) {
            return null;
        }
        IRoomBigFaceServices service = (IRoomBigFaceServices)ServiceManagerProxy.getService(IRoomBigFaceServices.class);
        FaceDbBean cache = service.findFaceBean(id2);
        if (cache != null) {
            return cache;
        }
        for (FaceDbBean faceDbBean : this.mCacheFb) {
            if (faceDbBean == null || !id2.equals(faceDbBean.getFaceId())) continue;
            return faceDbBean;
        }
        return null;
    }

    @Override
    public void getCacheFaceDb(String id2, ICommonFaceMvp.IModel.CallBack<FaceDbBean> callBack) {
        if (StringUtils.isEmpty((String)id2)) {
            if (callBack != null) {
                callBack.onFail();
            }
            return;
        }
        if (this.mCacheFb.isEmpty() && this.hadReadData) {
            if (callBack != null) {
                callBack.onFail();
            }
            return;
        }
        if (this.mCacheFb.isEmpty()) {
            List<ICommonFaceMvp.IModel.CallBack<FaceDbBean>> list2;
            if (this.pendingCallbackList == null) {
                this.pendingCallbackList = new ConcurrentHashMap<String, List<ICommonFaceMvp.IModel.CallBack<FaceDbBean>>>();
            }
            if ((list2 = this.pendingCallbackList.get(id2)) == null) {
                list2 = new ArrayList<ICommonFaceMvp.IModel.CallBack<FaceDbBean>>();
                this.pendingCallbackList.put(id2, list2);
            }
            if (!list2.contains(callBack)) {
                list2.add(callBack);
            }
            return;
        }
        FaceDbBean cache = this.getCacheFaceDb(id2);
        if (cache != null) {
            if (callBack != null) {
                callBack.onSuccess(cache);
            }
        } else if (callBack != null) {
            callBack.onFail();
        }
    }

    private void requestDbFaceData(final IFaceMvp.IModel.CallBack<List<FaceDbBean>> callback2, String roomId) {
        MLog.info((Object)TAG, (String)" \u5927\u8868\u60c5 requestDbFaceData", (Object[])new Object[0]);
        MyBox box = ((IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class)).boxForGlobal(FaceDbBean.class);
        if (box != null) {
            box.getAll((MyBox.IGetItemsCallBack)new MyBox.IGetItemsCallBack<FaceDbBean>(){

                public void onLoaded(ArrayList<FaceDbBean> datas) {
                    if (datas != null && datas.size() > 0) {
                        MLog.info((Object)FaceCommonModel.TAG, (String)" \u5927\u8868\u60c5 requestDbFaceData have data", (Object[])new Object[0]);
                        for (int i = 0; i < datas.size(); ++i) {
                            FaceDbBean dbBean = datas.get(i);
                            String strJson = dbBean.getRandomResult();
                            if (TextUtils.isEmpty((CharSequence)strJson)) continue;
                            dbBean.setRandoms(BigFaceUtil.INSTANCE.parseRandomResultJson(strJson));
                        }
                        callback2.onSuccess(datas);
                    } else {
                        MLog.info((Object)FaceCommonModel.TAG, (String)" \u5927\u8868\u60c5 requestDbFaceData no data", (Object[])new Object[0]);
                        callback2.onFail();
                    }
                }
            });
        } else {
            MLog.info((Object)TAG, (String)" \u5927\u8868\u60c5 box is null", (Object[])new Object[0]);
        }
    }

    @Override
    public void sendFace(final ICommonFaceMvp.IModel.CallBack<BCInfo> callBack, FaceDbBean dbBean, String roomId) {
        MLog.info((Object)TAG, (String)"\u53d1\u9001\u8868\u60c5", (Object[])new Object[0]);
        SendRequest request = new SendRequest.Builder().id(dbBean.getFaceId()).build();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)request, (IProtoCallback)new SimpleProtoCallback<SendResponse>("\u53d1\u9001\u8868\u60c5"){

            public void onResponse(@Nullable SendResponse message) {
                super.onResponse((AndroidMessage)message);
                MLog.info((Object)FaceCommonModel.TAG, (String)"\u53d1\u9001\u8868\u60c5 onResponse", (Object[])new Object[0]);
                if (message != null) {
                    BCInfo bcInfo = message.bcinfo;
                    if (bcInfo != null) {
                        MLog.info((Object)FaceCommonModel.TAG, (String)"\u53d1\u9001\u8868\u60c5 onSelected", (Object[])new Object[0]);
                        if (callBack != null) {
                            callBack.onSuccess(bcInfo);
                        }
                    } else {
                        MLog.info((Object)FaceCommonModel.TAG, (String)"\u53d1\u9001\u8868\u60c5 onFail", (Object[])new Object[0]);
                        if (callBack != null) {
                            callBack.onFail();
                        }
                    }
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callBack != null) {
                    callBack.onFail();
                }
            }
        });
    }

    private void updateFaceDb(List<FaceDbBean> lists) {
        MLog.info((Object)TAG, (String)"\u66f4\u65b0\u6570\u636e\u5e93 changeToFaceDbBean", (Object[])new Object[0]);
        MyBox box = ((IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class)).boxForGlobal(FaceDbBean.class);
        if (box != null) {
            box.deleteAll();
            box.updateItems(lists, true);
        } else {
            MLog.info((Object)TAG, (String)"\u66f4\u65b0\u6570\u636e\u5e93 box is null", (Object[])new Object[0]);
        }
    }

    private void updateLocalVersion(String version) {
        AccountRelatedSetting.getInstance().putString(FACE_VERSION, version);
    }

    private void checkPendingCallback() {
        if (this.pendingCallbackList == null) {
            return;
        }
        for (Map.Entry<String, List<ICommonFaceMvp.IModel.CallBack<FaceDbBean>>> entry : this.pendingCallbackList.entrySet()) {
            List<ICommonFaceMvp.IModel.CallBack<FaceDbBean>> list2 = entry.getValue();
            String id2 = entry.getKey();
            if (FP.empty(list2)) continue;
            for (ICommonFaceMvp.IModel.CallBack<FaceDbBean> callBack : list2) {
                this.getCacheFaceDb(id2, callBack);
            }
        }
        this.pendingCallbackList.clear();
    }
}

