/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.announcement.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageReuseView;

public class NoticeView
extends YYLinearLayout
implements View.OnClickListener,
IPageReuseView {
    private YYTextView tvNotice;
    private ImageView ivNotice;
    private View.OnClickListener mClickListener;

    public void setClickListener(View.OnClickListener mClickListener2) {
        this.mClickListener = mClickListener2;
    }

    public NoticeView(Context context) {
        super(context);
        this.initView(context);
    }

    public NoticeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public NoticeView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    private void initView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_room_notice_channel, (ViewGroup)this);
        this.setBackgroundResource(R.drawable.bg_shape_room_notice);
        this.tvNotice = (YYTextView)this.findViewById(R.id.tv_notice);
        this.ivNotice = (ImageView)this.findViewById(R.id.iv_notice);
        this.setOnClickListener(this);
        this.setOrientation(0);
    }

    public void onClick(View v) {
        if (this.mClickListener != null) {
            this.mClickListener.onClick(v);
        }
    }

    public void updateNoticeView(boolean isRoomOwnerOrAnchor, String notice) {
        if (isRoomOwnerOrAnchor) {
            this.setVisibility(0);
            this.tvNotice.setText((CharSequence)ResourceUtils.getString((int)R.string.title_room_edit_notice));
            return;
        }
        if (FP.empty((CharSequence)notice)) {
            this.setVisibility(8);
            return;
        }
        this.setVisibility(0);
        this.tvNotice.setText((CharSequence)ResourceUtils.getString((int)R.string.title_room_notice));
    }

    public void updateWhiteTheme() {
        this.ivNotice.setColorFilter(ResourceUtils.getColor((int)R.color.black));
        this.tvNotice.setTextColor(ResourceUtils.getColor((int)R.color.black_333333));
        this.setBackgroundResource(R.drawable.bg_white_notice);
    }

    public void setVisibility(int visibility) {
        if (visibility != this.getVisibility()) {
            super.setVisibility(visibility);
        }
    }

    public void resetViewState() {
    }
}

