/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.announcement.ui;

import android.content.ClipData;
import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.common.Callback;
import com.yy.appbase.inputfilter.NoticeInputFilter;
import com.yy.appbase.inputfilter.NoticeUtils;
import com.yy.appbase.ui.utils.CrashCatchLinkMovementMethod;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.ui.StatusBarManager;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.SelectStatus;
import com.yy.hiyo.channel.component.announcement.NoticePresenter;
import com.yy.hiyo.channel.component.announcement.ui.NoticeCountView;
import com.yy.hiyo.channel.component.announcement.ui.NoticeEditText;
import com.yy.hiyo.channel.component.announcement.ui.NoticePushSelectView;
import com.yy.hiyo.channel.component.announcement.ui.NoticeView;
import com.yy.hiyo.channel.component.base.util.HyperLinkUtil;

public class NoticeDialog
extends YYDialog {
    private static final String TAG = "NoticeDialog";
    private NoticeCountView tvCount;
    private NoticeEditText edNotice;
    private YYTextView tvNotice;
    private TextView btnOk;
    private View mRootView;
    private YYImageView mIvArrow;
    private NoticePresenter mPresenter;
    private NoticeInputFilter mInputFilter;
    private boolean isRoomOwnerOrAnchor;
    private String mNotice;
    private Context mContext;
    private NoticePushSelectView mNoticePushSelectView;
    private View.OnLongClickListener onLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View v) {
            if (v instanceof TextView && NoticeDialog.this.mContext != null) {
                NoticeDialog.this.showCopyDialog(NoticeDialog.this.mContext, ((TextView)v).getText().toString());
            }
            return false;
        }
    };

    private void setPresenter(@NonNull NoticePresenter mPresenter) {
        this.mPresenter = mPresenter;
        this.isRoomOwnerOrAnchor = this.mPresenter.isRoomOwnerOrAnchor();
        this.mNotice = this.mPresenter.getNotice();
    }

    public NoticeDialog(Context context, @NonNull NoticePresenter mPresenter) {
        super(context, R.style.normal_yydialog);
        this.mContext = context;
        this.setPresenter(mPresenter);
        this.initView();
    }

    private void initView() {
        View view2 = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_notice_dialog_channel, null);
        ViewGroup.LayoutParams contentLp = new ViewGroup.LayoutParams(-1, -2);
        this.setContentView(view2, contentLp);
        WindowManager.LayoutParams dialogLp = this.getWindow().getAttributes();
        dialogLp.gravity = 53;
        this.setPosition(dialogLp);
        this.getWindow().setAttributes(dialogLp);
        if (this.isRoomOwnerOrAnchor) {
            this.getWindow().clearFlags(131072);
            this.getWindow().setSoftInputMode(4);
        }
        this.tvCount = (NoticeCountView)view2.findViewById(R.id.tv_count);
        this.tvCount.setMaxCount(500);
        this.tvNotice = (YYTextView)view2.findViewById(R.id.tv_notice);
        this.edNotice = (NoticeEditText)view2.findViewById(R.id.ed_notice);
        this.btnOk = (TextView)view2.findViewById(R.id.tv_ok);
        this.mIvArrow = (YYImageView)view2.findViewById(R.id.iv_arrow);
        this.mNoticePushSelectView = (NoticePushSelectView)view2.findViewById(R.id.view_notice_push_select);
        this.mRootView = view2.findViewById(R.id.root_view);
        this.mInputFilter = new NoticeInputFilter();
        this.setListener();
        this.tvNotice.setMovementMethod((MovementMethod)CrashCatchLinkMovementMethod.getInstance());
        this.tvNotice.setTextIsSelectable(true);
        this.tvNotice.setAutoLinkMask(1);
        this.tvNotice.setLinkTextColor(ResourceUtils.getColor((int)R.color.color_335aff));
    }

    private void setPosition(WindowManager.LayoutParams layoutParams) {
        NoticeView noticeView = this.mPresenter.getNoticeView();
        if (noticeView == null || noticeView.getVisibility() != 0) {
            MLog.info((Object)TAG, (String)"setPosition failed!!!!!!!", (Object[])new Object[0]);
            return;
        }
        layoutParams.x = ResolutionUtils.dip2Px((float)10.0f);
        int screenWidth = ResolutionUtils.getScreenWidth((Context)this.mContext);
        if (screenWidth > 0) {
            layoutParams.width = ResolutionUtils.getScreenWidth((Context)this.mContext) - 2 * layoutParams.x;
        }
        int positionY = (int)(noticeView.getY() + (float)noticeView.getHeight());
        if (StatusBarManager.INSTANCE.isSupportStatusBar()) {
            positionY -= StatusBarManager.INSTANCE.getStatusBarHeight(this.getContext());
        }
        layoutParams.y = positionY;
    }

    private void setListener() {
        InputFilter[] filters = new InputFilter[]{this.mInputFilter};
        this.edNotice.setFilters(filters);
        this.edNotice.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String msg = s.toString();
                NoticeDialog.this.updateBtnAndCount(msg);
            }
        });
        this.edNotice.setTextPasteCallback(() -> {
            int index = this.edNotice.getSelectionStart();
            Editable editText = this.edNotice.getEditableText();
            ClipData clipData = SystemServiceUtils.getClipboardManager2((Context)RuntimeContext.sApplicationContext).getPrimaryClip();
            if (clipData != null && clipData.getItemAt(0) != null && clipData.getItemAt(0).getText() != null) {
                String clipStr = clipData.getItemAt(0).getText().toString();
                if (StringUtils.isEmpty((String)clipStr)) {
                    return;
                }
                int curCount = NoticeUtils.calculationNoticeSize((CharSequence)editText);
                if (curCount >= 500) {
                    return;
                }
                clipStr = NoticeUtils.cutInputStr((CharSequence)editText, (CharSequence)clipStr).toString();
                if (index < 0 || index >= editText.length()) {
                    editText.append((CharSequence)clipStr);
                } else {
                    editText.insert(index, (CharSequence)clipStr);
                }
            }
        });
        this.btnOk.setOnClickListener(v -> {
            String content = this.edNotice.getText().toString();
            boolean withPush = this.mNoticePushSelectView.getCurrSelectStatus() == SelectStatus.SELETED;
            this.mPresenter.saveNotice(content, withPush);
        });
    }

    private void showCopyDialog(Context context, String content) {
        if (context == null || FP.empty((CharSequence)content)) {
            return;
        }
        View view2 = LayoutInflater.from((Context)context).inflate(R.layout.layout_copy_item_channel, null, false);
        PopupWindow mPopupWindow = new PopupWindow(view2, ResolutionUtils.dip2Px((float)100.0f), ResolutionUtils.dip2Px((float)30.0f), true);
        view2.setOnClickListener(view1 -> {
            if (mPopupWindow != null) {
                mPopupWindow.dismiss();
            }
            SystemUtils.initialize((Context)context);
            SystemUtils.setClipboardTextToSystem((String)content);
        });
        mPopupWindow.showAtLocation(this.mRootView, 17, 0, 0);
    }

    private void updateView() {
        if (this.isRoomOwnerOrAnchor) {
            this.edNotice.setText(this.mNotice);
            this.edNotice.setSelection(this.mNotice.length());
            this.tvNotice.setVisibility(8);
            this.edNotice.setMaxHeight(ResolutionUtils.dip2Px((float)130.0f));
            this.updateBtnAndCount(this.mNotice);
            this.mNoticePushSelectView.setVisibility(0);
            this.mNoticePushSelectView.reset();
            this.mNoticePushSelectView.initData(this.mPresenter.getChannelId());
        } else {
            this.edNotice.setVisibility(8);
            this.tvCount.setVisibility(8);
            this.btnOk.setVisibility(8);
            this.tvNotice.setMaxHeight(ResolutionUtils.dip2Px((float)200.0f));
            this.tvNotice.setText((CharSequence)this.mNotice);
            HyperLinkUtil.INSTANCE.interceptHyperLink((TextView)this.tvNotice, (Callback<Boolean>)((Callback)data2 -> this.dismiss()));
            this.mNoticePushSelectView.setVisibility(8);
        }
    }

    private void updateBtnAndCount(String content) {
        int size = NoticeUtils.calculationNoticeSize((CharSequence)content);
        this.tvCount.setCurEditCount(size);
    }

    public void show() {
        super.show();
        this.mNotice = this.mPresenter.getNotice();
        this.updateView();
    }
}

