/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/yy/hiyo/channel/utils/BitmapUtils;", "", "()V", "circleCrop", "Landroid/graphics/Bitmap;", "pool", "Lcom/bumptech/glide/load/engine/bitmap_recycle/BitmapPool;", "source", "radius", "", "channel-components_release"})
public final class BitmapUtils {
    public static final BitmapUtils INSTANCE;

    @Nullable
    public final Bitmap circleCrop(@NotNull BitmapPool pool, @NotNull Bitmap source, float radius) {
        Intrinsics.checkParameterIsNotNull((Object)pool, (String)"pool");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        int size = Math.min(source.getWidth(), source.getHeight());
        int x = (source.getWidth() - size) / 2;
        int y = (source.getHeight() - size) / 2;
        Bitmap squared = Bitmap.createBitmap((Bitmap)source, (int)x, (int)y, (int)size, (int)size);
        Bitmap bitmap = pool.get(size, size, Bitmap.Config.ARGB_8888);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"pool.get(size, size, Bitmap.Config.ARGB_8888)");
        Bitmap result = bitmap;
        if (result == null) {
            Bitmap bitmap2 = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(size\u2026 Bitmap.Config.ARGB_8888)");
            result = bitmap2;
        }
        Canvas canvas = new Canvas(result);
        Paint paint = new Paint();
        paint.setShader((Shader)new BitmapShader(squared, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        paint.setAntiAlias(true);
        float r = (float)size / 2.0f;
        canvas.drawCircle(r, r, radius, paint);
        return result;
    }

    private BitmapUtils() {
    }

    static {
        BitmapUtils bitmapUtils;
        INSTANCE = bitmapUtils = new BitmapUtils();
    }
}

