/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.voicefilter;

import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.VoiceFilterConfig;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.VoiceFilterData;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IVoiceFilterService;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.service.BaseService;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;

public class VoiceFilterService
extends BaseService
implements IVoiceFilterService {
    private VoiceFilterData mData = new VoiceFilterData();
    private long mVoiceFilterStartTime = 0L;
    private int selectChangeMode = 0;

    public VoiceFilterService(final IChannel channel) {
        super(channel);
        this.mData.setValue("currentChannelMode", (Object)channel.getPluginService().getCurPluginData().mode);
        channel.getPluginService().addPluginDataListener(new IPluginService.IPluginDataChangedCallBack(){

            public void onPluginModeChanged(String channelId, ChannelPluginData pluginData, ChannelPluginData beforePlugin) {
                VoiceFilterService.this.mData.setValue("currentChannelMode", (Object)channel.getPluginService().getCurPluginData().mode);
            }
        });
    }

    private void refreshFromConfig(VoiceFilterConfig data2) {
        if (data2 != null && data2.configData != null) {
            this.mData.setValue("isSupportVoiceFilter", (Object)data2.configData.isopen);
            List infoList = data2.configData.voicefilterlist == null ? new ArrayList() : data2.configData.voicefilterlist;
            this.mData.setValue("voiceFilterInfoList", infoList);
        }
    }

    public VoiceFilterData data() {
        return this.mData;
    }

    public void closeVoiceFilter() {
        int preId = this.mData.currentVoiceFilterId;
        if (preId == 0) {
            return;
        }
        this.mData.setValue("currentVoiceFilterId", (Object)0);
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setVoiceChange(0);
        this.selectChangeMode = 0;
        if (this.mVoiceFilterStartTime > 0L) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "change_sound_time").put("room_id", this.channel.getChannelId()).put("gid", this.channel.getPluginService().getCurPluginData().getId()).put("change_sound_mode", "" + preId).put("remain_time", String.valueOf((System.currentTimeMillis() - this.mVoiceFilterStartTime) / 1000L)));
            this.mVoiceFilterStartTime = 0L;
        }
    }

    @Override
    public void onJoined(boolean rejoin2, ChannelDetailInfo info, EnterChannelData data2) {
        super.onJoined(rejoin2, info, data2);
        AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.VOICE_FILTER_CONFIG);
        this.refreshFromConfig(aConfigData == null ? null : (VoiceFilterConfig)aConfigData);
        this.mData.setValue("currentChannelMode", (Object)this.channel.getPluginService().getCurPluginData().mode);
    }

    @Override
    public void onLeaved() {
        super.onLeaved();
        this.mData.setValue("currentChannelMode", (Object)-1);
        this.closeVoiceFilter();
    }

    public void selectVoiceFilter(int id2) {
        int preId = this.mData.currentVoiceFilterId;
        if (id2 == this.mData.currentVoiceFilterId) {
            return;
        }
        this.mData.setValue("currentVoiceFilterId", (Object)id2);
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setVoiceChange(id2);
        this.selectChangeMode = id2;
        if (this.mVoiceFilterStartTime > 0L) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "change_sound_time").put("room_id", this.channel.getChannelId()).put("gid", this.channel.getPluginService().getCurPluginData().getId()).put("change_sound_mode", "" + preId).put("remain_time", String.valueOf((System.currentTimeMillis() - this.mVoiceFilterStartTime) / 1000L)));
        }
        if (id2 > 0) {
            this.mVoiceFilterStartTime = System.currentTimeMillis();
        }
    }

    public void resumeSelectId() {
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setVoiceChange(this.selectChangeMode);
    }
}

