/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.video.play.normal;

import android.view.View;
import android.view.ViewGroup;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.live.LiveCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.bean.video.LiveVideoStreamInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.video.ILiveVideo;
import com.yy.hiyo.channel.service.video.play.AbLiveVideoPlayer;
import com.yy.hiyo.channel.service.video.play.normal.NormalLiveVideo;
import com.yy.hiyo.voice.base.VoiceConstant;
import com.yy.hiyo.voice.base.bean.WatchCodeRateDefine;
import com.yy.hiyo.voice.base.bean.event.OnNoMatchCodeRateCallback;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.channelvoice.IMediaInfoService;
import com.yy.hiyo.voice.base.channelvoice.IThunderPlayerView;
import com.yy.hiyo.voice.base.mediav1.bean.IMediaRoom;
import com.yy.hiyo.voice.base.mediav1.protocal.IWatcherManager;
import com.yy.hiyo.voice.base.mediav1.service.IMediaRoomService;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class NormalLiveVideoPlayer
extends AbLiveVideoPlayer
implements LiveCallback {
    private String logTag;
    private ArrayList<WeakReference<LiveCallback>> mLiveListeners;
    private NormalLiveVideo.IVideoCallBackEx mVideoCallBack;
    protected boolean isVideoMode;
    protected long sceneId;
    private String channelId;

    public NormalLiveVideoPlayer(IChannel channel, AbLiveVideoPlayer.IVidelPlayerCallBack callBack) {
        super(channel, callBack);
        this.logTag = "NormalLiveVideoPlayer_" + channel.getChannelId();
    }

    private boolean skipCallback(long uid) {
        return this.channel.getPluginService().getCurPluginData().mode == 15;
    }

    @Override
    protected void join() {
        boolean isMeAnchor = this.channel.getRoleService().isAnchor(AccountUtil.getUid());
        MLog.info((Object)this.logTag, (String)"join! isMeAnchor:%b", (Object[])new Object[]{isMeAnchor});
        if (isMeAnchor) {
            return;
        }
        this.updateAnchorUid();
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).listenLineStreamInfos();
        this.channel.getMediaService().registerLiveListener((LiveCallback)this);
        this.handlePluginInfoChange(this.channel.getPluginService().getCurPluginData());
        this.channelId = this.channel.getChannelId();
        if (this.isVideoMode) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (NormalLiveVideoPlayer.this.callback != null) {
                        NormalLiveVideoPlayer.this.callback.precreatePlayerView();
                    }
                }
            });
        }
    }

    private void updateAnchorUid() {
        if (this.channel != null && this.channel.getPluginService().getCurPluginData().mode == 14 && !((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).isLunMicChannel(this.channel.getChannelId())) {
            ChannelDetailInfo info = this.channel.getDataService().getCacheDetail();
            long anchorUid = this.channel.getRoleService().getAnchorUid();
            IMediaRoom room = ((IMediaRoomService)ServiceManagerProxy.getService(IMediaRoomService.class)).getRoom(this.channel.getChannelId());
            if (room != null) {
                if (anchorUid > 0L) {
                    room.updateCurrentLiveAnchor(anchorUid);
                } else if (info != null) {
                    room.updateCurrentLiveAnchor(info.baseInfo.ownerUid);
                }
            }
        }
    }

    @Override
    protected void exitReal() {
        MLog.info((Object)this.logTag, (String)"exitReal!", (Object[])new Object[0]);
        this.channel.getMediaService().unregisterLiveListener((LiveCallback)this);
    }

    @Override
    protected ILiveVideo createVideo(LiveVideoStreamInfo info, View playerView) {
        MLog.info((Object)this.logTag, (String)"lyy createVideo\uff1a%s! view:%s", (Object[])new Object[]{info.getId(), playerView});
        if (this.mVideoCallBack == null) {
            this.mVideoCallBack = new NormalLiveVideo.IVideoCallBackEx(){

                @Override
                public String getChannelId() {
                    if (NormalLiveVideoPlayer.this.channel != null) {
                        return NormalLiveVideoPlayer.this.channel.getChannelId();
                    }
                    return NormalLiveVideoPlayer.this.channelId;
                }
            };
        }
        return new NormalLiveVideo(this.callback.getContext(), playerView, this.mVideoCallBack, info.getId());
    }

    public IThunderPlayerView obtainPlayView() {
        return this.callback.getPlayerView();
    }

    public void changeCodeRate(@WatchCodeRateDefine String codeRate, OnNoMatchCodeRateCallback callback2) {
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).changeWatchLiveCodeRate(codeRate, callback2);
    }

    @Override
    public void release() {
        MLog.info((Object)this.logTag, (String)"release!", (Object[])new Object[0]);
        if (this.mLiveListeners != null) {
            this.mLiveListeners.clear();
            this.mLiveListeners = null;
        }
        super.release();
    }

    @Override
    public void onPluginModeChanged(String channelId, ChannelPluginData pluginData, ChannelPluginData beforePlugin) {
        super.onPluginModeChanged(channelId, pluginData, beforePlugin);
        this.handlePluginInfoChange(pluginData);
    }

    @Override
    public void onPluginInfoChanged(String channelId, ChannelPluginData pluginData) {
        super.onPluginInfoChanged(channelId, pluginData);
        this.handlePluginInfoChange(pluginData);
    }

    @Override
    public void onVideoModeChanged(String channelId, boolean isVideoMode) {
        super.onVideoModeChanged(channelId, isVideoMode);
        this.handlePluginInfoChange(this.channel.getPluginService().getCurPluginData());
    }

    private void handlePluginInfoChange(ChannelPluginData pluginData) {
        if (pluginData.isVideoMode()) {
            this.switchToVideoModel(pluginData);
        } else {
            this.exitVideoModel(pluginData);
        }
    }

    private void switchToVideoModel(ChannelPluginData pluginData) {
        ChannelDetailInfo detailInfo = this.channel.getDataService().getCacheDetail();
        boolean isMeOwner = this.channel.getRoleService().isMeAnchor();
        if (detailInfo != null && !detailInfo.baseInfo.isGroupParty()) {
            isMeOwner = this.channel.getRoleService().isMeOwner();
        }
        MLog.info((Object)this.logTag, (String)"switchToVideoModel isVideoMode:%d,pluginMode:%d, isMeOwner:%b!", (Object[])new Object[]{this.isVideoMode ? 1 : 0, pluginData.mode, isMeOwner});
        long sceneId = this.getSceneId(pluginData);
        if (!this.isVideoMode || sceneId != this.sceneId) {
            if (sceneId != this.sceneId) {
                ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setSecneParam(this.channel.getChannelId(), sceneId, ((IMediaInfoService)ServiceManagerProxy.getService(IMediaInfoService.class)).getThunderRoomconfigLiveType());
            }
            this.sceneId = sceneId;
        }
        if (this.isVideoMode) {
            return;
        }
        this.isVideoMode = true;
        if (isMeOwner) {
            return;
        }
        this.updateAnchorUid();
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).changeShowVideo(true);
    }

    private void exitVideoModel(ChannelPluginData pluginData) {
        MLog.info((Object)this.logTag, (String)"exitVideoModel isVideoMode:%d,pluginMode:%d!", (Object[])new Object[]{this.isVideoMode ? 1 : 0, pluginData.mode});
        long sceneId = this.getSceneId(pluginData);
        if (this.isVideoMode || sceneId != this.sceneId) {
            if (sceneId != this.sceneId) {
                ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setSecneParam(this.channel.getChannelId(), sceneId, ((IMediaInfoService)ServiceManagerProxy.getService(IMediaInfoService.class)).getThunderRoomconfigMultiAudioRoomType());
            }
            this.sceneId = sceneId;
        }
        if (!this.isVideoMode) {
            return;
        }
        this.isVideoMode = false;
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).changeShowVideo(false);
    }

    public void registerCallback(LiveCallback callback2) {
        if (callback2 == null) {
            return;
        }
        if (this.mLiveListeners == null) {
            this.mLiveListeners = new ArrayList(2);
        } else {
            for (WeakReference<LiveCallback> item : this.mLiveListeners) {
                LiveCallback listenerReal;
                if (item == null || (listenerReal = (LiveCallback)item.get()) != callback2) continue;
                return;
            }
        }
        this.mLiveListeners.add(new WeakReference<LiveCallback>(callback2));
    }

    public void unregisterCallback(LiveCallback callback2) {
        if (callback2 == null || this.mLiveListeners == null || this.mLiveListeners.size() <= 0) {
            return;
        }
        for (WeakReference<LiveCallback> item : this.mLiveListeners) {
            LiveCallback listenerReal;
            if (item == null || (listenerReal = (LiveCallback)item.get()) != callback2) continue;
            this.mLiveListeners.remove(item);
            return;
        }
    }

    public void onVideoStart(long anchorId, int width, int height, boolean isCdn) {
        LiveVideoStreamInfo info = this.getStream(anchorId);
        if (this.skipCallback(anchorId)) {
            return;
        }
        if (info != null) {
            if (info.getHeight() != height || info.getWidth() != width || info.getType() != (isCdn ? 1 : 0)) {
                LiveVideoStreamInfo newInfo = new LiveVideoStreamInfo(info);
                newInfo.updateWidh(width);
                newInfo.updateHeight(height);
                newInfo.updateType(isCdn ? 1 : 0);
                super.onStreamInfoUpdated(newInfo);
                MLog.info((Object)this.logTag, (String)"onVideoStart anchorId:%s,width:%d,height:%d,isCdn:%d!", (Object[])new Object[]{String.valueOf(anchorId), width, height, isCdn ? 1 : 0});
            } else {
                MLog.info((Object)this.logTag, (String)"onVideoStart anchorId:%s, and no Stream data update!", (Object[])new Object[]{String.valueOf(anchorId)});
            }
        } else {
            MLog.info((Object)this.logTag, (String)"onVideoStart anchorId:%s, not find this stream!", (Object[])new Object[]{String.valueOf(anchorId)});
        }
        ILiveVideo liveVideo = this.getLiveVideo(anchorId);
        if (liveVideo instanceof NormalLiveVideo) {
            ((NormalLiveVideo)liveVideo).onVideStarted();
        }
        if (this.mLiveListeners == null || this.mLiveListeners.size() == 0) {
            return;
        }
        for (WeakReference<LiveCallback> item : this.mLiveListeners) {
            LiveCallback listener2;
            if (item == null || item.get() == null || (listener2 = (LiveCallback)item.get()) == null) continue;
            listener2.onVideoStart(anchorId, width, height, isCdn);
        }
    }

    public void onVideoStop(long anchorId) {
        if (this.skipCallback(anchorId)) {
            return;
        }
        LiveVideoStreamInfo info = this.getStream(anchorId);
        if (info != null) {
            super.onStreamDelete(info);
            MLog.info((Object)this.logTag, (String)"onVideoStop anchorId:%s!", (Object[])new Object[]{String.valueOf(anchorId)});
        } else {
            MLog.info((Object)this.logTag, (String)"onVideoStop anchorId:%s,but not find this stream!", (Object[])new Object[]{String.valueOf(anchorId)});
        }
        ILiveVideo liveVideo = this.getLiveVideo(anchorId);
        if (liveVideo instanceof NormalLiveVideo) {
            ((NormalLiveVideo)liveVideo).onVideStoped();
        }
        if (this.mLiveListeners == null || this.mLiveListeners.size() == 0) {
            return;
        }
        for (WeakReference<LiveCallback> item : this.mLiveListeners) {
            LiveCallback listener2;
            if (item == null || item.get() == null || (listener2 = (LiveCallback)item.get()) == null) continue;
            listener2.onVideoStop(anchorId);
        }
    }

    public void onVideoSizeChange(long anchorId, int width, int height, int rotation) {
        if (this.skipCallback(anchorId)) {
            return;
        }
        LiveVideoStreamInfo info = this.getStream(anchorId);
        if (info == null) {
            info = new LiveVideoStreamInfo(anchorId);
            info.updateHeight(height);
            info.updateWidh(width);
            info.updateRotation(rotation);
            super.onStreamAdd(info);
            MLog.info((Object)this.logTag, (String)"onVideoSizeChange anchorId:%s, not find this Stream!", (Object[])new Object[]{String.valueOf(anchorId)});
            MLog.info((Object)this.logTag, (String)"onVideoSizeChange anchorId:%s,width:%d,height:%d,rotation:%d!", (Object[])new Object[]{String.valueOf(anchorId), width, height, rotation});
        } else if (info.getHeight() != height || info.getWidth() != width || info.getRotation() != rotation) {
            LiveVideoStreamInfo newInfo = new LiveVideoStreamInfo(info);
            newInfo.updateRotation(rotation);
            newInfo.updateWidh(width);
            newInfo.updateHeight(height);
            super.onStreamInfoUpdated(newInfo);
            MLog.info((Object)this.logTag, (String)"onVideoSizeChange anchorId:%s,width:%d,height:%d,rotation:%d,oldWidth:%d,oldHeight:%d,oldRotation:%d!", (Object[])new Object[]{String.valueOf(anchorId), width, height, rotation, info.getWidth(), info.getHeight(), info.getRotation()});
        } else {
            MLog.info((Object)this.logTag, (String)"onVideoSizeChange anchorId:%s, but no data update!", (Object[])new Object[]{String.valueOf(anchorId)});
        }
        if (this.mLiveListeners == null || this.mLiveListeners.size() == 0) {
            return;
        }
        for (WeakReference<LiveCallback> item : this.mLiveListeners) {
            LiveCallback listener2;
            if (item == null || item.get() == null || (listener2 = (LiveCallback)item.get()) == null) continue;
            listener2.onVideoSizeChange(anchorId, width, height, rotation);
        }
    }

    public void onVideoStreamOpen(long anchorId) {
        LiveVideoStreamInfo info;
        if (this.skipCallback(anchorId) || RuntimeContext.isHagoPartySdk()) {
            return;
        }
        if (this.channel != null && this.channel.getEnterParam() != null && this.channel.getEnterParam().mChannelTimingStat != null) {
            this.channel.getEnterParam().mChannelTimingStat.onVideoStreamOpen();
        }
        if ((info = this.getStream(anchorId)) == null) {
            super.onStreamAdd(new LiveVideoStreamInfo(anchorId));
            MLog.info((Object)this.logTag, (String)"VideoStreamOpen anchorId:%s!", (Object[])new Object[]{String.valueOf(anchorId)});
        } else {
            MLog.info((Object)this.logTag, (String)"VideoStreamOpen anchorId:%s, has opened!", (Object[])new Object[0]);
        }
        ILiveVideo liveVideo = this.getLiveVideo(anchorId);
        if (liveVideo == null) {
            IWatcherManager watcherManager;
            IMediaRoom room = ((IMediaRoomService)ServiceManagerProxy.getService(IMediaRoomService.class)).getRoom(this.channel.getChannelId());
            ViewGroup view = null;
            if (room != null && (watcherManager = room.getWatcherManager()) != null) {
                view = watcherManager.getCacheWatchView();
                MLog.info((Object)"TAG", (String)"lyy cache view:%s", (Object[])new Object[]{view});
            }
            if (view == null) {
                view = this.callback.getPlayerView().getView();
                MLog.info((Object)"TAG", (String)"lyy view from callback:%s", (Object[])new Object[]{view});
            }
            liveVideo = super.createLiveVideo(anchorId, (View)view);
            liveVideo.play(null);
            MLog.error((Object)this.logTag, (String)"VideoStreamOpen UI\u5c42\u8fd8\u6ca1\u6709\u521b\u5efavideo\uff0c\u8bc1\u660e\u6d41\u4fe1\u606f\u6765\u4e4b\u524dUI\u5c42\u8fd8\u672a\u521b\u5efa\uff0c\u9700\u8981\u68c0\u67e5!", (Object[])new Object[0]);
        } else {
            liveVideo.play(null);
        }
        if (this.mLiveListeners == null || this.mLiveListeners.size() == 0) {
            return;
        }
        for (WeakReference<LiveCallback> item : this.mLiveListeners) {
            LiveCallback listener2;
            if (item == null || item.get() == null || (listener2 = (LiveCallback)item.get()) == null) continue;
            listener2.onVideoStreamOpen(anchorId);
        }
    }

    public void onJoinChannelSuccess(@Nullable String channel, @Nullable String p1, int elapsed) {
        MLog.info((Object)this.logTag, (String)"on Media JoinChannelSuccess!", (Object[])new Object[0]);
        if (this.skipCallback(StringUtils.safeParseLong((String)p1))) {
            return;
        }
        if (this.mLiveListeners == null || this.mLiveListeners.size() == 0) {
            return;
        }
        for (WeakReference<LiveCallback> item : this.mLiveListeners) {
            LiveCallback listener2;
            if (item == null || item.get() == null || (listener2 = (LiveCallback)item.get()) == null) continue;
            listener2.onJoinChannelSuccess(channel, p1, elapsed);
        }
    }

    public void onSourceChange(boolean isCdn) {
    }

    private long getSceneId(ChannelPluginData pluginData) {
        String source;
        long sceneId = ChannelPluginData.getSceneId((ChannelPluginData)pluginData);
        if (this.channel.getDataService() != null && this.channel.getDataService().getCacheDetail() != null && this.channel.getDataService().getCacheDetail().baseInfo != null && ("hago.amongus".equals(source = this.channel.getDataService().getCacheDetail().baseInfo.source) || "hago.amongus-user".equals(source))) {
            sceneId = VoiceConstant.SCENE_ID_TEAM_UP;
        }
        return sceneId;
    }
}

