/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.video.play.normal;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.cbase.module.common.CodeRateUtils;
import com.yy.hiyo.channel.cbase.module.radio.config.LiveConstants;
import com.yy.hiyo.channel.service.video.play.AbLiveVideo;
import com.yy.hiyo.voice.base.bean.event.OnNoMatchCodeRateCallback;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.mediav1.bean.IMediaRoom;
import com.yy.hiyo.voice.base.mediav1.bean.StreamSubType;
import com.yy.hiyo.voice.base.mediav1.service.IMediaRoomService;

public class NormalLiveVideo
extends AbLiveVideo {
    protected IVideoCallBackEx mCallBackEx;
    private View mPlayView;
    private String logTag;

    public NormalLiveVideo(Context context, View playView, IVideoCallBackEx callBack, long videoId) {
        super(context, callBack, videoId);
        this.mCallBackEx = callBack;
        this.mPlayView = playView;
        this.logTag = "NormalLiveVideo_" + videoId;
    }

    @Override
    public boolean bindReal(ViewGroup cotainer, ViewGroup.LayoutParams layoutParams) {
        if (cotainer == null) {
            return false;
        }
        ViewParent parent = this.mPlayView.getParent();
        if (parent != null && parent instanceof ViewGroup) {
            if (parent == cotainer) {
                this.mPlayView.setLayoutParams(layoutParams);
            } else {
                ((ViewGroup)parent).removeView(this.mPlayView);
                cotainer.addView(this.mPlayView, layoutParams);
            }
        } else {
            cotainer.addView(this.mPlayView, layoutParams);
        }
        return true;
    }

    @Override
    public void unbindReal(ViewGroup cotainer) {
        ViewParent parent = this.mPlayView.getParent();
        if (parent != null && parent instanceof ViewGroup && cotainer == parent) {
            this.unbindForce();
        }
    }

    @Override
    public void unbindForce() {
        ViewParent parent = this.mPlayView.getParent();
        if (parent != null && parent instanceof ViewGroup) {
            ((ViewGroup)parent).removeView(this.mPlayView);
        }
    }

    @Override
    public String getLogTag() {
        return this.logTag;
    }

    @Override
    public void stopReal() {
        MLog.info((Object)this.getLogTag(), (String)"stopReal!", (Object[])new Object[0]);
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).stopWatchLive(this.mCallBackEx.getChannelId(), this.getId());
    }

    @Override
    public void onVideStarted() {
        super.onVideStarted();
    }

    @Override
    public void onVideStoped() {
        super.onVideStoped();
    }

    @Override
    public boolean playReal(OnNoMatchCodeRateCallback callback2) {
        IMediaRoom room;
        MLog.info((Object)this.getLogTag(), (String)"lyy playReal! %s", (Object[])new Object[]{this.mPlayView});
        boolean hasAutoLevel = false;
        IMediaRoomService roomService = (IMediaRoomService)ServiceManagerProxy.getService(IMediaRoomService.class);
        if (roomService != null && (room = roomService.getRoom(this.mCallBackEx.getChannelId())) != null) {
            hasAutoLevel = room.getPreferStreamSubType() == StreamSubType.STREAM_SUBTYPE_CDN_DASH || room.getPreferStreamSubType() == StreamSubType.STREAM_SUBTYPE_THUNDER_TRANS;
        }
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).startWatchLive(this.mPlayView, this.getId(), CodeRateUtils.INSTANCE.getCodeRateLevelString(LiveConstants.INSTANCE.getPlayQualityLevel(hasAutoLevel)), callback2);
        return true;
    }

    public void reusePlay() {
        if (this.mRelased) {
            return;
        }
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).reusePlay(this.mPlayView, this.getId());
    }

    public View getPlayView() {
        return this.mPlayView;
    }

    public static interface IVideoCallBackEx
    extends AbLiveVideo.IVideoCallBack {
        public String getChannelId();
    }
}

