/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.video.play;

import android.content.Context;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.video.ILiveVideoPlayer;
import com.yy.hiyo.channel.service.video.play.AbLiveVideoPlayer;
import com.yy.hiyo.channel.service.video.play.PlayerViewManager;
import com.yy.hiyo.channel.service.video.play.normal.NormalLiveVideoPlayer;
import com.yy.hiyo.voice.base.channelvoice.IThunderPlayerView;
import java.util.HashMap;

public class LiveVideoPlayerManager
implements AbLiveVideoPlayer.IVidelPlayerCallBack {
    private Context mContext;
    private HashMap<String, AbLiveVideoPlayer> players;
    private PlayerViewManager playerViewManager;

    public LiveVideoPlayerManager(Context context) {
        this.mContext = context;
        this.playerViewManager = new PlayerViewManager(this.mContext);
    }

    public ILiveVideoPlayer getLiveVideoPlayer(IChannel channel) {
        AbLiveVideoPlayer player;
        if (channel == null || StringUtils.isEmpty((String)channel.getChannelId())) {
            return null;
        }
        if (this.players == null) {
            this.players = new HashMap(2);
        }
        if ((player = this.players.get(channel.getChannelId())) != null) {
            return player;
        }
        player = new NormalLiveVideoPlayer(channel, this);
        this.players.put(channel.getChannelId(), player);
        return player;
    }

    public void onStartUpFinished() {
        this.playerViewManager.onStartUpFinished();
    }

    @Override
    public void onJoined(ILiveVideoPlayer player, IChannel channel) {
    }

    @Override
    public void onExit(ILiveVideoPlayer player, IChannel channel) {
    }

    @Override
    public void onRelease(ILiveVideoPlayer player) {
        if (this.players != null) {
            this.players.remove(player);
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public void afterRelease(ILiveVideoPlayer player) {
        if (this.players != null) {
            this.players.remove(player.getId());
        }
    }

    @Override
    public void precreatePlayerView() {
        this.playerViewManager.ensurePreCreateView();
    }

    @Override
    public IThunderPlayerView getPlayerView() {
        return this.playerViewManager.getPlayerView();
    }
}

