/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.video.play;

import android.content.Context;
import android.view.View;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.bean.video.LiveVideoStreamInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.base.service.video.ILiveVideo;
import com.yy.hiyo.channel.base.service.video.ILiveVideoPlayer;
import com.yy.hiyo.channel.base.service.video.IStreamChangeCallback;
import com.yy.hiyo.voice.base.channelvoice.IThunderPlayerView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class AbLiveVideoPlayer
implements ILiveVideoPlayer,
IPluginService.IPluginDataChangedCallBack {
    private ArrayList<WeakReference<IStreamChangeCallback>> mStreamListeners;
    private ArrayList<LiveVideoStreamInfo> mStreamInfos;
    private ArrayList<ILiveVideo> mVideos;
    protected boolean joined;
    protected IChannel channel;
    protected IVidelPlayerCallBack callback;
    private String id;

    public AbLiveVideoPlayer(IChannel channel, IVidelPlayerCallBack callBack) {
        this.callback = callBack;
        this.channel = channel;
        this.id = channel.getChannelId();
    }

    protected abstract void join();

    protected abstract void exitReal();

    protected abstract ILiveVideo createVideo(LiveVideoStreamInfo var1, View var2);

    public final void join(IChannel channel) {
        if (channel == null) {
            return;
        }
        if (!StringUtils.equal((String)channel.getChannelId(), (String)this.channel.getChannelId()) && RuntimeContext.sIsDebuggable) {
            throw new RuntimeException("channel not right!");
        }
        this.joined = true;
        this.channel = channel;
        this.join();
        channel.getPluginService().addPluginDataListener((IPluginService.IPluginDataChangedCallBack)this);
        if (this.callback != null) {
            this.callback.onJoined(this, channel);
        }
    }

    public final void exit() {
        if (this.channel == null) {
            return;
        }
        if (this.joined) {
            this.channel.getPluginService().removePluginDataListener((IPluginService.IPluginDataChangedCallBack)this);
            this.exitReal();
            if (this.callback != null) {
                this.callback.onExit(this, this.channel);
            }
            this.channel = null;
            this.joined = false;
        }
    }

    public final ILiveVideo createLiveVideo(long anchorId, View playerView) {
        LiveVideoStreamInfo liveVideoStreamInfo = this.getStream(anchorId);
        if (liveVideoStreamInfo != null) {
            ILiveVideo liveVideo;
            if (this.mVideos == null) {
                this.mVideos = new ArrayList(2);
            }
            if ((liveVideo = this.createVideo(liveVideoStreamInfo, playerView)) != null) {
                this.mVideos.add(liveVideo);
            }
            return liveVideo;
        }
        return null;
    }

    public ILiveVideo getLiveVideo(long anchorId) {
        if (this.mVideos != null && this.mVideos.size() > 0) {
            for (ILiveVideo video : this.mVideos) {
                if (video.getId() != anchorId) continue;
                return video;
            }
        }
        return null;
    }

    public List<LiveVideoStreamInfo> getStreams() {
        if (this.mStreamInfos != null && this.mStreamInfos.size() > 0) {
            return new ArrayList<LiveVideoStreamInfo>(this.mStreamInfos);
        }
        return new ArrayList<LiveVideoStreamInfo>(0);
    }

    public LiveVideoStreamInfo getStream(long streamId) {
        if (this.mStreamInfos != null && this.mStreamInfos.size() > 0) {
            for (LiveVideoStreamInfo info : this.mStreamInfos) {
                if (info.getId() != streamId) continue;
                return info;
            }
        }
        return null;
    }

    public void release() {
        if (this.callback != null) {
            this.callback.onRelease(this);
        }
        this.exit();
        if (this.mStreamListeners != null) {
            this.mStreamListeners.clear();
            this.mStreamListeners = null;
        }
        if (this.mStreamInfos != null) {
            this.mStreamInfos.clear();
            this.mStreamInfos = null;
        }
        if (this.mVideos != null) {
            for (ILiveVideo video : this.mVideos) {
                video.release();
            }
            this.mVideos.clear();
            this.mVideos = null;
        }
        if (this.callback != null) {
            this.callback.afterRelease(this);
        }
    }

    public void onPluginModeChanged(String channelId, ChannelPluginData pluginData, ChannelPluginData beforePlugin) {
        if (RuntimeContext.sIsDebuggable && !StringUtils.equal((String)channelId, (String)this.channel.getChannelId())) {
            throw new RuntimeException("channel not right!");
        }
    }

    public void onPluginInfoChanged(String channelId, ChannelPluginData pluginData) {
        if (RuntimeContext.sIsDebuggable && !StringUtils.equal((String)channelId, (String)this.channel.getChannelId())) {
            throw new RuntimeException("channel not right!");
        }
    }

    public void onVideoModeChanged(String channelId, boolean isVideoMode) {
        if (RuntimeContext.sIsDebuggable && !StringUtils.equal((String)channelId, (String)this.channel.getChannelId())) {
            throw new RuntimeException("channel not right!");
        }
    }

    public void registerStreamListener(IStreamChangeCallback callback2) {
        if (callback2 == null) {
            return;
        }
        if (this.mStreamListeners == null) {
            this.mStreamListeners = new ArrayList(2);
        } else {
            for (WeakReference<IStreamChangeCallback> item : this.mStreamListeners) {
                IStreamChangeCallback listenerReal;
                if (item == null || (listenerReal = (IStreamChangeCallback)item.get()) != callback2) continue;
                return;
            }
        }
        this.mStreamListeners.add(new WeakReference<IStreamChangeCallback>(callback2));
    }

    public void unregisterStreamListener(IStreamChangeCallback callback2) {
        if (callback2 == null || this.mStreamListeners == null || this.mStreamListeners.size() <= 0) {
            return;
        }
        for (WeakReference<IStreamChangeCallback> item : this.mStreamListeners) {
            IStreamChangeCallback listenerReal;
            if (item == null || (listenerReal = (IStreamChangeCallback)item.get()) != callback2) continue;
            this.mStreamListeners.remove(item);
            return;
        }
    }

    protected void onStreamAdd(LiveVideoStreamInfo info) {
        if (this.mStreamInfos == null) {
            this.mStreamInfos = new ArrayList(2);
        }
        LiveVideoStreamInfo itemFind = null;
        if (this.mStreamInfos != null) {
            itemFind = this.getStream(info.getId());
        }
        if (itemFind == null) {
            this.mStreamInfos.add(info);
        }
        if (this.mStreamListeners == null || this.mStreamListeners.size() == 0) {
            return;
        }
        for (WeakReference<IStreamChangeCallback> item : this.mStreamListeners) {
            IStreamChangeCallback listener2;
            if (item == null || item.get() == null || (listener2 = (IStreamChangeCallback)item.get()) == null) continue;
            listener2.onStreamAdd(info);
        }
    }

    protected void onStreamDelete(LiveVideoStreamInfo info) {
        if (info == null) {
            return;
        }
        LiveVideoStreamInfo itemFind = null;
        if (this.mStreamInfos != null) {
            itemFind = this.getStream(info.getId());
        }
        if (itemFind == null) {
            return;
        }
        this.mStreamInfos.remove(itemFind);
        info = itemFind;
        if (this.mStreamListeners == null || this.mStreamListeners.size() == 0) {
            return;
        }
        for (WeakReference<IStreamChangeCallback> item : this.mStreamListeners) {
            IStreamChangeCallback listener2;
            if (item == null || item.get() == null || (listener2 = (IStreamChangeCallback)item.get()) == null) continue;
            listener2.onStreamDelete(info);
        }
    }

    protected void onStreamInfoUpdated(LiveVideoStreamInfo info) {
        LiveVideoStreamInfo itemFind = null;
        if (this.mStreamInfos != null) {
            itemFind = this.getStream(info.getId());
        }
        if (itemFind == null) {
            return;
        }
        LiveVideoStreamInfo oldInfo = new LiveVideoStreamInfo(itemFind);
        itemFind.updateBy(info);
        if (this.mStreamListeners == null || this.mStreamListeners.size() == 0) {
            return;
        }
        for (WeakReference<IStreamChangeCallback> item : this.mStreamListeners) {
            IStreamChangeCallback listener2;
            if (item == null || item.get() == null || (listener2 = (IStreamChangeCallback)item.get()) == null) continue;
            listener2.onStreamInfoUpdated(itemFind, oldInfo);
        }
    }

    public String getId() {
        return this.id;
    }

    public static interface IVidelPlayerCallBack {
        public void onJoined(ILiveVideoPlayer var1, IChannel var2);

        public void onExit(ILiveVideoPlayer var1, IChannel var2);

        public void onRelease(ILiveVideoPlayer var1);

        public void afterRelease(ILiveVideoPlayer var1);

        public void precreatePlayerView();

        public IThunderPlayerView getPlayerView();

        public Context getContext();
    }
}

