/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.request.role;

import android.content.Context;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import biz.ChannelMember;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.bean.JoinApproveData;
import com.yy.hiyo.channel.base.bean.OnlineInfo;
import com.yy.hiyo.channel.base.bean.OnlineWithStatusInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.service.request.RequestPreventDuplicater;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import common.ERet;
import common.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.ihago.channel.srv.mgr.AcceptRoleReq;
import net.ihago.channel.srv.mgr.AcceptRoleRes;
import net.ihago.channel.srv.mgr.BannedReq;
import net.ihago.channel.srv.mgr.BannedRes;
import net.ihago.channel.srv.mgr.BannedStatus;
import net.ihago.channel.srv.mgr.BatchSetRoleReq;
import net.ihago.channel.srv.mgr.BatchSetRoleRes;
import net.ihago.channel.srv.mgr.ECode;
import net.ihago.channel.srv.mgr.GetBannedStatusReq;
import net.ihago.channel.srv.mgr.GetBannedStatusRes;
import net.ihago.channel.srv.mgr.GetCurrentChannelsReq;
import net.ihago.channel.srv.mgr.GetCurrentChannelsRes;
import net.ihago.channel.srv.mgr.GetMemberListReq;
import net.ihago.channel.srv.mgr.GetMemberListRes;
import net.ihago.channel.srv.mgr.GetOnlinesReq;
import net.ihago.channel.srv.mgr.GetOnlinesRes;
import net.ihago.channel.srv.mgr.GetPartyOnlinesReq;
import net.ihago.channel.srv.mgr.GetPartyOnlinesRes;
import net.ihago.channel.srv.mgr.GetPartyOnlinesWithStatusReq;
import net.ihago.channel.srv.mgr.GetPartyOnlinesWithStatusRes;
import net.ihago.channel.srv.mgr.JoinApplyReq;
import net.ihago.channel.srv.mgr.JoinApplyRes;
import net.ihago.channel.srv.mgr.JoinApproveReq;
import net.ihago.channel.srv.mgr.JoinApproveRes;
import net.ihago.channel.srv.mgr.KickOffReq;
import net.ihago.channel.srv.mgr.KickOffRes;
import net.ihago.channel.srv.mgr.RetStatus;
import net.ihago.channel.srv.mgr.SetRoleReq;
import net.ihago.channel.srv.mgr.SetRoleRes;
import net.ihago.online.srv.online.OnlineStatus;

public class RoleRequestManager
extends BaseRequestManager {
    private static final String TAG = "ChannelRequest_Role";
    private RequestPreventDuplicater<BaseRequestManager.IGetAllMembersCallBack> syncGroupInfoDuplicater;
    private long lastRquestBannedStatuUid = 0L;
    private String lastRquestBannedStatuGid = "";
    private long lastRquestBannedStatuTime = 0L;
    private BannedStatus lastBannedStatusData = null;

    private ChannelMember obtainChannelMember(int roleType) {
        ChannelMember.Builder builder = new ChannelMember.Builder();
        builder.role(Integer.valueOf(roleType));
        return builder.build();
    }

    public void applyJoin(final String cid, String joinFrom, final IRoleService.IJoinApplyCallBack callBack) {
        UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(AccountUtil.getUid());
        JoinApplyReq req = new JoinApplyReq.Builder().cid(cid).nick(userInfoKS != null ? userInfoKS.nick : "").avatar(userInfoKS != null ? userInfoKS.avatar : "").source(joinFrom).build();
        MLog.info((Object)TAG, (String)"applyJoin cid:%s, source:%s", (Object[])new Object[]{cid, joinFrom});
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<JoinApplyRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable JoinApplyRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Role error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull JoinApplyRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    ChannelMember channelMember;
                    String applyId = message.apply_id;
                    ChannelMember channelMember2 = channelMember = !message.member.__isDefaultInstance() ? message.member : null;
                    if (callBack != null) {
                        callBack.onSuccess(cid, applyId, channelMember != null ? BaseRequestManager.obtainChannelUser((ChannelMember)channelMember) : null);
                    }
                    MLog.info((Object)RoleRequestManager.TAG, (String)"applyJoin success, cid:%s,applyId:%s", (Object[])new Object[]{cid, applyId});
                    BaseRequestManager.statMetric((String)"channel/joinaplly", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (callBack != null) {
                    if (code == (long)ECode.ROLE_NUM_LIMIT.getValue()) {
                        callBack.onFailByMemberReachLimit(cid);
                    } else if (code == (long)ECode.JOIN_NUM_LIMIT.getValue()) {
                        callBack.onFailByJoinedChannelLimit(cid);
                    } else if (code == (long)ECode.JOIN_BAN_FOREVER.getValue()) {
                        callBack.onJoinBanForever(cid);
                    } else if (code == (long)ECode.STILL_IN_CHANNEL.getValue()) {
                        callBack.onAlreadyJoined(cid);
                    } else if (code == (long)ECode.ALREADY_HAS_FAMILY.getValue()) {
                        callBack.onHaveJoinedFamily(cid);
                    } else if (code == (long)ECode.FAMILY_JOIN_APPLY_NOT_CONDITION.getValue()) {
                        callBack.onFailByJoinedLvLimit(cid);
                    } else if (code == (long)ECode.JOIN_FAMILY_FROZE.getValue()) {
                        callBack.onFailByJoinedFrozeLimit(cid, message.leave_family_froze.intValue());
                    } else if (code == (long)ECode.NOT_ALLOW_CAUSE_BLACK_LIST.getValue()) {
                        callBack.onFailByInOwnerBlackList(cid, message.result.errmsg);
                    } else if (callBack != null) {
                        callBack.onError(cid, 102, msg, new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    }
                    MLog.error((Object)RoleRequestManager.TAG, (String)"applyJoin error cid:%s,code:%d,errortips:%s", (Object[])new Object[]{cid, code, !message.result.__isDefaultInstance() ? message.result.errmsg : ""});
                    BaseRequestManager.statMetric((String)"channel/joinaplly", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(cid, 100, "", new Exception("Time out!"));
                        }
                        MLog.info((Object)RoleRequestManager.TAG, (String)"applyJoin error, cid:%s,code:%s", (Object[])new Object[]{cid, "Time out!"});
                        BaseRequestManager.statMetric((String)"channel/joinaplly", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)RoleRequestManager.TAG, (String)"applyJoin netError cid:%s, code:%d, reason:%s!", (Object[])new Object[]{cid, code, reason});
                        if (callBack != null) {
                            callBack.onError(cid, 100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        }
                        BaseRequestManager.statMetric((String)"channel/joinaplly", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void joinApprove(final String cid, final JoinApproveData data2, final IRoleService.IJoinApproveCallBack callBack) {
        JoinApproveReq req = new JoinApproveReq.Builder().apply_id(data2.applyId).accept(Boolean.valueOf(data2.accept)).reject_forever(Boolean.valueOf(data2.rejectForever)).reason(data2.reason).member(this.obtainChannelMember(data2.roleType)).build();
        MLog.info((Object)TAG, (String)"joinApprove cid:%s, data:%s", (Object[])new Object[]{cid, data2.toString()});
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<JoinApproveRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable JoinApproveRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Role error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull JoinApproveRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    ChannelMember channelMember = message.member;
                    if (callBack != null) {
                        callBack.onSuccess(cid, data2.applyId, BaseRequestManager.obtainChannelUser((ChannelMember)channelMember));
                    }
                    MLog.info((Object)RoleRequestManager.TAG, (String)"joinApprove success, cid:%s,applyId:%s", (Object[])new Object[]{cid, data2.applyId});
                    BaseRequestManager.statMetric((String)"channel/joinapprove", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (callBack != null) {
                    if (code == (long)ECode.ROLE_NUM_LIMIT.getValue()) {
                        callBack.onFailByMemberReachLimit(cid, data2.applyId);
                    } else if (code == (long)ECode.JOIN_NUM_LIMIT.getValue()) {
                        callBack.onFailByJoinedChannelLimit(cid, data2.applyId);
                    } else if (code == (long)ECode.NO_PERMIT.getValue() || code == (long)ERet.kRetErrPermissionDenied.getValue()) {
                        callBack.onNoPermissionError(cid, data2.applyId);
                    } else if (code == (long)ECode.ALREADY_CHANGED.getValue() || code == (long)ECode.OTHER_REJECTED.getValue()) {
                        callBack.onApplyAlreadyInvalidError(cid, data2.applyId);
                    } else if (code == (long)ECode.STILL_IN_CHANNEL.getValue()) {
                        callBack.onAlreadyJoined(cid, data2.applyId);
                    } else if (code == (long)ECode.CHANNEL_NOT_EXISTS.getValue()) {
                        callBack.onChannelNoExit(cid, code);
                    } else if (code == (long)ECode.CHANNEL_BANNED.getValue()) {
                        callBack.onChannelBanned(cid, code);
                    } else if (code == (long)ECode.JOIN_BAN_FOREVER.getValue()) {
                        callBack.onChannelJoinBanForever(cid, code);
                    } else if (code == (long)ECode.NOT_IN_CHANNEL.getValue()) {
                        callBack.onNotInChannel(cid, code);
                    } else if (code == (long)ECode.OTHER_REJECTED.getValue()) {
                        callBack.onOtherRejected(cid, code);
                    } else if (code == (long)ECode.NO_ARROW.getValue()) {
                        callBack.onNoArrow(cid, code);
                    } else if (code == (long)ECode.ALREADY_HAS_FAMILY.getValue()) {
                        callBack.onFailAlreadHaveFamily(cid, code);
                    } else if (callBack != null) {
                        callBack.onError(cid, 102, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    }
                    MLog.error((Object)RoleRequestManager.TAG, (String)"joinApprove error, cid:%s,code:%d,errortips:%s", (Object[])new Object[]{cid, code, !message.result.__isDefaultInstance() ? message.result.errmsg : ""});
                    BaseRequestManager.statMetric((String)"channel/joinapprove", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(cid, 100, "", new Exception("Time out!"));
                        }
                        MLog.error((Object)RoleRequestManager.TAG, (String)"joinApprove error, cid:%s,applyId:%s,code:%s", (Object[])new Object[]{cid, data2.applyId, "Time out!"});
                        BaseRequestManager.statMetric((String)"channel/joinapprove", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)RoleRequestManager.TAG, (String)"joinApprove error, cid:%s,code:%d, reason:%s!", (Object[])new Object[]{cid, code, reason});
                        if (callBack != null) {
                            callBack.onError(cid, 100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        }
                        BaseRequestManager.statMetric((String)"channel/joinapprove", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void setRole(final String cid, final long uid, int roleType, String joinFrom, final IRoleService.ISetRoleCallBack callBack) {
        SetRoleReq req = new SetRoleReq.Builder().cid(cid).uid(Long.valueOf(uid)).role(Integer.valueOf(roleType)).source(joinFrom).build();
        MLog.info((Object)TAG, (String)"setRole cid:%s, uid:%s, roleType:%d, source:%s", (Object[])new Object[]{cid, String.valueOf(uid), roleType, joinFrom});
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<SetRoleRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable SetRoleRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Role error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull SetRoleRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    String setId = message.set_id;
                    if (callBack != null) {
                        callBack.onSuccess(cid, uid, StringUtils.isNotEmpty((String)setId));
                    }
                    MLog.info((Object)RoleRequestManager.TAG, (String)"setRole success, cid:%s,uid:%s,setId:%s", (Object[])new Object[]{cid, String.valueOf(uid), setId});
                    BaseRequestManager.statMetric((String)"channel/setrole", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (callBack != null) {
                    if (code == (long)ECode.ROLE_NUM_LIMIT.getValue()) {
                        callBack.onFailByMemberReachLimit();
                    } else if (code == (long)ECode.JOIN_NUM_LIMIT.getValue()) {
                        callBack.onFailByJoinedChannelLimit();
                    } else if (code == (long)ECode.NO_PERMIT.getValue() || code == (long)ERet.kRetErrPermissionDenied.getValue()) {
                        callBack.onNoPermissionError(cid);
                    } else if (code == (long)ECode.STILL_IN_CHANNEL.getValue() || code == (long)ECode.NOT_IN_CHANNEL.getValue()) {
                        callBack.onFailByAlreadyIsThisRole(cid);
                    } else if (code == (long)ECode.ALREADY_HAS_FAMILY.getValue()) {
                        callBack.onHaveJoinedFamily(cid);
                    } else if (code == (long)ECode.FAMILY_JOIN_APPLY_NOT_CONDITION.getValue()) {
                        callBack.onFailByJoinedLvLimit(cid);
                    } else if (callBack != null) {
                        callBack.onError(cid, 102, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    }
                    MLog.error((Object)RoleRequestManager.TAG, (String)"setRole error, cid:%s,uid:%s,code:%d,errortips:%s", (Object[])new Object[]{cid, String.valueOf(uid), code, !message.result.__isDefaultInstance() ? message.result.errmsg : ""});
                    BaseRequestManager.statMetric((String)"channel/setrole", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(cid, 100, "", new Exception("Time out!"));
                        }
                        MLog.error((Object)RoleRequestManager.TAG, (String)"setRole error, cid:%s,code:%s", (Object[])new Object[]{cid, "Time out!"});
                        BaseRequestManager.statMetric((String)"channel/setrole", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)RoleRequestManager.TAG, (String)"setRole netError cid:%s,code:%d, reason:%s!", (Object[])new Object[]{cid, code, reason});
                        if (callBack != null) {
                            callBack.onError(cid, 100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        }
                        BaseRequestManager.statMetric((String)"channel/setrole", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void acceptRole(final String cid, final String inviteId, boolean accept, final IRoleService.IAcceptRoleInviteCallBack callBack) {
        AcceptRoleReq req = new AcceptRoleReq.Builder().accept(Boolean.valueOf(accept)).set_id(inviteId).build();
        MLog.info((Object)TAG, (String)"AcceptRole cid:%s, inviteId:%s", (Object[])new Object[]{cid, inviteId});
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<AcceptRoleRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable AcceptRoleRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Role error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull AcceptRoleRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    ChannelMember channelMember = message.member;
                    ChannelUser user = BaseRequestManager.obtainChannelUser((ChannelMember)channelMember);
                    if (callBack != null) {
                        callBack.onSuccess(cid, user);
                    }
                    MLog.info((Object)RoleRequestManager.TAG, (String)"AcceptRole success, cid:%s,inviteid:%s,User:%s", (Object[])new Object[]{cid, inviteId, user});
                    BaseRequestManager.statMetric((String)"channel/acceptrole", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (callBack != null) {
                    if (code == (long)ECode.ROLE_NUM_LIMIT.getValue()) {
                        callBack.onFailByMemberReachLimit(cid, inviteId);
                    } else if (code == (long)ECode.JOIN_NUM_LIMIT.getValue()) {
                        callBack.onFailByJoinedChannelLimit(cid, inviteId);
                    } else if (code == (long)ECode.ALREADY_CHANGED.getValue()) {
                        callBack.onInviteAlreadyInvalidError(cid, inviteId);
                    } else if (code == (long)ECode.STILL_IN_CHANNEL.getValue()) {
                        callBack.onAlreadyJoined(cid, inviteId);
                    } else if (code == (long)ECode.CHANNEL_NOT_EXISTS.getValue()) {
                        callBack.onChannelNoExit(cid, code);
                    } else if (code == (long)ECode.CHANNEL_BANNED.getValue()) {
                        callBack.onChannelBanned(cid, code);
                    } else if (code == (long)ECode.JOIN_BAN_FOREVER.getValue()) {
                        callBack.onChannelJoinBanForever(cid, code);
                    } else if (code == (long)ECode.NOT_IN_CHANNEL.getValue()) {
                        callBack.onNotInChannel(cid, code);
                    } else if (code == (long)ECode.OTHER_REJECTED.getValue()) {
                        callBack.onOtherRejected(cid, code);
                    } else if (code == (long)ECode.JOIN_FAMILY_FROZE.getValue()) {
                        callBack.onFailByJoinedFrozeLimit(cid, message.leave_family_froze.intValue());
                    } else if (code == (long)ECode.NO_ARROW.getValue()) {
                        callBack.onNoArrow(cid, code);
                    } else {
                        callBack.onError(cid, 102, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    }
                    MLog.error((Object)RoleRequestManager.TAG, (String)"AcceptRole error, cid:%s,inviteId:%s,code:%s", (Object[])new Object[]{cid, inviteId, code});
                    BaseRequestManager.statMetric((String)"channel/acceptrole", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(cid, 100, "", new Exception("Time out!"));
                        }
                        MLog.error((Object)RoleRequestManager.TAG, (String)"AcceptRole error, cid:%s,inviteId:%s,code:%s", (Object[])new Object[]{cid, inviteId, "Time out!"});
                        BaseRequestManager.statMetric((String)"channel/acceptrole", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)RoleRequestManager.TAG, (String)"AcceptRole netError cid:%s, code:%d, reason:%s!", (Object[])new Object[]{cid, code, reason});
                        if (callBack != null) {
                            callBack.onError(cid, 100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        }
                        BaseRequestManager.statMetric((String)"channel/acceptrole", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void setRoles(final String cid, HashMap<Long, Integer> uidAndRoles, String joinFrom, final IRoleService.ISetRolesCallBack callBack) {
        final Set<Long> keys = uidAndRoles.keySet();
        ArrayList<SetRoleReq> reqs = new ArrayList<SetRoleReq>(keys.size());
        for (Long uid : keys) {
            SetRoleReq req = new SetRoleReq.Builder().cid(cid).uid(uid).role(uidAndRoles.get(uid)).source(joinFrom).build();
            reqs.add(req);
        }
        BatchSetRoleReq batchSetRoleReq = new BatchSetRoleReq.Builder().set_role_reqs(reqs).build();
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)"setRoles cid:%s, source:%s, uidAndRoles:%s", (Object[])new Object[]{cid, joinFrom, uidAndRoles.toString()});
        } else {
            MLog.info((Object)TAG, (String)"setRoles cid:%s, source:%s, uidAndRoles size:%d", (Object[])new Object[]{cid, joinFrom, uidAndRoles.size()});
        }
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)batchSetRoleReq, (IProtoCallback)new IProtoCallback<BatchSetRoleRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable BatchSetRoleRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Role error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull BatchSetRoleRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    List ress = message.set_role_ress;
                    if ((ress == null || ress.size() != keys.size()) && RuntimeContext.sIsDebuggable) {
                        throw new RuntimeException("return data size not match request!");
                    }
                    HashMap<Long, IRoleService.SetRoleRes> results = new HashMap<Long, IRoleService.SetRoleRes>(keys.size());
                    int index = 0;
                    for (Long key : keys) {
                        IRoleService.SetRoleRes setRoleRes = new IRoleService.SetRoleRes();
                        SetRoleRes messageItem = (SetRoleRes)ress.get(index);
                        if (messageItem != null) {
                            long itemCode = messageItem.result != null ? messageItem.result.errcode : -1L;
                            setRoleRes.success = ProtoManager.isSuccessCode((long)itemCode);
                            if (setRoleRes.success) {
                                setRoleRes.waitForAccept = StringUtils.isNotEmpty((String)messageItem.set_id);
                            } else {
                                setRoleRes.errorCode = itemCode;
                            }
                        }
                        setRoleRes.uid = key;
                        ++index;
                        results.put(key, setRoleRes);
                    }
                    if (callBack != null) {
                        callBack.onSuccess(cid, results);
                    }
                    MLog.info((Object)RoleRequestManager.TAG, (String)"setRoles success, cid:%s,uids length:%d,", (Object[])new Object[]{cid, keys.size()});
                    BaseRequestManager.statMetric((String)"channel/setroles", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (code == (long)ECode.ALREADY_HAS_FAMILY.getValue()) {
                    if (callBack != null) {
                        callBack.onHaveJoinedFamily(cid);
                    }
                } else if (code == (long)ECode.FAMILY_JOIN_APPLY_NOT_CONDITION.getValue()) {
                    if (callBack != null) {
                        callBack.onFailByJoinedLvLimit(cid);
                    }
                } else if (callBack != null) {
                    MLog.error((Object)RoleRequestManager.TAG, (String)"setRole error, cid:%s,uids length:%d,code:%d,errortips:%s", (Object[])new Object[]{cid, keys.size(), code, !message.result.__isDefaultInstance() ? message.result.errmsg : ""});
                    BaseRequestManager.statMetric((String)"channel/setroles", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(cid, 100, "", new Exception("Time out!"));
                        }
                        MLog.error((Object)RoleRequestManager.TAG, (String)"setRole error, cid:%s,code:%s", (Object[])new Object[]{cid, "Time out!"});
                        BaseRequestManager.statMetric((String)"channel/setroles", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)RoleRequestManager.TAG, (String)"setRole netError cid:%s,code:%d, reason:%s!", (Object[])new Object[]{cid, code, reason});
                        if (callBack != null) {
                            callBack.onError(cid, 100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        }
                        BaseRequestManager.statMetric((String)"channel/setroles", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void kickOff(String gid, long uid, IChannel.IKickOffCallBack callBack) {
        this.kickOff(gid, uid, "", true, callBack);
    }

    public void kickOff(final String gid, final long uid, String reason, boolean onlyThisChannel, final IChannel.IKickOffCallBack callBack) {
        KickOffReq req = new KickOffReq.Builder().cid(gid).uid(Long.valueOf(uid)).build();
        MLog.info((Object)TAG, (String)"kickOff cid:%s, uid:%s, reason:%s, onlyThis:%d", (Object[])new Object[]{gid, String.valueOf(uid), reason, String.valueOf(onlyThisChannel)});
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(gid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<KickOffRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable KickOffRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Role error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull KickOffRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    if (callBack != null) {
                        callBack.onSuccess(gid, uid, -1L);
                    }
                    MLog.info((Object)RoleRequestManager.TAG, (String)"kickOff cid:%s, uid:%s success!", (Object[])new Object[]{gid, String.valueOf(uid)});
                    BaseRequestManager.statMetric((String)"channel/kickoff", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (code == 1820L) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_high_pay_level_kickoff, (int)0);
                } else if (callBack != null) {
                    if (callBack != null) {
                        callBack.onError(102, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    }
                    MLog.error((Object)RoleRequestManager.TAG, (String)"kickoff error code:%d,errortips:%s", (Object[])new Object[]{code, !message.result.__isDefaultInstance() ? message.result.errmsg : ""});
                    BaseRequestManager.statMetric((String)"channel/kickoff", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(100, "", new Exception("Time out!"));
                        }
                        MLog.error((Object)RoleRequestManager.TAG, (String)"kickoff error Timeout!", (Object[])new Object[0]);
                        BaseRequestManager.statMetric((String)"channel/kickoff", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)RoleRequestManager.TAG, (String)"kickoff netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        if (callBack != null) {
                            callBack.onError(100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        }
                        BaseRequestManager.statMetric((String)"channel/kickoff", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void getAllMembers(final String gid, final long ver, final BaseRequestManager.IGetAllMembersCallBack callBack) {
        if (YYTaskExecutor.isMainThread()) {
            this.getAllMembersInner(gid, ver, callBack);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    RoleRequestManager.this.getAllMembersInner(gid, ver, callBack);
                }
            });
        }
    }

    private void notifyGetGroupInfoAndMembersCallBack(String gid, long ver, List<ChannelMember> members, List<OnlineStatus> status) {
        List<BaseRequestManager.IGetAllMembersCallBack> callBacks = this.syncGroupInfoDuplicater.getCallBacks();
        if (callBacks != null && callBacks.size() > 0) {
            for (BaseRequestManager.IGetAllMembersCallBack callBack : callBacks) {
                callBack.onSuccess(gid, ver, members, status);
            }
        }
    }

    private void notifyGetGroupInfoAndMembersNotGroupCallBack(String gid, int errorCode) {
        List<BaseRequestManager.IGetAllMembersCallBack> callBacks = this.syncGroupInfoDuplicater.getCallBacks();
        if (callBacks != null && callBacks.size() > 0) {
            for (BaseRequestManager.IGetAllMembersCallBack callBack : callBacks) {
                callBack.onTopGroupNotExist(gid, errorCode);
            }
        }
    }

    private void notifyGetGroupInfoAndMembersCallBack(String gid, int errorCode, String errorTips, Exception e) {
        List<BaseRequestManager.IGetAllMembersCallBack> callBacks = this.syncGroupInfoDuplicater.getCallBacks();
        if (callBacks != null && callBacks.size() > 0) {
            for (BaseRequestManager.IGetAllMembersCallBack callBack : callBacks) {
                callBack.onError(gid, errorCode, errorTips, e);
            }
        }
    }

    private ChannelMember obtainSeletor() {
        ChannelUser channelUser = new ChannelUser();
        channelUser.roleType = 1;
        channelUser.source = 1;
        channelUser.remark = "1";
        channelUser.inviter = 1L;
        channelUser.uid = 1L;
        channelUser.time = 1L;
        channelUser.msgReceiveMode = 1;
        channelUser.title = 0;
        return RoleRequestManager.obtainSeletor((ChannelUser)channelUser);
    }

    private void getAllMembersInner(final String gid, long ver, final BaseRequestManager.IGetAllMembersCallBack callBack) {
        if (this.syncGroupInfoDuplicater == null) {
            this.syncGroupInfoDuplicater = new RequestPreventDuplicater();
        }
        if (this.syncGroupInfoDuplicater.isStarted()) {
            this.syncGroupInfoDuplicater.addCallBack(callBack);
            return;
        }
        this.syncGroupInfoDuplicater.onStart(callBack);
        MLog.info((Object)TAG, (String)"getAllMembers cid:%s, ver:%s", (Object[])new Object[]{gid, String.valueOf(ver)});
        ProtoManager.Page page = new ProtoManager.Page();
        page.offset = -1L;
        page.limit = -1L;
        page.snap = 0L;
        GetMemberListReq req = new GetMemberListReq.Builder().cid(gid).ver(Long.valueOf(0L)).selector(this.obtainSeletor()).page(ProtoManager.obtainPage((ProtoManager.Page)page)).role(Integer.valueOf(0)).ret_status(new RetStatus(Boolean.valueOf(true))).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(gid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetMemberListRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable GetMemberListRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Role error, use old result!");
                }
                RoleRequestManager.this.syncGroupInfoDuplicater.onFinish();
            }

            @UiThread
            public void onResponse(@NonNull GetMemberListRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    long newVer = message.ver;
                    List members = message.members;
                    RoleRequestManager.this.notifyGetGroupInfoAndMembersCallBack(gid, newVer, members, message.party_status);
                    MLog.info((Object)RoleRequestManager.TAG, (String)"getAllMembers success cid:%s, ver:%s", (Object[])new Object[]{gid, String.valueOf(newVer)});
                    BaseRequestManager.statMetric((String)"channel/getrole", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (callBack != null) {
                    if (code == (long)ECode.CHANNEL_NOT_EXISTS.getValue()) {
                        RoleRequestManager.this.notifyGetGroupInfoAndMembersNotGroupCallBack(gid, 1011);
                    } else if (callBack != null) {
                        RoleRequestManager.this.notifyGetGroupInfoAndMembersCallBack(gid, 102, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    }
                    MLog.error((Object)RoleRequestManager.TAG, (String)"getAllMembers error code:%d,errortips:%s", (Object[])new Object[]{code, !message.result.__isDefaultInstance() ? message.result.errmsg : ""});
                    BaseRequestManager.statMetric((String)"channel/getrole", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
                RoleRequestManager.this.syncGroupInfoDuplicater.onFinish();
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RoleRequestManager.this.notifyGetGroupInfoAndMembersCallBack(gid, 100, "", new Exception("Time out!"));
                        MLog.error((Object)RoleRequestManager.TAG, (String)"getAllMembers Timeout!", (Object[])new Object[0]);
                        RoleRequestManager.this.syncGroupInfoDuplicater.onFinish();
                        BaseRequestManager.statMetric((String)"channel/getrole", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)RoleRequestManager.TAG, (String)"getAllMembers netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        RoleRequestManager.this.notifyGetGroupInfoAndMembersCallBack(gid, 100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        RoleRequestManager.this.syncGroupInfoDuplicater.onFinish();
                        BaseRequestManager.statMetric((String)"channel/getrole", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void setBanned(String gid, long uid, long banTime, BaseRequestManager.IRequestCallBack callBack) {
        this.setBanned(gid, uid, true, banTime, callBack);
    }

    public void setBanned(final String gid, final long uid, boolean onlyThisChannel, long banTime, final BaseRequestManager.IRequestCallBack callBack) {
        MLog.info((Object)TAG, (String)"setBanned cid:%s, uid:%s", (Object[])new Object[]{gid, String.valueOf(uid)});
        BannedReq req = new BannedReq.Builder().cid(gid).only_this(Boolean.valueOf(onlyThisChannel)).uid(Long.valueOf(uid)).time(Long.valueOf(banTime)).banned(Boolean.valueOf(banTime > 0L)).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(gid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<BannedRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable BannedRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Role error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull BannedRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                    MLog.info((Object)RoleRequestManager.TAG, (String)"setBanned success cid:%s, uid:%s", (Object[])new Object[]{gid, String.valueOf(uid)});
                    BaseRequestManager.statMetric((String)"channel/banned", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (code == 1820L) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_high_pay_level_banned, (int)0);
                } else if (callBack != null) {
                    if (code == 3L || code == (long)ECode.NO_PERMIT.getValue()) {
                        callBack.onFailUnauthorized();
                    } else if (callBack != null) {
                        callBack.onError(102, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    }
                    MLog.error((Object)RoleRequestManager.TAG, (String)"setBanned error code:%d,errortips:%s", (Object[])new Object[]{code, !message.result.__isDefaultInstance() ? message.result.errmsg : ""});
                    BaseRequestManager.statMetric((String)"channel/banned", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(100, "", new Exception("Time out!"));
                        }
                        MLog.error((Object)RoleRequestManager.TAG, (String)"setBanned error Timeout!", (Object[])new Object[0]);
                        BaseRequestManager.statMetric((String)"channel/banned", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        }
                        MLog.error((Object)RoleRequestManager.TAG, (String)"setBanned netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        BaseRequestManager.statMetric((String)"channel/banned", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void getChannelOnlineUserWithStatusList(final String gid, final ProtoManager.Page page, final BaseRequestManager.IGetUserListWithWithStatusCallBack callBack) {
        MLog.info((Object)TAG, (String)"getChannelOnlineUserWithStatusList gid:%s,page:%s", (Object[])new Object[]{gid, page});
        GetPartyOnlinesWithStatusReq req = new GetPartyOnlinesWithStatusReq.Builder().cid(gid).page(ProtoManager.obtainPage((ProtoManager.Page)page)).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(gid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetPartyOnlinesWithStatusRes>(){

            @UiThread
            public void onResponse(@NonNull GetPartyOnlinesWithStatusRes message, long code, String msg) {
                if (callBack == null) {
                    return;
                }
                if (ProtoManager.isSuccessCode((long)code)) {
                    ProtoManager.Page pageResult = ProtoManager.obtainPage((Page)message.page);
                    OnlineWithStatusInfo onlineInfo = new OnlineWithStatusInfo();
                    if (pageResult.total <= 0L) {
                        pageResult.total = message.in_group.size() + message.in_hago.size();
                    }
                    onlineInfo.setOnlineTotalNum(pageResult.total);
                    onlineInfo.setOnline(message.in_hago);
                    onlineInfo.setParty(message.in_group);
                    onlineInfo.setAll(message.members);
                    callBack.onSuccess(onlineInfo, page, pageResult);
                    BaseRequestManager.statMetric((String)"channel/channelonlinel", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                    if (!RuntimeContext.sIsDebuggable) {
                        MLog.info((Object)RoleRequestManager.TAG, (String)"getChannelOnlineUserWithStatusList success gid:%s!", (Object[])new Object[]{gid});
                    } else {
                        MLog.info((Object)RoleRequestManager.TAG, (String)"getChannelOnlineUserWithStatusList success gid:%s,page:%s,onlineInfo:%s!", (Object[])new Object[]{gid, pageResult.toString(), onlineInfo.toString()});
                    }
                } else {
                    MLog.error((Object)RoleRequestManager.TAG, (String)"getChannelOnlineUserWithStatusList error code:%d,errortips:%s", (Object[])new Object[]{code, !message.result.__isDefaultInstance() ? message.result.errmsg : ""});
                    callBack.onError(102, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    BaseRequestManager.statMetric((String)"channel/channelonlinel", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack == null) {
                            return;
                        }
                        MLog.error((Object)RoleRequestManager.TAG, (String)"getChannelOnlineUserList TimeOut!", (Object[])new Object[0]);
                        callBack.onError(100, "", new Exception("Time out!"));
                        BaseRequestManager.statMetric((String)"channel/channelonlinel", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack == null) {
                            return;
                        }
                        MLog.error((Object)RoleRequestManager.TAG, (String)"getChannelOnlineUserWithStatusList netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        callBack.onError(100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        BaseRequestManager.statMetric((String)"channel/channelonlinel", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void getChannelOnlineUserList(final String gid, final ProtoManager.Page page, final BaseRequestManager.IGetUserListWithTotalCallBack callBack) {
        MLog.info((Object)TAG, (String)"getChannelOnlineUserList gid:%s,page:%s", (Object[])new Object[]{gid, page});
        GetPartyOnlinesReq req = new GetPartyOnlinesReq.Builder().cid(gid).page(ProtoManager.obtainPage((ProtoManager.Page)page)).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(gid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetPartyOnlinesRes>(){

            @UiThread
            public void onResponse(@NonNull GetPartyOnlinesRes message, long code, String msg) {
                if (callBack == null) {
                    return;
                }
                if (ProtoManager.isSuccessCode((long)code)) {
                    ProtoManager.Page pageResult = ProtoManager.obtainPage((Page)message.page);
                    OnlineInfo onlineInfo = new OnlineInfo();
                    if (pageResult != null && pageResult.total <= 0L) {
                        pageResult.total = message.uids.size();
                        onlineInfo.setOnlineTotalNum((long)message.uids.size());
                    } else {
                        onlineInfo.setOnlineTotalNum(pageResult.total);
                    }
                    onlineInfo.setOnlineUids(message.uids);
                    callBack.onSuccess(onlineInfo, page, pageResult);
                    BaseRequestManager.statMetric((String)"channel/channelonlinel", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                    if (!RuntimeContext.sIsDebuggable) {
                        MLog.info((Object)RoleRequestManager.TAG, (String)"getChannelOnlineUserList success gid:%s!", (Object[])new Object[]{gid});
                    } else {
                        MLog.info((Object)RoleRequestManager.TAG, (String)"getChannelOnlineUserList success gid:%s,page:%s,onlineInfo:%s!", (Object[])new Object[]{gid, pageResult.toString(), onlineInfo.toString()});
                    }
                } else {
                    MLog.error((Object)RoleRequestManager.TAG, (String)"getChannelOnlineUserList error code:%d,errortips:%s", (Object[])new Object[]{code, !message.result.__isDefaultInstance() ? message.result.errmsg : ""});
                    callBack.onError(102, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    BaseRequestManager.statMetric((String)"channel/channelonlinel", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack == null) {
                            return;
                        }
                        MLog.error((Object)RoleRequestManager.TAG, (String)"getChannelOnlineUserList TimeOut!", (Object[])new Object[0]);
                        callBack.onError(100, "", new Exception("Time out!"));
                        BaseRequestManager.statMetric((String)"channel/channelonlinel", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack == null) {
                            return;
                        }
                        MLog.error((Object)RoleRequestManager.TAG, (String)"getChannelOnlineUserList netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        callBack.onError(100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        BaseRequestManager.statMetric((String)"channel/channelonlinel", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void getOnlineUserList(final String gid, final ProtoManager.Page page, boolean onlyPotential, final BaseRequestManager.IGetUserListWithTotalCallBack callBack) {
        MLog.info((Object)TAG, (String)"getOnlineUserList gid:%s,page:%s", (Object[])new Object[]{gid, page});
        GetOnlinesReq req = new GetOnlinesReq.Builder().cid(gid).page(ProtoManager.obtainPage((ProtoManager.Page)page)).only_potential(Boolean.valueOf(onlyPotential)).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(gid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetOnlinesRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable GetOnlinesRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Role error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull GetOnlinesRes message, long code, String msg) {
                if (callBack == null) {
                    return;
                }
                if (ProtoManager.isSuccessCode((long)code)) {
                    ProtoManager.Page pageResult = ProtoManager.obtainPage((Page)message.page);
                    OnlineInfo onlineInfo = new OnlineInfo();
                    if (pageResult != null && pageResult.total <= 0L) {
                        pageResult.total = message.uids.size();
                        onlineInfo.setOnlineTotalNum((long)message.uids.size());
                    } else {
                        onlineInfo.setOnlineTotalNum(pageResult.total);
                    }
                    onlineInfo.setVipUids(message.vip_uids);
                    onlineInfo.setOnlineUids(message.uids);
                    onlineInfo.setWearingsMap(message.uid_wears);
                    onlineInfo.setUserCardMap(message.uid_cards);
                    onlineInfo.setPotentialMap(message.uid_comer_flags);
                    callBack.onSuccess(onlineInfo, page, pageResult);
                    BaseRequestManager.statMetric((String)"channel/onlinel", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                    if (!RuntimeContext.sIsDebuggable) {
                        MLog.info((Object)RoleRequestManager.TAG, (String)"getOnlineUserList success gid:%s!, size=%d", (Object[])new Object[]{gid, message.uids.size()});
                    } else {
                        MLog.info((Object)RoleRequestManager.TAG, (String)"getOnlineUserList success gid:%s,page:%s,onlineInfo:%s!", (Object[])new Object[]{gid, pageResult.toString(), onlineInfo.toString()});
                    }
                } else {
                    MLog.error((Object)RoleRequestManager.TAG, (String)"getOnlineUserList error code:%d,errortips:%s", (Object[])new Object[]{code, !message.result.__isDefaultInstance() ? message.result.errmsg : ""});
                    callBack.onError(102, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    BaseRequestManager.statMetric((String)"channel/onlinel", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack == null) {
                            return;
                        }
                        MLog.error((Object)RoleRequestManager.TAG, (String)"getOnlineUserList TimeOut!", (Object[])new Object[0]);
                        callBack.onError(100, "", new Exception("Time out!"));
                        BaseRequestManager.statMetric((String)"channel/onlinel", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack == null) {
                            return;
                        }
                        MLog.error((Object)RoleRequestManager.TAG, (String)"getOnlineUserList netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        callBack.onError(100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        BaseRequestManager.statMetric((String)"channel/onlinel", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBanned(final String gid, final long uid, final BaseRequestManager.IIsBannedCallBack callBack) {
        Class<RoleRequestManager> clazz = RoleRequestManager.class;
        synchronized (RoleRequestManager.class) {
            if (StringUtils.equal((String)gid, (String)this.lastRquestBannedStatuGid) && uid == this.lastRquestBannedStatuUid && this.lastBannedStatusData != null && SystemClock.elapsedRealtime() - this.lastRquestBannedStatuTime < 2000L) {
                final BannedStatus status = this.lastBannedStatusData;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.banned(gid, uid, status.BanTime.longValue(), status.BanLeftTime.longValue());
                        }
                    }
                });
                MLog.info((Object)TAG, (String)"GetBannedStatus \u547d\u4e2d\u7f13\u5b58 cid:%s,uid:%s", (Object[])new Object[]{gid, String.valueOf(uid)});
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            MLog.info((Object)TAG, (String)"GetBannedStatus cid:%s,uid:%s", (Object[])new Object[]{gid, String.valueOf(uid)});
            ArrayList<Long> uids = new ArrayList<Long>();
            uids.add(uid);
            GetBannedStatusReq req = new GetBannedStatusReq.Builder().cid(gid).uids(uids).build();
            final long startTime = SystemClock.uptimeMillis();
            ProtoManager.getInstance().sendRpc(gid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetBannedStatusRes>(){

                @Deprecated
                @UiThread
                public void onResponse(@Nullable GetBannedStatusRes message) {
                    if (RuntimeContext.sIsDebuggable) {
                        throw new RuntimeException("ChannelRequest_Role error, use old result!");
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @UiThread
                public void onResponse(@NonNull GetBannedStatusRes message, long code, String msg) {
                    if (ProtoManager.isSuccessCode((long)code)) {
                        BannedStatus status;
                        List statuses = message.list;
                        if (statuses != null && statuses.size() > 0 && (status = (BannedStatus)statuses.get(0)) != null && status.uid == uid) {
                            if (callBack != null) {
                                callBack.banned(gid, uid, status.BanTime.longValue(), status.BanLeftTime.longValue());
                            }
                            MLog.info((Object)RoleRequestManager.TAG, (String)"GetBannedStatus success cid:%s,uid:%s, banned left time:%d , banned time:%d", (Object[])new Object[]{gid, String.valueOf(uid), status.BanLeftTime, status.BanTime});
                            Class<RoleRequestManager> clazz = RoleRequestManager.class;
                            // MONITORENTER : com.yy.hiyo.channel.service.request.role.RoleRequestManager.class
                            RoleRequestManager.this.lastBannedStatusData = status;
                            RoleRequestManager.this.lastRquestBannedStatuGid = gid;
                            RoleRequestManager.this.lastRquestBannedStatuUid = uid;
                            RoleRequestManager.this.lastRquestBannedStatuTime = SystemClock.elapsedRealtime();
                            // MONITOREXIT : clazz
                        }
                        BaseRequestManager.statMetric((String)"channel/banned", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)-1L);
                        return;
                    }
                    BaseRequestManager.statMetric((String)"channel/banned", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    MLog.error((Object)RoleRequestManager.TAG, (String)"GetBannedStatus error code:%d,errortips:%s", (Object[])new Object[]{code, !message.result.__isDefaultInstance() ? message.result.errmsg : ""});
                    if (callBack == null) return;
                    callBack.onError(gid, (int)code, "", null);
                }

                public boolean retryWhenTimeout(boolean canRetry) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MLog.error((Object)RoleRequestManager.TAG, (String)"GetBannedStatus error TimeOut!", (Object[])new Object[0]);
                            if (callBack != null) {
                                callBack.onError(gid, 100, "", new Exception("Time out!"));
                            }
                            BaseRequestManager.statMetric((String)"channel/banned", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                        }
                    });
                    return false;
                }

                public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MLog.error((Object)RoleRequestManager.TAG, (String)"GetBannedStatus netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                            if (callBack != null) {
                                callBack.onError(gid, 100, "", new Exception("Time out!"));
                            }
                            BaseRequestManager.statMetric((String)"channel/banned", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                        }
                    });
                    return false;
                }
            });
            return;
        }
    }

    public static void getCurrentChannels(boolean includePrivate, boolean onlyMember, List<Long> uids, IRoleService.IQueryUsersInChannelCallBack callBack) {
        RoleRequestManager.getCurrentChannels(includePrivate, onlyMember, false, uids, callBack);
    }

    public static void getCurrentChannels(boolean includePrivate, boolean onlyMember, boolean retOnline, final List<Long> uids, final IRoleService.IQueryUsersInChannelCallBack callBack) {
        MLog.info((Object)TAG, (String)"geetCurrentChannels uids:%s", (Object[])new Object[]{String.valueOf(uids.size())});
        GetCurrentChannelsReq req = new GetCurrentChannelsReq.Builder().uids(uids).only_public(Boolean.valueOf(!includePrivate)).only_member(Boolean.valueOf(onlyMember)).only_room(Boolean.valueOf(RuntimeContext.isHagoPartySdk())).ret_online(Boolean.valueOf(retOnline)).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetCurrentChannelsRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable GetCurrentChannelsRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Role error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull GetCurrentChannelsRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    HashMap inChannelMap;
                    block10: {
                        List channelIds = message.rids;
                        inChannelMap = new HashMap(uids.size());
                        if (channelIds != null && channelIds.size() > 0) {
                            try {
                                int index = 0;
                                for (Long uid : uids) {
                                    inChannelMap.put(uid, channelIds.get(index));
                                    ++index;
                                }
                            }
                            catch (Exception e) {
                                if (!RuntimeContext.sIsDebuggable) break block10;
                                throw new RuntimeException("getCurrentChannels return data error:uids size:" + uids.size() + " data size:" + channelIds.size());
                            }
                        }
                    }
                    if (callBack != null) {
                        callBack.onSuccess(inChannelMap);
                        callBack.onSuccess(inChannelMap, message.onlines);
                    }
                    if (!RuntimeContext.sIsDebuggable) {
                        MLog.info((Object)RoleRequestManager.TAG, (String)"getCurrentChannels success inChannelMap size:%d", (Object[])new Object[]{inChannelMap.size()});
                    } else {
                        MLog.info((Object)RoleRequestManager.TAG, (String)"getCurrentChannels success inChannelMap size:%s", (Object[])new Object[]{inChannelMap.toString()});
                    }
                    BaseRequestManager.statMetric((String)"channel/getCurrent", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)-1L);
                } else {
                    BaseRequestManager.statMetric((String)"channel/getCurrent", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    MLog.error((Object)RoleRequestManager.TAG, (String)"getCurrentChannels error code:%d,errortips:%s", (Object[])new Object[]{code, msg});
                    if (callBack != null) {
                        callBack.onError((int)code, "", (Exception)new IllegalStateException("getCurrentChannels error"));
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)RoleRequestManager.TAG, (String)"getCurrentChannels error TimeOut!", (Object[])new Object[0]);
                        if (callBack != null) {
                            callBack.onError(100, "", new Exception("Time out!"));
                        }
                        BaseRequestManager.statMetric((String)"channel/getCurrent", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)RoleRequestManager.TAG, (String)"getCurrentChannels netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        if (callBack != null) {
                            callBack.onError(100, "", new Exception("Time out!"));
                        }
                        BaseRequestManager.statMetric((String)"channel/getCurrent", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }
}

