/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.request.msg;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.squareup.wire.AndroidMessage;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.TimeUtils;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.service.request.RequestPreventDuplicater;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import java.util.ArrayList;
import java.util.List;
import net.ihago.channel.srv.mgr.GetMsgUnreadReq;
import net.ihago.channel.srv.mgr.GetMsgUnreadRes;
import net.ihago.channel.srv.mgr.MsgUnread;

public class MsgRequestManager
extends BaseRequestManager {
    private static final String TAG = "ChannelRequest_Msg";
    private RequestPreventDuplicater<IUnreadMsgRequestCallBack> myGetUnReadDuplicater;

    private void notifyGetUnreadNumsCallBack(ArrayList<UnreadMsgItem> result) {
        List<IUnreadMsgRequestCallBack> callBacks = this.myGetUnReadDuplicater.getCallBacks();
        if (callBacks != null && callBacks.size() > 0) {
            for (IUnreadMsgRequestCallBack callBack : callBacks) {
                callBack.onSuccess(result);
            }
        }
    }

    private void notifyGetUnreadNumsCallBack(int errorCode, String tips) {
        List<IUnreadMsgRequestCallBack> callBacks = this.myGetUnReadDuplicater.getCallBacks();
        if (callBacks != null && callBacks.size() > 0) {
            for (IUnreadMsgRequestCallBack callBack : callBacks) {
                callBack.onError(errorCode, tips);
            }
        }
    }

    public void getUnreadMsgNum(ArrayList<UnreadMsgRequestItem> requestItems, final IUnreadMsgRequestCallBack callBack) {
        if (this.myGetUnReadDuplicater == null) {
            this.myGetUnReadDuplicater = new RequestPreventDuplicater();
        }
        if (this.myGetUnReadDuplicater.isStarted()) {
            this.myGetUnReadDuplicater.addCallBack(callBack);
            return;
        }
        this.myGetUnReadDuplicater.onStart(callBack);
        ArrayList<MsgUnread> msgUnreads = new ArrayList<MsgUnread>();
        long adjustTime = -1L;
        for (UnreadMsgRequestItem item : requestItems) {
            if (item.beforeTime <= 0L && (adjustTime = TimeUtils.getServiceRealTime()) <= 0L) {
                adjustTime = System.currentTimeMillis();
            }
            msgUnreads.add(new MsgUnread.Builder().begin_time(Long.valueOf(item.beforeTime > 0L ? item.beforeTime : adjustTime)).cid(item.cid).build());
        }
        GetMsgUnreadReq req = new GetMsgUnreadReq.Builder().unread(msgUnreads).build();
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)"getUnreadMsgNum data:%s", (Object[])new Object[]{requestItems.toString()});
        } else {
            MLog.info((Object)TAG, (String)"getUnreadMsgNum data length:%d", (Object[])new Object[]{requestItems.size()});
        }
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetMsgUnreadRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable GetMsgUnreadRes message) {
                MsgRequestManager.this.myGetUnReadDuplicater.onFinish();
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Msg error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull GetMsgUnreadRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    List channelMember = message.unread;
                    ArrayList<UnreadMsgItem> msgUnreadItems = new ArrayList<UnreadMsgItem>();
                    if (channelMember != null && channelMember.size() > 0) {
                        for (MsgUnread item : channelMember) {
                            if (item == null) continue;
                            msgUnreadItems.add(UnreadMsgItem.obtain(item));
                        }
                    }
                    MsgRequestManager.this.notifyGetUnreadNumsCallBack(msgUnreadItems);
                    if (RuntimeContext.sIsDebuggable) {
                        MLog.info((Object)MsgRequestManager.TAG, (String)"getUnreadMsgNum success:%s!", (Object[])new Object[]{msgUnreadItems.toString()});
                    } else {
                        MLog.info((Object)MsgRequestManager.TAG, (String)"getUnreadMsgNum success!", (Object[])new Object[0]);
                    }
                    BaseRequestManager.statMetric((String)"channel/getunread", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (callBack != null) {
                    MLog.error((Object)MsgRequestManager.TAG, (String)"getUnreadMsgNum error, code:%d,errortips:%s", (Object[])new Object[]{code, msg});
                    MsgRequestManager.this.notifyGetUnreadNumsCallBack((int)code, msg);
                    BaseRequestManager.statMetric((String)"channel/getunread", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
                MsgRequestManager.this.myGetUnReadDuplicater.onFinish();
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MsgRequestManager.this.notifyGetUnreadNumsCallBack(100, "");
                        MsgRequestManager.this.myGetUnReadDuplicater.onFinish();
                        MLog.error((Object)MsgRequestManager.TAG, (String)"getUnreadMsgNum error,code:%s", (Object[])new Object[]{"Time out!"});
                        BaseRequestManager.statMetric((String)"channel/getunread", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)MsgRequestManager.TAG, (String)"getUnreadMsgNum error, code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        MsgRequestManager.this.notifyGetUnreadNumsCallBack(100, "");
                        MsgRequestManager.this.myGetUnReadDuplicater.onFinish();
                        BaseRequestManager.statMetric((String)"channel/getunread", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public static class UnreadMsgItem {
        public String cid;
        public long beforeTime;
        public long endTime;
        public long unreadNum;
        public long lastestTimestamp;

        public static UnreadMsgItem obtain(MsgUnread item) {
            UnreadMsgItem unreadMsgItem = new UnreadMsgItem();
            unreadMsgItem.beforeTime = item.begin_time;
            unreadMsgItem.endTime = item.end_time;
            unreadMsgItem.unreadNum = item.count;
            unreadMsgItem.cid = item.cid;
            unreadMsgItem.lastestTimestamp = item.latest_timestamp;
            return unreadMsgItem;
        }

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "UnreadMsgItem{cid='" + this.cid + '\'' + ", beforeTime='" + this.beforeTime + '\'' + ", unreadNum='" + this.unreadNum + '\'' + ", endTime='" + this.endTime + '\'' + ", lastestTimestamp='" + this.lastestTimestamp + '\'' + '}';
        }
    }

    public static class UnreadMsgRequestItem {
        public String cid;
        public long beforeTime;

        public UnreadMsgRequestItem(String cid, long beforeTime) {
            this.beforeTime = beforeTime;
            this.cid = cid;
        }

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "UnreadMsgRequestItem{cid='" + this.cid + '\'' + ", beforeTime='" + this.beforeTime + '\'' + '}';
        }
    }

    public static interface IUnreadMsgRequestCallBack {
        public void onSuccess(ArrayList<UnreadMsgItem> var1);

        public void onError(int var1, String var2);
    }
}

