/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.request.join;

import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import biz.CInfo;
import biz.ChannelMember;
import biz.ClientHardware;
import biz.MediaToken;
import biz.PluginInfo;
import biz.SeatUser;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.RadioLiveConfig;
import com.yy.appbase.unifyconfig.config.RadioLiveConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.ChannelNotifyDef;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.EntryInfo;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelBannedData;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelDynamicInfo;
import com.yy.hiyo.channel.base.bean.ChannelLeaveResp;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.LiveCodeRate;
import com.yy.hiyo.channel.base.bean.LiveCodeRateKt;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.hiyo.channel.base.bean.RecommendEnterData;
import com.yy.hiyo.channel.base.bean.RoomlistEventBean;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.module.common.AnchorQualityManager;
import com.yy.hiyo.channel.service.request.RequestPreventDuplicater;
import com.yy.hiyo.channel.service.request.join.WsConnectListenerTask;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.tjgsdk.TjgSDK;
import com.yy.tjgsdk.event.Event;
import com.yy.tjgsdk.event.EventStage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.ihago.channel.srv.mgr.Background;
import net.ihago.channel.srv.mgr.BanInfo;
import net.ihago.channel.srv.mgr.ECode;
import net.ihago.channel.srv.mgr.EnterInfo;
import net.ihago.channel.srv.mgr.EnterReq;
import net.ihago.channel.srv.mgr.EnterRes;
import net.ihago.channel.srv.mgr.GameContext;
import net.ihago.channel.srv.mgr.GetMyFamilyReq;
import net.ihago.channel.srv.mgr.GetMyFamilyRes;
import net.ihago.channel.srv.mgr.GetMyJoinedReq;
import net.ihago.channel.srv.mgr.GetMyJoinedRes;
import net.ihago.channel.srv.mgr.GetUserJoinedReq;
import net.ihago.channel.srv.mgr.GetUserJoinedRes;
import net.ihago.channel.srv.mgr.HiidoInfo;
import net.ihago.channel.srv.mgr.LeaveReq;
import net.ihago.channel.srv.mgr.LeaveRes;
import net.ihago.channel.srv.mgr.MatchInfo;
import net.ihago.channel.srv.mgr.MobileDeviceSpec;
import net.ihago.channel.srv.mgr.ProbeReq;
import net.ihago.channel.srv.mgr.ProbeRes;
import net.ihago.channel.srv.mgr.TransEnterInfo;
import net.ihago.channel.srv.mgr.TranscodeInfo;
import net.ihago.channel.srv.mgr.UserARGift;
import net.ihago.money.api.family.GetFamilyProfileReq;
import net.ihago.money.api.family.GetFamilyProfileRes;
import net.ihago.room.api.rrec.GetUserRecentlyHistoryReq;
import net.ihago.room.api.rrec.GetUserRecentlyHistoryRes;

public class JoinRequestManager
extends BaseRequestManager {
    private static final String TAG = "ChannelRequest_Join";
    private static final int ERROR_TYPE_CANCEL = 99;
    private static WsConnectListenerTask wsConnectListenerTask;
    private static WsConnectListenerTask wsConnectListenerTaskTwo;
    private RequestPreventDuplicater<IChannelCenterService.IGetMyJoinedChannelsCallBack> myJoinPDuplicater;

    public void getMyJoinedGroups(final IChannelCenterService.IGetMyJoinedChannelsCallBack callBack) {
        if (YYTaskExecutor.isMainThread()) {
            this.getMyJoinedGroupsInner(callBack);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    JoinRequestManager.this.getMyJoinedGroupsInner(callBack);
                }
            });
        }
    }

    private void notifyMyJoinedGroupsCallBack(ArrayList<MyJoinChannelItem> groupSummays) {
        List<IChannelCenterService.IGetMyJoinedChannelsCallBack> callBacks = this.myJoinPDuplicater.getCallBacks();
        if (callBacks != null && callBacks.size() > 0) {
            for (IChannelCenterService.IGetMyJoinedChannelsCallBack callBack : callBacks) {
                callBack.onSuccess(groupSummays);
            }
        }
    }

    private void notifyMyJoinedGroupsCallBack(int errorCode, Exception e) {
        List<IChannelCenterService.IGetMyJoinedChannelsCallBack> callBacks = this.myJoinPDuplicater.getCallBacks();
        if (callBacks != null && callBacks.size() > 0) {
            for (IChannelCenterService.IGetMyJoinedChannelsCallBack callBack : callBacks) {
                callBack.onError(errorCode, e);
            }
        }
    }

    public static void findRecentHistoryChannel(String gid, final ICommonCallback<String> callback2) {
        GetUserRecentlyHistoryReq req = new GetUserRecentlyHistoryReq.Builder().gid(gid).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetUserRecentlyHistoryRes>(){

            public void onResponse(@NonNull GetUserRecentlyHistoryRes res, long code, String msgTip) {
                super.onResponse((AndroidMessage)res, code, msgTip);
                String cid = null;
                if (this.isSuccess(code)) {
                    cid = res.cid;
                    if (callback2 != null) {
                        callback2.onSuccess((Object)cid, new Object[0]);
                    }
                } else if (callback2 != null) {
                    callback2.onFail((int)code, msgTip, new Object[0]);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback2 != null) {
                    callback2.onFail(code, reason, new Object[0]);
                }
            }
        });
    }

    private static void onJoinSuccessed(String cid) {
        SettingFlags.setStringValue((String)"lastjoinedcid", (String)cid);
    }

    private static void onLeaveSuccessed(String cid) {
        String lastJoinCid = SettingFlags.getStringValue((String)"lastjoinedcid", (String)"");
        if (StringUtils.equal((String)cid, (String)lastJoinCid)) {
            SettingFlags.setStringValue((String)"lastjoinedcid", (String)"");
        }
    }

    private static void onJoinBaseBroadcastGroupSuccessed(String cid) {
        SettingFlags.setStringValue((String)"lastjoinedbroadcastCid", (String)cid);
    }

    private static void onLeaveBaseBroadcastGroupSuccessed(String cid) {
        String lastJoinCid = SettingFlags.getStringValue((String)"lastjoinedbroadcastCid", (String)"");
        if (StringUtils.equal((String)cid, (String)lastJoinCid)) {
            SettingFlags.setStringValue((String)"lastjoinedbroadcastCid", (String)"");
        }
    }

    public static void leaveLastJoinChannel() {
        String lastJoinCid = SettingFlags.getStringValue((String)"lastjoinedcid", (String)"");
        if (StringUtils.isNotEmpty((String)lastJoinCid)) {
            MLog.info((Object)TAG, (String)"leaveLastJoinChannel:%s", (Object[])new Object[]{lastJoinCid});
            JoinRequestManager.leaveGroup(lastJoinCid, new IChannel.ILeaveCallBack(){

                public void onSuccess(String channelId, ChannelLeaveResp leaveResp) {
                    MLog.info((Object)JoinRequestManager.TAG, (String)"leaveLastJoinChannel success!", (Object[])new Object[0]);
                }

                public void onError(int errorCode, String errorTips, Exception e) {
                    MLog.info((Object)JoinRequestManager.TAG, (String)"leaveLastJoinChannel error!", (Object[])new Object[0]);
                }
            }, false);
        }
    }

    public static void leaveLastJoinBaseBroadCast() {
        String lastJoinCid = SettingFlags.getStringValue((String)"lastjoinedbroadcastCid", (String)"");
        if (StringUtils.isNotEmpty((String)lastJoinCid)) {
            MLog.info((Object)TAG, (String)"leaveLastJoinChannel:%s", (Object[])new Object[]{lastJoinCid});
            JoinRequestManager.leaveGroup(lastJoinCid, new IChannel.ILeaveCallBack(){

                public void onSuccess(String channelId, ChannelLeaveResp leaveResp) {
                    MLog.info((Object)JoinRequestManager.TAG, (String)"leaveLastJoinChannel success!", (Object[])new Object[0]);
                }

                public void onError(int errorCode, String errorTips, Exception e) {
                    MLog.info((Object)JoinRequestManager.TAG, (String)"leaveLastJoinChannel error!", (Object[])new Object[0]);
                }
            }, true);
        }
    }

    public static void joinGroup(EnterParam param2, IChannel.IJoinCallBack callBack) {
        if (ProtoManager.getInstance().isWSConnected()) {
            JoinRequestManager.joinGroupInner(param2, callBack, false);
        } else {
            MLog.warn((Object)TAG, (String)"joinGroup web socket not connect", (Object[])new Object[0]);
            wsConnectListenerTask = new WsConnectListenerTask();
            wsConnectListenerTask.start((Function1<? super Boolean, Unit>)((Function1)isSuccess -> {
                MLog.info((Object)TAG, (String)"web socket connected: %s", (Object[])new Object[]{isSuccess});
                if (isSuccess.booleanValue()) {
                    JoinRequestManager.joinGroupInner(param2, callBack, false);
                } else if (callBack != null) {
                    callBack.onError(param2, 100, ResourceUtils.getString((int)R.string.network_error), (Exception)new IllegalStateException("socket not connected"));
                }
                wsConnectListenerTask = null;
                return null;
            }));
        }
    }

    public static void joinBaseBroadcastGroup(EnterParam param2, IChannel.IJoinCallBack callBack) {
        if (ProtoManager.getInstance().isWSConnected()) {
            JoinRequestManager.joinGroupInner(param2, callBack, true);
        } else {
            MLog.warn((Object)TAG, (String)"joinGroup web socket not connect", (Object[])new Object[0]);
            wsConnectListenerTaskTwo = new WsConnectListenerTask();
            wsConnectListenerTaskTwo.start((Function1<? super Boolean, Unit>)((Function1)isSuccess -> {
                MLog.info((Object)TAG, (String)"web socket connected: %s", (Object[])new Object[]{isSuccess});
                if (isSuccess.booleanValue()) {
                    JoinRequestManager.joinGroupInner(param2, callBack, true);
                } else if (callBack != null) {
                    callBack.onError(param2, 100, ResourceUtils.getString((int)R.string.network_error), (Exception)new IllegalStateException("socket not connected"));
                }
                wsConnectListenerTaskTwo = null;
                return null;
            }));
        }
    }

    public static void joinBaseBroadcastGroupInner(EnterParam param2, IChannel.IJoinCallBack callBack) {
    }

    public static void leaveBaseBroadcastGroup(String cid, IChannel.ILeaveCallBack callBack) {
        JoinRequestManager.leaveGroup(cid, callBack, true);
    }

    private static void joinGroupInner(final EnterParam param2, final IChannel.IJoinCallBack callBack, final boolean voiceToBase) {
        RoomlistEventBean roomlistEventBean = (RoomlistEventBean)param2.getExtra("ROOM_LIST_EVENT", null);
        MLog.info((Object)TAG, (String)"join channel start, requestParams:%s,\n roomlistEventBean:%s", (Object[])new Object[]{param2, roomlistEventBean != null ? roomlistEventBean : ""});
        UserInfoBean userInfoBean = ((IUserInfoService)ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null);
        long iconFrame = ((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).getSelfHeadFrameFromCache();
        RecommendEnterData recommendEnterData = (RecommendEnterData)param2.getExtra("from_recommend_info", null);
        String recommendToken = "";
        if (recommendEnterData != null) {
            recommendToken = recommendEnterData.getToken();
        }
        String dlSource = (String)param2.getExtra("deep_link_source", (Object)"");
        String srcShow = "";
        String srcPush = "";
        String preSource = StringUtils.isNotEmpty((String)param2.preSource) ? param2.preSource : "0";
        EntryInfo entryInfo = param2.entryInfo;
        String firstEntType = "-1";
        String secondEntType = "-1";
        String thirdEntType = "-1";
        if (entryInfo != null) {
            firstEntType = String.valueOf(entryInfo.getFirstEntType().getValue());
            if (entryInfo.getSecondEntType() != null) {
                secondEntType = entryInfo.getSecondEntType();
            }
            if (entryInfo.getThirdEntType() != null) {
                thirdEntType = entryInfo.getThirdEntType();
            }
        }
        MLog.debug((Object)TAG, (String)("testEntryInfo " + firstEntType + ", " + secondEntType + ", " + thirdEntType), (Object[])new Object[0]);
        switch (param2.entry) {
            case 6: 
            case 14: {
                srcPush = preSource;
                break;
            }
            case 13: {
                srcShow = preSource;
                break;
            }
        }
        final EnterReq.Builder builder = new EnterReq.Builder().user_info(JoinRequestManager.obtainUser((UserInfoBean)userInfoBean, (long)iconFrame, (long)param2.matchedUid, (int)EnterParam.JoinChannelFrom.SE_PLATFORM_FIND_GAME, (String)param2.postId, (long)param2.matchedUid, (long)param2.roomGameMatchUid)).source(Integer.valueOf(param2.entry)).selector(JoinRequestManager.obtianSeletorCInfo()).password(param2.password).enter_token(param2.pwdToken).rejoin(Boolean.valueOf(param2.isRejoin)).vip(Integer.valueOf(param2.isVipSeat ? 1 : 0)).card_id(Long.valueOf(param2.cardId)).min_base(Boolean.valueOf(voiceToBase)).show_info(!param2.isRejoin ? param2.showInfo : null).hiido_info(new HiidoInfo.Builder().sid((String)param2.getExtra("JOIN_SESSION", (Object)"")).alg(recommendToken).tab_id(roomlistEventBean != null ? roomlistEventBean.getTabCatId() : "").dl_source(dlSource).act_id(param2.activityId).act_ext(param2.activityExtend).src_push(srcPush).src_show(srcShow).e_a(firstEntType).e_b(secondEntType).e_c(thirdEntType).build());
        MobileDeviceSpec mobileInfo = new MobileDeviceSpec.Builder().cpu(HardwareUtils.getCpuArch()).model(Build.MODEL).android_version(Build.VERSION.RELEASE).ram_size_mb(Integer.valueOf(CommonUtils.getTotalMemory())).build();
        builder.device_spec(mobileInfo);
        MLog.info((Object)TAG, (String)"set mobile info", (Object[])new Object[0]);
        if (TextUtils.isEmpty((CharSequence)param2.roomId) && param2.gameInfo != null) {
            builder.game_id(param2.gameInfo.gid);
        } else {
            builder.cid(param2.roomId);
        }
        if (!param2.isRejoin) {
            List gids;
            MatchInfo.Builder matchBuild = new MatchInfo.Builder();
            matchBuild.been_ktv(Boolean.valueOf(SettingFlags.getBoolean((String)"key_ktv_hasjoin", (boolean)false)));
            long micupSongId = (Long)param2.getExtra("micup_song_id", (Object)0L);
            if (micupSongId > 0L) {
                matchBuild.song_id(Long.valueOf(micupSongId));
            }
            if ((gids = param2.matchGameIds) != null && !gids.isEmpty()) {
                matchBuild.game_ids.addAll(gids);
            }
            builder.match_info(matchBuild.build());
        }
        final long startTime = SystemClock.uptimeMillis();
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).setMiddlewareInfo("");
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ClientHardware.CpuInfo cpuInfo = new ClientHardware.CpuInfo(HardwareUtils.getCpuRealName(), Integer.valueOf(HardwareUtils.getCpuCoreCount()), HardwareUtils.getCpuArch(), Long.valueOf(HardwareUtils.getMinCpuFreq()), Long.valueOf(HardwareUtils.getMaxCpuFreq()));
                int memory = CommonUtils.getTotalMemory();
                ClientHardware hardware = new ClientHardware(cpuInfo, Integer.valueOf(memory), Build.MODEL, Build.MANUFACTURER);
                EnterReq req = builder.hardware(hardware).build();
                ProtoManager.getInstance().sendRpc(StringUtils.notNull((String)param2.roomId), (AndroidMessage)req, (IProtoCallback)new IProtoCallback<EnterRes>(){

                    @Deprecated
                    @UiThread
                    public void onResponse(@Nullable EnterRes message) {
                        if (RuntimeContext.sIsDebuggable) {
                            throw new RuntimeException("ChannelRequest_Join error, use old result!");
                        }
                    }

                    @UiThread
                    public void onResponse(@NonNull EnterRes message, long code, String msgTip) {
                        boolean dataValid = JoinRequestManager.isValid(message);
                        long curTime = SystemClock.uptimeMillis();
                        if (ProtoManager.isSuccessCode((long)code) && dataValid) {
                            ChannelMember memberInThisChannel;
                            BanInfo banInfo;
                            if (StringUtils.isNotEmpty((String)message.middleware_info)) {
                                ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).setMiddlewareInfo(message.middleware_info);
                            }
                            ChannelDetailInfo info = new ChannelDetailInfo();
                            info.baseInfo = BaseRequestManager.obtianChannelInfo((CInfo)message.cinfo);
                            info.dynamicInfo = new ChannelDynamicInfo();
                            info.dynamicInfo.onlines = message.onlines.intValue();
                            info.dynamicInfo.topOnlines = message.top_onlines.intValue();
                            info.dynamicInfo.mCurrentPlayBgUid = message.bg_music_uid;
                            info.dynamicInfo.mBgmPlaying = message.bg_music_uid > 0L;
                            info.dynamicInfo.mIsAllSeatLock = message.all_video_seats_locked;
                            info.baseInfo.showUid = message.show_uid;
                            info.baseInfo.theme = BaseRequestManager.obtianBgInfo((Background)message.background);
                            info.baseInfo.forbidAge = message.forbid_age;
                            info.baseInfo.canWatchRtc = message.radio_rtc;
                            if (!FP.empty((Collection)message.trans_info)) {
                                for (TransEnterInfo transEnterInfo : message.trans_info) {
                                    info.extInfo.transEnterInfo.put(transEnterInfo.key, transEnterInfo.value);
                                }
                            }
                            info.extInfo.assistGameStartMatch = param2.entry == EnterParam.JoinChannelFrom.SE_PARTY_GAME_PAGE_LIST;
                            EnterChannelData data2 = new EnterChannelData();
                            data2.useOldRoomStyle = message.old;
                            data2.isUpgrade = message.upgrade;
                            data2.pluginData = BaseRequestManager.obtainPluginData((PluginInfo)message.plugin_info, (String)"join", (String)info.baseInfo.gid);
                            MLog.error((Object)JoinRequestManager.TAG, (String)"plugin info ext:%s", (Object[])new Object[]{message.plugin_info.ext});
                            data2.enterInfo = BaseRequestManager.obtainEnterInfo((EnterInfo)message.open_game);
                            data2.lightEffect = message.light_affect;
                            GameContext gameContext = message.game_ctx;
                            data2.pluginData.update(gameContext.start.booleanValue(), gameContext.ctx, gameContext.url);
                            data2.mediaToken = BaseRequestManager.obtainMediaTokenInfo((MediaToken)message.media_token);
                            ArrayList<com.yy.hiyo.channel.base.bean.SeatUser> seats = new ArrayList<com.yy.hiyo.channel.base.bean.SeatUser>();
                            List seatUsers = message.seat_users;
                            if (seatUsers != null && seatUsers.size() > 0) {
                                for (SeatUser seatUser : seatUsers) {
                                    com.yy.hiyo.channel.base.bean.SeatUser seat = new com.yy.hiyo.channel.base.bean.SeatUser();
                                    seat.index = seatUser.seat;
                                    if (seat.index <= 0) {
                                        seat.index = 0;
                                    }
                                    seat.uid = seatUser.uid;
                                    seat.status = seatUser.status;
                                    seat.ts = seatUser.ts;
                                    seats.add(seat);
                                }
                                data2.seatList = seats;
                            }
                            if ((banInfo = message.ban_info) != null && banInfo.banned > 0L) {
                                ChannelBannedData bannedData = new ChannelBannedData(info.baseInfo.gid, banInfo.reason.longValue());
                                bannedData.bannedTime = banInfo.banned;
                                data2.bannedData = bannedData;
                            }
                            if ((memberInThisChannel = message.member) != null && memberInThisChannel.role > 0) {
                                data2.memberInThisChannel = ChannelUser.obtain((ChannelMember)memberInThisChannel);
                                data2.memberInThisChannel.isShowChannelNick = message.cinfo.hidden_channel_nick;
                                data2.memberInThisChannel.isShowChannelTitle = message.cinfo.show_channel_title;
                            }
                            if (AccountUtil.getUid() == info.baseInfo.ownerUid) {
                                param2.setExtra("RECOMMEND_TAG_ID", (Object)message.tag_id);
                            }
                            if (info.baseInfo == null || StringUtils.isEmpty((String)info.baseInfo.gid)) {
                                if (callBack != null) {
                                    callBack.onError(param2, 98, "", new Exception());
                                }
                                MLog.error((Object)JoinRequestManager.TAG, (String)"join channel fail data error\uff0c cinfo:%s, cdata:%s", (Object[])new Object[]{info.toString(), data2.toString()});
                                BaseRequestManager.statMetric((String)"channel/join", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)98L);
                            } else {
                                MLog.info((Object)JoinRequestManager.TAG, (String)"join channel success cinfo:%s, cdata:%s", (Object[])new Object[]{info.toString(), data2.toString()});
                                JoinRequestManager.handleCodeRateBiz(message);
                                if (callBack != null) {
                                    callBack.onSuccess(param2, info, data2);
                                }
                                long time = SystemClock.uptimeMillis() - startTime;
                                MLog.debug((Object)JoinRequestManager.TAG, (String)("uri channel/join time " + time + " code " + code), (Object[])new Object[0]);
                                BaseRequestManager.statMetric((String)"channel/join", (long)time, (boolean)true, (long)code);
                                Event event = TjgSDK.Companion.getInstance().obtianEvent("app_state", "ChannelJoinChannel", 4);
                                event.withRefState(1, "app_state");
                                TjgSDK.Companion.getInstance().fireEvent(event, EventStage.End, "");
                            }
                            if (voiceToBase) {
                                JoinRequestManager.onJoinBaseBroadcastGroupSuccessed(info.baseInfo.gid);
                            } else {
                                JoinRequestManager.onJoinSuccessed(info.baseInfo.gid);
                            }
                        } else if (callBack != null) {
                            MLog.info((Object)JoinRequestManager.TAG, (String)"join channel callBack != null", (Object[])new Object[0]);
                            if (code == (long)ECode.ONLINE_LIMIT.getValue()) {
                                callBack.onFailByOnlineLimit(param2, msgTip);
                            } else if (code == (long)ECode.PRIVATE.getValue()) {
                                callBack.onPrivateChannel(param2, msgTip);
                            } else if (code == (long)ECode.PASSWORD_ERROR.getValue()) {
                                if (StringUtils.isEmpty((String)param2.password)) {
                                    callBack.onFailByNeedPassword(param2, msgTip);
                                } else {
                                    callBack.onFailByPasswordError(param2, msgTip);
                                }
                            } else if (code == (long)ECode.LOCKED.getValue()) {
                                callBack.onFailByNeedPassword(param2, msgTip);
                            } else if (code == (long)ECode.PASSWORD_TRY_LIMIT.getValue()) {
                                callBack.onFailByPasswordTryTooFrequently(param2, msgTip);
                            } else if (code == (long)ECode.KICK_OFF_FROZE.getValue()) {
                                callBack.onKickOffFrozenError(param2, msgTip);
                            } else if (code == (long)ECode.CHANNEL_NOT_EXISTS.getValue()) {
                                callBack.onFailByChannelNotExist(param2, msgTip);
                            } else if (code == (long)ECode.INVITE_EXPIRE.getValue()) {
                                callBack.onFailByInviteExpire(param2, msgTip);
                            } else if (code == (long)ECode.INVITE_MAX_LIMIT.getValue()) {
                                callBack.onFailByInviteClickMaxLimit(param2, msgTip);
                            } else if (code == (long)ECode.NOT_MATCH_CHANNEL.getValue()) {
                                if (param2.gameInfo != null) {
                                    callBack.onNotMatchChannel(param2);
                                } else {
                                    callBack.onFailChannelMatchFail(param2, msgTip);
                                }
                            } else if (code == (long)ECode.CHANNEL_All_DISBAND.getValue()) {
                                callBack.onFailChannelAllDisBand(param2, msgTip);
                            } else if (code == (long)ECode.CHANNEL_DISBAND_RETRY_OTHER.getValue()) {
                                callBack.onRetryUnBannedChannel(message.disband_try_cid, param2, msgTip);
                            } else if (code == (long)ECode.GLOBAL_PLUGIN_NOT_ARROW.getValue()) {
                                callBack.onCrossRegionNotAllow(param2, msgTip);
                            } else if (code == (long)ECode.OWNER_NO_IN_ROOM.getValue()) {
                                callBack.onFailEnterMultiVideoRoom(param2, msgTip);
                            } else if (code == (long)ECode.CLIENT_HARDWARE_BAD_PERFORMANCE.getValue()) {
                                callBack.onFailClientHardwareBad(param2, msgTip);
                            } else if (code == (long)ECode.CHANNEL_SHOW_NUM_LIMIT.getValue()) {
                                callBack.onFailChannelShowNumLimit(param2, msgTip);
                            } else if (code == (long)ECode.ONLY_ARROW_MEMBER_ENTER.getValue()) {
                                callBack.onFailNumberNoArrow(param2, msgTip);
                            } else if (code == (long)ECode.SENSITIVE.getValue()) {
                                callBack.onFailSensitive(param2, msgTip);
                            } else if (code == (long)ECode.BLACK_LIST_NOT_ALLOW.getValue()) {
                                callBack.onInBlackList(param2, msgTip);
                            } else if (code == (long)ECode.NOT_ALLOW_CAUSE_BLACK_LIST.getValue()) {
                                callBack.onInOwnerBlackList(param2, message.result.errmsg);
                            } else if (code == (long)ECode.FORBID_AGE.getValue()) {
                                callBack.onAgeLimit(param2, message.result.errmsg);
                            } else if (code == (long)ECode.ENTER_LIMIT_POPUP_WINDOW.getValue()) {
                                callBack.onEnterLimitPopWindow(param2, msgTip);
                            } else if (code == (long)ECode.CHANNEL_MODIFY_CREATE_UID_LIMIT.getValue()) {
                                callBack.onModifyChannelLimit();
                            } else {
                                BanInfo banInfo;
                                MLog.info((Object)JoinRequestManager.TAG, (String)"join channel no define error code", (Object[])new Object[0]);
                                BanInfo banInfo2 = banInfo = !message.ban_info.__isDefaultInstance() ? message.ban_info : null;
                                if (banInfo != null && banInfo.banned > 0L) {
                                    ChannelBannedData bannedData = new ChannelBannedData(param2.roomId, banInfo.reason.longValue());
                                    bannedData.bannedTime = banInfo.banned;
                                    callBack.onChannelBanned(param2, bannedData, msgTip);
                                } else {
                                    callBack.onError(param2, 102, "", new Exception("code:" + code + " msg:" + (msgTip != null ? msgTip : "")));
                                }
                            }
                        }
                        MLog.info((Object)JoinRequestManager.TAG, (String)"join channel response, error code:%d,errortips:%s,dataValid:%s", (Object[])new Object[]{code, !message.result.__isDefaultInstance() ? message.result.errmsg : "", dataValid ? "true" : "false"});
                        BaseRequestManager.statMetric((String)"channel/join", (long)(curTime - startTime), (boolean)false, (long)code);
                        Notification notification = Notification.obtain((int)ChannelNotifyDef.ENTER_CHANNEL_REQUEST_RESULT);
                        notification.extObj = new Pair((Object)param2.roomId, (Object)code);
                        NotificationCenter.getGlobalInstance().notify(notification);
                    }

                    public boolean retryWhenTimeout(boolean canRetry) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (callBack != null) {
                                    callBack.onError(param2, 100, "", new Exception("Time out!"));
                                }
                                MLog.error((Object)JoinRequestManager.TAG, (String)"join channel error timeout!", (Object[])new Object[0]);
                                BaseRequestManager.statMetric((String)"channel/join", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                            }
                        });
                        return false;
                    }

                    public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (callBack != null) {
                                    callBack.onError(param2, 100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                                }
                                MLog.error((Object)JoinRequestManager.TAG, (String)"join channel netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                                BaseRequestManager.statMetric((String)"channel/join", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                            }
                        });
                        return false;
                    }
                });
            }
        });
    }

    public static void leaveGroup(final String gid, final IChannel.ILeaveCallBack callBack, final boolean voiceToBase) {
        LeaveReq req = new LeaveReq.Builder().cid(gid).min_base(Boolean.valueOf(voiceToBase)).build();
        MLog.info((Object)TAG, (String)"leaveGroup cid:%s", (Object[])new Object[]{gid});
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(gid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<LeaveRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable LeaveRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Join error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull LeaveRes message, long code, String msg) {
                if (callBack != null) {
                    ChannelLeaveResp data2 = new ChannelLeaveResp(true, message.join_count.longValue(), message.show_time.intValue(), false);
                    callBack.onSuccess(gid, data2);
                }
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.info((Object)JoinRequestManager.TAG, (String)"leaveGroup success cid:%s", (Object[])new Object[]{gid});
                } else {
                    MLog.error((Object)JoinRequestManager.TAG, (String)"leaveGroup error cid:%s,code:%d,tips:%s", (Object[])new Object[]{gid, code, !message.result.__isDefaultInstance() ? message.result.errmsg : ""});
                }
                if (voiceToBase) {
                    JoinRequestManager.onLeaveBaseBroadcastGroupSuccessed(gid);
                } else {
                    JoinRequestManager.onLeaveSuccessed(gid);
                }
                BaseRequestManager.statMetric((String)"channel/leave", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                Event event = TjgSDK.Companion.getInstance().obtianEvent("app_state", "ChannelLeaveChannel", 4);
                event.withRefState(1, "app_state");
                TjgSDK.Companion.getInstance().fireEvent(event, EventStage.End, "");
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)JoinRequestManager.TAG, (String)"leaveGroup time out cid:%s!", (Object[])new Object[]{gid});
                        if (callBack != null) {
                            callBack.onError(100, "", new Exception("Time out!"));
                        }
                        BaseRequestManager.statMetric((String)"channel/leave", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        }
                        MLog.error((Object)JoinRequestManager.TAG, (String)"leaveGroup netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        BaseRequestManager.statMetric((String)"channel/leave", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void sendProbeRequest(String cid, String data2) {
        ProbeReq req = new ProbeReq.Builder().cid(cid).data(data2).build();
        MLog.info((Object)TAG, (String)"sendProbeRequest cid:%s", (Object[])new Object[]{cid});
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<ProbeRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable ProbeRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Join error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull ProbeRes message, long code, String msg) {
                MLog.info((Object)JoinRequestManager.TAG, (String)"sendProbeRequest code:%d,tips:%s", (Object[])new Object[]{code, !message.result.__isDefaultInstance() ? message.result.errmsg : ""});
                BaseRequestManager.statMetric((String)"channel/Probe", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)JoinRequestManager.TAG, (String)"sendProbeRequest Timeout!", (Object[])new Object[0]);
                        BaseRequestManager.statMetric((String)"channel/Probe", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)JoinRequestManager.TAG, (String)"sendProbeRequest netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        BaseRequestManager.statMetric((String)"channel/Probe", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void getUserJoinedGroups(long uid, IChannelCenterService.QueryJoinChannelConfig config, final IChannelCenterService.IGetMyJoinedChannelsCallBack callBack) {
        MLog.info((Object)TAG, (String)"getUserJoinedGroupsInner", (Object[])new Object[0]);
        GetUserJoinedReq req = new GetUserJoinedReq.Builder().uid(Long.valueOf(uid)).return_roles(Boolean.valueOf(true)).return_common_channels(Boolean.valueOf(config.returnCommonChannels)).sort_type(Integer.valueOf(config.sortType)).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetUserJoinedRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable GetUserJoinedRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Join error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull GetUserJoinedRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    ArrayList<MyJoinChannelItem> groupSummays = new ArrayList<MyJoinChannelItem>(message.cinfos.size());
                    List items = message.cinfos;
                    List memberAndCIDS = message.channel_members;
                    int index = 0;
                    if (items != null && items.size() > 0) {
                        MyJoinChannelItem myJoinChannelItem = null;
                        boolean findMemeber = false;
                        for (CInfo item : items) {
                            if (item == null) continue;
                            myJoinChannelItem = BaseRequestManager.obtainJoinChannelItem((CInfo)item);
                            findMemeber = false;
                            for (GetUserJoinedRes.ChannelMemberAndCID memberAndCID : memberAndCIDS) {
                                if (StringUtils.equal((String)item.cid, (String)memberAndCID.cid)) {
                                    myJoinChannelItem.myRoleData = BaseRequestManager.obtainChannelUser((ChannelMember)memberAndCID.member);
                                    if (memberAndCID.plugin_info != null && !FP.empty((CharSequence)memberAndCID.plugin_info.pid)) {
                                        myJoinChannelItem.mPluginData = BaseRequestManager.obtainPluginData((PluginInfo)memberAndCID.plugin_info, (String)"", (String)memberAndCID.cid);
                                    }
                                }
                                findMemeber = true;
                            }
                            if (!findMemeber && RuntimeContext.sIsDebuggable) {
                                throw new RuntimeException("\u540e\u53f0\u8fd4\u56de\u65e0\u6548\u6570\u636e\uff0c\u6ca1\u6709\u4e00\u4e00\u5bf9\u5e94\uff0c\u6ca1\u6709\u8fd4\u56de\u89d2\u8272\u4fe1\u606f\uff01");
                            }
                            if (StringUtils.isNotEmpty((String)myJoinChannelItem.cid) && myJoinChannelItem.ownerUid > 0L) {
                                groupSummays.add(myJoinChannelItem);
                            } else if (RuntimeContext.sIsDebuggable) {
                                MLog.error((Object)JoinRequestManager.TAG, (Throwable)new RuntimeException("\u540e\u53f0\u8fd4\u56de\u4e86\u65e0\u6548\u6570\u636e," + myJoinChannelItem.toString()));
                            }
                            if (index < FP.size((Collection)message.role_count)) {
                                myJoinChannelItem.roleCount = ((Integer)message.role_count.get(index)).intValue();
                            }
                            if (index < FP.size((Collection)message.role_limit)) {
                                myJoinChannelItem.roleLimit = ((Integer)message.role_limit.get(index)).intValue();
                            }
                            if (index < FP.size((Collection)message.is_common_channels)) {
                                myJoinChannelItem.channelJoinedStateWithLocalUid = (Boolean)message.is_common_channels.get(index) != false ? MyJoinChannelItem.ChannelJoinStateWithLocalUid.LOCAL_UID_HAS_JOIN : MyJoinChannelItem.ChannelJoinStateWithLocalUid.LOCAL_UID_NOT_JOIN;
                            }
                            ++index;
                            myJoinChannelItem.roomShowType = item.room_show_type;
                        }
                    }
                    if (callBack != null) {
                        callBack.onSuccess(groupSummays);
                    }
                    MLog.info((Object)JoinRequestManager.TAG, (String)"getUserJoinedGroupsInner success datas:%s!", (Object[])new Object[]{groupSummays.toString()});
                    BaseRequestManager.statMetric((String)"channel/userjoin", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else {
                    MLog.error((Object)JoinRequestManager.TAG, (String)"getUserJoinedGroupsInner error code:%d!", (Object[])new Object[]{code});
                    BaseRequestManager.statMetric((String)"channel/userjoin", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)JoinRequestManager.TAG, (String)"getUserJoinedGroupsInner retryWhenTimeout", (Object[])new Object[0]);
                BaseRequestManager.statMetric((String)"channel/userjoin", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)JoinRequestManager.TAG, (String)"getUserJoinedGroupsInner retryWhenError", (Object[])new Object[0]);
                BaseRequestManager.statMetric((String)"channel/userjoin", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                return false;
            }
        });
    }

    private static void handleCodeRateBiz(EnterRes message) {
        if (!message.transcode_options.__isDefaultInstance()) {
            RadioLiveConfigData data2;
            AConfigData config;
            ArrayList<LiveCodeRate> liveCodeRateList = new ArrayList<LiveCodeRate>();
            HashSet<Integer> coderates = new HashSet<Integer>();
            for (int i = 0; i < message.transcode_options.transcode_info.size(); ++i) {
                TranscodeInfo codeRateInfo = (TranscodeInfo)message.transcode_options.transcode_info.get(i);
                LiveCodeRate liveCodeRate = new LiveCodeRate();
                LiveCodeRateKt.transformOrigin((LiveCodeRate)liveCodeRate, (TranscodeInfo)codeRateInfo);
                liveCodeRateList.add(liveCodeRate);
                coderates.add(codeRateInfo.transcode_middleground_mode_v2);
            }
            if ((coderates.isEmpty() || coderates.size() == 1 && coderates.contains(0)) && (config = UnifyConfig.INSTANCE.getConfigData(BssCode.RADIO_LIVE_CONFIG)) instanceof RadioLiveConfig && (data2 = ((RadioLiveConfig)config).getData()) != null && !FP.empty((Collection)data2.getRadioDefaultCodeRate())) {
                liveCodeRateList.clear();
                List radioDefaultCodeRate = data2.getRadioDefaultCodeRate();
                for (RadioLiveConfigData.LiveCodeRate item : radioDefaultCodeRate) {
                    LiveCodeRate liveCodeRate = new LiveCodeRate();
                    liveCodeRate.setCodeRate(item.getCodeRate());
                    RadioLiveConfigData.LiveCodeRate.MediaInfo mediaInfo = item.getMediaInfo();
                    if (mediaInfo != null) {
                        LiveCodeRate.MediaInfo info = new LiveCodeRate.MediaInfo();
                        info.setBitrate(mediaInfo.getBitrate());
                        info.setFps(mediaInfo.getFps());
                        info.setVideoHeight(mediaInfo.getVideoHeight());
                        info.setVideoWidth(mediaInfo.getVideoWidth());
                        liveCodeRate.setMediaInfo(info);
                    }
                    liveCodeRateList.add(liveCodeRate);
                }
            }
            MLog.info((Object)TAG, (String)"set anchor code rate:%s,ar_gift=%s", (Object[])new Object[]{JoinRequestManager.getCodeRateStr(liveCodeRateList), message.users_ar_gift});
            AnchorQualityManager.INSTANCE.updateSupportCodeRateList(liveCodeRateList);
            AnchorQualityManager.INSTANCE.getUnSupportArGiftMap().clear();
            for (UserARGift userARGift : message.users_ar_gift) {
                AnchorQualityManager.INSTANCE.getUnSupportArGiftMap().put(userARGift.uid, userARGift.close);
            }
        } else {
            AnchorQualityManager.INSTANCE.updateSupportCodeRateList(Collections.emptyList());
        }
    }

    private static String getCodeRateStr(List<LiveCodeRate> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        for (LiveCodeRate codeRate : list2) {
            stringBuilder.append("[");
            stringBuilder.append(codeRate.toString());
            stringBuilder.append("]");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static boolean isValid(EnterRes message) {
        return message != null && !message.cinfo.__isDefaultInstance() && message.cinfo.owner > 0L && !FP.empty((CharSequence)message.cinfo.cid);
    }

    public void getMyJoinedFamilyChannel(final ICommonCallback<MyJoinChannelItem> callback2) {
        GetMyFamilyReq getMyFamilyReq = new GetMyFamilyReq.Builder().build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)getMyFamilyReq, (IProtoCallback)new IProtoCallback<GetMyFamilyRes>(){

            public void onResponse(@NonNull GetMyFamilyRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    CInfo cInfo = message != null ? message.cinfo : null;
                    String msgContent = StringUtils.formatWitUSLocal((String)"getMyJoinedFamilyChannel cInfo:%s, code:%d, msg:%s", (Object[])new Object[]{cInfo, code, msg});
                    MLog.info((Object)JoinRequestManager.TAG, (String)msgContent, (Object[])new Object[0]);
                    if (callback2 != null) {
                        if (cInfo != null) {
                            callback2.onSuccess((Object)BaseRequestManager.obtainJoinChannelItem((CInfo)cInfo), new Object[0]);
                        } else {
                            callback2.onFail(-1, msgContent, new Object[0]);
                        }
                    }
                } else if (callback2 != null) {
                    callback2.onFail(-2, StringUtils.formatWitUSLocal((String)"getMyJoinedFamilyChannel code:%d, msg:%s", (Object[])new Object[]{code, msg}), new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread(() -> {
                    if (callback2 != null) {
                        callback2.onFail(-3, "getMyJoinedFamilyChannel retryWhenTimeout " + canRetry, new Object[0]);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                YYTaskExecutor.postToMainThread(() -> {
                    if (callback2 != null) {
                        callback2.onFail(-4, "getMyJoinedFamilyChannel retryWhenError " + canRetry + reason + code, new Object[0]);
                    }
                });
                return false;
            }
        });
    }

    public void getFamilyInfo(String fid, final ICommonCallback<GetFamilyProfileRes> callback2) {
        GetFamilyProfileReq getMyFamilyReq = new GetFamilyProfileReq.Builder().fid(fid).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)getMyFamilyReq, (IProtoCallback)new IProtoCallback<GetFamilyProfileRes>(){

            public void onResponse(@NonNull GetFamilyProfileRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.info((Object)JoinRequestManager.TAG, (String)("getFaimilyinfo: " + message.toString()), (Object[])new Object[0]);
                    if (callback2 != null) {
                        callback2.onSuccess((Object)message, new Object[0]);
                    }
                } else if (callback2 != null) {
                    callback2.onFail(-2, StringUtils.formatWitUSLocal((String)"getFamilyInfo code:%d, msg:%s", (Object[])new Object[]{code, msg}), new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread(() -> {
                    if (callback2 != null) {
                        callback2.onFail(-3, "getFamilyInfo retryWhenTimeout " + canRetry, new Object[0]);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                YYTaskExecutor.postToMainThread(() -> {
                    if (callback2 != null) {
                        callback2.onFail(-4, "getFamilyInfo retryWhenError " + canRetry + reason + code, new Object[0]);
                    }
                });
                return false;
            }
        });
    }

    private void getMyJoinedGroupsInner(IChannelCenterService.IGetMyJoinedChannelsCallBack callBack) {
        if (this.myJoinPDuplicater == null) {
            this.myJoinPDuplicater = new RequestPreventDuplicater();
        }
        if (this.myJoinPDuplicater.isStarted()) {
            this.myJoinPDuplicater.addCallBack(callBack);
            return;
        }
        this.myJoinPDuplicater.onStart(callBack);
        MLog.info((Object)TAG, (String)"getMyJoinedChannels!", (Object[])new Object[0]);
        GetMyJoinedReq req = new GetMyJoinedReq.Builder().return_roles(Boolean.valueOf(true)).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetMyJoinedRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable GetMyJoinedRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Join error, use old result!");
                }
                JoinRequestManager.this.myJoinPDuplicater.onFinish();
            }

            @UiThread
            public void onResponse(@NonNull GetMyJoinedRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    ArrayList<MyJoinChannelItem> groupSummays = new ArrayList<MyJoinChannelItem>(message.cinfos.size());
                    List items = message.cinfos;
                    List memberAndCIDS = message.channel_members;
                    if (items != null && items.size() > 0) {
                        MyJoinChannelItem myJoinChannelItem = null;
                        boolean findMemeber = false;
                        int index = 0;
                        boolean injectClientTrans = items.size() == message.game_msg_entry.size();
                        for (CInfo item : items) {
                            boolean isVideoAnchor;
                            if (item == null) continue;
                            myJoinChannelItem = BaseRequestManager.obtainJoinChannelItem((CInfo)item);
                            findMemeber = false;
                            for (GetMyJoinedRes.ChannelMemberAndCID memberAndCID : memberAndCIDS) {
                                if (StringUtils.equal((String)item.cid, (String)memberAndCID.cid)) {
                                    myJoinChannelItem.myRoleData = BaseRequestManager.obtainChannelUser((ChannelMember)memberAndCID.member);
                                    if (memberAndCID.plugin_info != null && !FP.empty((CharSequence)memberAndCID.plugin_info.pid)) {
                                        myJoinChannelItem.mPluginData = BaseRequestManager.obtainPluginData((PluginInfo)memberAndCID.plugin_info, (String)"", (String)memberAndCID.cid);
                                    }
                                }
                                findMemeber = true;
                            }
                            if (!findMemeber && RuntimeContext.sIsDebuggable) {
                                throw new RuntimeException("\u540e\u53f0\u8fd4\u56de\u65e0\u6548\u6570\u636e\uff0c\u6ca1\u6709\u4e00\u4e00\u5bf9\u5e94\uff0c\u6ca1\u6709\u8fd4\u56de\u89d2\u8272\u4fe1\u606f\uff01");
                            }
                            if (StringUtils.isNotEmpty((String)myJoinChannelItem.cid) && myJoinChannelItem.ownerUid > 0L) {
                                groupSummays.add(myJoinChannelItem);
                            } else if (RuntimeContext.sIsDebuggable) {
                                MLog.error((Object)JoinRequestManager.TAG, (Throwable)new RuntimeException("\u540e\u53f0\u8fd4\u56de\u4e86\u65e0\u6548\u6570\u636e," + myJoinChannelItem.toString()));
                            }
                            if (index < FP.size((Collection)message.role_count)) {
                                myJoinChannelItem.roleCount = ((Integer)message.role_count.get(index)).intValue();
                            }
                            if (index < FP.size((Collection)message.role_limit)) {
                                myJoinChannelItem.roleLimit = ((Integer)message.role_limit.get(index)).intValue();
                            }
                            if (index < FP.size((Collection)message.is_video_anchor) && (isVideoAnchor = ((Boolean)message.is_video_anchor.get(index)).booleanValue())) {
                                myJoinChannelItem.videoAnchors.add(AccountUtil.getUid());
                            }
                            myJoinChannelItem.roomShowType = item.room_show_type;
                            if (injectClientTrans) {
                                myJoinChannelItem.transClient = (Boolean)message.game_msg_entry.get(index);
                            }
                            ++index;
                        }
                    }
                    MLog.info((Object)JoinRequestManager.TAG, (String)"getMyJoinedChannels success datas:%s!", (Object[])new Object[]{groupSummays.toString()});
                    JoinRequestManager.this.notifyMyJoinedGroupsCallBack(groupSummays);
                    BaseRequestManager.statMetric((String)"channel/myjoin", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else {
                    MLog.error((Object)JoinRequestManager.TAG, (String)"getMyJoinedChannels error code:%d!", (Object[])new Object[]{code});
                    JoinRequestManager.this.notifyMyJoinedGroupsCallBack(100, new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    BaseRequestManager.statMetric((String)"channel/myjoin", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
                JoinRequestManager.this.myJoinPDuplicater.onFinish();
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)JoinRequestManager.TAG, (String)"getMyJoinedChannels error Timeout!", (Object[])new Object[0]);
                        JoinRequestManager.this.notifyMyJoinedGroupsCallBack(100, new Exception("Time out!"));
                        JoinRequestManager.this.myJoinPDuplicater.onFinish();
                        BaseRequestManager.statMetric((String)"channel/myjoin", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JoinRequestManager.this.notifyMyJoinedGroupsCallBack(100, new Exception((reason != null ? reason : "") + " code:" + code));
                        MLog.error((Object)JoinRequestManager.TAG, (String)"getMyJoinedChannels netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        JoinRequestManager.this.myJoinPDuplicater.onFinish();
                        BaseRequestManager.statMetric((String)"channel/myjoin", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }
}

