/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.request.cinfo;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import biz.CDynamic;
import biz.CInfo;
import biz.PluginInfo;
import biz.PluginType;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.GroupChatClassificationConfig;
import com.yy.appbase.unifyconfig.config.GroupChatClassificationData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.AcrossRecommendInfo;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelDynamicInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfoSelector;
import com.yy.hiyo.channel.base.bean.ChannelTag;
import com.yy.hiyo.channel.base.bean.ChannelTagItem;
import com.yy.hiyo.channel.base.bean.FamilyGateInfo;
import com.yy.hiyo.channel.base.bean.ThemeItemBean;
import com.yy.hiyo.channel.base.bean.create.CreateChannelParams;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IMsgService;
import com.yy.hiyo.channel.module.recommend.base.bean.LocationBean;
import com.yy.hiyo.channel.service.request.RequestPreventDuplicater;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.location.LocationHelper;
import com.yy.location.LocationInfo;
import common.ERet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.ihago.base.tag.Tag;
import net.ihago.channel.srv.mgr.Background;
import net.ihago.channel.srv.mgr.CreateReq;
import net.ihago.channel.srv.mgr.CreateRes;
import net.ihago.channel.srv.mgr.DisbandReq;
import net.ihago.channel.srv.mgr.DisbandRes;
import net.ihago.channel.srv.mgr.DoNotDisturbReq;
import net.ihago.channel.srv.mgr.DoNotDisturbRes;
import net.ihago.channel.srv.mgr.ECode;
import net.ihago.channel.srv.mgr.GetCInfoListReq;
import net.ihago.channel.srv.mgr.GetCInfoListRes;
import net.ihago.channel.srv.mgr.GetCInfoReq;
import net.ihago.channel.srv.mgr.GetCInfoRes;
import net.ihago.channel.srv.mgr.GetEnterTokenReq;
import net.ihago.channel.srv.mgr.GetEnterTokenRes;
import net.ihago.channel.srv.mgr.ModifyReq;
import net.ihago.channel.srv.mgr.ModifyRes;
import net.ihago.channel.srv.mgr.SetChannelBGIMGReq;
import net.ihago.channel.srv.mgr.SetChannelBGIMGRes;
import net.ihago.channel.srv.mgr.SetLightEffectReq;
import net.ihago.channel.srv.mgr.SetLightEffectRes;
import net.ihago.channel.srv.mgr.SwitchLbsReq;
import net.ihago.channel.srv.mgr.SwitchLbsRes;
import net.ihago.room.api.rrec.AcrossRecomReq;
import net.ihago.room.api.rrec.AcrossRecomRes;
import net.ihago.room.api.rrec.RoomTabItem;

public class CInfoRequestManager
extends BaseRequestManager {
    private static final String TAG = "ChannelRequest_Cinfo";
    private static final int ERROR_TYPE_CANCEL = 99;
    private RequestPreventDuplicater<BaseRequestManager.IGetTopAndSubGroupInfosCallBack> groupListDuplicater;
    private RequestPreventDuplicater<BaseRequestManager.IGetChannelInfoCallBack> channelInfoDuplicater;
    private static ArrayList<WeakReference<IRequestManagerCallBack>> sCallBacks;

    private static CInfo obtianCInfo(String parentCID, CreateChannelParams params) {
        ChannelInfo info = new ChannelInfo();
        if (StringUtils.isNotEmpty((String)parentCID)) {
            info.pid = parentCID;
        } else if (StringUtils.isNotEmpty((String)params.parentCid)) {
            info.pid = params.parentCid;
        }
        info.name = params.name;
        if (StringUtils.isNotEmpty((String)params.tagId)) {
            info.tag = new ChannelTag();
            info.tag.setTags(new ArrayList(0));
            ChannelTagItem tagItem = new ChannelTagItem();
            tagItem.setTagId(StringUtils.notNull((String)params.tagId));
            info.tag.getTags().add(tagItem);
            info.tag.inflate(null);
        }
        info.enterMode = params.joinMode;
        info.password = params.password;
        info.creator = params.creatorUid;
        info.ownerUid = params.ownUid;
        info.isPrivate = params.type == 2;
        info.avatar = params.avatar;
        info.lockEnterMode = params.lockEnterMode;
        if (params.isSameCity) {
            info.isSameCity = true;
            info.sameCityInfo = params.sameCityInfo;
        }
        info.source = params.source;
        info.joinMode = params.beRoleMode;
        if ("hago.family".equals(params.source)) {
            info.joinPayLevel = params.joinPayLevel;
            info.joinActiveTime = params.joinActiveTime;
        }
        info.firstType = params.firstType;
        info.secondType = params.secondType;
        info.indieGameId = params.gameId;
        return CInfoRequestManager.obtianCInfo((ChannelInfo)info);
    }

    public static void createChannel(CreateChannelParams params, IChannel.ICreateCallBack callBack) {
        CInfoRequestManager.createChannel("", params, callBack);
    }

    public static void createChannel(String parentCID, CreateChannelParams params, IChannel.ICreateCallBack callBack) {
        MLog.info((Object)TAG, (String)"createChannel parentCID:%s, params:%s", (Object[])new Object[]{parentCID, params.toString()});
        CInfoRequestManager.createChannel(parentCID, CInfoRequestManager.obtianCInfo(parentCID, params), params, callBack);
    }

    public static void createChannel(String parentCID, CInfo cInfo, final CreateChannelParams params, final IChannel.ICreateCallBack callBack) {
        CreateReq.Builder reqBuilder = new CreateReq.Builder().cinfo(cInfo).entry_point(Integer.valueOf(params.from));
        if (params.cardId <= 0L) {
            reqBuilder.card_id(Long.valueOf(params.cardId));
        }
        if (params != null && params.channelPluginData != null) {
            reqBuilder.plugin_info(CInfoRequestManager.obtainPluginInfo(params.channelPluginData));
        }
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(parentCID, (AndroidMessage)reqBuilder.build(), (IProtoCallback)new IProtoCallback<CreateRes>(){
            boolean isShowGamePanel;
            ChannelPluginData channelPluginData;
            {
                this.isShowGamePanel = params.isShowGamePanel;
                this.channelPluginData = params.channelPluginData;
            }

            @Deprecated
            @UiThread
            public void onResponse(@Nullable CreateRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Cinfo error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull CreateRes message, long code, String msgTip) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    CInfo cInfo = message.cinfo;
                    ChannelInfo channelInfo = BaseRequestManager.obtianChannelInfo((CInfo)cInfo);
                    ChannelDetailInfo groupDetailInfo = new ChannelDetailInfo();
                    groupDetailInfo.extInfo.isShowGamePanel = this.isShowGamePanel;
                    groupDetailInfo.baseInfo = channelInfo;
                    groupDetailInfo.dynamicInfo = new ChannelDynamicInfo();
                    if (callBack != null) {
                        callBack.onSuccess(groupDetailInfo);
                    }
                    CInfoRequestManager.notifyCreateChannelSuccess(channelInfo);
                    MLog.info((Object)CInfoRequestManager.TAG, (String)"createChannel success info:%s", (Object[])new Object[]{groupDetailInfo});
                    BaseRequestManager.statMetric((String)"channel/create", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (callBack != null) {
                    if (code == (long)ECode.CHANNEL_NUM_LIMIT.getValue() || code == (long)ECode.MAX_CHANNEL_COUNT_LIMIT.getValue()) {
                        callBack.onFailByGroupNumLimit(msgTip);
                    } else if (code == (long)ECode.SENSITIVE.getValue()) {
                        callBack.onContainSensitiveWord(params, msgTip);
                    } else if (code == (long)ECode.NO_PERMIT.getValue() || code == (long)ERet.kRetErrPermissionDenied.getValue()) {
                        callBack.onNoPermission(msgTip);
                    } else if (code == (long)ECode.CAN_NOT_USE_OLD_VERSION.getValue()) {
                        callBack.onNoUseOldVersion(msgTip);
                    } else {
                        callBack.onError(102, "", new Exception("code:" + code + " msg:" + (msgTip != null ? msgTip : "")));
                    }
                    MLog.error((Object)CInfoRequestManager.TAG, (String)"createChannel error code:%d,errortips:%s", (Object[])new Object[]{code, message.result != null ? message.result.errmsg : ""});
                    BaseRequestManager.statMetric((String)"channel/create", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(100, "", new Exception("Time out!"));
                        }
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"createChannel Timeout params:%s!", (Object[])new Object[]{params});
                        BaseRequestManager.statMetric((String)"channel/create", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        }
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"createChannel netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        BaseRequestManager.statMetric((String)"channel/create", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    private static PluginInfo obtainPluginInfo(ChannelPluginData channelPluginData) {
        PluginInfo.Builder pluginInfoBuilder = new PluginInfo.Builder().pid(channelPluginData.getPluginId());
        int type = PluginType.PT_CHAT.getValue();
        if (channelPluginData.getMode() == 11) {
            type = PluginType.PT_KTV.getValue();
        } else if (channelPluginData.getMode() == 13) {
            type = PluginType.PT_MAKEFRIENDS.getValue();
        } else if (channelPluginData.getMode() == 14) {
            type = PluginType.PT_RADIO.getValue();
        } else if (channelPluginData.getMode() == 15) {
            type = PluginType.PT_MULTIVIDEO.getValue();
        } else if (channelPluginData.getMode() == 1) {
            type = PluginType.PT_BASE.getValue();
        } else if (channelPluginData.getMode() == 300) {
            type = PluginType.PT_ZHU_LI.getValue();
        }
        pluginInfoBuilder.type(Integer.valueOf(type));
        return pluginInfoBuilder.build();
    }

    public void disbandSubGroup(final String groupId, final IChannel.IDisbandCallBack callBack) {
        DisbandReq req = new DisbandReq.Builder().cid(groupId).build();
        MLog.info((Object)TAG, (String)"disbandSubGroup cID:%s", (Object[])new Object[]{groupId});
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(groupId, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<DisbandRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable DisbandRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Cinfo error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull DisbandRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    if (callBack != null) {
                        callBack.onSuccess(groupId);
                    }
                    MLog.info((Object)CInfoRequestManager.TAG, (String)"disbandSubGroup success cID:%s", (Object[])new Object[]{groupId});
                    BaseRequestManager.statMetric((String)"channel/remove", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (callBack != null) {
                    if (code == (long)ECode.STILL_IN_CHANNEL.getValue()) {
                        callBack.onFailByStillHasOthersIn(groupId);
                    } else if (code == (long)ECode.CHANNEL_DELTOP_FORBIDDEN.getValue()) {
                        callBack.onFailByCannotDeleteTopChannel(groupId);
                    } else if (callBack != null) {
                        callBack.onError(groupId, 102, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    }
                    MLog.error((Object)CInfoRequestManager.TAG, (String)"disbandSubGroup error code:%d,errortips:%s", (Object[])new Object[]{code, message.result != null ? message.result.errmsg : ""});
                    BaseRequestManager.statMetric((String)"channel/remove", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"disbandSubGroup Timeout cID:%s", (Object[])new Object[]{groupId});
                        if (callBack != null) {
                            callBack.onError(groupId, 100, "", new Exception("Time out!"));
                        }
                        BaseRequestManager.statMetric((String)"channel/remove", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(groupId, 100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        }
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"disbandSubGroup netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        BaseRequestManager.statMetric((String)"channel/remove", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void getChannelInfo(final String cid, final ChannelInfoSelector infoSelector, final BaseRequestManager.IGetChannelInfoCallBack callBack) {
        if (YYTaskExecutor.isMainThread()) {
            this.getChannelInfoInner(cid, infoSelector, callBack);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    CInfoRequestManager.this.getChannelInfoInner(cid, infoSelector, callBack);
                }
            });
        }
    }

    public void fetchAcrossRecommendList(String channelId, String pid, int recommendType, @Nullable String pluginId, boolean videoMode, @NonNull IDataService.IGetAcrossRecommendListCallback callback2) {
        if (YYTaskExecutor.isMainThread()) {
            this.fetchAcrossRecommendListInner(channelId, pid, recommendType, pluginId, videoMode, callback2);
        } else {
            YYTaskExecutor.postToMainThread(() -> this.fetchAcrossRecommendListInner(channelId, pid, recommendType, pluginId, videoMode, callback2));
        }
    }

    private void fetchAcrossRecommendListInner(final String channelId, String pid, int recommendType, @Nullable String pluginId, final boolean videoMode, final @NonNull IDataService.IGetAcrossRecommendListCallback callback2) {
        MLog.info((Object)TAG, (String)"fetchAcrossRecommendListInner, channelId = %s, recommendType = %s, pluginId = %s,", (Object[])new Object[]{channelId, recommendType, pluginId});
        AcrossRecomReq.Builder reqBuilder = new AcrossRecomReq.Builder().across_recom_type(Integer.valueOf(recommendType));
        if (!TextUtils.isEmpty((CharSequence)pluginId)) {
            reqBuilder.game_id(pluginId);
        }
        LocationBean location = this.getLocation();
        if (recommendType == 3 && location != null) {
            MLog.info((Object)TAG, (String)"fetchAcrossRecommendListInner, location=%s", (Object[])new Object[]{location});
            reqBuilder.longitude(Double.valueOf(location.getLongitude()));
            reqBuilder.latitude(Double.valueOf(location.getLatitude()));
            reqBuilder.country(location.getCountry());
            reqBuilder.city(location.getCity());
            if (SettingFlags.containKey((String)"key_first_enter_samecity_channel_time")) {
                long time = SettingFlags.getLongValue((String)"key_first_enter_samecity_channel_time");
                reqBuilder.first_city_time(Long.valueOf(time));
                MLog.info((Object)TAG, (String)"fetchAcrossRecommendListInner firstSameCityChannelTime=%s", (Object[])new Object[]{time});
            }
        }
        reqBuilder.pid(pid);
        ProtoManager.getInstance().sendHttp(channelId, (AndroidMessage)reqBuilder.build(), (IProtoCallback)new SimpleProtoCallback<AcrossRecomRes>(){

            public void onResponse(@NonNull AcrossRecomRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)CInfoRequestManager.TAG, (String)"fetchAcrossRecommendListInner, code=%s, list cout=%s, msg=%s", (Object[])new Object[]{code, FP.size((Collection)message.channels), msg});
                if (ProtoManager.isSuccessCode((long)code)) {
                    int type = message.across_recom_type;
                    if (FP.empty((Collection)message.channels)) {
                        callback2.onSuccess(channelId, new ArrayList());
                    } else {
                        ArrayList<AcrossRecommendInfo> list2 = new ArrayList<AcrossRecommendInfo>();
                        HashSet<String> idSet = new HashSet<String>();
                        for (RoomTabItem item : message.channels) {
                            if (idSet.contains(item.id)) continue;
                            idSet.add(item.id);
                            list2.add(CInfoRequestManager.this.obtainAcrossRecommend(type, item, videoMode));
                        }
                        callback2.onSuccess(channelId, list2);
                    }
                } else {
                    callback2.onError(channelId, (int)code, new Exception(msg));
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                callback2.onError(channelId, code, new Exception(reason));
            }
        });
    }

    private LocationBean getLocation() {
        LocationBean result = null;
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.PERFORMANCE_CONFIG);
        LocationInfo info = LocationHelper.getLocationInfo((boolean)true);
        if (config != null && config.getBoolValue("samecity_list_city_from_geocoder", false)) {
            if (info != null && !TextUtils.isEmpty((CharSequence)info.getGeocoderCity()) && !TextUtils.isEmpty((CharSequence)info.getGeocoderCountry())) {
                result = new LocationBean(info.getLongitude(), info.getLatitude(), info.getGeocoderCity(), info.getGeocoderCountry());
            }
        } else if (info != null) {
            result = new LocationBean(info.getLongitude(), info.getLatitude(), info.getCity(), info.getCountry());
        }
        return result;
    }

    private AcrossRecommendInfo obtainAcrossRecommend(int type, RoomTabItem item, boolean radioVideoMode) {
        AcrossRecommendInfo info = new AcrossRecommendInfo(item.id, radioVideoMode);
        info.setRecommendType(type);
        info.setOwnerAvatar(item.url);
        info.setOwnerNick(item.nick_name);
        info.setName(item.name);
        info.setGid(item.gameid);
        info.setPlayerNum(item.player_num.longValue());
        info.setAllPlayerNum(item.all_player_num.longValue());
        info.setDistance(item.dist.longValue());
        info.setPluginType(item.plugin_type.intValue());
        info.setSong(item.song);
        info.setFreeSeatNum(item.free_seat_num.intValue());
        info.setPluginLabelMsg(item.plugin_label_msg);
        info.setMicConnectAvatar(item.mic_connected_avatar);
        info.setVideo(item.video.booleanValue());
        return info;
    }

    private void notifyGetChannelInfoCallBack(ChannelInfo channelInfo, int topOnline) {
        List<BaseRequestManager.IGetChannelInfoCallBack> callBacks = this.channelInfoDuplicater.getCallBacks();
        if (callBacks != null && callBacks.size() > 0) {
            for (BaseRequestManager.IGetChannelInfoCallBack callBack : callBacks) {
                callBack.onSuccess(channelInfo, topOnline);
            }
        }
    }

    private void notifyGetChannelInfoCallBack(String gid, int errorCode, String errorTips, Exception e) {
        List<BaseRequestManager.IGetChannelInfoCallBack> callBacks = this.channelInfoDuplicater.getCallBacks();
        if (callBacks != null && callBacks.size() > 0) {
            for (BaseRequestManager.IGetChannelInfoCallBack callBack : callBacks) {
                callBack.onError(gid, errorCode, errorTips, e);
            }
        }
    }

    private void getChannelInfoInner(final String cid, ChannelInfoSelector infoSelector, final BaseRequestManager.IGetChannelInfoCallBack callBack) {
        if (this.channelInfoDuplicater == null) {
            this.channelInfoDuplicater = new RequestPreventDuplicater();
        }
        if (this.channelInfoDuplicater.isStarted()) {
            this.channelInfoDuplicater.addCallBack(callBack);
            return;
        }
        this.channelInfoDuplicater.onStart(callBack);
        MLog.info((Object)TAG, (String)"getChannelInfo cid:%s", (Object[])new Object[]{cid});
        GetCInfoReq req = infoSelector != null ? new GetCInfoReq.Builder().cid(cid).selector(CInfoRequestManager.obtianSeletorCInfo()).ret_top_party_bg(Boolean.valueOf(infoSelector.getNeedPartyBg())).ret_top_online(Boolean.valueOf(infoSelector.getNeedTopOnlines())).return_roles(Boolean.valueOf(true)).return_bgi_audit_active(Boolean.valueOf(true)).return_mod_room_avatar(Boolean.valueOf(true)).build() : new GetCInfoReq.Builder().cid(cid).ret_top_party_bg(Boolean.valueOf(false)).return_roles(Boolean.valueOf(true)).selector(CInfoRequestManager.obtianSeletorCInfo()).return_bgi_audit_active(Boolean.valueOf(true)).return_mod_room_avatar(Boolean.valueOf(true)).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetCInfoRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable GetCInfoRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Cinfo error, use old result!");
                }
                CInfoRequestManager.this.channelInfoDuplicater.onFinish();
            }

            @UiThread
            public void onResponse(@NonNull GetCInfoRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    boolean isDataValid = CInfoRequestManager.isValid(message);
                    ChannelInfo channelInfo = BaseRequestManager.obtianChannelInfo((CInfo)message.cinfo);
                    channelInfo.partyTheme = ThemeItemBean.toThemeItemBean((Background)message.party_background);
                    if (channelInfo.partyTheme != null) {
                        channelInfo.partyThemeId = channelInfo.partyTheme.getThemeId();
                    }
                    channelInfo.roleCount = message.role_count.intValue();
                    channelInfo.roleLimit = message.role_limit.intValue();
                    channelInfo.masterLimit = message.master_limit.intValue();
                    channelInfo.isBgInReview = message.is_bgi_audit_active == false;
                    channelInfo.roomAvatar = message.cinfo.room_avatar;
                    channelInfo.modifyRoomAvatarPermit = message.is_mod_room_avatar;
                    CInfoRequestManager.this.notifyGetChannelInfoCallBack(channelInfo, message.top_online);
                    MLog.info((Object)CInfoRequestManager.TAG, (String)"getChannelInfo success cid:%s,info:%s", (Object[])new Object[]{cid, channelInfo.toString()});
                    BaseRequestManager.statMetric((String)"channel/getcinfo", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                    if (!isDataValid && RuntimeContext.sIsDebuggable) {
                        throw new RuntimeException("getChannelInfo data from server is not valid!");
                    }
                } else if (callBack != null) {
                    MLog.error((Object)CInfoRequestManager.TAG, (String)"getChannelInfo error code:%d,errortips:%s", (Object[])new Object[]{code, message.result != null ? message.result.errmsg : ""});
                    CInfoRequestManager.this.notifyGetChannelInfoCallBack(cid, 102, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    BaseRequestManager.statMetric((String)"channel/getcinfo", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
                CInfoRequestManager.this.channelInfoDuplicater.onFinish();
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"getChannelInfo Timeout cid:%s!", (Object[])new Object[]{cid});
                        CInfoRequestManager.this.notifyGetChannelInfoCallBack(cid, 100, "", new Exception("Time out!"));
                        CInfoRequestManager.this.channelInfoDuplicater.onFinish();
                        BaseRequestManager.statMetric((String)"channel/getcinfo", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CInfoRequestManager.this.notifyGetChannelInfoCallBack(cid, 100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        CInfoRequestManager.this.channelInfoDuplicater.onFinish();
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"getChannelInfo netError cid:%s, code:%d, reason:%s!", (Object[])new Object[]{cid, code, reason});
                        BaseRequestManager.statMetric((String)"channel/getcinfo", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void getTopAndSubGroupInfos(final String pid, final String cid, final long ver, final BaseRequestManager.IGetTopAndSubGroupInfosCallBack callBack, boolean justBase) {
        if (YYTaskExecutor.isMainThread()) {
            this.getTopAndSubGroupInfosInner(pid, cid, ver, callBack);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    CInfoRequestManager.this.getTopAndSubGroupInfosInner(pid, cid, ver, callBack);
                }
            });
        }
    }

    private void notifyGetTopAndSubGroupInfosCallBack(List<CInfo> staticInfos, List<CDynamic> dynamicInfos, List<Integer> totalCounts, List<Integer> limitCounts, ThemeItemBean themeItemBean) {
        List<BaseRequestManager.IGetTopAndSubGroupInfosCallBack> callBacks = this.groupListDuplicater.getCallBacks();
        if (callBacks != null && callBacks.size() > 0) {
            for (BaseRequestManager.IGetTopAndSubGroupInfosCallBack callBack : callBacks) {
                callBack.onSuccess(staticInfos, dynamicInfos, totalCounts, limitCounts, themeItemBean);
            }
        }
    }

    private void notifyGetTopAndSubGroupInfosCallBack(String gid, int errorCode, String errorTips, Exception e) {
        List<BaseRequestManager.IGetTopAndSubGroupInfosCallBack> callBacks = this.groupListDuplicater.getCallBacks();
        if (callBacks != null && callBacks.size() > 0) {
            for (BaseRequestManager.IGetTopAndSubGroupInfosCallBack callBack : callBacks) {
                callBack.onError(gid, errorCode, errorTips, e);
            }
        }
    }

    private void getTopAndSubGroupInfosInner(String pid, final String cid, long ver, final BaseRequestManager.IGetTopAndSubGroupInfosCallBack callBack) {
        if (this.groupListDuplicater == null) {
            this.groupListDuplicater = new RequestPreventDuplicater();
        }
        if (this.groupListDuplicater.isStarted()) {
            this.groupListDuplicater.addCallBack(callBack);
            return;
        }
        this.groupListDuplicater.onStart(callBack);
        MLog.info((Object)TAG, (String)"getTopAndSubChannelInfos pid:%s cid:%s, ver:%s", (Object[])new Object[]{pid, cid, ver});
        GetCInfoListReq req = new GetCInfoListReq.Builder().cid(cid).return_roles(Boolean.valueOf(true)).selector(CInfoRequestManager.obtianSeletorCInfo()).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetCInfoListRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable GetCInfoListRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Cinfo error, use old result!");
                }
                CInfoRequestManager.this.groupListDuplicater.onFinish();
            }

            @UiThread
            public void onResponse(@NonNull GetCInfoListRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    List staticInfos = message.cinfos;
                    List dynamicInfos = message.dynamics;
                    List totalCounts = message.role_count;
                    List limitCounts = message.role_limit;
                    CInfoRequestManager.this.notifyGetTopAndSubGroupInfosCallBack(staticInfos, dynamicInfos, totalCounts, limitCounts, ThemeItemBean.toThemeItemBean((Background)message.party_background));
                    if (!ChannelDefine.sUnEnableLog) {
                        MLog.info((Object)CInfoRequestManager.TAG, (String)"getTopAndSubChannelInfos success cid:%s, staticInfos:%s, dynamicInfos:%s", (Object[])new Object[]{cid, staticInfos.toString(), dynamicInfos.toString()});
                    }
                    BaseRequestManager.statMetric((String)"channel/getgroups", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (callBack != null) {
                    MLog.error((Object)CInfoRequestManager.TAG, (String)"getTopAndSubChannelInfos error cid:%s code:%d,errortips:%s", (Object[])new Object[]{cid, code, message.result != null ? message.result.errmsg : ""});
                    CInfoRequestManager.this.notifyGetTopAndSubGroupInfosCallBack(cid, 102, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    BaseRequestManager.statMetric((String)"channel/getgroups", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
                CInfoRequestManager.this.groupListDuplicater.onFinish();
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"getTopAndSubChannelInfos Timeout cid:%s", (Object[])new Object[]{cid});
                        CInfoRequestManager.this.notifyGetTopAndSubGroupInfosCallBack(cid, 100, "", new Exception("Time out!"));
                        CInfoRequestManager.this.groupListDuplicater.onFinish();
                        BaseRequestManager.statMetric((String)"channel/getgroups", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CInfoRequestManager.this.notifyGetTopAndSubGroupInfosCallBack(cid, 100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        CInfoRequestManager.this.groupListDuplicater.onFinish();
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"getTopAndSubChannelInfos netError cid:%s, code:%d, reason:%s!", (Object[])new Object[]{cid, code, reason});
                        BaseRequestManager.statMetric((String)"channel/getgroups", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void updateLightEffect(String gid, String lightEffect, final BaseRequestManager.IRequestCallBack callBack) {
        SetLightEffectReq req = new SetLightEffectReq.Builder().cid(gid).affect(lightEffect).build();
        ProtoManager.getInstance().sendRpc(gid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<SetLightEffectRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable SetLightEffectRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Cinfo error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull SetLightEffectRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                } else if (callBack != null) {
                    callBack.onError(102, msg, new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"updateLightEffect retryWhenTimeout", (Object[])new Object[0]);
                        if (callBack != null) {
                            callBack.onError(102, "retryWhenTimeout", new Exception("updateLightEffect retryWhenTimeout"));
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"updateLightEffect retryWhenError reason:%s code:%d", (Object[])new Object[]{reason, code});
                        if (callBack != null) {
                            callBack.onError(102, reason, new Exception("code:" + code + " msg:" + (reason != null ? reason : "")));
                        }
                    }
                });
                return false;
            }
        });
    }

    private void modify(CInfo seletor, CInfo cInfo, BaseRequestManager.IRequestCallBack callBack) {
        this.modify(seletor, cInfo, new ModifyReq.Builder(), callBack);
    }

    private void modify(final CInfo seletor, final CInfo cInfo, ModifyReq.Builder reqBuilder, final BaseRequestManager.IRequestCallBack callBack) {
        ModifyReq req = reqBuilder.cinfo(cInfo).set_fields(seletor).build();
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)"modify cInfo:%s, \n selector %s", (Object[])new Object[]{cInfo.toString(), seletor.toString()});
        } else {
            MLog.info((Object)TAG, (String)"modify cInfo:%s", (Object[])new Object[]{cInfo.cid});
        }
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(cInfo.cid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<ModifyRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable ModifyRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Cinfo error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull ModifyRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                    if (!FP.empty((CharSequence)seletor.name) && callBack != null) {
                        callBack.onRecommendTagUpdate(message.tag_id);
                    }
                    if (!ChannelDefine.sUnEnableLog) {
                        MLog.info((Object)CInfoRequestManager.TAG, (String)"modifyCinfo success cid:%s, new cinfo:%s", (Object[])new Object[]{cInfo.cid, BaseRequestManager.obtianChannelInfo((CInfo)message.cinfo)});
                    }
                    BaseRequestManager.statMetric((String)"channel/cmodefy", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (callBack != null) {
                    if (!RuntimeContext.sIsDebuggable || code == (long)ECode.CHANNEL_RENAME_LIMIT.getValue() || code == (long)ECode.NO_ARROW.getValue()) {
                        // empty if block
                    }
                    if ((code == (long)ECode.CHANNEL_RENAME_LIMIT.getValue() || code == (long)ECode.CHANNEL_MODIFY_MONEY_NOT_ALLOWED.getValue() || code == (long)ECode.NO_ARROW.getValue() || code == (long)ECode.CHANNEL_MOD_NAME_LIMIT.getValue()) && StringUtils.isNotEmpty((String)message.result.errmsg)) {
                        callBack.updateLimit(message.result.errmsg);
                    } else if (code == (long)ECode.NO_PERMIT.getValue() || code == (long)ERet.kRetErrPermissionDenied.getValue()) {
                        callBack.onFailUnauthorized();
                    } else if (code == (long)ECode.SENSITIVE.getValue()) {
                        callBack.onContainSensitiveWord();
                    } else if (code == (long)ECode.CHANNEL_MODIFY_CREATE_UID_LIMIT.getValue()) {
                        callBack.limitNoToast();
                    } else {
                        int responseCode = 102;
                        if (code == (long)ECode.RATELIMIT.getValue()) {
                            responseCode = 1016;
                        }
                        callBack.onError(responseCode, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    }
                    MLog.error((Object)CInfoRequestManager.TAG, (String)"modify error cid:%s, code:%d,errortips:%s", (Object[])new Object[]{cInfo.cid, code, message.result != null ? message.result.errmsg : ""});
                    if (!ChannelDefine.sUnEnableLog) {
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"modifyCinfo error cid:%s, cInfo:%s", (Object[])new Object[]{cInfo.cid, cInfo.toString()});
                    }
                    BaseRequestManager.statMetric((String)"channel/cmodefy", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
                if (code == (long)ECode.CHANNEL_MODIFY_MONEY_NOT_ALLOWED.getValue() && !TextUtils.isEmpty((CharSequence)msg)) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)msg, (int)1);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(100, "", new Exception("Time out!"));
                        }
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"modifyCinfo error Timeout cid:%s", (Object[])new Object[]{cInfo.cid});
                        BaseRequestManager.statMetric((String)"channel/cmodefy", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        }
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"modifyCinfo netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        BaseRequestManager.statMetric((String)"channel/cmodefy", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void setName(String gid, String name, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.name = name;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.name("1");
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), callBack);
    }

    public void updateCategory(String gid, int firstType, int secondType, boolean updateToIndieGameSourceIfCategoryIsGame, BaseRequestManager.IRequestCallBack callback2) {
        List configData1;
        AConfigData configData;
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.firstType = firstType;
        channelInfo.secondType = secondType;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.first_type(Integer.valueOf(1));
        cInfoBuilder.second_type(Integer.valueOf(1));
        if (firstType == 3 && updateToIndieGameSourceIfCategoryIsGame && (configData = UnifyConfig.INSTANCE.getConfigData(BssCode.GROUP_CHAT_CLASSIFICATION)) instanceof GroupChatClassificationConfig && !FP.empty((Collection)(configData1 = ((GroupChatClassificationConfig)configData).getConfigData()))) {
            block0: for (GroupChatClassificationData data2 : configData1) {
                if (data2.getId() != firstType) continue;
                List subClassification = data2.getSubClassification();
                if (FP.empty((Collection)subClassification)) break;
                for (GroupChatClassificationData sub : subClassification) {
                    String s;
                    if (sub.getId() != secondType) continue;
                    if (FP.empty((Collection)sub.getGameIds()) || !StringUtils.isNotEmpty((String)(s = (String)sub.getGameIds().get(0)))) break block0;
                    channelInfo.indieGameId = s;
                    channelInfo.source = "hago.indiegame";
                    cInfoBuilder.indie_gameid = "1";
                    cInfoBuilder.source = "1";
                    break block0;
                }
            }
        }
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), callback2);
    }

    public void updateChannelPostPermission(String gid, int content, int role, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.postSyncRole = role;
        channelInfo.postSyncContent = content;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.post_sync_role(Integer.valueOf(role));
        cInfoBuilder.post_sync_content(Integer.valueOf(content));
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), callBack);
    }

    public void updateChannelPostPermission(String gid, int content, int role, int topPerm, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.postSyncRole = role;
        channelInfo.postSyncContent = content;
        channelInfo.postOperRole = topPerm;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.post_sync_role(Integer.valueOf(role));
        cInfoBuilder.post_sync_content(Integer.valueOf(content));
        cInfoBuilder.post_oper_role(Integer.valueOf(topPerm));
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), callBack);
    }

    public void setAnnouncement(String gid, String announcement, boolean withPush, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.announcement = announcement;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.bulletin("1");
        ModifyReq.Builder reqBuilder = new ModifyReq.Builder().push_bulletin(Boolean.valueOf(withPush));
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), reqBuilder, callBack);
    }

    public void changeFamilyGateInfo(String gid, FamilyGateInfo gateInfo, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        if (gateInfo.getWeath() != -1L) {
            channelInfo.joinPayLevel = gateInfo.getWeath();
            cInfoBuilder.join_pay_level(Long.valueOf(1L));
        }
        if (gateInfo.getDuration() != -1L) {
            channelInfo.joinActiveTime = gateInfo.getDuration();
            cInfoBuilder.join_active_time(Long.valueOf(1L));
        }
        ModifyReq.Builder reqBuilder = new ModifyReq.Builder();
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), reqBuilder, callBack);
    }

    public void setEnterMode(String gid, int enterMode, String password, int lockEnterMode, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.enterMode = enterMode;
        channelInfo.password = password;
        channelInfo.lockEnterMode = lockEnterMode;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.enter_mode(Integer.valueOf(1));
        cInfoBuilder.password(password);
        if (lockEnterMode != -1) {
            cInfoBuilder.lock_enter_mode(Integer.valueOf(lockEnterMode));
        }
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), callBack);
    }

    public void setOpenPartyPermission(String gid, boolean forbidMember, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.channelShowPermit = forbidMember ? 5 : 1;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.channel_show_permit(Integer.valueOf(1));
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), callBack);
    }

    public void setSpeakMode(String gid, int mode, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.speakMode = mode;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.speak_mode(Integer.valueOf(1));
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), callBack);
    }

    public void setVoiceEnterMode(String gid, int mode, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.voiceEnterMode = mode;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.channel_voice_enter_mode(Integer.valueOf(1));
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), callBack);
    }

    public void setGuestSpeakLimit(String gid, int bitMask, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.guestSpeakLimitBitmask = bitMask;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.guest_speak_limit(Integer.valueOf(1));
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), callBack);
    }

    public void updatePrivacyMode(String gid, boolean privatePrivacy, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.isPrivate = privatePrivacy;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.is_private(Boolean.valueOf(true));
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), callBack);
    }

    public void updateRoleJoinMode(String gid, int mode, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.joinMode = mode;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.join_mode(Integer.valueOf(1));
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), callBack);
    }

    public void updateTag(String gid, ArrayList<String> tagIds, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.tag = new ChannelTag();
        for (String tagId : tagIds) {
            if (FP.empty((CharSequence)tagId)) continue;
            if (channelInfo.tag.getTags() == null) {
                channelInfo.tag.setTags(new ArrayList(1));
            }
            channelInfo.tag.getTags().add(new ChannelTagItem(StringUtils.notNull((String)tagId)));
        }
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.tags(Collections.singletonList(new Tag.Builder().tid("1").build()));
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), callBack);
    }

    public void updateOpenVoiceChatMode(String gid, int mode, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.openVoiceChatMode = mode;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.voice_mode(Integer.valueOf(1));
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), callBack);
    }

    public void updateDoNotDisturb(final String cid, final boolean switchOn, final IMsgService.ISetDoNotDisturbCallBack callBack) {
        DoNotDisturbReq req = new DoNotDisturbReq.Builder().cid(cid).notify(Boolean.valueOf(!switchOn)).build();
        MLog.info((Object)TAG, (String)"updateDoNotDisturb cid:%s, switchOn:%d", (Object[])new Object[]{cid, switchOn ? 1 : 0});
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<DoNotDisturbRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable DoNotDisturbRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Cinfo error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull DoNotDisturbRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    if (callBack != null) {
                        callBack.onSuccess(cid, switchOn);
                    }
                    MLog.info((Object)CInfoRequestManager.TAG, (String)"updateDoNotDisturb  success cid:%s!", (Object[])new Object[]{cid});
                    BaseRequestManager.statMetric((String)"channel/setdonotdisturb", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (callBack != null) {
                    if (callBack != null) {
                        callBack.onError(cid, 102, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    }
                    MLog.error((Object)CInfoRequestManager.TAG, (String)"updateDoNotDisturb error cid:%s,code:%d,errortips:%s", (Object[])new Object[]{cid, code, message.result != null ? message.result.errmsg : ""});
                    BaseRequestManager.statMetric((String)"channel/setdonotdisturb", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(cid, 100, "", new Exception("Time out!"));
                        }
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"updateDoNotDisturb error Timeout cid:%s", (Object[])new Object[]{cid});
                        BaseRequestManager.statMetric((String)"channel/setdonotdisturb", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(cid, 100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        }
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"updateDoNotDisturb netError cid:%s,code:%d, reason:%s!", (Object[])new Object[]{cid, code, reason});
                        BaseRequestManager.statMetric((String)"channel/setdonotdisturb", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void getInviteEnterToken(final String cid, final IDataService.IGetInviteTokenCallBack callBack) {
        MLog.info((Object)TAG, (String)"getInviteEnterToken cid:%s", (Object[])new Object[]{cid});
        GetEnterTokenReq req = new GetEnterTokenReq.Builder().cid(cid).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetEnterTokenRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable GetEnterTokenRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest_Cinfo error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull GetEnterTokenRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    String token = message.enter_token;
                    if (callBack != null) {
                        callBack.onSuccess(cid, token);
                    }
                    MLog.info((Object)CInfoRequestManager.TAG, (String)"getInviteEnterToken success:%s token:%s", (Object[])new Object[]{cid, token});
                    BaseRequestManager.statMetric((String)"channel/getentertoken", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else if (callBack != null) {
                    if (callBack != null) {
                        callBack.onError(cid, 102, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                    }
                    MLog.error((Object)CInfoRequestManager.TAG, (String)"getInviteEnterToken error cid:%s,code:%d,errortips:%s", (Object[])new Object[]{cid, code, message.result != null ? message.result.errmsg : ""});
                    BaseRequestManager.statMetric((String)"channel/getentertoken", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(cid, 100, "", new Exception("Time out!"));
                        }
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"getInviteEnterToken error Timeout cid:%s", (Object[])new Object[]{cid});
                        BaseRequestManager.statMetric((String)"channel/getentertoken", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(cid, 100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                        }
                        MLog.error((Object)CInfoRequestManager.TAG, (String)"getInviteEnterToken netError cid:%s, code:%d, reason:%s!", (Object[])new Object[]{cid, code, reason});
                        BaseRequestManager.statMetric((String)"channel/getentertoken", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void switchLbs(final String cid, final boolean open, double longitude, double latitude, final ICommonCallback<Boolean> callBack) {
        MLog.info((Object)TAG, (String)"switchLbs cid:%s, open:%s, longitude:%s, latitude:%s", (Object[])new Object[]{cid, open, longitude, latitude});
        SwitchLbsReq req = new SwitchLbsReq.Builder().cid(cid).status(Boolean.valueOf(open)).longitude(Double.valueOf(longitude)).latitude(Double.valueOf(latitude)).build();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<SwitchLbsRes>(){

            @UiThread
            public void onResponse(@NonNull SwitchLbsRes message, long code, String msg) {
                MLog.error((Object)CInfoRequestManager.TAG, (String)"switchLbs result cid:%s, code:%d, errortips:%s", (Object[])new Object[]{cid, code, msg});
                if (ProtoManager.isSuccessCode((long)code)) {
                    if (callBack != null) {
                        callBack.onSuccess((Object)open, new Object[0]);
                    }
                } else if (callBack != null) {
                    callBack.onFail((int)code, msg, new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread(() -> {
                    if (callBack != null) {
                        callBack.onFail(-1, "Time out!", new Object[0]);
                    }
                    MLog.error((Object)CInfoRequestManager.TAG, (String)"switchLbs error Timeout cid:%s", (Object[])new Object[]{cid});
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                YYTaskExecutor.postToMainThread(() -> {
                    if (callBack != null) {
                        callBack.onFail(code, reason, new Object[0]);
                    }
                    MLog.error((Object)CInfoRequestManager.TAG, (String)"switchLbs netError cid:%s, code:%d, reason:%s!", (Object[])new Object[]{cid, code, reason});
                });
                return false;
            }
        });
    }

    public static synchronized void addGlobalCallBack(IRequestManagerCallBack callBack) {
        if (callBack == null) {
            return;
        }
        if (sCallBacks == null) {
            sCallBacks = new ArrayList(3);
        }
        IRequestManagerCallBack itemReal = null;
        for (WeakReference<IRequestManagerCallBack> item : sCallBacks) {
            if (item != null) {
                itemReal = (IRequestManagerCallBack)item.get();
            }
            if (itemReal == null || itemReal != callBack) continue;
            return;
        }
        sCallBacks.add(new WeakReference<IRequestManagerCallBack>(callBack));
    }

    public static synchronized void deleteGlobalCallBack(IRequestManagerCallBack callBack) {
        if (sCallBacks == null) {
            return;
        }
        IRequestManagerCallBack itemReal = null;
        for (WeakReference<IRequestManagerCallBack> item : sCallBacks) {
            if (item != null) {
                itemReal = (IRequestManagerCallBack)item.get();
            }
            if (itemReal == null || itemReal != callBack) continue;
            sCallBacks.remove(item);
            return;
        }
    }

    private static synchronized void notifyCreateChannelSuccess(ChannelInfo channelInfo) {
        if (sCallBacks == null || sCallBacks.size() <= 0) {
            return;
        }
        IRequestManagerCallBack itemReal = null;
        for (WeakReference<IRequestManagerCallBack> item : sCallBacks) {
            if (item != null) {
                itemReal = (IRequestManagerCallBack)item.get();
            }
            if (itemReal == null) continue;
            itemReal.onCreateChannelSuccess(channelInfo);
        }
    }

    private static boolean isValid(GetCInfoRes message) {
        return message != null && !message.cinfo.__isDefaultInstance() && message.cinfo.owner > 0L && !FP.empty((CharSequence)message.cinfo.cid);
    }

    public void setChannelAvatar(String gid, String avatarUrl, BaseRequestManager.IRequestCallBack callBack) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.gid = gid;
        channelInfo.avatar = avatarUrl;
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.avatar("1");
        this.modify(cInfoBuilder.build(), CInfoRequestManager.obtianCInfo((ChannelInfo)channelInfo), callBack);
    }

    public void updateGroupChatBg(String cid, String imgUrl, final BaseRequestManager.IRequestCallBack callBack) {
        SetChannelBGIMGReq req = new SetChannelBGIMGReq.Builder().cid(cid).img(imgUrl).is_default(Boolean.valueOf(false)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<SetChannelBGIMGRes>(){

            public void onResponse(@NonNull SetChannelBGIMGRes res, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    callBack.onSuccess();
                } else {
                    callBack.onError((int)code, msg, null);
                }
            }

            public void onError(String reason, int code) {
                callBack.onError(code, reason, null);
            }
        });
    }

    public void clearGroupChatBg(String cid, final BaseRequestManager.IRequestCallBack callBack) {
        SetChannelBGIMGReq req = new SetChannelBGIMGReq.Builder().cid(cid).is_default(Boolean.valueOf(true)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<SetChannelBGIMGRes>(){

            public void onResponse(@NonNull SetChannelBGIMGRes res, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    callBack.onSuccess();
                } else {
                    callBack.onError((int)code, msg, null);
                }
            }

            public void onError(String reason, int code) {
                callBack.onError(code, reason, null);
            }
        });
    }

    public static interface IRequestManagerCallBack {
        public void onCreateChannelSuccess(ChannelInfo var1);
    }
}

