/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.notify;

import android.text.TextUtils;
import biz.ChannelRoleType;
import biz.PluginInfo;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelBannedData;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.KickOffData;
import com.yy.hiyo.channel.base.bean.LiveCodeRate;
import com.yy.hiyo.channel.base.bean.LiveCodeRateKt;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.service.notify.BaseNotifyHandler;
import com.yy.hiyo.channel.service.notify.IChannelNotifyHandler;
import com.yy.hiyo.linkmic.base.ILinkMicService;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.ihago.channel.srv.mgr.Background;
import net.ihago.channel.srv.mgr.EnterUserInfo;
import net.ihago.channel.srv.mgr.Notify;
import net.ihago.channel.srv.mgr.NotifyARGift;
import net.ihago.channel.srv.mgr.NotifyBgMusic;
import net.ihago.channel.srv.mgr.NotifyChangeJoinMode;
import net.ihago.channel.srv.mgr.NotifyChangeSeat;
import net.ihago.channel.srv.mgr.NotifyChannelLock;
import net.ihago.channel.srv.mgr.NotifyChannelUpgrade;
import net.ihago.channel.srv.mgr.NotifyEnter;
import net.ihago.channel.srv.mgr.NotifyExecuteEnter;
import net.ihago.channel.srv.mgr.NotifyForbidAgeOpenCamera;
import net.ihago.channel.srv.mgr.NotifyGameFinish;
import net.ihago.channel.srv.mgr.NotifyGlobalLeave;
import net.ihago.channel.srv.mgr.NotifyKTVStatus;
import net.ihago.channel.srv.mgr.NotifyKickOff;
import net.ihago.channel.srv.mgr.NotifyLeave;
import net.ihago.channel.srv.mgr.NotifyLoadPlugin;
import net.ihago.channel.srv.mgr.NotifyLockAllSeats;
import net.ihago.channel.srv.mgr.NotifyLockSeat;
import net.ihago.channel.srv.mgr.NotifyNewBackground;
import net.ihago.channel.srv.mgr.NotifyOpenVoiceChat;
import net.ihago.channel.srv.mgr.NotifyProbe;
import net.ihago.channel.srv.mgr.NotifyRadioStation;
import net.ihago.channel.srv.mgr.NotifyReady;
import net.ihago.channel.srv.mgr.NotifyRemindPlayerEnter;
import net.ihago.channel.srv.mgr.NotifyRoomAnchorTextMsg;
import net.ihago.channel.srv.mgr.NotifySeat;
import net.ihago.channel.srv.mgr.NotifySetBackground;
import net.ihago.channel.srv.mgr.NotifySetMic;
import net.ihago.channel.srv.mgr.NotifySetVideo;
import net.ihago.channel.srv.mgr.NotifySitDown;
import net.ihago.channel.srv.mgr.NotifySitDownPlzAccept;
import net.ihago.channel.srv.mgr.NotifySitdownPlz;
import net.ihago.channel.srv.mgr.NotifyStandUp;
import net.ihago.channel.srv.mgr.NotifyStandUpPlz;
import net.ihago.channel.srv.mgr.NotifyStartGame;
import net.ihago.channel.srv.mgr.NotifySwitchLbs;
import net.ihago.channel.srv.mgr.NotifyUpdateBgMusicSetting;
import net.ihago.channel.srv.mgr.NotifyVideoStatus;
import net.ihago.channel.srv.mgr.TranscodeInfo;
import net.ihago.channel.srv.mgr.Uri;

public class NormalNotifyHandler
extends BaseNotifyHandler {
    private static final String TAG = "ChannelNotifyHandler_Normal";

    public NormalNotifyHandler(BaseNotifyHandler.ICallBack callback2) {
        super(callback2);
    }

    public void handleNotify(Integer uri, Notify notify2) {
        if (uri == null) {
            return;
        }
        if (uri.intValue() == Uri.UriOnlines.getValue()) {
            if (notify2.onlines != null && notify2.onlines.onlines >= 0) {
                this.handleNotifyOnline(notify2.cid, notify2.onlines.onlines.intValue());
            }
        } else if (uri.intValue() == Uri.UriBanned.getValue()) {
            if (notify2.banned != null && notify2.banned.oper > 0L) {
                long curTime = System.currentTimeMillis() / 1000L;
                long banedTime = notify2.banned.time;
                this.handleNotifyBanned(notify2.cid, notify2.banned.oper, banedTime > 0L && banedTime > curTime, notify2.banned.time);
            }
        } else if (uri.intValue() == Uri.UriKickOff.getValue()) {
            if (notify2.kick_off != null) {
                this.handleNotifyKillOff(notify2.cid, notify2.kick_off);
            }
        } else if (uri.intValue() == Uri.UriChannelBanned.getValue()) {
            if (notify2.group_banned != null) {
                this.handleNotifyBanner(notify2.cid, notify2.group_banned.reason);
            }
        } else if (uri.intValue() == Uri.UriForceLeaveNotify.getValue()) {
            if (notify2.force_leave != null) {
                this.handleNotifyForceLeave(notify2.cid);
            }
        } else if (uri.intValue() == Uri.UriForbidAgeOpenCamera.getValue()) {
            this.handleTeenagerForbidCamera(notify2.forbid_age);
        } else {
            this.handleNormalNotify(uri, notify2);
        }
    }

    private void handleNormalNotify(Integer uri, Notify notify2) {
        if (uri == null) {
            return;
        }
        ChannelNotify channelNotify = new ChannelNotify();
        channelNotify.cid = notify2.cid;
        channelNotify.notify = new ChannelNotify.Notify();
        if (uri.intValue() == Uri.UriSeat.getValue()) {
            NotifySeat notifySeat = notify2.seat;
            if (notifySeat != null && notifySeat.seat_users != null) {
                channelNotify.uri = ChannelNotify.Uri.UriSeatsChange;
                channelNotify.notify.seatsChange = new NotifyDataDefine.SeatsChangeNotify(BaseRequestManager.obtainSeats((List)notifySeat.seat_users));
            }
        } else if (uri.intValue() == Uri.UriProbe.getValue()) {
            NotifyProbe notifyOrigin = notify2.probe;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriProbe;
                channelNotify.notify.probeNotify = new NotifyDataDefine.ProbeNotify(notify2.cid, notifyOrigin.data);
            }
        } else if (uri.intValue() == Uri.UriLoadPlugin.getValue()) {
            NotifyLoadPlugin notifyOrigin = notify2.load_plugin;
            if (notifyOrigin != null && notifyOrigin.info != null) {
                channelNotify.uri = ChannelNotify.Uri.UriSwitchPluginNotify;
                channelNotify.notify.switchPlugin = new NotifyDataDefine.SwitchPluginNotify(BaseRequestManager.obtainPluginData((PluginInfo)notifyOrigin.info, (String)"loadnotify", (String)channelNotify.cid));
                MLog.info((Object)TAG, (String)"loadplugin cid:%s,plugin:%s", (Object[])new Object[]{channelNotify.cid, channelNotify.notify.switchPlugin.pluginData.toString()});
            }
        } else if (uri.intValue() == Uri.UriChangeJoinMode.getValue()) {
            NotifyChangeJoinMode notifyOrigin = notify2.change_join_mode;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriRoleJoinModeChange;
                channelNotify.notify.roleJoinModeChangeNotify = new NotifyDataDefine.RoleJoinModeChangeNotify();
                channelNotify.notify.roleJoinModeChangeNotify.mode = notifyOrigin.mode;
            }
        } else if (uri.intValue() == Uri.UriEnter.getValue()) {
            MLog.info((Object)TAG, (String)"UriJoinNotify", (Object[])new Object[0]);
            NotifyEnter notifyOrigin = notify2.enter;
            if (notifyOrigin != null && !notifyOrigin.user_info.__isDefaultInstance()) {
                EnterUserInfo userInfo = notifyOrigin.user_info;
                channelNotify.uri = ChannelNotify.Uri.UriJoinNotify;
                channelNotify.notify.join = new NotifyDataDefine.JoinNotify();
                channelNotify.notify.join.icon = userInfo.url;
                channelNotify.notify.join.iconframeID = userInfo.icon_frame;
                channelNotify.notify.join.nick = userInfo.nick;
                channelNotify.notify.join.user = notifyOrigin.uid;
                channelNotify.notify.join.seat = notifyOrigin.seat.intValue();
                channelNotify.notify.join.sex = userInfo.sex;
                channelNotify.notify.join.isBBSEnter = !TextUtils.isEmpty((CharSequence)userInfo.bbs_user.post_id);
                channelNotify.notify.join.source = notifyOrigin.source;
                channelNotify.notify.join.isNobleEnter = notifyOrigin.noble_level > 0;
                channelNotify.notify.join.nobleIcon = notifyOrigin.noble_icon;
                channelNotify.notify.join.userType = notifyOrigin.comer_flag;
                channelNotify.notify.join.isGuest = notifyOrigin.role.intValue() == ChannelRoleType.CRT_GUEST.getValue();
                MLog.info((Object)TAG, (String)"UriJoinNotify uid: %d, nick: %s, noble_level: %d, noble_icon: %s", (Object[])new Object[]{notifyOrigin.uid, userInfo.nick, notifyOrigin.noble_level, notifyOrigin.noble_icon});
            }
        } else if (uri.intValue() == Uri.UriLeave.getValue()) {
            NotifyLeave notifyOrigin = notify2.leave;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriLeaveNotify;
                channelNotify.notify.levae = new NotifyDataDefine.LeaveNotify();
                channelNotify.notify.levae.user = notifyOrigin.uid;
                ((ILinkMicService)ServiceManagerProxy.getInstance().getService(ILinkMicService.class)).handleLeaveRoomNotify(notify2.cid, notifyOrigin.uid.longValue());
            }
        } else if (uri.intValue() == Uri.UriSitDown.getValue()) {
            NotifySitDown notifyOrigin = notify2.sit_down;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriSitDownNotify;
                channelNotify.notify.sitDown = new NotifyDataDefine.SitDownNotify();
                channelNotify.notify.sitDown.seat = notifyOrigin.seat;
                channelNotify.notify.sitDown.uid = notifyOrigin.uid;
            }
        } else if (uri.intValue() == Uri.UriSitdownPlz.getValue()) {
            NotifySitdownPlz notifyOrigin = notify2.sitdown_plz;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriSitDownPlzNotify;
                channelNotify.notify.sitDownPlz = new NotifyDataDefine.SitDownPlzNotify();
                channelNotify.notify.sitDownPlz.plzId = notifyOrigin.plz_id;
            }
        } else if (uri.intValue() == Uri.UriSitDownPlzAccept.getValue()) {
            NotifySitDownPlzAccept notifyOrigin = notify2.sit_down_plz_accept;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriSitDownPlzAcceptNotify;
                channelNotify.notify.sitDownPlzAccept = new NotifyDataDefine.SitDownPlzAcceptNotify();
                channelNotify.notify.sitDownPlzAccept.accept = notifyOrigin.accept;
                channelNotify.notify.sitDownPlzAccept.seat = notifyOrigin.seat;
                channelNotify.notify.sitDownPlzAccept.uid = notifyOrigin.uid;
            }
        } else if (uri.intValue() == Uri.UriStandUp.getValue()) {
            NotifyStandUp notifyOrigin = notify2.stand_up;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriStandUpNotify;
                channelNotify.notify.standUp = new NotifyDataDefine.StandUpNotify();
                channelNotify.notify.standUp.seat = notifyOrigin.seat;
                channelNotify.notify.standUp.uid = notifyOrigin.uid;
            }
        } else if (uri.intValue() == Uri.UriStandUpPlz.getValue()) {
            NotifyStandUpPlz notifyOrigin = notify2.stand_up_plz;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriStandUpPlzNotify;
                channelNotify.notify.standUpPlz = new NotifyDataDefine.StandUpPlzNotify();
            }
        } else if (uri.intValue() == Uri.UriLockSeat.getValue()) {
            NotifyLockSeat notifyOrigin = notify2.lock_seat;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriLockSeatNotify;
                channelNotify.notify.lockSeatNotify = new NotifyDataDefine.LockSeatNotify();
                channelNotify.notify.lockSeatNotify.seat = notifyOrigin.seat;
                channelNotify.notify.lockSeatNotify.uid = notifyOrigin.uid;
            }
        } else if (uri.intValue() == Uri.UriUnlockSeat.getValue()) {
            NotifyLockSeat notifyOrigin = notify2.lock_seat;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriUnlockSeatNotify;
                channelNotify.notify.unlockSeatNotify = new NotifyDataDefine.UnlockSeatNotify();
                channelNotify.notify.unlockSeatNotify.seat = notifyOrigin.seat;
            }
        } else if (uri.intValue() == Uri.UriSetMic.getValue()) {
            NotifySetMic notifySetMic = notify2.set_mic;
            if (notifySetMic != null) {
                channelNotify.uri = ChannelNotify.Uri.UriSetMicNotify;
                channelNotify.notify.setMic = new NotifyDataDefine.SetMicNotify();
                channelNotify.notify.setMic.uid = notifySetMic.uid;
                channelNotify.notify.setMic.micCloseBy = notifySetMic.mic_close;
                channelNotify.notify.setMic.micBan = notifySetMic.mic_ban;
                channelNotify.notify.setMic.seat = notifySetMic.seat;
            }
        } else if (uri.intValue() == Uri.UriChangeSeat.getValue()) {
            NotifyChangeSeat notifyOrigin = notify2.change_seat;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriUserSeatChannelNotify;
                channelNotify.notify.userChangeSeatNotify = new NotifyDataDefine.UserSeatChangeNotify();
                channelNotify.notify.userChangeSeatNotify.newSeat = notifyOrigin.new_seat;
                channelNotify.notify.userChangeSeatNotify.oldSeat = notifyOrigin.old_seat;
                channelNotify.notify.userChangeSeatNotify.uid = notifyOrigin.uid;
            }
        } else if (uri.intValue() == Uri.UriSetBackground.getValue()) {
            NotifySetBackground notifyOrigin = notify2.set_background;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriSetThemeNotify;
                channelNotify.notify.setTheme = new NotifyDataDefine.SetThemeNotify();
                channelNotify.notify.setTheme.cid = notify2.cid;
                channelNotify.notify.setTheme.theme = BaseRequestManager.obtianBgInfo((Background)notifyOrigin.background);
            }
        } else if (uri.intValue() == Uri.UriNewBackground.getValue()) {
            NotifyNewBackground notifyOrigin = notify2.new_background;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriNewThemeNotify;
                channelNotify.notify.newTheme = new NotifyDataDefine.NewThemeNotify();
                channelNotify.notify.newTheme.theme = BaseRequestManager.obtianBgInfo((Background)notifyOrigin.background);
            }
        } else if (uri.intValue() == Uri.UriOpenVoiceChat.getValue()) {
            NotifyOpenVoiceChat notifyOrigin = notify2.open_voice_chat;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriOpenVoiceChatNotify;
                channelNotify.notify.openVoiceChatNotify = new NotifyDataDefine.OpenVoiceChatNotify();
                channelNotify.notify.openVoiceChatNotify.operUid = notifyOrigin.uid;
            }
        } else if (uri.intValue() == Uri.UriChannelLock.getValue()) {
            NotifyChannelLock notifyOrigin = notify2.channel_lock;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriChannelLockNotify;
                channelNotify.notify.channelLock = new NotifyDataDefine.ChannelLockNotify();
                channelNotify.notify.channelLock.lock = notifyOrigin.lock;
                channelNotify.notify.channelLock.pwdToken = notifyOrigin.pwd_token;
            }
        } else if (uri.intValue() == Uri.UriReady.getValue()) {
            NotifyReady notifyOrigin = notify2.ready;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriPluginReadyNotify;
                channelNotify.notify.ready = new NotifyDataDefine.PluginStatusReadyNotify();
                channelNotify.notify.ready.ready = notifyOrigin.ready;
                channelNotify.notify.ready.seat = notifyOrigin.seat;
                channelNotify.notify.ready.uid = notifyOrigin.uid;
            }
        } else if (uri.intValue() == Uri.UriStartGame.getValue()) {
            NotifyStartGame notifyOrigin = notify2.start_game;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriPluginStartNotify;
                channelNotify.notify.start = new NotifyDataDefine.PluginStatusStartNotify();
                channelNotify.notify.start.uid = notifyOrigin.uid;
                channelNotify.notify.start.pluginData = BaseRequestManager.obtainPluginData((PluginInfo)notifyOrigin.plugin_info, (String)"notifystart", (String)channelNotify.cid);
                channelNotify.notify.start.pluginData.update(true, notifyOrigin.join_game_ctx, notifyOrigin.url);
                MLog.info((Object)TAG, (String)"pluginstart cid:%s,plugin:%s", (Object[])new Object[]{channelNotify.cid, channelNotify.notify.start.pluginData.toString()});
            }
        } else if (uri.intValue() == Uri.UriGameFinish.getValue()) {
            NotifyGameFinish notifyOrigin = notify2.game_finish;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriPluginFinishNotify;
                channelNotify.notify.finish = new NotifyDataDefine.GameFinishNotify();
            }
        } else if (uri.intValue() == Uri.UriExecuteEnter.getValue()) {
            NotifyExecuteEnter notifyOrigin = notify2.execute_enter;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriLeaveAndReJoinNotify;
                channelNotify.notify.leaveAndReEnterNotify = new NotifyDataDefine.LeaveAndReEnterNotify();
            }
        } else if (uri.intValue() == Uri.UriRadioStationNotify.getValue()) {
            NotifyRadioStation notifyOrigin = notify2.enter_radio;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriRadioStationNotify;
                channelNotify.notify.raidoStation = new NotifyDataDefine.RadioStationNotify();
                channelNotify.notify.raidoStation.fromUid = notifyOrigin.from_uid;
            }
        } else if (uri.intValue() == Uri.UriARGift.getValue()) {
            NotifyARGift notifyAr = notify2.notify_ar_gift;
            if (notifyAr != null) {
                channelNotify.uri = ChannelNotify.Uri.UriARGift;
                channelNotify.notify.mUserArGiftNotify = new NotifyDataDefine.UserArGift();
                channelNotify.notify.mUserArGiftNotify.uid = notifyAr.uid;
                channelNotify.notify.mUserArGiftNotify.close = notifyAr.close;
            }
        } else if (uri.intValue() == Uri.UriVideoStatusNotify.getValue()) {
            NotifyVideoStatus notifyOrigin = notify2.video_status;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriVideoStatusNotify;
                channelNotify.notify.videoStatus = new NotifyDataDefine.VideoStatusNotify();
                channelNotify.notify.videoStatus.isOpen = notifyOrigin.is_open;
                channelNotify.notify.videoStatus.roundId = notifyOrigin.round_id;
                if (!notifyOrigin.transcode_list.__isDefaultInstance()) {
                    ArrayList<LiveCodeRate> liveCodeRateList = new ArrayList<LiveCodeRate>();
                    for (int i = 0; i < notifyOrigin.transcode_list.transcode_info.size(); ++i) {
                        TranscodeInfo info = (TranscodeInfo)notifyOrigin.transcode_list.transcode_info.get(i);
                        LiveCodeRate liveCodeRate = new LiveCodeRate();
                        LiveCodeRateKt.transformOrigin((LiveCodeRate)liveCodeRate, (TranscodeInfo)info);
                        liveCodeRateList.add(liveCodeRate);
                    }
                    channelNotify.notify.videoStatus.mLiveCodeRateList = liveCodeRateList;
                }
            }
        } else if (uri.intValue() == Uri.UriKTVStatusNotify.getValue()) {
            NotifyKTVStatus notifyOrigin = notify2.ktv_status;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriKTVStatusNotify;
                channelNotify.notify.ktvStatus = new NotifyDataDefine.KTVStatusNotify();
                channelNotify.notify.ktvStatus.isOpen = notifyOrigin.is_open;
            }
        } else if (uri.intValue() == Uri.UriChannelUpgradeNotify.getValue()) {
            NotifyChannelUpgrade notifyOrigin = notify2.channel_upgrade;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriChannelUpgradeNotify;
                channelNotify.notify.channelUpgrade = new NotifyDataDefine.ChannelUpgradeNotify();
                channelNotify.notify.channelUpgrade.cid = notifyOrigin.top_cid;
                channelNotify.notify.channelUpgrade.version = notifyOrigin.version;
            }
        } else if (uri.intValue() == Uri.UriSwitchLbsNotify.getValue()) {
            NotifySwitchLbs notifyOrigin = notify2.switch_lbs;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriSwitchLBSNotify;
                channelNotify.notify.switchLBSNotify = new NotifyDataDefine.SwitchLBSNotify();
                channelNotify.notify.switchLBSNotify.isOpen = notifyOrigin.status;
                channelNotify.notify.switchLBSNotify.operUid = notifyOrigin.oper;
                channelNotify.notify.switchLBSNotify.longitude = notifyOrigin.longitude;
                channelNotify.notify.switchLBSNotify.latitude = notifyOrigin.latitude;
            }
        } else if (uri.intValue() == Uri.UriBgMusicNotify.getValue()) {
            NotifyBgMusic notifyOrigin = notify2.bg_music;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriPlayBgmNotify;
                channelNotify.notify.mBgmPlayNotify = new NotifyDataDefine.BgmPlayNotify();
                channelNotify.notify.mBgmPlayNotify.uid = notifyOrigin.oper_uid;
                channelNotify.notify.mBgmPlayNotify.playState = notifyOrigin.play;
                channelNotify.notify.mBgmPlayNotify.manual = notifyOrigin.manual;
                channelNotify.notify.mBgmPlayNotify.ownerCid = notifyOrigin.cid;
            }
        } else if (uri.intValue() == Uri.UriUpdateBgMusicSettingNotify.getValue()) {
            NotifyUpdateBgMusicSetting notifyOrigin = notify2.update_music_setting;
            if (notifyOrigin != null) {
                channelNotify.uri = ChannelNotify.Uri.UriUpdateBgmMode;
                channelNotify.notify.mBgmUpdateNotify = new NotifyDataDefine.BgmUpdateNotify();
                channelNotify.notify.mBgmUpdateNotify.bgmEnable = notifyOrigin.enable_master;
            }
        } else if (uri.intValue() == Uri.UriGlobalLeaveNotify.getValue()) {
            NotifyDataDefine.GlobalLeaveNotify globalLeaveNotify = NotifyDataDefine.GlobalLeaveNotify.from((NotifyGlobalLeave)notify2.global_leave);
            channelNotify.uri = ChannelNotify.Uri.UriGlobalLeaveNotify;
            channelNotify.notify.globalLeaveNotify = globalLeaveNotify;
        } else if (uri.intValue() == Uri.UriLockAllSeats.getValue()) {
            NotifyLockAllSeats notifyOrigin = notify2.lock_all_seats;
            if (null != notifyOrigin) {
                channelNotify.uri = ChannelNotify.Uri.UriLockAllSeat;
                channelNotify.notify.lockAllSeatNotify = new NotifyDataDefine.LockAllSeatNotify();
                channelNotify.notify.lockAllSeatNotify.cid = notifyOrigin.cid;
                channelNotify.notify.lockAllSeatNotify.lock = notifyOrigin.lock;
            }
        } else if (uri.intValue() == Uri.UriSetVideo.getValue()) {
            NotifySetVideo notifySetVideo = notify2.set_video;
            if (notifySetVideo != null) {
                channelNotify.uri = ChannelNotify.Uri.UriSetVideoNotify;
                channelNotify.notify.setVideo = new NotifyDataDefine.SetVideoNotify();
                channelNotify.notify.setVideo.uid = notifySetVideo.uid;
                channelNotify.notify.setVideo.videoCloseBy = notifySetVideo.video_close;
                channelNotify.notify.setVideo.videoBan = notifySetVideo.video_ban;
                channelNotify.notify.setVideo.seat = notifySetVideo.seat;
            }
        } else if (uri.intValue() == Uri.UriRemindPlayerEnter.getValue()) {
            NotifyRemindPlayerEnter remindPlayerEnter = notify2.RemindPlayerEnter;
            if (remindPlayerEnter != null) {
                channelNotify.uri = ChannelNotify.Uri.UriRemindPlayerEnter;
                channelNotify.notify.mRemindPlayerEnterNotify = new NotifyDataDefine.NotifyRemindPlayerEnter();
                channelNotify.notify.mRemindPlayerEnterNotify.enterUid = remindPlayerEnter.enter_uid;
            }
        } else if (this.isLinkMicNotify(uri)) {
            ((ILinkMicService)ServiceManagerProxy.getInstance().getService(ILinkMicService.class)).handleNotify(notify2.cid, uri.intValue(), notify2);
        } else if (uri.intValue() == Uri.UriRoomAnchorTextMsg.getValue()) {
            NotifyRoomAnchorTextMsg roomAnchorTextMsg = notify2.room_anchor_msg;
            if (roomAnchorTextMsg != null) {
                channelNotify.uri = ChannelNotify.Uri.UriRoomAnchorTxtMsg;
                channelNotify.notify.mRoomAnchorTxtMsg = new NotifyDataDefine.NotifyRoomAnchorTxtMsg();
                channelNotify.notify.mRoomAnchorTxtMsg.anchorUid = roomAnchorTextMsg.anchor_uid;
                channelNotify.notify.mRoomAnchorTxtMsg.cid = roomAnchorTextMsg.cid;
                channelNotify.notify.mRoomAnchorTxtMsg.text = roomAnchorTextMsg.text;
            }
        } else if (uri.intValue() == Uri.UriChannelRoomPartyEntry.getValue()) {
            MLog.info((Object)TAG, (String)"UriChannelRoomPartyEntry", (Object[])new Object[0]);
            channelNotify.notify.mChannelRoomPartyEntry = new NotifyDataDefine.ChannelRoomPartyEntry();
            channelNotify.uri = ChannelNotify.Uri.UriChannelRoomPartyEntry;
            if (notify2.channel_room_party_entry.plugin_info != null && notify2.channel_room_party_entry.plugin_info.type != null) {
                channelNotify.notify.mChannelRoomPartyEntry.pluginType = notify2.channel_room_party_entry.plugin_info.type;
            }
            if (notify2.channel_room_party_entry.user_info != null && notify2.channel_room_party_entry.user_info.avatar != null) {
                channelNotify.notify.mChannelRoomPartyEntry.avatar = notify2.channel_room_party_entry.user_info.avatar;
            }
            if (notify2.channel_room_party_entry.user_info != null && notify2.channel_room_party_entry.user_info.nick != null) {
                channelNotify.notify.mChannelRoomPartyEntry.nick = notify2.channel_room_party_entry.user_info.nick;
            }
        } else if (uri.intValue() != Uri.UriReceiveMsg.getValue()) {
            MLog.error((Object)TAG, (String)"unknown notify!", (Object[])new Object[0]);
        }
        this.dispatchChannelNotify(notify2.cid, channelNotify);
    }

    private boolean isLinkMicNotify(Integer uri) {
        return uri.intValue() == Uri.UriJoinMicQueue.getValue() || uri.intValue() == Uri.UriStartJoinMic.getValue() || uri.intValue() == Uri.UriChangeJoinMicType.getValue() || uri.intValue() == Uri.UriCloseJoinMic.getValue() || uri.intValue() == Uri.UriInviteJoinMic.getValue() || uri.intValue() == Uri.UriRejectJoinMic.getValue();
    }

    private void handleNotifyOnline(String gid, long onlineNum) {
        ArrayList<WeakReference<IChannelNotifyHandler>> notifyHandlers = this.callback.getNotifyHandlers();
        if (notifyHandlers == null || notifyHandlers.size() == 0) {
            return;
        }
        IChannelNotifyHandler listener2 = null;
        for (WeakReference<IChannelNotifyHandler> item : notifyHandlers) {
            if (item == null || (listener2 = (IChannelNotifyHandler)item.get()) == null) continue;
            listener2.handleNotifyOnline(gid, onlineNum);
        }
    }

    private void handleNotifyBanned(String gid, long operUid, boolean banned, long time) {
        ArrayList<WeakReference<IChannelNotifyHandler>> notifyHandlers = this.callback.getNotifyHandlers();
        if (notifyHandlers == null || notifyHandlers.size() == 0) {
            return;
        }
        IChannelNotifyHandler listener2 = null;
        for (WeakReference<IChannelNotifyHandler> item : notifyHandlers) {
            if (item == null || (listener2 = (IChannelNotifyHandler)item.get()) == null) continue;
            listener2.handleNotifyBanned(gid, operUid, banned, time);
        }
    }

    private void handleNotifyKillOff(String groupId, NotifyKickOff data2) {
        if (data2.uid == AccountUtil.getUid()) {
            Notification notification = Notification.obtain((int)NotificationIdDef.CHANNEL_MYSELF_IS_KICK_OFF);
            notification.extObj = new KickOffData(groupId, data2.frozen_time.longValue());
            NotificationCenter.getGlobalInstance().notify(notification);
        }
        String openUserNick = NormalNotifyHandler.parseLongString(data2.op_nick);
        String userKickOffedNick = NormalNotifyHandler.parseLongString(data2.nick);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)"FTRoomGroupSigNotify", (String)"handleNotifyKillOff cid:%s, frozenTime:%s, opuid:%s, uid:%s, opnick:%s, nick:%s", (Object[])new Object[]{groupId, String.valueOf(data2.frozen_time), String.valueOf(data2.op_uid), String.valueOf(data2.uid), openUserNick, userKickOffedNick});
        }
        if (data2.op_uid <= 0L || StringUtils.isEmpty((String)userKickOffedNick)) {
            return;
        }
    }

    private void handleNotifyBanner(String gid, long reason) {
        Notification notification = Notification.obtain((int)NotificationIdDef.CHANNEL_BANNED);
        notification.extObj = new ChannelBannedData(gid, reason);
        NotificationCenter.getGlobalInstance().notify(notification);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)"FTRoomGroupSigNotify", (String)"handleNotifyBanner cid:%s, reason:%s!", (Object[])new Object[]{gid, reason});
        }
    }

    private void handleNotifyForceLeave(String cid) {
        Notification notification = Notification.obtain((int)NotificationIdDef.CHANNEL_FORCE_LEAVE);
        notification.extObj = cid;
        NotificationCenter.getGlobalInstance().notify(notification);
    }

    private void handleTeenagerForbidCamera(NotifyForbidAgeOpenCamera notifyForbidAgeOpenCamera) {
        MLog.info((Object)TAG, (String)("handleTeenagerForbidCamera " + notifyForbidAgeOpenCamera.uid + "," + notifyForbidAgeOpenCamera.cid), (Object[])new Object[0]);
        IChannelCenterService service = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
        if (service == null) {
            MLog.info((Object)TAG, (String)"handleTeenagerForbidCamera getIChannelCenterService is null", (Object[])new Object[0]);
            return;
        }
        IChannel channel = service.getChannel(notifyForbidAgeOpenCamera.cid);
        if (channel == null) {
            MLog.info((Object)TAG, (String)"handleTeenagerForbidCamera getChannel is null", (Object[])new Object[0]);
            return;
        }
        channel.getSeatService().setVideosForbidByLimited(true);
    }

    public synchronized void dispatchChannelNotify(final String cid, final ChannelNotify notify2) {
        if (notify2 == null) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ArrayList<WeakReference<IChannelNotifyHandler>> notifyHandlers = NormalNotifyHandler.this.callback.getNotifyHandlers();
                if (notifyHandlers == null || notifyHandlers.size() <= 0) {
                    return;
                }
                IChannelNotifyHandler listener2 = null;
                for (WeakReference<IChannelNotifyHandler> item : notifyHandlers) {
                    if (item == null || (listener2 = (IChannelNotifyHandler)item.get()) == null) continue;
                    listener2.handleNotify(cid, notify2);
                }
            }
        });
    }
}

