/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.notify;

import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.squareup.wire.ProtoAdapter;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.service.BaseService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.ProtoUtils;
import com.yy.hiyo.proto.notify.INotifyInterceptor;
import comextend.ValBlackPlugins;
import common.Header;
import java.util.Collection;
import okio.ByteString;

public class ChannelNotifyInterceptor
extends BaseService
implements INotifyInterceptor {
    private static final String TAG = "ChannelNotifyInterceptor";
    private IChannel mChannel;

    public ChannelNotifyInterceptor(IChannel channel) {
        super(channel);
        MLog.info((Object)TAG, (String)"create channel: %d", (Object[])new Object[]{channel.hashCode()});
        this.mChannel = channel;
    }

    public INotifyInterceptor.Opt onIntercept(@NonNull Header header, @NonNull AndroidMessage notify2) {
        if (this.mChannel == null) {
            return INotifyInterceptor.Opt.NONE;
        }
        if (StringUtils.isEmpty((String)header.roomid) || StringUtils.equal((String)header.roomid, (String)this.mChannel.getChannelId()) && StringUtils.equal((String)header.roomid, (String)RuntimeContext.getVoiceRoomId())) {
            ValBlackPlugins blackPlugins;
            ByteString bytes = (ByteString)header.extend.get("BlackPlugins");
            MLog.debug((Object)TAG, (String)"onIntercept extend bytes: %s, header: %s", (Object[])new Object[]{bytes, ProtoUtils.headerString((Header)header)});
            if (bytes != null && (blackPlugins = (ValBlackPlugins)ProtoUtils.parseBytes((ProtoAdapter)ValBlackPlugins.ADAPTER, (byte[])bytes.toByteArray())) != null && !FP.empty((Collection)blackPlugins.black_plugins)) {
                int curPlugin = this.getPluginType();
                MLog.info((Object)TAG, (String)"onIntercept curPlugin: %d, blackPlugins: %s", (Object[])new Object[]{curPlugin, blackPlugins.black_plugins});
                return blackPlugins.black_plugins.contains(curPlugin) ? INotifyInterceptor.Opt.INTERCEPT : INotifyInterceptor.Opt.NONE;
            }
        }
        return INotifyInterceptor.Opt.NONE;
    }

    private int getPluginType() {
        if (this.mChannel != null && this.mChannel.getPluginService() != null && this.mChannel.getPluginService().getCurPluginData() != null) {
            return this.mChannel.getPluginService().getCurPluginData().mode;
        }
        return 0;
    }

    @Override
    public void onJoined(boolean rejoin2, ChannelDetailInfo info, EnterChannelData data2) {
        super.onJoined(rejoin2, info, data2);
        ProtoManager.getInstance().addNotifyInterceptor((INotifyInterceptor)this);
    }

    @Override
    public void onLeaved() {
        super.onLeaved();
        ProtoManager.getInstance().removeNotifyInterceptor((INotifyInterceptor)this);
    }

    @Override
    public void onDestroy() {
        ProtoManager.getInstance().removeNotifyInterceptor((INotifyInterceptor)this);
    }
}

