/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.msg.localModel;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.collection.ArrayMap;
import biz.IMMsgItem;
import biz.IMMsgSection;
import biz.SimpleCardInfo;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ICIMService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.CInterregion;
import com.yy.hiyo.channel.base.bean.ChannelPushContent;
import com.yy.hiyo.channel.base.bean.MsgBizExt;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.base.db.ChannelMsgData;
import com.yy.hiyo.channel.base.db.ChannelMsgLocal;
import com.yy.hiyo.channel.base.service.IChannelHonorService;
import com.yy.hiyo.channel.base.service.IMsgService;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IImMsgMatcher;
import com.yy.hiyo.channel.cbase.publicscreen.msg.ImageMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.SysTextMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.TextImageMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.VideoMsg;
import com.yy.hiyo.channel.component.base.util.PrivilegeHelper;
import com.yy.hiyo.channel.component.textgroup.GroupUtils;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.channel.publicscreen.BaseImMsgWrap;
import com.yy.hiyo.channel.publicscreen.HideMsg;
import com.yy.hiyo.channel.service.msg.IChannelMsgModel;
import com.yy.hiyo.channel.service.msg.localModel.ChannelMsgLocalFactory;
import com.yy.hiyo.im.IMsgDeleteCallback;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.login.base.utils.GuestLoginUtils;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.ihago.channel.srv.mgr.SendMsgReq;
import net.ihago.im.srv.limited.GroupType;
import net.ihago.im.srv.limited.SendMsgReq;
import net.ihago.im.srv.limited.SendMsgRes;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelMsgModel
implements IChannelMsgModel {
    private static final String TAG = "FTRoomGroupMsgModel";
    private static final int MAX_NUM_TEST = 1000;
    private static final boolean EnableMsgTestOn = false;
    private static final boolean EnableMsgTest;
    private IQueueTaskExecutor taskExecutor = YYTaskExecutor.createAQueueExcuter((boolean)false, (boolean)false);
    private boolean saveToFile = false;
    private ChannelMsgLocal localModel;
    private ChannelMsgLocalFactory factory;
    private final HashMap<String, ChannelMsgData> onlineMsgMap = new HashMap();
    private final ArrayMap<String, ChannelMsgData> localMsgMap = new ArrayMap();
    private ArrayList<DataUpdateListener> dataListeners;
    private long uid;
    private static int testIndex;

    public ChannelMsgModel(long uid, ChannelMsgLocalFactory factory) {
        this.uid = uid;
        this.factory = factory;
    }

    private synchronized ChannelMsgData getGroupMsgData(String groupId) {
        ChannelMsgData data2;
        if (this.localModel == null && this.saveToFile) {
            this.localModel = this.factory.getMsgLocalModel(this.uid);
            this.localModel.setCallBack((msgId, msg) -> {
                if (ServiceManagerProxy.getService(IPublicScreenService.class) != null) {
                    ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().transformMsgItem(msgId, msg);
                }
                return msg;
            });
        }
        if ((data2 = this.onlineMsgMap.get(groupId)) == null) {
            if (this.localModel != null) {
                data2 = this.localModel.getGroupMsgData(groupId);
            }
            if (data2 == null) {
                data2 = new ChannelMsgData();
                if (this.localModel != null) {
                    this.localModel.addGroupMsgData(groupId, data2);
                }
            } else if (!ChannelDefine.sUnEnableLog) {
                MLog.info((Object)TAG, (String)"ChannelMsgData data fromDB:%s!", (Object[])new Object[]{data2.toString()});
            }
            this.onlineMsgMap.put(groupId, data2);
        }
        return data2;
    }

    private void updateUnreadData(String groupid, ChannelMsgData data2, long unreadNum, String lastReadMsgId) {
        boolean changed = false;
        if (StringUtils.equal((String)data2.lastReadMsgId, (String)lastReadMsgId)) {
            data2.lastReadMsgId = lastReadMsgId;
            changed = true;
        }
        if (data2.unreadNum != unreadNum) {
            data2.unreadNum = unreadNum;
            changed = true;
            this.notifyunReadNumChange(groupid, unreadNum);
        }
        if (changed && this.localModel != null) {
            this.localModel.updateGroupMsgDataNotIncludeMsg(groupid, data2);
        }
    }

    private void updateLastMsgId(String groupid, ChannelMsgData data2, String lastMsgId) {
        boolean changed = false;
        if (StringUtils.equal((String)data2.lastMsgId, (String)lastMsgId)) {
            data2.lastMsgId = lastMsgId;
            changed = true;
        }
        if (changed && this.localModel != null) {
            this.localModel.updateGroupMsgDataNotIncludeMsg(groupid, data2);
        }
    }

    private void updateLastNotHiidenMsgId(String groupid, ChannelMsgData data2, String lastNotHiidenMsgId) {
        boolean changed = false;
        if (StringUtils.equal((String)data2.lastNotHiidenMsgId, (String)lastNotHiidenMsgId)) {
            data2.lastNotHiidenMsgId = lastNotHiidenMsgId;
            changed = true;
        }
        if (changed && this.localModel != null) {
            this.localModel.updateGroupMsgDataNotIncludeMsg(groupid, data2);
        }
    }

    @Override
    public void deleteAllMsg(String channelId) {
        this.taskExecutor.execute(() -> {
            this.onlineMsgMap.remove(channelId);
            this.localMsgMap.remove((Object)channelId);
            if (this.localModel != null) {
                this.localModel.deleteGroup(channelId);
            }
        }, 0L);
    }

    @Override
    public void inMsgPage(String channelId) {
        this.taskExecutor.execute(() -> {
            if (!ChannelDefine.sUnEnableLog) {
                MLog.info((Object)TAG, (String)"cid:%s, inMsgPage!", (Object[])new Object[]{channelId});
            }
            ChannelMsgData data2 = this.getGroupMsgData(channelId);
            this.updateUnreadData(channelId, data2, 0L, data2.getLastMsgId());
            data2.inPage = true;
        }, 0L);
    }

    @Override
    public void exitMsgPage(String channelId) {
        this.taskExecutor.execute(() -> {
            if (!ChannelDefine.sUnEnableLog) {
                MLog.info((Object)TAG, (String)"cid:%s, exitMsgPage!", (Object[])new Object[]{channelId});
            }
            ChannelMsgData data2 = this.getGroupMsgData(channelId);
            if (data2.inPage) {
                this.updateUnreadData(channelId, data2, 0L, data2.getLastMsgId());
            }
            data2.inPage = false;
        }, 0L);
    }

    @Override
    public void deleteMsg(String channelId, String msgId) {
        this.taskExecutor.execute(() -> this.deleteMsgInner(channelId, msgId, ""), 0L);
    }

    @Override
    public void deleteMsg(String channelId, String region, final BaseImMsg msg) {
        ((ImService)ServiceManagerProxy.getService(ImService.class)).deleteMsg(channelId, region, msg, new IMsgDeleteCallback(){

            public void onSuccess(String channelId, String region, BaseImMsg ms) {
                MLog.info((Object)ChannelMsgModel.TAG, (String)"deleteMessage onSuccess", (Object[])new Object[0]);
                ChannelMsgModel.this.taskExecutor.execute(() -> ChannelMsgModel.this.deleteMsgInner(channelId, msg.getMsgId(), msg.getCseq()), 0L);
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.im_message_deleted);
            }

            public void onError(String channelId, String region, BaseImMsg ms, Error error) {
            }
        });
    }

    @Override
    public void revokeMsg(String groupId, BaseImMsg imMsg) {
        SendMsgReq.Builder builder = new SendMsgReq.Builder().to_cid(groupId);
        builder.cseq(StringUtils.isNotEmpty((String)imMsg.getCseq()) ? imMsg.getCseq() : "");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("cid", imMsg.getCid());
        jsonObject.addProperty("msgid", imMsg.getMsgId());
        for (MsgSection sec : imMsg.getSections()) {
            builder.sections.add(new IMMsgSection.Builder().content(jsonObject.toString()).type(Integer.valueOf(3609)).color(StringUtils.isNotEmpty((String)sec.getColor()) ? sec.getColor() : "").extention(StringUtils.isNotEmpty((String)sec.getExtention()) ? sec.getExtention() : "").jump(StringUtils.isNotEmpty((String)sec.getJump()) ? sec.getJump() : "").trans(StringUtils.isNotEmpty((String)sec.getTrans()) ? sec.getTrans() : "").build());
        }
        ProtoManager.getInstance().sendRpc(groupId, (AndroidMessage)builder.build(), (IProtoCallback)new IProtoCallback<net.ihago.channel.srv.mgr.SendMsgRes>(){

            public void onResponse(@NonNull net.ihago.channel.srv.mgr.SendMsgRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.info((Object)ChannelMsgModel.TAG, (String)"RevokeMsgReq onSuccess", (Object[])new Object[0]);
                } else {
                    MLog.debug((Object)ChannelMsgModel.TAG, (String)("RevokeMsgReq onFail: " + message.result.errmsg), (Object[])new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    @Override
    public void addLocalMsg(String groupId, BaseImMsg msg) {
        this.taskExecutor.execute(() -> {
            ChannelMsgData localMsgData = this.getLocalMsgData(groupId);
            BaseImMsg findMsg = localMsgData.findMsgByCseq(msg.getCseq(), 100);
            if (findMsg == null) {
                if (!ChannelDefine.sUnEnableLog && msg != null) {
                    MLog.info((Object)TAG, (String)"cid:%s, add msg:%s", (Object[])new Object[]{groupId, msg});
                }
                localMsgData.addMsg(msg);
            }
        }, 0L);
    }

    @Override
    public void addLocalMsgs(String groupId, List<BaseImMsg> msgs) {
        this.taskExecutor.execute(() -> {
            ChannelMsgData localMsgData = this.getLocalMsgData(groupId);
            for (BaseImMsg msg : msgs) {
                BaseImMsg findMsg = localMsgData.findMsgByCseq(msg.getCseq(), 100);
                if (findMsg != null) continue;
                if (!ChannelDefine.sUnEnableLog && msg != null) {
                    MLog.info((Object)TAG, (String)"cid:%s, add msg:%s", (Object[])new Object[]{groupId, msg});
                }
                localMsgData.addMsg(msg);
            }
        }, 0L);
    }

    private synchronized ChannelMsgData getLocalMsgData(String groupId) {
        ChannelMsgData data2 = (ChannelMsgData)this.localMsgMap.get((Object)groupId);
        if (data2 == null) {
            data2 = new ChannelMsgData();
            this.localMsgMap.put((Object)groupId, (Object)data2);
        }
        return data2;
    }

    @Override
    public void findMsg(String channelId, String msgId, IMsgService.IGetMsgCallBack callBack) {
        this.taskExecutor.execute(() -> this.findMsgInner(channelId, msgId, callBack), 0L);
    }

    @Override
    public void findMsg(String channelId, IImMsgMatcher matcher, IMsgService.IGetMsgCallBack callBack) {
        this.taskExecutor.execute(() -> this.findMsgInner(channelId, matcher, callBack), 0L);
    }

    @Override
    public void replaceMsg(String channelId, String msgid, BaseImMsg newMsg, int reason) {
        this.taskExecutor.execute(() -> {
            int index;
            ChannelMsgData data2 = this.getGroupMsgData(channelId);
            BaseImMsg findMsg = data2.findMsg(msgid);
            MLog.info((Object)TAG, (String)"replaceMsg findMsg = %s", (Object[])new Object[]{findMsg});
            if (findMsg == null) {
                MLog.info((Object)TAG, (String)"replaceMsg findMsg null, channelData =  %s", (Object[])new Object[]{data2});
            }
            boolean fromDb = false;
            if (findMsg == null && this.localModel != null) {
                findMsg = this.localModel.find(channelId, msgid);
                fromDb = true;
            }
            if (findMsg == null) {
                return;
            }
            if (this.localModel != null) {
                this.localModel.replace(channelId, msgid, newMsg);
            }
            if (!fromDb && (index = data2.msgs.indexOf(findMsg)) >= 0) {
                data2.msgs.remove(findMsg);
                data2.msgs.add(index, newMsg);
            }
            this.notifyMsgReplaced(channelId, findMsg, newMsg, reason);
        }, 0L);
    }

    private void deleteMsgInner(String groupId, String msgId, String msgCseq, boolean notNotify) {
        ChannelMsgData data2;
        BaseImMsg imMsg;
        boolean result = false;
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, delete msg:%s", (Object[])new Object[]{groupId, msgId});
        }
        if ((imMsg = (data2 = this.getGroupMsgData(groupId)).findMsg(msgId)) != null) {
            BaseImMsg lastMsg;
            if (!StringUtils.equal((String)data2.lastReadMsgId, (String)imMsg.getMsgId())) {
                if (data2.unreadNum > 0L && StringUtils.isNotEmpty((String)data2.lastReadMsgId) && !GroupUtils.containFlag(imMsg.getFlags(), 2) && data2.isAfter(imMsg.getMsgId(), data2.lastReadMsgId)) {
                    this.updateUnreadData(groupId, data2, data2.unreadNum - 1L, data2.lastReadMsgId);
                }
            } else {
                BaseImMsg lastReadMsg = data2.getAheadMsg(imMsg);
                this.updateUnreadData(groupId, data2, data2.unreadNum, lastReadMsg != null ? lastReadMsg.getMsgId() : "");
            }
            data2.removeMsg(imMsg);
            if (StringUtils.equal((String)imMsg.getMsgId(), (String)data2.lastMsgId)) {
                lastMsg = data2.getLastMsg();
                this.updateLastMsgId(groupId, data2, lastMsg != null ? lastMsg.getMsgId() : "");
            }
            if (StringUtils.equal((String)imMsg.getMsgId(), (String)data2.lastNotHiidenMsgId)) {
                lastMsg = data2.getLastNotHiddenMsg();
                this.updateLastNotHiidenMsgId(groupId, data2, lastMsg != null ? lastMsg.getMsgId() : "");
            }
            long dbId = imMsg.getDBId();
            if (this.localModel != null) {
                if (dbId > 0L) {
                    boolean remove = this.localModel.deleteMsg(groupId, dbId);
                    if (!remove) {
                        this.localModel.deleteMsg(groupId, imMsg.getMsgId());
                    }
                } else {
                    this.localModel.deleteMsg(groupId, imMsg.getMsgId());
                }
            }
            result = true;
        } else {
            ChannelMsgData localMsgData;
            BaseImMsg findMsg;
            if (this.localModel != null) {
                result = this.localModel.deleteMsg(groupId, imMsg.getMsgId());
            }
            if ((findMsg = (localMsgData = this.getLocalMsgData(groupId)).findMsgByCseq(msgCseq, 100)) != null) {
                findMsg.setMsgState(3);
                localMsgData.removeMsg(findMsg);
                result = true;
            }
        }
        if (result && !notNotify) {
            this.notifyMsgDeleted(groupId, msgId);
        }
    }

    private void findMsgInner(final String groupId, String msgId, final IMsgService.IGetMsgCallBack callBack) {
        ChannelMsgData data2;
        BaseImMsg imMsg;
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, findMsg msgID:%s", (Object[])new Object[]{groupId, msgId});
        }
        if ((imMsg = (data2 = this.getGroupMsgData(groupId)).findMsg(msgId)) == null && this.localModel != null) {
            imMsg = this.localModel.find(groupId, msgId);
        }
        if (!ChannelDefine.sUnEnableLog) {
            if (imMsg != null) {
                MLog.info((Object)TAG, (String)"cid:%s, findMsg msgID:%s result:%s", (Object[])new Object[]{groupId, msgId, imMsg.toString()});
            } else {
                MLog.info((Object)TAG, (String)"cid:%s, not findMsg msgID:%s", (Object[])new Object[]{groupId, msgId});
            }
        }
        final BaseImMsg fImMsg = imMsg;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (callBack != null) {
                    callBack.onMsg(groupId, fImMsg);
                }
            }
        });
    }

    private void deleteMsgInner(String groupId, String msgId, String cseq) {
        this.deleteMsgInner(groupId, msgId, cseq, false);
    }

    private void findMsgInner(String groupId, IImMsgMatcher matcher, IMsgService.IGetMsgCallBack callBack) {
        ChannelMsgData data2;
        List imMsg;
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s", (Object[])new Object[]{groupId});
        }
        if ((imMsg = (data2 = this.getGroupMsgData(groupId)).getAllMsgs()) == null && this.localModel != null) {
            imMsg = this.localModel.findAll(groupId);
        }
        if (!ChannelDefine.sUnEnableLog) {
            if (imMsg != null) {
                MLog.info((Object)TAG, (String)"cid:%s, findMsg result:%s", (Object[])new Object[]{groupId, imMsg.toString()});
            } else {
                MLog.info((Object)TAG, (String)"cid:%s, not findMsg ", (Object[])new Object[]{groupId});
            }
        }
        BaseImMsg msgTarget = null;
        if (imMsg != null && !imMsg.isEmpty()) {
            ArrayList msgsCopy = new ArrayList(imMsg);
            for (int i = 0; i < msgsCopy.size(); ++i) {
                boolean match;
                BaseImMsg msg = (BaseImMsg)msgsCopy.get(i);
                if (matcher == null || !(match = matcher.match(msg, i))) continue;
                msgTarget = msg;
                break;
            }
        }
        BaseImMsg finalMsgTarget = msgTarget;
        YYTaskExecutor.postToMainThread(() -> {
            if (callBack != null) {
                callBack.onMsg(groupId, finalMsgTarget);
            }
        });
    }

    private boolean addMsgInner(String groupId, BaseImMsg section, boolean addByUser) {
        BaseImMsg findMsg;
        BaseImMsg msgToDelete;
        if (section == null) {
            return false;
        }
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, add msg:%s, cseqid:%s", (Object[])new Object[]{groupId, section.toString(), section.getCseq()});
        }
        ChannelMsgData data2 = this.getGroupMsgData(groupId);
        if (EnableMsgTest) {
            if (data2.msgs != null && data2.msgs.size() > 1000 && (msgToDelete = (BaseImMsg)data2.msgs.get(0)) != null) {
                this.deleteMsgInner(groupId, msgToDelete.getMsgId(), msgToDelete.getCseq(), true);
            }
        } else if (data2.msgs != null && data2.msgs.size() > 500 && (msgToDelete = (BaseImMsg)data2.msgs.get(0)) != null) {
            this.deleteMsgInner(groupId, msgToDelete.getMsgId(), msgToDelete.getCseq(), true);
        }
        if ((findMsg = data2.findMsg(section.getMsgId(), 100)) == null && StringUtils.isNotEmpty((String)section.getCseq())) {
            findMsg = data2.findMsgByCseq(section.getCseq(), 100);
        }
        if (findMsg != null) {
            if (addByUser) {
                return true;
            }
            if (findMsg.getMsgState() != 1) {
                findMsg.setMsgState(1);
                findMsg.setMsgId(section.getMsgId());
                findMsg.setSeqid(section.getSeqid());
                findMsg.setTs(section.getTs());
                this.notifyMsgStatuChanged(groupId, findMsg, 1);
                if (this.localModel != null) {
                    this.localModel.updateMsg(groupId, findMsg, section.getCseq(), section.getFrom());
                }
            }
            if (section.isFirstCharge()) {
                findMsg.setFirstCharge(true);
                if (this.localModel != null) {
                    this.localModel.updateMsg(groupId, findMsg, section.getCseq(), section.getFrom());
                }
            }
            return true;
        }
        if (!addByUser) {
            section.setMsgState(1);
        }
        if (data2.msgs == null) {
            data2.msgs = new ArrayList();
        }
        data2.msgs.add(section);
        if (data2.inPage) {
            this.updateUnreadData(groupId, data2, 0L, section.getMsgId());
        } else {
            if (data2.unreadNum < 0L) {
                data2.unreadNum = 0L;
            }
            if (!(section instanceof SysTextMsg || section instanceof HideMsg || GroupUtils.containFlag(section.getFlags(), 2))) {
                this.updateUnreadData(groupId, data2, data2.unreadNum + 1L, section.getMsgId());
            }
        }
        if (!GroupUtils.containFlag(section.getFlags(), 2)) {
            this.updateLastNotHiidenMsgId(groupId, data2, section.getMsgId());
        }
        this.updateLastMsgId(groupId, data2, section.getMsgId());
        if (this.localModel != null) {
            this.localModel.addMsg(groupId, section);
        }
        if (!addByUser) {
            this.notifyReceiveMsg(groupId, section);
        }
        return false;
    }

    @Override
    public void setUnreadNumZero(final String channelId) {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ChannelMsgData data2 = ChannelMsgModel.this.getGroupMsgData(channelId);
                ChannelMsgModel.this.updateUnreadData(channelId, data2, 0L, data2.getLastMsgId());
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)ChannelMsgModel.TAG, (String)"cid:%s, setUnreadNumZero", (Object[])new Object[]{channelId});
                }
            }
        }, 0L);
    }

    @Override
    public long getUnreadNum(ArrayList<String> groupIds, IMsgService.IGetUnreadNumsCallBack callBack) {
        return -1L;
    }

    @Override
    public void getLastMsg(final String channelId, final IMsgService.IGetMsgCallBack callBack) {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final BaseImMsg lastMsg = ChannelMsgModel.this.getGroupMsgData(channelId).getLastMsg();
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)ChannelMsgModel.TAG, (String)"cid:%s, getLastMsg:%s", (Object[])new Object[]{channelId, lastMsg != null ? lastMsg : ""});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onMsg(channelId, lastMsg);
                        }
                    }
                });
            }
        }, 0L);
    }

    @Override
    public void onReceiveMsg(final String channelId, final BaseImMsg section, final IChannelMsgModel.IReceiveMsgCallBack callBack) {
        if (section == null) {
            return;
        }
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                boolean handled = ChannelMsgModel.this.handleReceiveMsg(section);
                if (!handled) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callBack != null) {
                                callBack.onReceiveMsg(channelId, section);
                            }
                        }
                    });
                }
            }
        }, 0L);
    }

    private boolean handleReceiveMsg(BaseImMsg imMsg) {
        if (imMsg.isRevokeMsg()) {
            this.onReceiveRevokedMsg(imMsg.getCid(), imMsg);
            return true;
        }
        boolean find = this.addMsgInner(imMsg.getCid(), imMsg, false);
        if (find) {
            MLog.info((Object)TAG, (String)"onReceiveMsg, cid:%s, msg:%s, finded!", (Object[])new Object[]{imMsg.getCid(), imMsg});
            return true;
        }
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"onReceiveMsg, cid:%s, msg:%s", (Object[])new Object[]{imMsg.getCid(), imMsg});
        }
        return false;
    }

    @Override
    public void onReceiveMsgs(final List<BaseImMsg> sections, final IChannelMsgModel.IReceiveMsgCallBack callBack) {
        if (sections == null || sections.size() == 0) {
            return;
        }
        if (sections.size() == 1) {
            BaseImMsg imMsg = sections.get(0);
            if (imMsg != null) {
                this.onReceiveMsg(imMsg.getCid(), imMsg, callBack);
            } else {
                return;
            }
        }
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                boolean handled = false;
                ArrayList<BaseImMsg> notHandleMsgs = null;
                for (BaseImMsg imMsg : sections) {
                    if (imMsg == null) {
                        return;
                    }
                    handled = ChannelMsgModel.this.handleReceiveMsg(imMsg);
                    if (!handled) continue;
                    if (notHandleMsgs == null) {
                        notHandleMsgs = new ArrayList<BaseImMsg>(sections.size());
                    }
                    notHandleMsgs.add(imMsg);
                }
                final ArrayList msgsToHandle = new ArrayList(sections.size());
                msgsToHandle.addAll(sections);
                if (notHandleMsgs != null) {
                    msgsToHandle.removeAll(notHandleMsgs);
                }
                if (msgsToHandle.size() == 0) {
                    return;
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (BaseImMsg imMsg : msgsToHandle) {
                            if (imMsg == null || callBack == null) continue;
                            callBack.onReceiveMsg(imMsg.getCid(), imMsg);
                        }
                    }
                });
            }
        }, 0L);
    }

    private void onReceiveRevokedMsg(String channelId, BaseImMsg imMsg) {
        String content = ((MsgSection)imMsg.getSections().get(0)).getContent();
        JsonElement parse = new com.google.gson.JsonParser().parse(content);
        String msgid = parse.getAsJsonObject().get("msgid").getAsString();
        MLog.info((Object)TAG, (String)"onReceiveRevokedMsg msgid = %s", (Object[])new Object[]{msgid});
        this.notifyImageClose(channelId, msgid);
        this.replaceMsg(channelId, msgid, imMsg, 0);
    }

    private void notifyImageClose(String channelId, String msgid) {
        this.findMsg(channelId, msgid, (channelId1, oldImMsg) -> {
            if ((oldImMsg instanceof ImageMsg || oldImMsg instanceof TextImageMsg) && oldImMsg.getFrom() != AccountUtil.getUid()) {
                Message message = Message.obtain();
                message.what = BaseMsgDef.CLOSE_WINDOW_PHOTO_WHEN_MSG_REVOKED;
                Bundle bundle = new Bundle();
                bundle.putInt("from_entrance", 1);
                String url = null;
                url = oldImMsg instanceof ImageMsg ? ((ImageMsg)oldImMsg).getImageUrl() : ((TextImageMsg)oldImMsg).getImageMsg().getImageUrl();
                bundle.putString("url", url);
                message.setData(bundle);
                MsgDispatcher.getInstance().sendMessage(message);
            } else if (oldImMsg instanceof VideoMsg && oldImMsg.getMsgType() == 4) {
                String videoUrl = ((VideoMsg)oldImMsg).getVideoUrl();
                MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.MSG_REVOKE_GROUP_VIDEO_MSG, (Object)videoUrl);
            }
        });
    }

    @Override
    public void getHistoryMsgList(final String channelId, final CInterregion region, final IMsgService.MsgAnchor anchor, final int pullNum, final boolean nextFromColdData, final IMsgService.IGetMsgList callBack) {
        ICIMService icimService = (ICIMService)ServiceManagerProxy.getServiceManager().getService(ICIMService.class);
        if (!icimService.isOpened()) {
            icimService.initCIM();
            icimService.open(new ICIMService.IOpenCallBack(){

                public void onsuccess() {
                    ChannelMsgModel.this.getHistoryMsgListInner(channelId, region, anchor, pullNum, nextFromColdData, callBack);
                }

                public void onError(int errorCode, String tips) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callBack != null) {
                                callBack.onError(channelId, -1, "");
                            }
                        }
                    });
                }
            });
        } else {
            this.getHistoryMsgListInner(channelId, region, anchor, pullNum, nextFromColdData, callBack);
        }
    }

    private void getHistoryMsgListInner(String channelId, CInterregion region, final IMsgService.MsgAnchor anchor, int pullNum, boolean nextFromColdData, final IMsgService.IGetMsgList callBack) {
        ((ImService)ServiceManagerProxy.getService(ImService.class)).getHistoryMsgList(channelId, region, anchor, pullNum, nextFromColdData, new IMsgService.IGetMsgList(){

            public void onMsgs(final String channelId, final boolean hasMore, final boolean nextFromColdData, final IMsgService.MsgAnchor nextAnchor, final List<BaseImMsg> msgs) {
                if (msgs == null || msgs.size() <= 0) {
                    if (callBack != null) {
                        callBack.onMsgs(channelId, hasMore, nextFromColdData, nextAnchor, msgs);
                    }
                    return;
                }
                ChannelMsgModel.this.taskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ChannelMsgData msgData = ChannelMsgModel.this.getGroupMsgData(channelId);
                        msgData.addHistroyMsg(anchor, msgs, nextAnchor);
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (callBack != null) {
                                    callBack.onMsgs(channelId, hasMore, nextFromColdData, nextAnchor, msgs);
                                }
                            }
                        });
                    }
                }, 0L);
            }

            public boolean isUnSupportBelow_3_3(IMMsgItem msg) {
                if (callBack != null) {
                    return callBack.isUnSupportBelow_3_3(msg);
                }
                return false;
            }

            public BaseImMsg transformMsgItem(String msgId, IMMsgItem msg, ChannelPushContent pushContent) {
                if (callBack != null) {
                    return callBack.transformMsgItem(msgId, msg, pushContent);
                }
                return null;
            }

            public void onError(String channelId, int errorCode, String errorTips) {
                if (callBack != null) {
                    callBack.onError(channelId, errorCode, errorTips);
                }
            }
        });
    }

    @Override
    public void getMsgListByUid(final String channelId, final long uid, final int pullNum, final IMsgService.IGetMsgListByUidCallBack callBack) {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ChannelMsgData data2 = ChannelMsgModel.this.getGroupMsgData(channelId);
                if (data2.msgs == null || data2.msgs.size() <= 0) {
                    if (callBack != null) {
                        callBack.onMsgs(channelId, uid, pullNum, new ArrayList());
                    }
                    return;
                }
                final List uidMsgs = ChannelMsgModel.getMsgListByUid(data2.msgs, uid, pullNum);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onMsgs(channelId, uid, pullNum, uidMsgs);
                        }
                    }
                });
            }
        }, 0L);
    }

    @Override
    public void getMsgListByUidIncludeLocal(final String channelId, final long uid, final int pullNum, final IMsgService.IGetMsgListByUidCallBack callBack) {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ArrayList msgAll = new ArrayList();
                List onlineMsgs = ((ChannelMsgModel)ChannelMsgModel.this).getGroupMsgData((String)channelId).msgs;
                List localMsgs = ((ChannelMsgModel)ChannelMsgModel.this).getLocalMsgData((String)channelId).msgs;
                msgAll.addAll(ChannelMsgModel.getMsgListByUid(onlineMsgs, uid, pullNum));
                msgAll.addAll(ChannelMsgModel.getMsgListByUid(localMsgs, uid, pullNum));
                Collections.sort(msgAll, new BaseImMsg.BaseImMsgComparator());
                final List msgs = FP.subList(msgAll, (int)(msgAll.size() - pullNum), (int)msgAll.size());
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onMsgs(channelId, uid, pullNum, msgs);
                        }
                    }
                });
            }
        }, 0L);
    }

    private static List<BaseImMsg> getMsgListByUid(List<BaseImMsg> sourceList, long uid, int num) {
        if (sourceList != null) {
            ArrayList<BaseImMsg> uidMsgs = new ArrayList<BaseImMsg>();
            BaseImMsg imMsg = null;
            for (int i = sourceList.size() - 1; i >= 0; --i) {
                imMsg = sourceList.get(i);
                if (imMsg == null || imMsg.getFrom() != uid) continue;
                uidMsgs.add(imMsg);
                if (uidMsgs.size() >= num) break;
            }
            return uidMsgs;
        }
        return Collections.emptyList();
    }

    @Override
    public void addDataListener(final String channelId, final IMsgService.IDataListener listener2) {
        if (listener2 == null) {
            return;
        }
        if (RuntimeContext.sIsDebuggable && !YYTaskExecutor.isMainThread()) {
            throw new RuntimeException("lllllllllllll0");
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ChannelMsgModel.this.dataListeners == null) {
                    ChannelMsgModel.this.dataListeners = new ArrayList(2);
                } else {
                    IMsgService.IDataListener listenerReal = null;
                    for (DataUpdateListener item : ChannelMsgModel.this.dataListeners) {
                        if (item == null || item.listener == null || (listenerReal = (IMsgService.IDataListener)item.listener.get()) != listener2 || !StringUtils.equal((String)channelId, (String)item.groupId)) continue;
                        return;
                    }
                }
                ChannelMsgModel.this.dataListeners.add(new DataUpdateListener(channelId, listener2));
            }
        });
    }

    @Override
    public void removeDataListener(final String channelId, final IMsgService.IDataListener listener2) {
        if (listener2 == null || this.dataListeners == null || this.dataListeners.size() <= 0) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                IMsgService.IDataListener listenerReal = null;
                for (DataUpdateListener item : ChannelMsgModel.this.dataListeners) {
                    if (item == null || item.listener == null || (listenerReal = (IMsgService.IDataListener)item.listener.get()) != listener2 || !StringUtils.equal((String)channelId, (String)item.groupId)) continue;
                    ChannelMsgModel.this.dataListeners.remove(item);
                    return;
                }
            }
        });
    }

    private void notifyMsgDeleted(final String groupId, final String msgId) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ChannelMsgModel.this.dataListeners == null || ChannelMsgModel.this.dataListeners.size() == 0) {
                    return;
                }
                IMsgService.IDataListener listener2 = null;
                ArrayList<DataUpdateListener> listenerToDelete = null;
                for (DataUpdateListener item : ChannelMsgModel.this.dataListeners) {
                    if (item == null || item.listener == null) continue;
                    listener2 = (IMsgService.IDataListener)item.listener.get();
                    if (listener2 != null) {
                        if (!StringUtils.equal((String)item.groupId, (String)groupId)) continue;
                        listener2.onDeleteMsg(groupId, msgId);
                        continue;
                    }
                    if (listenerToDelete == null) {
                        listenerToDelete = new ArrayList<DataUpdateListener>(5);
                    }
                    listenerToDelete.add(item);
                }
                if (listenerToDelete != null) {
                    ChannelMsgModel.this.dataListeners.removeAll(listenerToDelete);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)ChannelMsgModel.TAG, (String)"notifyMsgDeleted cid:%s, msgId:%s", (Object[])new Object[]{groupId, msgId});
                }
            }
        });
    }

    private void notifyMsgStatuChanged(final String groupId, final BaseImMsg baseImMsg, final int state) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ChannelMsgModel.this.dataListeners == null || ChannelMsgModel.this.dataListeners.size() == 0) {
                    return;
                }
                IMsgService.IDataListener listener2 = null;
                ArrayList<DataUpdateListener> listenerToDelete = null;
                for (DataUpdateListener item : ChannelMsgModel.this.dataListeners) {
                    if (item == null || item.listener == null) continue;
                    listener2 = (IMsgService.IDataListener)item.listener.get();
                    if (listener2 != null) {
                        if (!StringUtils.equal((String)item.groupId, (String)groupId)) continue;
                        listener2.onMsgStatuChanged(baseImMsg, state);
                        continue;
                    }
                    if (listenerToDelete == null) {
                        listenerToDelete = new ArrayList<DataUpdateListener>(5);
                    }
                    listenerToDelete.add(item);
                }
                if (listenerToDelete != null) {
                    ChannelMsgModel.this.dataListeners.removeAll(listenerToDelete);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)ChannelMsgModel.TAG, (String)"notifyMsgStatuChanged cid:%s, msg:%s state:%d", (Object[])new Object[]{groupId, baseImMsg != null ? baseImMsg.toString() : "", state});
                }
            }
        });
    }

    private void notifyMsgSendErrored(final String groupId, final BaseImMsg baseImMsg, final long errorCode, final String errorMsg) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ChannelMsgModel.this.dataListeners == null || ChannelMsgModel.this.dataListeners.size() == 0) {
                    return;
                }
                IMsgService.IDataListener listener2 = null;
                ArrayList<DataUpdateListener> listenerToDelete = null;
                for (DataUpdateListener item : ChannelMsgModel.this.dataListeners) {
                    if (item == null || item.listener == null) continue;
                    listener2 = (IMsgService.IDataListener)item.listener.get();
                    if (listener2 != null) {
                        if (!StringUtils.equal((String)item.groupId, (String)groupId)) continue;
                        listener2.onMsgSendErrored(baseImMsg, errorCode, errorMsg);
                        continue;
                    }
                    if (listenerToDelete == null) {
                        listenerToDelete = new ArrayList<DataUpdateListener>(5);
                    }
                    listenerToDelete.add(item);
                }
                if (listenerToDelete != null) {
                    ChannelMsgModel.this.dataListeners.removeAll(listenerToDelete);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)ChannelMsgModel.TAG, (String)"notifyMsgSendErrored cid:%s, msg:%s errorCode:%d", (Object[])new Object[]{groupId, baseImMsg != null ? baseImMsg.toString() : "", errorCode});
                }
            }
        });
    }

    private void notifyMsgReplaced(final String groupId, final BaseImMsg baseImMsg, final BaseImMsg newMsg, final int reason) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ChannelMsgModel.this.dataListeners == null || ChannelMsgModel.this.dataListeners.size() == 0) {
                    return;
                }
                IMsgService.IDataListener listener2 = null;
                ArrayList<DataUpdateListener> listenerToDelete = null;
                for (DataUpdateListener item : ChannelMsgModel.this.dataListeners) {
                    if (item == null || item.listener == null) continue;
                    listener2 = (IMsgService.IDataListener)item.listener.get();
                    if (listener2 != null) {
                        if (!StringUtils.equal((String)item.groupId, (String)groupId)) continue;
                        listener2.onMsgReplaced(baseImMsg, newMsg, reason);
                        continue;
                    }
                    if (listenerToDelete == null) {
                        listenerToDelete = new ArrayList<DataUpdateListener>(5);
                    }
                    listenerToDelete.add(item);
                }
                if (listenerToDelete != null) {
                    ChannelMsgModel.this.dataListeners.removeAll(listenerToDelete);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)ChannelMsgModel.TAG, (String)"notifyMsgReplaced cid:%s, msg:%s createMsg:%s", (Object[])new Object[]{groupId, baseImMsg != null ? baseImMsg.toString() : "", newMsg != null ? newMsg.toString() : ""});
                }
            }
        });
    }

    private void notifyReceiveMsg(final String groupId, final BaseImMsg msg) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ChannelMsgModel.this.dataListeners == null || ChannelMsgModel.this.dataListeners.size() == 0) {
                    return;
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)ChannelMsgModel.TAG, (String)"notifyReceiveMsg cid:%s, msg:%s, listener size:%d", (Object[])new Object[]{groupId, msg, ChannelMsgModel.this.dataListeners != null ? ChannelMsgModel.this.dataListeners.size() : 0});
                }
                IMsgService.IDataListener listener2 = null;
                ArrayList<DataUpdateListener> listenerToDelete = null;
                for (DataUpdateListener item : ChannelMsgModel.this.dataListeners) {
                    if (item == null || item.listener == null) continue;
                    listener2 = (IMsgService.IDataListener)item.listener.get();
                    if (listener2 != null) {
                        if (StringUtils.equal((String)item.groupId, (String)groupId) || listener2.expectMsg(groupId, msg)) {
                            listener2.onReceiveMsg(msg);
                            continue;
                        }
                        if (ChannelDefine.sUnEnableLog) continue;
                        MLog.info((Object)ChannelMsgModel.TAG, (String)"notifyReceiveMsg cid:%s, msg:%s, listener:%s, listengroup:%s", (Object[])new Object[]{groupId, msg, listener2, item.groupId});
                        continue;
                    }
                    if (listenerToDelete == null) {
                        listenerToDelete = new ArrayList<DataUpdateListener>(5);
                    }
                    listenerToDelete.add(item);
                }
                if (listenerToDelete != null) {
                    ChannelMsgModel.this.dataListeners.removeAll(listenerToDelete);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)ChannelMsgModel.TAG, (String)"notifyReceiveMsg cid:%s, msg:%s", (Object[])new Object[]{groupId, msg != null ? msg.toString() : ""});
                }
            }
        });
    }

    private void notifyunReadNumChange(final String groupId, final long unreadNum) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ChannelMsgModel.this.dataListeners == null || ChannelMsgModel.this.dataListeners.size() == 0) {
                    return;
                }
                IMsgService.IDataListener listener2 = null;
                ArrayList<DataUpdateListener> listenerToDelete = null;
                for (DataUpdateListener item : ChannelMsgModel.this.dataListeners) {
                    if (item == null || item.listener == null) continue;
                    listener2 = (IMsgService.IDataListener)item.listener.get();
                    if (listener2 != null) {
                        if (!StringUtils.equal((String)item.groupId, (String)groupId)) continue;
                        listener2.onUnreadNumChange(groupId, unreadNum);
                        continue;
                    }
                    if (listenerToDelete == null) {
                        listenerToDelete = new ArrayList<DataUpdateListener>(5);
                    }
                    listenerToDelete.add(item);
                }
                if (listenerToDelete != null) {
                    ChannelMsgModel.this.dataListeners.removeAll(listenerToDelete);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)ChannelMsgModel.TAG, (String)"notifyReceiveMsg cid:%s, unreadNum:%s", (Object[])new Object[]{groupId, String.valueOf(unreadNum)});
                }
            }
        });
    }

    private void handleMsgStates(final String groupId, final BaseImMsg msg, final int state, String msgId, long ts) {
        if (state == 1) {
            if (msg.getMsgState() != 1) {
                msg.setMsgId(msgId);
                msg.setSeqid(msg.getSeqid());
                msg.setMsgState(state);
                msg.setTs(ts);
                this.taskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (ChannelMsgModel.this.localModel != null) {
                            ChannelMsgModel.this.localModel.updateMsg(groupId, msg, msg.getCseq(), msg.getFrom());
                        }
                        ChannelMsgModel.this.notifyMsgStatuChanged(groupId, msg, state);
                    }
                }, 0L);
            }
        } else if (state == 2 && msg.getMsgState() != 2 && msg.getMsgState() != 1) {
            this.taskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    msg.setMsgState(state);
                    if (ChannelMsgModel.this.localModel != null) {
                        ChannelMsgModel.this.localModel.updateMsg(groupId, msg, msg.getCseq(), msg.getFrom());
                    }
                    ChannelMsgModel.this.notifyMsgStatuChanged(groupId, msg, state);
                }
            }, 0L);
        }
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"handleMsgStates cid:%s, msgid:%s, ts:%s", (Object[])new Object[]{groupId, msgId, String.valueOf(ts)});
        }
    }

    @Override
    public void sendMsg(final String channelId, final BaseImMsg msgItem) {
        if (GuestLoginUtils.checkAndShowGuide((int)15)) {
            msgItem.setMsgState(2);
            return;
        }
        if (EnableMsgTest) {
            this.sendTest(channelId, msgItem);
        } else {
            if (msgItem == null) {
                MLog.error((Object)TAG, (String)"sendMsg input msg null error!!!", (Object[])new Object[0]);
                return;
            }
            this.taskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ChannelMsgModel.this.sendMsgInner(channelId, msgItem);
                }
            }, 0L);
        }
    }

    private void sendTest(final String groupId, final BaseImMsg msgItem) {
        if (msgItem == null) {
            MLog.error((Object)TAG, (String)"sendMsg input msg null error!!!", (Object[])new Object[0]);
            return;
        }
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ChannelMsgModel.this.sendMsgInner(groupId, msgItem);
            }
        }, 0L);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                testIndex = testIndex + 1;
                BaseImMsgWrap imMsg = new BaseImMsgWrap(msgItem);
                imMsg.setMsgId("" + testIndex);
                imMsg.setCseq("" + testIndex);
                ChannelMsgModel.this.sendMsg(groupId, (BaseImMsg)imMsg);
            }
        }, (long)1200L);
    }

    private void sendMsgInner(final String groupId, final BaseImMsg msgItem) {
        if (msgItem == null) {
            MLog.error((Object)TAG, (String)"sendMsg input msg null error!!!", (Object[])new Object[0]);
            return;
        }
        List section = msgItem.getSections();
        if (section == null || section.isEmpty()) {
            MLog.error((Object)TAG, (String)"sendMsg input msg section empty!!!", (Object[])new Object[0]);
            return;
        }
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"sendMsg cid:%s, msg:%s, cseqid:%s", (Object[])new Object[]{groupId, msgItem.toString(), msgItem.getCseq()});
        }
        if (StringUtils.isEmpty((String)msgItem.getCseq()) && ServiceManagerProxy.getService(IPublicScreenService.class) != null) {
            msgItem.setCseq(((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().getLocalCseq());
        }
        this.addMsgInner(groupId, msgItem, true);
        String trackHasMention = "0";
        String trackMentionUid = "";
        MsgBizExt msgBizExt = msgItem.getMsgBizExt();
        if (msgBizExt != null && msgBizExt.getInterfaceType() == 1) {
            SendMsgReq.Builder builder = new SendMsgReq.Builder();
            builder.group_type = GroupType.GROUP_TYPE_GAME.getValue();
            builder.group_id = groupId;
            builder.seq_id = msgItem.getCseq();
            for (MsgSection sec : section) {
                builder.sections.add(new IMMsgSection.Builder().content(StringUtils.isNotEmpty((String)sec.getContent()) ? sec.getContent() : "").type(Integer.valueOf(sec.getType())).color(StringUtils.isNotEmpty((String)sec.getColor()) ? sec.getColor() : "").extention(StringUtils.isNotEmpty((String)sec.getExtention()) ? sec.getExtention() : "").jump(StringUtils.isNotEmpty((String)sec.getJump()) ? sec.getJump() : "").trans(StringUtils.isNotEmpty((String)sec.getTrans()) ? sec.getTrans() : "").build());
                if (sec.getType() != 2005) continue;
                trackHasMention = "1";
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)sec.getContent());
                    trackMentionUid = jsonObject.optString("uid");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            final String finalTrackHasMention = trackHasMention;
            final String finalTrackMentionUid = trackMentionUid;
            final long startTime = SystemClock.uptimeMillis();
            ProtoManager.getInstance().sendRpc(groupId, (AndroidMessage)builder.build(), (IProtoCallback)new IProtoCallback<SendMsgRes>(){

                public void onResponse(@NonNull SendMsgRes message, long code, String msg) {
                    super.onResponse((AndroidMessage)message, code, msg);
                    IMMsgItem imMsgItem = message.msg;
                    if (ProtoManager.isSuccessCode((long)code)) {
                        RoomTrack.INSTANCE.roomSpeakSuccess(groupId, finalTrackHasMention, finalTrackMentionUid);
                        List serverSectionsList = null;
                        List localSectionList = null;
                        if (imMsgItem != null && !FP.empty((Collection)(serverSectionsList = imMsgItem.sections)) && !FP.empty((Collection)(localSectionList = msgItem.getSections()))) {
                            int minSum = serverSectionsList.size() >= localSectionList.size() ? localSectionList.size() : serverSectionsList.size();
                            String extention = null;
                            for (int i = 0; i < minSum; ++i) {
                                extention = ((IMMsgSection)serverSectionsList.get((int)i)).extention;
                                if (!StringUtils.isNotEmpty((String)extention)) continue;
                                ((MsgSection)localSectionList.get(i)).setExtention(extention);
                            }
                        }
                        if (imMsgItem != null && imMsgItem.from_umark != null) {
                            ArrayList honorIds = new ArrayList(imMsgItem.from_umark.medal_id);
                            msgItem.setHonerIds(honorIds);
                            if (ServiceManagerProxy.getService(IChannelHonorService.class) != null) {
                                ((IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)).updateSelfHonorIds(honorIds);
                            }
                            if (imMsgItem.from_umark.cards != null) {
                                ArrayList<com.yy.hiyo.channel.base.bean.SimpleCardInfo> list2 = new ArrayList<com.yy.hiyo.channel.base.bean.SimpleCardInfo>();
                                for (SimpleCardInfo cardInfo : imMsgItem.from_umark.cards) {
                                    list2.add(new com.yy.hiyo.channel.base.bean.SimpleCardInfo(cardInfo.card_type.intValue(), cardInfo.level.intValue(), cardInfo.name, cardInfo.fid, cardInfo.sub_type));
                                }
                                msgItem.getUserTagInfos().postValue(list2);
                                ((IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)).updateSelfUserTags(list2);
                            }
                            if (imMsgItem.from_uinfo != null) {
                                PrivilegeHelper.INSTANCE.saveChatExt(imMsgItem.from_uinfo.uid, imMsgItem.from_umark.chat_bubble_id, imMsgItem.from_umark.nick_color_id);
                            }
                        }
                        ChannelMsgModel.this.handleMsgStates(groupId, msgItem, 1, imMsgItem.msgid, imMsgItem.ts);
                        MLog.info((Object)ChannelMsgModel.TAG, (String)"sendMsg success:%d, msg:%s, msgID:%s", (Object[])new Object[]{code, message, imMsgItem.msgid});
                        BaseRequestManager.statMetric((String)"channel/sendmsg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)0L);
                    } else {
                        ChannelMsgModel.this.handleMsgStates(groupId, msgItem, 2, imMsgItem.msgid, imMsgItem.ts);
                        ChannelMsgModel.this.notifyMsgSendErrored(groupId, msgItem, code, message.result.errmsg);
                        BaseRequestManager.statMetric((String)"channel/sendmsg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                        MLog.info((Object)ChannelMsgModel.TAG, (String)"sendMsg fail:%d, msg:%s, msgID:%s", (Object[])new Object[]{code, message, imMsgItem.msgid});
                    }
                }

                public boolean retryWhenTimeout(boolean canRetry) {
                    BaseRequestManager.statMetric((String)"channel/sendmsg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ChannelMsgModel.this.handleMsgStates(groupId, msgItem, 2, "", -1L);
                        }
                    }, (long)5000L);
                    MLog.error((Object)ChannelMsgModel.TAG, (String)"retryWhenTimeout:%b", (Object[])new Object[]{canRetry});
                    return false;
                }

                public boolean retryWhenError(boolean canRetry, String reason, int code) {
                    MLog.error((Object)ChannelMsgModel.TAG, (String)"retryWhenError can retry:%b, reason:%s, code:%d", (Object[])new Object[]{canRetry, reason, code});
                    BaseRequestManager.statMetric((String)"channel/sendmsg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ChannelMsgModel.this.handleMsgStates(groupId, msgItem, 2, "", -1L);
                        }
                    }, (long)5000L);
                    return false;
                }

                public long getCacheEffectiveTime() {
                    return 0L;
                }
            });
        } else {
            SendMsgReq.Builder builder = new SendMsgReq.Builder().to_cid(groupId);
            builder.cseq(StringUtils.isNotEmpty((String)msgItem.getCseq()) ? msgItem.getCseq() : "");
            for (MsgSection sec : section) {
                builder.sections.add(new IMMsgSection.Builder().content(StringUtils.isNotEmpty((String)sec.getContent()) ? sec.getContent() : "").type(Integer.valueOf(sec.getType())).color(StringUtils.isNotEmpty((String)sec.getColor()) ? sec.getColor() : "").extention(StringUtils.isNotEmpty((String)sec.getExtention()) ? sec.getExtention() : "").jump(StringUtils.isNotEmpty((String)sec.getJump()) ? sec.getJump() : "").trans(StringUtils.isNotEmpty((String)sec.getTrans()) ? sec.getTrans() : "").build());
                if (sec.getType() != 2005) continue;
                trackHasMention = "1";
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)sec.getContent());
                    trackMentionUid = jsonObject.optString("uid");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            final String finalTrackHasMention = trackHasMention;
            final String finalTrackMentionUid = trackMentionUid;
            final long startTime = SystemClock.uptimeMillis();
            ProtoManager.getInstance().sendRpc(groupId, (AndroidMessage)builder.build(), (IProtoCallback)new IProtoCallback<net.ihago.channel.srv.mgr.SendMsgRes>(){

                public void onResponse(@NonNull net.ihago.channel.srv.mgr.SendMsgRes message, long code, String msg) {
                    super.onResponse((AndroidMessage)message, code, msg);
                    IMMsgItem imMsgItem = message.msg;
                    if (ProtoManager.isSuccessCode((long)code)) {
                        RoomTrack.INSTANCE.roomSpeakSuccess(groupId, finalTrackHasMention, finalTrackMentionUid);
                        List serverSectionsList = null;
                        List localSectionList = null;
                        if (imMsgItem != null && !FP.empty((Collection)(serverSectionsList = imMsgItem.sections)) && !FP.empty((Collection)(localSectionList = msgItem.getSections()))) {
                            int minSum = serverSectionsList.size() >= localSectionList.size() ? localSectionList.size() : serverSectionsList.size();
                            String extention = null;
                            for (int i = 0; i < minSum; ++i) {
                                extention = ((IMMsgSection)serverSectionsList.get((int)i)).extention;
                                if (!StringUtils.isNotEmpty((String)extention)) continue;
                                ((MsgSection)localSectionList.get(i)).setExtention(extention);
                            }
                        }
                        if (imMsgItem != null && imMsgItem.from_umark != null) {
                            ArrayList honorIds = new ArrayList(imMsgItem.from_umark.medal_id);
                            msgItem.setHonerIds(honorIds);
                            if (ServiceManagerProxy.getService(IChannelHonorService.class) != null) {
                                ((IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)).updateSelfHonorIds(honorIds);
                            }
                            if (imMsgItem.from_umark.cards != null) {
                                ArrayList<com.yy.hiyo.channel.base.bean.SimpleCardInfo> list2 = new ArrayList<com.yy.hiyo.channel.base.bean.SimpleCardInfo>();
                                for (SimpleCardInfo cardInfo : imMsgItem.from_umark.cards) {
                                    list2.add(new com.yy.hiyo.channel.base.bean.SimpleCardInfo(cardInfo.card_type.intValue(), cardInfo.level.intValue(), cardInfo.name, cardInfo.fid, cardInfo.sub_type));
                                }
                                msgItem.getUserTagInfos().postValue(list2);
                                ((IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)).updateSelfUserTags(list2);
                            }
                            if (imMsgItem.from_uinfo != null) {
                                PrivilegeHelper.INSTANCE.saveChatExt(imMsgItem.from_uinfo.uid, imMsgItem.from_umark.chat_bubble_id, imMsgItem.from_umark.nick_color_id);
                            }
                        }
                        ChannelMsgModel.this.handleMsgStates(groupId, msgItem, 1, imMsgItem.msgid, imMsgItem.ts);
                        MLog.info((Object)ChannelMsgModel.TAG, (String)"sendMsg success:%d, msg:%s, msgID:%s", (Object[])new Object[]{code, message, imMsgItem.msgid});
                        BaseRequestManager.statMetric((String)"channel/sendmsg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)0L);
                    } else {
                        ChannelMsgModel.this.handleMsgStates(groupId, msgItem, 2, imMsgItem.msgid, imMsgItem.ts);
                        ChannelMsgModel.this.notifyMsgSendErrored(groupId, msgItem, code, message.result.errmsg);
                        BaseRequestManager.statMetric((String)"channel/sendmsg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                        MLog.info((Object)ChannelMsgModel.TAG, (String)"sendMsg fail:%d, msg:%s, msgID:%s", (Object[])new Object[]{code, message, imMsgItem.msgid});
                    }
                }

                public boolean retryWhenTimeout(boolean canRetry) {
                    BaseRequestManager.statMetric((String)"channel/sendmsg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ChannelMsgModel.this.handleMsgStates(groupId, msgItem, 2, "", -1L);
                        }
                    }, (long)5000L);
                    MLog.error((Object)ChannelMsgModel.TAG, (String)"retryWhenTimeout:%b", (Object[])new Object[]{canRetry});
                    return false;
                }

                public boolean retryWhenError(boolean canRetry, String reason, int code) {
                    MLog.error((Object)ChannelMsgModel.TAG, (String)"retryWhenError can retry:%b, reason:%s, code:%d", (Object[])new Object[]{canRetry, reason, code});
                    BaseRequestManager.statMetric((String)"channel/sendmsg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ChannelMsgModel.this.handleMsgStates(groupId, msgItem, 2, "", -1L);
                        }
                    }, (long)5000L);
                    return false;
                }
            });
        }
    }

    public void loginOut() {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (ChannelMsgModel.this.localModel != null) {
                    ChannelMsgModel.this.localModel.loginOut();
                }
            }
        }, 0L);
    }

    public void destroy() {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ChannelMsgModel.this.onlineMsgMap.clear();
                ChannelMsgModel.this.localMsgMap.clear();
            }
        }, 0L);
        if (this.dataListeners != null) {
            this.dataListeners.clear();
        }
    }

    public void onTrimMemory() {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Set keys = ChannelMsgModel.this.onlineMsgMap.keySet();
                ChannelMsgData item = null;
                for (String key : keys) {
                    if (!StringUtils.isNotEmpty((String)key) || (item = (ChannelMsgData)ChannelMsgModel.this.onlineMsgMap.get(key)) == null) continue;
                    item.onTrimMemory();
                }
            }
        }, 0L);
    }

    static {
        if (RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        EnableMsgTest = false;
        testIndex = 0;
    }

    private static class DataUpdateListener {
        String groupId;
        WeakReference<IMsgService.IDataListener> listener;

        DataUpdateListener(String groupId, IMsgService.IDataListener listener2) {
            this.groupId = groupId;
            this.listener = new WeakReference<IMsgService.IDataListener>(listener2);
        }
    }
}

