/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.media;

import android.app.Activity;
import android.os.SystemClock;
import androidx.annotation.MainThread;
import biz.MediaToken;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.live.LiveCallback;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.SeatStatusUtils;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.MediaData;
import com.yy.hiyo.channel.base.bean.MediaTokenInfo;
import com.yy.hiyo.channel.base.bean.RoomlistEventBean;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IMediaService;
import com.yy.hiyo.channel.base.service.IOperationCallback;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.base.service.intercepter.IMediaIntercepter;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.base.service.video.ILiveVideoPlayer;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.utils.perf.ChannelPathLog;
import com.yy.hiyo.channel.component.seat.SeatTrack;
import com.yy.hiyo.channel.service.BaseService;
import com.yy.hiyo.channel.service.data.ILocalDataModel;
import com.yy.hiyo.channel.service.media.AudioNotifyDef;
import com.yy.hiyo.channel.service.media.InvalidVoiceReporter;
import com.yy.hiyo.channel.service.media.MediaServiceImpl;
import com.yy.hiyo.channel.service.media.VoiceModel;
import com.yy.hiyo.voice.base.VoiceConstant;
import com.yy.hiyo.voice.base.bean.event.VoiceCallBack;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.mediav1.bean.IMediaRoom;
import com.yy.hiyo.voice.base.mediav1.service.IMediaRoomService;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ef\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0017*\u0001\u001f\u0018\u0000 \u0093\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0004\u0093\u0001\u0094\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u00100\u001a\u000201H\u0002J\u001c\u00102\u001a\u0002012\b\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u000106H\u0002J\"\u00107\u001a\u0002012\u0006\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020\u000f2\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u001e\u0010<\u001a\u0002012\u0014\u0010=\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020?\u0018\u00010>H\u0003J\u0010\u0010@\u001a\u0002012\u0006\u0010A\u001a\u00020\rH\u0002J\u0016\u0010B\u001a\u0002012\f\u0010C\u001a\b\u0012\u0004\u0012\u00020E0DH\u0003J\u0010\u0010F\u001a\u0002012\u0006\u0010G\u001a\u00020?H\u0016J\u0010\u0010H\u001a\u0002012\u0006\u0010G\u001a\u00020?H\u0016J\b\u0010I\u001a\u000201H\u0017J\b\u0010J\u001a\u0004\u0018\u00010\u000bJ\b\u0010K\u001a\u00020LH\u0002J\b\u0010M\u001a\u00020NH\u0016J\b\u0010O\u001a\u00020\u001aH\u0016J\n\u0010P\u001a\u0004\u0018\u00010\u001cH\u0016J\u000e\u0010Q\u001a\u00020\r2\u0006\u00105\u001a\u000206J\b\u0010R\u001a\u00020\u000fH\u0016J\u0010\u0010S\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\rH\u0002J\u0010\u0010T\u001a\u0002012\u0006\u00105\u001a\u000206H\u0016J\u000e\u0010U\u001a\u0002012\u0006\u00105\u001a\u000206J(\u0010V\u001a\u0002012\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020?2\u0006\u0010Z\u001a\u00020?2\u0006\u0010\u0005\u001a\u00020?H\u0016J.\u0010[\u001a\u0002012\b\u0010\\\u001a\u0004\u0018\u0001042\b\u00108\u001a\u0004\u0018\u0001042\b\u0010W\u001a\u0004\u0018\u00010X2\u0006\u0010]\u001a\u00020\rH\u0016J\u0012\u0010^\u001a\u0002012\b\u0010W\u001a\u0004\u0018\u00010XH\u0016J\u0010\u0010_\u001a\u0002012\u0006\u0010`\u001a\u00020?H\u0016J\u001e\u0010_\u001a\u0002012\u0014\u0010a\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020?\u0018\u00010>H\u0016J\b\u0010b\u001a\u000201H\u0016J \u0010c\u001a\u0002012\u0006\u0010\u0005\u001a\u0002042\u0006\u00108\u001a\u00020\r2\u0006\u0010d\u001a\u00020?H\u0016J$\u0010c\u001a\u0002012\b\u0010\u0005\u001a\u0004\u0018\u0001042\b\u0010e\u001a\u0004\u0018\u0001042\u0006\u0010d\u001a\u00020?H\u0016J \u0010f\u001a\u0002012\u0006\u0010g\u001a\u00020\u000f2\u0006\u0010h\u001a\u00020i2\u0006\u0010W\u001a\u00020jH\u0016J\b\u0010k\u001a\u000201H\u0016J\u0010\u0010l\u001a\u0002012\u0006\u0010m\u001a\u00020nH\u0016J\u0010\u0010o\u001a\u0002012\u0006\u0010p\u001a\u00020?H\u0016J\u001c\u0010q\u001a\u0002012\b\u0010W\u001a\u0004\u0018\u00010X2\b\u00108\u001a\u0004\u0018\u000104H\u0016J\u0010\u0010r\u001a\u0002012\u0006\u0010s\u001a\u00020\u000fH\u0016J$\u0010t\u001a\u0002012\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020?0>2\u0006\u0010u\u001a\u00020?H\u0016J(\u0010v\u001a\u0002012\u0006\u0010w\u001a\u00020\r2\u0006\u0010x\u001a\u00020?2\u0006\u0010y\u001a\u00020?2\u0006\u0010z\u001a\u00020?H\u0016J(\u0010{\u001a\u0002012\u0006\u0010w\u001a\u00020\r2\u0006\u0010x\u001a\u00020?2\u0006\u0010y\u001a\u00020?2\u0006\u0010s\u001a\u00020\u000fH\u0016J\u0010\u0010|\u001a\u0002012\u0006\u0010w\u001a\u00020\rH\u0016J\u0010\u0010}\u001a\u0002012\u0006\u0010w\u001a\u00020\rH\u0016J\b\u0010.\u001a\u00020~H\u0016J\u0011\u0010\u007f\u001a\u0002012\u0007\u0010\u0080\u0001\u001a\u00020\u0004H\u0016J\u0014\u0010\u0081\u0001\u001a\u0002012\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u0003H\u0016J\t\u0010\u0083\u0001\u001a\u000201H\u0002J\u0012\u0010\u0084\u0001\u001a\u0002012\u0007\u0010\u0085\u0001\u001a\u00020\u000bH\u0016J\u0014\u0010\u0086\u0001\u001a\u0002012\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u001cH\u0016J\u0012\u0010\u0088\u0001\u001a\u0002012\u0007\u0010\u0089\u0001\u001a\u00020\u000fH\u0002J\u001b\u0010\u008a\u0001\u001a\u0002012\u0007\u0010\u008b\u0001\u001a\u00020\u000f2\u0007\u0010\u008c\u0001\u001a\u000204H\u0002J$\u0010\u008d\u0001\u001a\u0002012\u0007\u0010\u008b\u0001\u001a\u00020\u000f2\u0007\u0010\u008e\u0001\u001a\u00020\u000f2\u0007\u0010\u008c\u0001\u001a\u000204H\u0002J\u0012\u0010\u008f\u0001\u001a\u0002012\u0007\u0010\u0080\u0001\u001a\u00020\u0004H\u0016J\u0014\u0010\u0090\u0001\u001a\u0002012\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u0003H\u0016J\t\u0010\u0091\u0001\u001a\u000201H\u0016J\u0017\u0010\u0092\u0001\u001a\u0002012\f\u0010C\u001a\b\u0012\u0004\u0012\u00020E0DH\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0014j\b\u0012\u0004\u0012\u00020\r`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0014j\b\u0012\u0004\u0012\u00020\u0003`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0095\u0001"}, d2={"Lcom/yy/hiyo/channel/service/media/MediaServiceImpl;", "Lcom/yy/hiyo/channel/service/BaseService;", "Lcom/yy/hiyo/channel/base/service/IMediaService;", "Lcom/yy/hiyo/voice/base/bean/event/VoiceCallBack;", "Lcom/yy/appbase/live/LiveCallback;", "channel", "Lcom/yy/hiyo/channel/base/service/IChannel;", "localGroupDataManager", "Lcom/yy/hiyo/channel/service/data/ILocalDataModel;", "(Lcom/yy/hiyo/channel/base/service/IChannel;Lcom/yy/hiyo/channel/service/data/ILocalDataModel;)V", "mContext", "Landroid/app/Activity;", "mEnableMicElapsedStartTime", "", "mFirstAudioPlayDataBackJustForStat", "", "mFirstAudioPlaySpectrumDataForStat", "mFirstAudioPlayTimestampForStat", "mFirstMediaSizeChangeForStat", "mInvalidUids", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "mInvalidVoiceReporter", "Lcom/yy/hiyo/channel/service/media/InvalidVoiceReporter;", "mIsInRoom", "mMediaData", "Lcom/yy/hiyo/channel/base/bean/MediaData;", "mMediaIntercepter", "Lcom/yy/hiyo/channel/base/service/intercepter/IMediaIntercepter;", "mOnSpeakListenerSet", "mPluginListener", "com/yy/hiyo/channel/service/media/MediaServiceImpl$mPluginListener$1", "Lcom/yy/hiyo/channel/service/media/MediaServiceImpl$mPluginListener$1;", "mSeatChangeListener", "Lcom/yy/hiyo/channel/base/service/ISeatUpdateListener;", "mSpeakingElapsedStartTime", "mSpeakingPreviousStatus", "Ljava/util/concurrent/atomic/AtomicInteger;", "mSpeakingTime", "mSpeakingUploadTime", "mUpdateTokenRunnable", "Ljava/lang/Runnable;", "mVideoListener", "", "mVoiceModel", "Lcom/yy/hiyo/channel/service/media/VoiceModel;", "pendingCallback", "Lcom/yy/hiyo/channel/service/media/MediaServiceImpl$PendingCallback;", "addSeatUpdateListener", "", "changeAudioAndVideoMute", "channelId", "", "pluginData", "Lcom/yy/hiyo/channel/base/bean/plugins/ChannelPluginData;", "changeMicByOwner", "uid", "open", "callback", "Lcom/yy/hiyo/channel/base/service/IOperationCallback;", "checkInvalidSpeaker", "speakList", "", "", "checkMediaTokenExpired", "expireTime", "checkUnmute", "seatUserList", "", "Lcom/yy/hiyo/channel/base/bean/SeatUser;", "disablePublishMic", "optFrom", "enablePublishMic", "exitRoom", "getContext", "getLiveService", "Lcom/yy/hiyo/voice/base/channelvoice/IKtvLiveServiceExtend;", "getLiveVideoPlayer", "Lcom/yy/hiyo/channel/base/service/video/ILiveVideoPlayer;", "getMediaData", "getMediaIntercepter", "getSceneId", "isInMultiRoom", "isValidSpeaker", "joinMultiRoom", "joinMultiRoomInner", "onAudioCapturePcmData", "data", "", "dataSize", "sampleRate", "onAudioPlayData", "roomId", "duration", "onAudioPlaySpectrumData", "onAudioPlayTimestamp", "playTimestamp", "audioVolumeMap", "onDestroy", "onJoinChannelSuccess", "elapsed", "p1", "onJoined", "rejoin", "info", "Lcom/yy/hiyo/channel/base/bean/ChannelDetailInfo;", "Lcom/yy/hiyo/channel/base/bean/EnterChannelData;", "onLeaved", "onPreJoin", "enterParam", "Lcom/yy/hiyo/channel/base/EnterParam;", "onReceiveAppMsgDataFailedStatus", "status", "onReceiveUserAppMsgData", "onSourceChange", "isCdn", "onSpeakingChanged", "streamType", "onVideoSizeChange", "anchorId", "width", "height", "rotation", "onVideoStart", "onVideoStop", "onVideoStreamOpen", "Lcom/yy/hiyo/channel/base/service/IMediaService$IMediaPendingCallback;", "registerLiveListener", "liveCallback", "registerOnSpeakListener", "onSpeakListener", "removeSeatUpdateListener", "setContext", "context", "setMediaIntercepter", "intercepter", "setVoiceRoomInMic", "isOpen", "statisticMicOpenTime", "start", "pluginId", "statisticsSpeakingTime", "forceUpload", "unregisterLiveListener", "unregisterOnSpeakListener", "updateMediaToken", "updateMyMicStatus", "Companion", "PendingCallback", "channel-components_release"})
public final class MediaServiceImpl
extends BaseService
implements IMediaService,
VoiceCallBack,
LiveCallback {
    private final VoiceModel mVoiceModel;
    private Activity mContext;
    private final MediaData mMediaData;
    private InvalidVoiceReporter mInvalidVoiceReporter;
    private final HashSet<VoiceCallBack> mOnSpeakListenerSet;
    private final HashSet<Long> mInvalidUids;
    private boolean mIsInRoom;
    private ISeatUpdateListener mSeatChangeListener;
    private final Set<LiveCallback> mVideoListener;
    private final PendingCallback pendingCallback;
    private boolean mFirstAudioPlayDataBackJustForStat;
    private boolean mFirstAudioPlaySpectrumDataForStat;
    private boolean mFirstAudioPlayTimestampForStat;
    private boolean mFirstMediaSizeChangeForStat;
    private long mEnableMicElapsedStartTime;
    private long mSpeakingElapsedStartTime;
    private long mSpeakingTime;
    private AtomicInteger mSpeakingPreviousStatus;
    private long mSpeakingUploadTime;
    private IMediaIntercepter mMediaIntercepter;
    private final Runnable mUpdateTokenRunnable;
    private final mPluginListener.1 mPluginListener;
    private static final String TAG = "MediaServiceImpl";
    public static final Companion Companion = new Companion(null);

    public void setContext(@NotNull Activity context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mContext = context;
    }

    @Nullable
    public final Activity getContext() {
        return this.mContext;
    }

    public void changeMicByOwner(long uid, boolean open, @Nullable IOperationCallback callback2) {
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        int index = iChannel.getSeatService().getSeatIndex(uid);
        this.mVoiceModel.changeMic(index, uid, open, callback2, false);
    }

    public void enablePublishMic(int optFrom) {
        block10: {
            block9: {
                MLog.info((Object)TAG, (String)("enablePublishMic , optForm: " + optFrom), (Object[])new Object[0]);
                long meUid = AccountUtil.getUid();
                IChannel iChannel = this.channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
                int meIndex = iChannel.getSeatService().getSeatIndex(meUid);
                if (meIndex <= 0) {
                    MLog.error((Object)TAG, (String)"enablePublishMic but me not in seat!", (Object[])new Object[0]);
                    return;
                }
                IChannel iChannel2 = this.channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel2, (String)"channel");
                boolean isMicForbid = SeatStatusUtils.isMicForbidden((long)iChannel2.getSeatService().getSeatStatus(meUid));
                if (isMicForbid) {
                    IChannel iChannel3 = this.channel;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel3, (String)"channel");
                    if (!iChannel3.getRoleService().isOwnerOrMaster(AccountUtil.getUid())) {
                        IChannel iChannel4 = this.channel;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel4, (String)"channel");
                        IRoleService iRoleService = iChannel4.getRoleService();
                        Intrinsics.checkExpressionValueIsNotNull((Object)iRoleService, (String)"channel.roleService");
                        if (!iRoleService.isMeAnchor()) {
                            MLog.error((Object)TAG, (String)"enablePublishMic but me is forbidden!", (Object[])new Object[0]);
                            return;
                        }
                    }
                }
                if (ServiceManagerProxy.getServiceManager() == null) break block9;
                IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
                if (iServiceManager == null) {
                    Intrinsics.throwNpe();
                }
                if (iServiceManager.getService(IKtvLiveServiceExtend.class) != null) break block10;
            }
            MLog.info((Object)TAG, (String)"enablePublishMic but service null", (Object[])new Object[0]);
            return;
        }
        if (!PermissionHelper.hasRecordAudioPermission((Activity)this.getContext())) {
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
            SeatTrack.INSTANCE.noVoicePermissionShow(iChannel.getChannelId());
        }
        PermissionHelper.requestRecordAudioPermission((Activity)this.getContext(), (IPermissionListener)new IPermissionListener(this, optFrom){
            final /* synthetic */ MediaServiceImpl this$0;
            final /* synthetic */ int $optFrom;

            public void onPermissionGranted(@NotNull String[] permission) {
                Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
                IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
                if (iServiceManager == null) {
                    Intrinsics.throwNpe();
                }
                boolean isDisabledBefore = ((IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class)).isAudioPublishDisabled(1);
                IServiceManager iServiceManager2 = ServiceManagerProxy.getServiceManager();
                if (iServiceManager2 == null) {
                    Intrinsics.throwNpe();
                }
                ((IKtvLiveServiceExtend)iServiceManager2.getService(IKtvLiveServiceExtend.class)).enablePublishAudio(1);
                MediaServiceImpl.access$setVoiceRoomInMic(this.this$0, true);
                if (1 == this.$optFrom) {
                    IChannel iChannel = MediaServiceImpl.access$getChannel$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
                    int index = iChannel.getSeatService().getSeatIndex(AccountUtil.getUid());
                    MediaServiceImpl.access$getMVoiceModel$p(this.this$0).changeMic(index, AccountUtil.getUid(), true, new IOperationCallback(this, isDisabledBefore){
                        final /* synthetic */ enablePublishMic.1 this$0;
                        final /* synthetic */ boolean $isDisabledBefore;

                        public void onSuccess() {
                        }

                        public void onFail(long reason) {
                            if (this.$isDisabledBefore) {
                                IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
                                if (iServiceManager == null) {
                                    Intrinsics.throwNpe();
                                }
                                ((IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class)).disablePublishAudio(1);
                                MediaServiceImpl.access$setVoiceRoomInMic(this.this$0.this$0, false);
                            }
                        }
                        {
                            this.this$0 = $outer;
                            this.$isDisabledBefore = $captured_local_variable$1;
                        }
                    }, true);
                }
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)AudioNotifyDef.INSTANCE.getAUDIO_PERMISSION_NOTIFY()));
            }

            public void onPermissionDenied(@NotNull String[] permission) {
                Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
                FeatureLog.e((String)"FTVoice", (String)"enablePublishMic but permission denied!", (Object[])new Object[0]);
                MediaServiceImpl.access$setVoiceRoomInMic(this.this$0, false);
                if (this.$optFrom == 0) {
                    IChannel iChannel = MediaServiceImpl.access$getChannel$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
                    int index = iChannel.getSeatService().getSeatIndex(AccountUtil.getUid());
                    MediaServiceImpl.access$getMVoiceModel$p(this.this$0).changeMic(index, AccountUtil.getUid(), false, null, true);
                }
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)AudioNotifyDef.INSTANCE.getAUDIO_PERMISSION_NOTIFY()));
            }
            {
                this.this$0 = $outer;
                this.$optFrom = $captured_local_variable$1;
            }
        });
    }

    public void disablePublishMic(int optFrom) {
        block9: {
            block8: {
                if (ServiceManagerProxy.getServiceManager() == null) break block8;
                IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
                if (iServiceManager == null) {
                    Intrinsics.throwNpe();
                }
                if (iServiceManager.getService(IKtvLiveServiceExtend.class) != null) break block9;
            }
            MLog.info((Object)TAG, (String)"disablePublishMic but service null", (Object[])new Object[0]);
            return;
        }
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            Intrinsics.throwNpe();
        }
        boolean isDisabled = ((IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class)).isAudioPublishDisabled(1);
        MLog.info((Object)TAG, (String)("disablePublishMic isDisabled: " + isDisabled + ", optFrom: " + optFrom), (Object[])new Object[0]);
        if (!isDisabled) {
            IServiceManager iServiceManager2 = ServiceManagerProxy.getServiceManager();
            if (iServiceManager2 == null) {
                Intrinsics.throwNpe();
            }
            ((IKtvLiveServiceExtend)iServiceManager2.getService(IKtvLiveServiceExtend.class)).disablePublishAudio(1);
            this.setVoiceRoomInMic(false);
            if (1 == optFrom) {
                IChannel iChannel = this.channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
                int index = iChannel.getSeatService().getSeatIndex(AccountUtil.getUid());
                this.mVoiceModel.changeMic(index, AccountUtil.getUid(), false, new IOperationCallback(this){
                    final /* synthetic */ MediaServiceImpl this$0;

                    public void onSuccess() {
                    }

                    public void onFail(long reason) {
                        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
                        if (iServiceManager == null) {
                            Intrinsics.throwNpe();
                        }
                        ((IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class)).enablePublishAudio(1);
                        MediaServiceImpl.access$setVoiceRoomInMic(this.this$0, true);
                    }
                    {
                        this.this$0 = $outer;
                    }
                }, true);
            }
        }
    }

    @Nullable
    public IMediaIntercepter getMediaIntercepter() {
        return this.mMediaIntercepter;
    }

    public void setMediaIntercepter(@Nullable IMediaIntercepter intercepter) {
        this.mMediaIntercepter = intercepter;
    }

    private final void addSeatUpdateListener() {
        if (this.mSeatChangeListener == null) {
            this.mSeatChangeListener = new ISeatUpdateListener(this){
                final /* synthetic */ MediaServiceImpl this$0;

                public final void onSeatUpdate(List<SeatUser> seatUserList) {
                    block0: {
                        List<SeatUser> list2 = seatUserList;
                        if (list2 == null) break block0;
                        List<SeatUser> list3 = list2;
                        boolean bl = false;
                        boolean bl2 = false;
                        List<SeatUser> it = list3;
                        boolean bl3 = false;
                        MediaServiceImpl.access$updateMyMicStatus(this.this$0, seatUserList);
                        MediaServiceImpl.access$checkUnmute(this.this$0, seatUserList);
                    }
                }
                {
                    this.this$0 = mediaServiceImpl;
                }
            };
        }
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        iChannel.getSeatService().addSeatUpdateListener(this.mSeatChangeListener);
    }

    private final void removeSeatUpdateListener() {
        block1: {
            ISeatUpdateListener iSeatUpdateListener = this.mSeatChangeListener;
            if (iSeatUpdateListener == null) break block1;
            ISeatUpdateListener iSeatUpdateListener2 = iSeatUpdateListener;
            boolean bl = false;
            boolean bl2 = false;
            ISeatUpdateListener it = iSeatUpdateListener2;
            boolean bl3 = false;
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
            ISeatService iSeatService = iChannel.getSeatService();
            ISeatUpdateListener iSeatUpdateListener3 = this.mSeatChangeListener;
            if (iSeatUpdateListener3 == null) {
                Intrinsics.throwNpe();
            }
            iSeatService.removeSeatUpdateListener(iSeatUpdateListener3);
        }
    }

    @MainThread
    private final void checkUnmute(List<SeatUser> seatUserList) {
        for (SeatUser seatUser : seatUserList) {
            if (!this.mInvalidUids.contains(seatUser.uid)) continue;
            this.mInvalidUids.remove(seatUser.uid);
            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
            if (iServiceManager == null) {
                Intrinsics.throwNpe();
            }
            ((IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class)).muteRemoteAudioStream(Long.valueOf(seatUser.uid), false);
            MLog.info((Object)TAG, (String)("Unmute " + seatUser + ".uid"), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateMyMicStatus(List<SeatUser> seatUserList) {
        if (StringUtils.isEmpty((String)this.getGroupId())) {
            FeatureLog.i((String)"FTVoiceRoom", (String)"updateMyMicStatus voiceRoomId\u4e3a\u7a7a\uff0c\u9501\u623f\uff1f", (Object[])new Object[0]);
            return;
        }
        int meIndex = -1;
        boolean bl = false;
        for (SeatUser value : (Iterable)seatUserList) {
            void index;
            if (value.uid == AccountUtil.getUid()) {
                meIndex = index;
                break;
            }
            ++index;
        }
        FeatureLog.i((String)"FTVoiceRoom", (String)"updateMyMicStatus meIndex=%s", (Object[])new Object[]{meIndex});
        if (meIndex >= 0 && meIndex < seatUserList.size()) {
            long flag = seatUserList.get((int)meIndex).status;
            boolean isMicPublishEnabled = SeatStatusUtils.isMicOpen((long)flag);
            if (isMicPublishEnabled) {
                this.enablePublishMic(0);
            } else {
                this.disablePublishMic(0);
            }
        } else {
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
            if (!iChannel.getRoleService().isLinkMicAudience(AccountUtil.getUid())) {
                IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
                if (iServiceManager == null) {
                    Intrinsics.throwNpe();
                }
                ((IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class)).disablePublishAudio(1);
                this.setVoiceRoomInMic(false);
            }
        }
    }

    public void updateMediaToken() {
        MLog.info((Object)TAG, (String)"updateMediaToken", (Object[])new Object[0]);
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        this.mVoiceModel.fetchMediaToken(iChannel.getChannelId(), (Callback<MediaToken>)((Callback)new Callback<MediaToken>(this){
            final /* synthetic */ MediaServiceImpl this$0;

            public final void onResponse(MediaToken data2) {
                MLog.info((Object)"MediaServiceImpl", (String)"fetchMediaToken onResponse %s", (Object[])new Object[]{data2});
                if (data2 != null && data2.token != null) {
                    IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
                    if (iServiceManager == null) {
                        Intrinsics.throwNpe();
                    }
                    IKtvLiveServiceExtend iKtvLiveServiceExtend = (IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class);
                    IChannel iChannel = MediaServiceImpl.access$getChannel$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
                    iKtvLiveServiceExtend.updateToken(iChannel.getChannelId(), data2.token.toByteArray());
                    Long l = data2.expire;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"data.expire");
                    MediaServiceImpl.access$checkMediaTokenExpired(this.this$0, l);
                }
            }
            {
                this.this$0 = mediaServiceImpl;
            }
        }));
    }

    private final void checkMediaTokenExpired(long expireTime) {
        long checkDelay = expireTime - (long)60;
        if (checkDelay <= 0L) {
            checkDelay = expireTime;
        }
        if (checkDelay < 0L) {
            checkDelay = 5L;
        }
        YYTaskExecutor.removeTask((Runnable)this.mUpdateTokenRunnable);
        YYTaskExecutor.postToMainThread((Runnable)this.mUpdateTokenRunnable, (long)(checkDelay * (long)1000));
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mUpdateTokenRunnable);
    }

    public void joinMultiRoom(@NotNull ChannelPluginData pluginData) {
        Intrinsics.checkParameterIsNotNull((Object)pluginData, (String)"pluginData");
        boolean intercept = false;
        if (this.mMediaIntercepter != null) {
            IMediaIntercepter iMediaIntercepter = this.mMediaIntercepter;
            if (iMediaIntercepter == null) {
                Intrinsics.throwNpe();
            }
            intercept = iMediaIntercepter.preJoinMediaRoom(this.channel, new Runnable(this){
                final /* synthetic */ MediaServiceImpl this$0;

                public final void run() {
                    Object[] objectArray = new Object[1];
                    IChannel iChannel = MediaServiceImpl.access$getChannel$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
                    objectArray[0] = iChannel.getChannelId();
                    MLog.info((Object)"MediaServiceImpl", (String)"joinMultiRoom:%s intercepted!", (Object[])objectArray);
                }
                {
                    this.this$0 = mediaServiceImpl;
                }
            });
        }
        if (!intercept) {
            this.joinMultiRoomInner(pluginData);
            return;
        }
    }

    private final void changeAudioAndVideoMute(String channelId, ChannelPluginData pluginData) {
        if (pluginData != null) {
            IMediaRoom iMediaRoom;
            boolean stopThunder = pluginData.getMode() == 14 && pluginData.isVideoMode();
            IMediaRoomService iMediaRoomService = (IMediaRoomService)ServiceManagerProxy.getService(IMediaRoomService.class);
            String string2 = channelId;
            if (string2 == null) {
                string2 = "";
            }
            Boolean cdnHasPlayFail = (iMediaRoom = iMediaRoomService.getRoom(string2)) != null && (iMediaRoom = iMediaRoom.getMediaData()) != null ? Boolean.valueOf(iMediaRoom.getCdnHasPlayFail()) : null;
            MLog.info((Object)TAG, (String)("changeAudioAndVideoMute stopThunder:" + stopThunder + ", cdnHasPlayFail:" + cdnHasPlayFail), (Object[])new Object[0]);
            if (stopThunder) {
                if (cdnHasPlayFail != null && !cdnHasPlayFail.booleanValue()) {
                    IKtvLiveServiceExtend iKtvLiveServiceExtend = this.getLiveService();
                    IChannel iChannel = this.channel;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
                    iKtvLiveServiceExtend.muteAllRemoteAudioAndVideoStreams(iChannel.getChannelId(), true);
                }
            } else {
                IKtvLiveServiceExtend iKtvLiveServiceExtend = this.getLiveService();
                IChannel iChannel = this.channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
                iKtvLiveServiceExtend.muteAllRemoteAudioAndVideoStreams(iChannel.getChannelId(), false);
            }
        } else {
            IKtvLiveServiceExtend iKtvLiveServiceExtend = this.getLiveService();
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
            iKtvLiveServiceExtend.muteAllRemoteAudioAndVideoStreams(iChannel.getChannelId(), false);
        }
    }

    public final void joinMultiRoomInner(@NotNull ChannelPluginData pluginData) {
        block4: {
            String source;
            Intrinsics.checkParameterIsNotNull((Object)pluginData, (String)"pluginData");
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
            ChannelPathLog.getEnterChannelLogger((String)iChannel.getChannelId()).add("Media Room pre join", new Object[0]);
            MediaTokenInfo mediaTokenInfo = this.mMediaData.getTokenInfo();
            if (mediaTokenInfo == null) break block4;
            MediaTokenInfo mediaTokenInfo2 = mediaTokenInfo;
            boolean bl = false;
            boolean bl2 = false;
            MediaTokenInfo it = mediaTokenInfo2;
            boolean bl3 = false;
            MediaTokenInfo mediaTokenInfo3 = this.mMediaData.getTokenInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)mediaTokenInfo3, (String)"mMediaData.tokenInfo");
            long expire = mediaTokenInfo3.getExpireAt();
            MediaTokenInfo mediaTokenInfo4 = this.mMediaData.getTokenInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)mediaTokenInfo4, (String)"mMediaData.tokenInfo");
            byte[] mediaToken = mediaTokenInfo4.getToken();
            this.registerLiveListener(this.pendingCallback);
            Object[] objectArray = new Object[2];
            objectArray[0] = expire;
            IChannel iChannel2 = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel2, (String)"channel");
            objectArray[1] = iChannel2.getChannelId();
            MLog.info((Object)TAG, (String)"joinMultiRoom expire %s, roomId %s", (Object[])objectArray);
            long sceneId = ChannelDefine.pluginModeToSceneId((int)pluginData.mode, (boolean)pluginData.isVideoMode());
            IChannel iChannel3 = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel3, (String)"channel");
            IDataService iDataService = iChannel3.getDataService();
            String string2 = iDataService != null && (iDataService = iDataService.getCacheDetail()) != null && (iDataService = iDataService.baseInfo) != null ? iDataService.source : (source = null);
            if (Intrinsics.areEqual(source, (Object)"hago.amongus") || Intrinsics.areEqual((Object)source, (Object)"hago.amongus-user")) {
                sceneId = VoiceConstant.SCENE_ID_TEAM_UP;
            }
            IChannel iChannel4 = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel4, (String)"channel");
            IPluginService iPluginService = iChannel4.getPluginService();
            if (iPluginService != null) {
                iPluginService.addPluginDataListener((IPluginService.IPluginDataChangedCallBack)this.mPluginListener);
            }
            IKtvLiveServiceExtend iKtvLiveServiceExtend = this.getLiveService();
            long l = AccountUtil.getUid();
            IChannel iChannel5 = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel5, (String)"channel");
            iKtvLiveServiceExtend.joinLiveRoom(l, iChannel5.getChannelId(), (VoiceCallBack)this, mediaToken, sceneId, true);
            this.getLiveService().registerVideoCallback((LiveCallback)this);
            this.checkMediaTokenExpired(expire);
            if (this.mInvalidVoiceReporter == null) {
                this.mInvalidVoiceReporter = new InvalidVoiceReporter();
            }
            InvalidVoiceReporter invalidVoiceReporter = this.mInvalidVoiceReporter;
            if (invalidVoiceReporter == null) {
                Intrinsics.throwNpe();
            }
            IChannel iChannel6 = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel6, (String)"channel");
            invalidVoiceReporter.setRoomId(iChannel6.getChannelId());
            this.mIsInRoom = true;
            this.addSeatUpdateListener();
            IChannel iChannel7 = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel7, (String)"channel");
            ChannelPathLog.getEnterChannelLogger((String)iChannel7.getChannelId()).add("Media Room Joining", new Object[0]);
        }
    }

    public final long getSceneId(@NotNull ChannelPluginData pluginData) {
        Intrinsics.checkParameterIsNotNull((Object)pluginData, (String)"pluginData");
        return ChannelPluginData.getSceneId((ChannelPluginData)pluginData);
    }

    public void registerOnSpeakListener(@Nullable VoiceCallBack onSpeakListener) {
        block0: {
            VoiceCallBack voiceCallBack = onSpeakListener;
            if (voiceCallBack == null) break block0;
            VoiceCallBack voiceCallBack2 = voiceCallBack;
            boolean bl = false;
            boolean bl2 = false;
            VoiceCallBack it = voiceCallBack2;
            boolean bl3 = false;
            this.mOnSpeakListenerSet.add(onSpeakListener);
        }
    }

    public void unregisterOnSpeakListener(@Nullable VoiceCallBack onSpeakListener) {
        block0: {
            VoiceCallBack voiceCallBack = onSpeakListener;
            if (voiceCallBack == null) break block0;
            VoiceCallBack voiceCallBack2 = voiceCallBack;
            boolean bl = false;
            boolean bl2 = false;
            VoiceCallBack it = voiceCallBack2;
            boolean bl3 = false;
            this.mOnSpeakListenerSet.remove(onSpeakListener);
        }
    }

    private final synchronized void statisticMicOpenTime(boolean start, String pluginId) {
        if (start) {
            this.mEnableMicElapsedStartTime = SystemClock.elapsedRealtime();
        } else if (this.mEnableMicElapsedStartTime > 0L) {
            Object object;
            RoomlistEventBean roomList;
            long openMicTimeMs = SystemClock.elapsedRealtime() - this.mEnableMicElapsedStartTime;
            this.mEnableMicElapsedStartTime = -1L;
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
            EnterParam enterParam = iChannel.getEnterParam();
            RoomlistEventBean roomlistEventBean = roomList = enterParam != null ? (RoomlistEventBean)enterParam.getExtra("ROOM_LIST_EVENT", null) : null;
            String token = roomlistEventBean != null ? roomlistEventBean.getToken() : null;
            CharSequence charSequence = token;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                IChannel iChannel2 = this.channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel2, (String)"channel");
                Object object2 = iChannel2.getEnterParam();
                if (object2 == null || (object2 = (String)object2.getExtra("token", (Object)"")) == null) {
                    object2 = "";
                }
                token = object2;
            }
            IChannel iChannel3 = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel3, (String)"channel");
            String string2 = iChannel3.getChannelId();
            IChannel iChannel4 = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel4, (String)"channel");
            Object object3 = iChannel4.getEnterParam();
            if (object3 == null || (object3 = String.valueOf(object3.entry)) == null) {
                object3 = "";
            }
            if ((object = roomList) == null || (object = object.getTabCatId()) == null) {
                object = "";
            }
            RoomTrack.INSTANCE.openVoiceTime(string2, pluginId, (String)object3, (String)object, String.valueOf(openMicTimeMs), token);
        }
    }

    @MainThread
    public void exitRoom() {
        MLog.info((Object)TAG, (String)"exit room", (Object[])new Object[0]);
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            Intrinsics.throwNpe();
        }
        IKtvLiveServiceExtend iKtvLiveServiceExtend = (IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class);
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        iKtvLiveServiceExtend.exitChannel(iChannel.getChannelId());
        IChannel iChannel2 = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel2, (String)"channel");
        iChannel2.getPluginService().removePluginDataListener((IPluginService.IPluginDataChangedCallBack)this.mPluginListener);
        if (this.mInvalidVoiceReporter != null) {
            InvalidVoiceReporter invalidVoiceReporter = this.mInvalidVoiceReporter;
            if (invalidVoiceReporter == null) {
                Intrinsics.throwNpe();
            }
            invalidVoiceReporter.destroy();
            this.mInvalidVoiceReporter = null;
        }
        this.mInvalidUids.clear();
        this.mIsInRoom = false;
        this.removeSeatUpdateListener();
        IChannel iChannel3 = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel3, (String)"channel");
        Object object = iChannel3.getPluginService();
        if (object == null || (object = object.getCurPluginData()) == null || (object = object.getPluginId()) == null) {
            object = "";
        }
        this.statisticMicOpenTime(false, (String)object);
        IChannel iChannel4 = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel4, (String)"channel");
        Object object2 = iChannel4.getPluginService();
        if (object2 == null || (object2 = object2.getCurPluginData()) == null || (object2 = object2.getPluginId()) == null) {
            object2 = "";
        }
        this.statisticsSpeakingTime(false, true, (String)object2);
        IChannel iChannel5 = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel5, (String)"channel");
        RuntimeContext.stopRecord((String)iChannel5.getChannelId(), (int)3);
        IChannel iChannel6 = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel6, (String)"channel");
        RuntimeContext.stopRecord((String)iChannel6.getChannelId(), (int)1);
        this.mSpeakingElapsedStartTime = -1L;
        this.mSpeakingPreviousStatus.set(0);
        this.mSpeakingTime = -1L;
        this.mEnableMicElapsedStartTime = -1L;
        this.mSpeakingUploadTime = -1L;
    }

    private final synchronized void statisticsSpeakingTime(boolean start, boolean forceUpload, String pluginId) {
        if (start) {
            this.mSpeakingElapsedStartTime = SystemClock.elapsedRealtime();
        } else if (this.mSpeakingElapsedStartTime > 0L) {
            long speakingTime = SystemClock.elapsedRealtime() - this.mSpeakingElapsedStartTime;
            this.mSpeakingTime += speakingTime;
            this.mSpeakingElapsedStartTime = -1L;
        }
        if (this.mSpeakingTime > 0L) {
            long uploadIntervalTime = SystemClock.elapsedRealtime() - this.mSpeakingUploadTime;
            if (forceUpload || uploadIntervalTime >= 60000L) {
                Object object;
                RoomlistEventBean roomList;
                IChannel iChannel = this.channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
                EnterParam enterParam = iChannel.getEnterParam();
                RoomlistEventBean roomlistEventBean = roomList = enterParam != null ? (RoomlistEventBean)enterParam.getExtra("ROOM_LIST_EVENT", null) : null;
                String token = roomlistEventBean != null ? roomlistEventBean.getToken() : null;
                CharSequence charSequence = token;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    IChannel iChannel2 = this.channel;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel2, (String)"channel");
                    Object object2 = iChannel2.getEnterParam();
                    if (object2 == null || (object2 = (String)object2.getExtra("token", (Object)"")) == null) {
                        object2 = "";
                    }
                    token = object2;
                }
                IChannel iChannel3 = this.channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel3, (String)"channel");
                String string2 = iChannel3.getChannelId();
                IChannel iChannel4 = this.channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel4, (String)"channel");
                Object object3 = iChannel4.getEnterParam();
                if (object3 == null || (object3 = String.valueOf(object3.entry)) == null) {
                    object3 = "";
                }
                if ((object = roomList) == null || (object = object.getTabCatId()) == null) {
                    object = "";
                }
                RoomTrack.INSTANCE.speakVoiceTime(string2, pluginId, (String)object3, (String)object, String.valueOf(this.mSpeakingTime), token);
                this.mSpeakingTime = -1L;
                this.mSpeakingUploadTime = SystemClock.elapsedRealtime();
            }
        }
    }

    public void onSpeakingChanged(@NotNull Map<Long, Integer> speakList, int streamType) {
        int n;
        Intrinsics.checkParameterIsNotNull(speakList, (String)"speakList");
        if (!MLog.isLogLevelAboveDebug()) {
            // empty if block
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, speakList, streamType){
            final /* synthetic */ MediaServiceImpl this$0;
            final /* synthetic */ Map $speakList;
            final /* synthetic */ int $streamType;

            public final void run() {
                HashMap<K, V> speak = new HashMap<K, V>(FP.size((Map)this.$speakList));
                if (!FP.empty((Map)this.$speakList)) {
                    Iterator<K> iterator = this.$speakList.keySet().iterator();
                    while (iterator.hasNext()) {
                        long id2 = ((Number)iterator.next()).longValue();
                        Integer n = (Integer)this.$speakList.get(id2);
                        int n2 = 1;
                        ((Map)speak).put(id2, n != null && n == n2);
                    }
                }
                boolean $i$f$onWork = false;
                if (YYTaskExecutor.isMainThread()) {
                    YYTaskExecutor.execute((Runnable)new Runnable(this, speak){
                        final /* synthetic */ onSpeakingChanged.1 this$0;
                        final /* synthetic */ HashMap $speak$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$speak$inlined = hashMap;
                        }

                        public final void run() {
                            boolean bl = false;
                            MediaServiceImpl.access$getMMediaData$p(this.this$0.this$0).setSpeakList(this.$speak$inlined);
                        }
                    });
                } else {
                    boolean bl = false;
                    MediaServiceImpl.access$getMMediaData$p(this.this$0).setSpeakList(speak);
                }
                for (VoiceCallBack callBack : MediaServiceImpl.access$getMOnSpeakListenerSet$p(this.this$0)) {
                    callBack.onSpeakingChanged(this.$speakList, this.$streamType);
                }
            }
            {
                this.this$0 = mediaServiceImpl;
                this.$speakList = map;
                this.$streamType = n;
            }
        });
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            Intrinsics.throwNpe();
        }
        if (((IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class)).isAudioPublishEnabled(1)) {
            Integer n2 = speakList.get(AccountUtil.getUid());
            n = n2 != null ? n2 : 0;
        } else {
            n = 0;
        }
        int mySpeakingStatus = n;
        int preStatus = 0;
        boolean statusChanged = false;
        do {
            boolean bl = statusChanged = (preStatus = this.mSpeakingPreviousStatus.get()) != mySpeakingStatus;
        } while (!this.mSpeakingPreviousStatus.compareAndSet(preStatus, mySpeakingStatus));
        if (statusChanged) {
            boolean start = mySpeakingStatus == 1;
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
            Object object = iChannel.getPluginService();
            if (object == null || (object = object.getCurPluginData()) == null || (object = object.getPluginId()) == null) {
                object = "";
            }
            this.statisticsSpeakingTime(start, false, (String)object);
            if (start) {
                IChannel iChannel2 = this.channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel2, (String)"channel");
                RuntimeContext.startRecord((String)iChannel2.getChannelId(), (int)1);
            } else {
                IChannel iChannel3 = this.channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel3, (String)"channel");
                RuntimeContext.stopRecord((String)iChannel3.getChannelId(), (int)1);
            }
        }
    }

    @MainThread
    private final void checkInvalidSpeaker(Map<Long, Integer> speakList) {
        if (this.mIsInRoom && speakList != null) {
            boolean muteInvalidAudio;
            Iterator<Long> it = speakList.keySet().iterator();
            AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.PERFORMANCE_CONFIG);
            boolean bl = muteInvalidAudio = configData == null || configData.getBoolValue("mute_invalid_audio", true);
            while (it.hasNext()) {
                long uid = ((Number)it.next()).longValue();
                if (this.isValidSpeaker(uid)) continue;
                if (muteInvalidAudio && !this.mInvalidUids.contains(uid)) {
                    this.mInvalidUids.add(uid);
                    IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
                    if (iServiceManager == null) {
                        Intrinsics.throwNpe();
                    }
                    ((IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class)).muteRemoteAudioStream(Long.valueOf(uid), true);
                }
                StringBuilder stringBuilder = new StringBuilder().append("find invalid speaker ").append(uid).append(", seats: ");
                IChannel iChannel = this.channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
                MLog.error((Object)TAG, (String)stringBuilder.append(iChannel.getSeatService().getSeatUidsList()).toString(), (Object[])new Object[0]);
                IChannel iChannel2 = this.channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel2, (String)"channel");
                IRoleService iRoleService = iChannel2.getRoleService();
                if (iRoleService == null || !iRoleService.isMeOwner()) {
                    IChannel iChannel3 = this.channel;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel3, (String)"channel");
                    IRoleService iRoleService2 = iChannel3.getRoleService();
                    if (iRoleService2 == null) continue;
                    if (!iRoleService2.isMeAnchor()) continue;
                }
                if (this.mInvalidVoiceReporter == null) continue;
                InvalidVoiceReporter invalidVoiceReporter = this.mInvalidVoiceReporter;
                if (invalidVoiceReporter == null) {
                    Intrinsics.throwNpe();
                }
                invalidVoiceReporter.addInvalidUid(uid);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidSpeaker(long uid) {
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        int role = iChannel.getRoleService().getRoleCache(uid);
        IChannel iChannel2 = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel2, (String)"channel");
        if (iChannel2.getSeatService().isInSeat(uid)) return true;
        if (15 == role) return true;
        if (10 == role) return true;
        IChannel iChannel3 = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel3, (String)"channel");
        IRoleService iRoleService = iChannel3.getRoleService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iRoleService, (String)"channel.roleService");
        if (!iRoleService.isMeAnchor()) return false;
        return true;
    }

    public void onJoinChannelSuccess(@NotNull String channel, long uid, int elapsed) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        MLog.info((Object)TAG, (String)"joinMultiRoom onJoinChannelSuccess channel %s, uid %s, elapsed %s", (Object[])new Object[]{channel, uid, elapsed});
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"this.channel");
        ChannelPathLog.getEnterChannelLogger((String)iChannel.getChannelId()).add("Media Room Join Success:%s", new Object[]{channel});
    }

    public void onAudioPlayData(@Nullable String roomId, @Nullable String uid, @Nullable byte[] data2, long duration) {
        if (!this.mFirstAudioPlayDataBackJustForStat) {
            this.mFirstAudioPlayDataBackJustForStat = true;
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"this.channel");
            ChannelPathLog.getEnterChannelLogger((String)iChannel.getChannelId()).add("Media Audio PlayData Receive", new Object[0]);
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, roomId, uid, data2, duration){
            final /* synthetic */ MediaServiceImpl this$0;
            final /* synthetic */ String $roomId;
            final /* synthetic */ String $uid;
            final /* synthetic */ byte[] $data;
            final /* synthetic */ long $duration;

            public final void run() {
                for (VoiceCallBack callBack : MediaServiceImpl.access$getMOnSpeakListenerSet$p(this.this$0)) {
                    callBack.onAudioPlayData(this.$roomId, this.$uid, this.$data, this.$duration);
                }
            }
            {
                this.this$0 = mediaServiceImpl;
                this.$roomId = string2;
                this.$uid = string3;
                this.$data = byArray;
                this.$duration = l;
            }
        });
    }

    public void onAudioPlaySpectrumData(@Nullable byte[] data2) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, data2){
            final /* synthetic */ MediaServiceImpl this$0;
            final /* synthetic */ byte[] $data;

            public final void run() {
                if (!MediaServiceImpl.access$getMFirstAudioPlaySpectrumDataForStat$p(this.this$0)) {
                    MediaServiceImpl.access$setMFirstAudioPlaySpectrumDataForStat$p(this.this$0, true);
                    IChannel iChannel = MediaServiceImpl.access$getChannel$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"this.channel");
                    ChannelPathLog.getEnterChannelLogger((String)iChannel.getChannelId()).add("Media Audio PlaySpectrumData Receive", new Object[0]);
                }
                for (VoiceCallBack callBack : MediaServiceImpl.access$getMOnSpeakListenerSet$p(this.this$0)) {
                    callBack.onAudioPlaySpectrumData(this.$data);
                }
            }
            {
                this.this$0 = mediaServiceImpl;
                this.$data = byArray;
            }
        });
    }

    public void onAudioPlayTimestamp(int playTimestamp) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, playTimestamp){
            final /* synthetic */ MediaServiceImpl this$0;
            final /* synthetic */ int $playTimestamp;

            public final void run() {
                if (!MediaServiceImpl.access$getMFirstAudioPlayTimestampForStat$p(this.this$0)) {
                    MediaServiceImpl.access$setMFirstAudioPlayTimestampForStat$p(this.this$0, true);
                    IChannel iChannel = MediaServiceImpl.access$getChannel$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"this.channel");
                    ChannelPathLog.getEnterChannelLogger((String)iChannel.getChannelId()).add("Media Audio PlayTimestamp  Receive", new Object[0]);
                }
                for (VoiceCallBack callBack : MediaServiceImpl.access$getMOnSpeakListenerSet$p(this.this$0)) {
                    callBack.onAudioPlayTimestamp(this.$playTimestamp);
                }
            }
            {
                this.this$0 = mediaServiceImpl;
                this.$playTimestamp = n;
            }
        });
    }

    public void onAudioPlayTimestamp(@Nullable Map<Long, Integer> audioVolumeMap) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, audioVolumeMap){
            final /* synthetic */ MediaServiceImpl this$0;
            final /* synthetic */ Map $audioVolumeMap;

            public final void run() {
                if (!MediaServiceImpl.access$getMFirstAudioPlayTimestampForStat$p(this.this$0)) {
                    MediaServiceImpl.access$setMFirstAudioPlayTimestampForStat$p(this.this$0, true);
                    IChannel iChannel = MediaServiceImpl.access$getChannel$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"this.channel");
                    ChannelPathLog.getEnterChannelLogger((String)iChannel.getChannelId()).add("Media Audio PlayTimestamp Receive", new Object[0]);
                }
                for (VoiceCallBack callBack : MediaServiceImpl.access$getMOnSpeakListenerSet$p(this.this$0)) {
                    Map map = this.$audioVolumeMap;
                    VoiceCallBack voiceCallBack = callBack;
                    boolean bl = false;
                    Map map2 = map;
                    if (map2 == null) {
                        map2 = MapsKt.emptyMap();
                    }
                    Map map3 = map2;
                    voiceCallBack.onAudioPlayTimestamp(map3);
                }
            }
            {
                this.this$0 = mediaServiceImpl;
                this.$audioVolumeMap = map;
            }
        });
    }

    public void onReceiveUserAppMsgData(@Nullable byte[] data2, @Nullable String uid) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, data2, uid){
            final /* synthetic */ MediaServiceImpl this$0;
            final /* synthetic */ byte[] $data;
            final /* synthetic */ String $uid;

            public final void run() {
                for (VoiceCallBack callBack : MediaServiceImpl.access$getMOnSpeakListenerSet$p(this.this$0)) {
                    String string2 = this.$uid;
                    byte[] byArray = this.$data;
                    VoiceCallBack voiceCallBack = callBack;
                    boolean bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        string3 = "";
                    }
                    String string4 = string3;
                    voiceCallBack.onReceiveUserAppMsgData(byArray, string4);
                }
            }
            {
                this.this$0 = mediaServiceImpl;
                this.$data = byArray;
                this.$uid = string2;
            }
        });
    }

    public void onReceiveAppMsgDataFailedStatus(int status) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, status){
            final /* synthetic */ MediaServiceImpl this$0;
            final /* synthetic */ int $status;

            public final void run() {
                for (VoiceCallBack callBack : MediaServiceImpl.access$getMOnSpeakListenerSet$p(this.this$0)) {
                    callBack.onReceiveAppMsgDataFailedStatus(this.$status);
                }
            }
            {
                this.this$0 = mediaServiceImpl;
                this.$status = n;
            }
        });
    }

    public void onAudioCapturePcmData(@NotNull byte[] data2, int dataSize, int sampleRate, int channel) {
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, data2, dataSize, sampleRate, channel){
            final /* synthetic */ MediaServiceImpl this$0;
            final /* synthetic */ byte[] $data;
            final /* synthetic */ int $dataSize;
            final /* synthetic */ int $sampleRate;
            final /* synthetic */ int $channel;

            public final void run() {
                for (VoiceCallBack callBack : MediaServiceImpl.access$getMOnSpeakListenerSet$p(this.this$0)) {
                    callBack.onAudioCapturePcmData(this.$data, this.$dataSize, this.$sampleRate, this.$channel);
                }
            }
            {
                this.this$0 = mediaServiceImpl;
                this.$data = byArray;
                this.$dataSize = n;
                this.$sampleRate = n2;
                this.$channel = n3;
            }
        });
    }

    @NotNull
    public MediaData getMediaData() {
        return this.mMediaData;
    }

    @Override
    public void onPreJoin(@NotNull EnterParam enterParam) {
        Intrinsics.checkParameterIsNotNull((Object)enterParam, (String)"enterParam");
    }

    @Override
    public void onJoined(boolean rejoin2, @NotNull ChannelDetailInfo info, @NotNull EnterChannelData data2) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        super.onJoined(rejoin2, info, data2);
        this.mFirstAudioPlayDataBackJustForStat = false;
        this.mFirstAudioPlaySpectrumDataForStat = false;
        this.mFirstAudioPlayTimestampForStat = false;
        this.mFirstMediaSizeChangeForStat = false;
        this.mMediaData.setTokenInfo(data2.mediaToken);
        ChannelPluginData channelPluginData = data2.pluginData;
        if (channelPluginData == null) {
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
            IPluginService iPluginService = iChannel.getPluginService();
            Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
            ChannelPluginData channelPluginData2 = iPluginService.getCurPluginData();
            channelPluginData = channelPluginData2;
            Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData2, (String)"channel.pluginService.curPluginData");
        }
        this.joinMultiRoom(channelPluginData);
        if (rejoin2) {
            ChannelInfo channelInfo = info.baseInfo;
            this.getLiveService().checkPushCdn(channelInfo != null ? channelInfo.getChannelId() : null);
        }
    }

    public boolean isInMultiRoom() {
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            Intrinsics.throwNpe();
        }
        IService iService = iServiceManager.getService(IKtvLiveServiceExtend.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)iService, (String)"getServiceManager()!!.ge\u2026erviceExtend::class.java)");
        return ((IKtvLiveServiceExtend)iService).isInMultiRoom();
    }

    @Override
    public void onLeaved() {
        this.exitRoom();
        super.onLeaved();
    }

    private final IKtvLiveServiceExtend getLiveService() {
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            Intrinsics.throwNpe();
        }
        IService iService = iServiceManager.getService(IKtvLiveServiceExtend.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)iService, (String)"getServiceManager()!!.ge\u2026erviceExtend::class.java)");
        return (IKtvLiveServiceExtend)iService;
    }

    public void registerLiveListener(@NotNull LiveCallback liveCallback) {
        Intrinsics.checkParameterIsNotNull((Object)liveCallback, (String)"liveCallback");
        this.mVideoListener.add(liveCallback);
    }

    public void unregisterLiveListener(@NotNull LiveCallback liveCallback) {
        Intrinsics.checkParameterIsNotNull((Object)liveCallback, (String)"liveCallback");
        this.mVideoListener.remove(liveCallback);
    }

    public void onVideoStart(long anchorId, int width, int height, boolean isCdn) {
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        ChannelPathLog.getEnterChannelLogger((String)iChannel.getChannelId()).add("Media Video Start", new Object[0]);
        if (YYTaskExecutor.isMainThread()) {
            for (LiveCallback callBack : this.mVideoListener) {
                callBack.onVideoStart(anchorId, width, height, isCdn);
            }
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, anchorId, width, height, isCdn){
                final /* synthetic */ MediaServiceImpl this$0;
                final /* synthetic */ long $anchorId;
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ boolean $isCdn;

                public final void run() {
                    for (LiveCallback callBack : MediaServiceImpl.access$getMVideoListener$p(this.this$0)) {
                        callBack.onVideoStart(this.$anchorId, this.$width, this.$height, this.$isCdn);
                    }
                }
                {
                    this.this$0 = mediaServiceImpl;
                    this.$anchorId = l;
                    this.$width = n;
                    this.$height = n2;
                    this.$isCdn = bl;
                }
            });
        }
    }

    public void onSourceChange(boolean isCdn) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, isCdn){
            final /* synthetic */ MediaServiceImpl this$0;
            final /* synthetic */ boolean $isCdn;

            public final void run() {
                for (LiveCallback callBack : MediaServiceImpl.access$getMVideoListener$p(this.this$0)) {
                    callBack.onSourceChange(this.$isCdn);
                }
            }
            {
                this.this$0 = mediaServiceImpl;
                this.$isCdn = bl;
            }
        });
    }

    public void onVideoStop(long anchorId) {
        if (YYTaskExecutor.isMainThread()) {
            for (LiveCallback callBack : this.mVideoListener) {
                callBack.onVideoStop(anchorId);
            }
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, anchorId){
                final /* synthetic */ MediaServiceImpl this$0;
                final /* synthetic */ long $anchorId;

                public final void run() {
                    for (LiveCallback callBack : MediaServiceImpl.access$getMVideoListener$p(this.this$0)) {
                        callBack.onVideoStop(this.$anchorId);
                    }
                }
                {
                    this.this$0 = mediaServiceImpl;
                    this.$anchorId = l;
                }
            });
        }
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        ChannelPathLog.getEnterChannelLogger((String)iChannel.getChannelId()).add("Media Video Stop", new Object[0]);
    }

    public void onVideoSizeChange(long anchorId, int width, int height, int rotation) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, width, height){
            final /* synthetic */ MediaServiceImpl this$0;
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;

            public final void run() {
                if (!MediaServiceImpl.access$getMFirstMediaSizeChangeForStat$p(this.this$0)) {
                    MediaServiceImpl.access$setMFirstMediaSizeChangeForStat$p(this.this$0, true);
                    IChannel iChannel = MediaServiceImpl.access$getChannel$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
                    ChannelPathLog.getEnterChannelLogger((String)iChannel.getChannelId()).add("Media Video SizeChange width:%d,height%d", new Object[]{this.$width, this.$height});
                }
            }
            {
                this.this$0 = mediaServiceImpl;
                this.$width = n;
                this.$height = n2;
            }
        });
        if (YYTaskExecutor.isMainThread()) {
            for (LiveCallback callBack : this.mVideoListener) {
                callBack.onVideoSizeChange(anchorId, width, height, rotation);
            }
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, anchorId, width, height, rotation){
                final /* synthetic */ MediaServiceImpl this$0;
                final /* synthetic */ long $anchorId;
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ int $rotation;

                public final void run() {
                    for (LiveCallback callBack : MediaServiceImpl.access$getMVideoListener$p(this.this$0)) {
                        callBack.onVideoSizeChange(this.$anchorId, this.$width, this.$height, this.$rotation);
                    }
                }
                {
                    this.this$0 = mediaServiceImpl;
                    this.$anchorId = l;
                    this.$width = n;
                    this.$height = n2;
                    this.$rotation = n3;
                }
            });
        }
    }

    public void onVideoStreamOpen(long anchorId) {
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        ChannelPathLog.getEnterChannelLogger((String)iChannel.getChannelId()).add("Media Video StreamOpen anchorId:%s", new Object[]{anchorId});
        if (YYTaskExecutor.isMainThread()) {
            for (LiveCallback callBack : this.mVideoListener) {
                callBack.onVideoStreamOpen(anchorId);
            }
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, anchorId){
                final /* synthetic */ MediaServiceImpl this$0;
                final /* synthetic */ long $anchorId;

                public final void run() {
                    for (LiveCallback callBack : MediaServiceImpl.access$getMVideoListener$p(this.this$0)) {
                        callBack.onVideoStreamOpen(this.$anchorId);
                    }
                }
                {
                    this.this$0 = mediaServiceImpl;
                    this.$anchorId = l;
                }
            });
        }
    }

    public void onJoinChannelSuccess(@Nullable String channel, @Nullable String p1, int elapsed) {
        if (channel != null) {
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"this.channel");
            ChannelPathLog.getEnterChannelLogger((String)iChannel.getChannelId()).add("Media Room Join Success:%s", new Object[]{channel});
        } else {
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"this.channel");
            ChannelPathLog.getEnterChannelLogger((String)iChannel.getChannelId()).add("Media Room Join Success", new Object[0]);
        }
        if (YYTaskExecutor.isMainThread()) {
            for (LiveCallback callBack : this.mVideoListener) {
                callBack.onJoinChannelSuccess(channel, p1, elapsed);
            }
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, channel, p1, elapsed){
                final /* synthetic */ MediaServiceImpl this$0;
                final /* synthetic */ String $channel;
                final /* synthetic */ String $p1;
                final /* synthetic */ int $elapsed;

                public final void run() {
                    for (LiveCallback callBack : MediaServiceImpl.access$getMVideoListener$p(this.this$0)) {
                        callBack.onJoinChannelSuccess(this.$channel, this.$p1, this.$elapsed);
                    }
                }
                {
                    this.this$0 = mediaServiceImpl;
                    this.$channel = string2;
                    this.$p1 = string3;
                    this.$elapsed = n;
                }
            });
        }
    }

    @NotNull
    public IMediaService.IMediaPendingCallback pendingCallback() {
        return this.pendingCallback;
    }

    @NotNull
    public ILiveVideoPlayer getLiveVideoPlayer() {
        ILiveVideoPlayer iLiveVideoPlayer = this.callBack.getLiveVideoPlayer(this.channel);
        Intrinsics.checkExpressionValueIsNotNull((Object)iLiveVideoPlayer, (String)"callBack.getLiveVideoPlayer(channel)");
        return iLiveVideoPlayer;
    }

    private final void setVoiceRoomInMic(boolean isOpen) {
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        RuntimeContext.setVoiceRoomInMic((String)iChannel.getChannelId(), (boolean)isOpen);
        MLog.info((Object)TAG, (String)("mic change " + isOpen), (Object[])new Object[0]);
        IChannel iChannel2 = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel2, (String)"channel");
        Object object = iChannel2.getPluginService();
        if (object == null || (object = object.getCurPluginData()) == null || (object = object.getPluginId()) == null) {
            object = "";
        }
        this.statisticMicOpenTime(isOpen, (String)object);
        if (isOpen) {
            IChannel iChannel3 = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel3, (String)"channel");
            RuntimeContext.startRecord((String)iChannel3.getChannelId(), (int)3);
        } else {
            IChannel iChannel4 = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel4, (String)"channel");
            RuntimeContext.stopRecord((String)iChannel4.getChannelId(), (int)3);
        }
        if (!isOpen) {
            IChannel iChannel5 = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel5, (String)"channel");
            Object object2 = iChannel5.getPluginService();
            if (object2 == null || (object2 = object2.getCurPluginData()) == null || (object2 = object2.getPluginId()) == null) {
                object2 = "";
            }
            this.statisticsSpeakingTime(false, true, (String)object2);
            IChannel iChannel6 = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel6, (String)"channel");
            RuntimeContext.stopRecord((String)iChannel6.getChannelId(), (int)1);
        }
    }

    public MediaServiceImpl(@NotNull IChannel channel, @NotNull ILocalDataModel localGroupDataManager) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)localGroupDataManager, (String)"localGroupDataManager");
        super(channel, localGroupDataManager);
        this.mVoiceModel = new VoiceModel();
        this.mMediaData = new MediaData();
        this.mOnSpeakListenerSet = new HashSet();
        this.mInvalidUids = new HashSet();
        MediaServiceImpl mediaServiceImpl = this;
        boolean bl = false;
        mediaServiceImpl.mVideoListener = set = (Set)new LinkedHashSet();
        this.pendingCallback = new PendingCallback();
        this.mEnableMicElapsedStartTime = -1L;
        this.mSpeakingElapsedStartTime = -1L;
        this.mSpeakingTime = -1L;
        this.mSpeakingPreviousStatus = new AtomicInteger(0);
        this.mSpeakingUploadTime = -1L;
        this.mUpdateTokenRunnable = new Runnable(this){
            final /* synthetic */ MediaServiceImpl this$0;

            public final void run() {
                this.this$0.updateMediaToken();
            }
            {
                this.this$0 = mediaServiceImpl;
            }
        };
        this.mVoiceModel.setRoomId(this.getGroupId());
        this.mPluginListener = new IPluginService.IPluginDataChangedCallBack(this){
            final /* synthetic */ MediaServiceImpl this$0;

            public void onPluginModeChanged(@Nullable String channelId, @Nullable ChannelPluginData pluginData, @Nullable ChannelPluginData beforePlugin) {
                Object object = beforePlugin;
                if (object == null || (object = object.getPluginId()) == null) {
                    object = "";
                }
                MediaServiceImpl.access$statisticMicOpenTime(this.this$0, false, (String)object);
                Object object2 = beforePlugin;
                if (object2 == null || (object2 = object2.getPluginId()) == null) {
                    object2 = "";
                }
                MediaServiceImpl.access$statisticsSpeakingTime(this.this$0, false, true, (String)object2);
                RuntimeContext.stopRecord((String)channelId, (int)3);
                RuntimeContext.stopRecord((String)channelId, (int)1);
                MediaServiceImpl.access$changeAudioAndVideoMute(this.this$0, channelId, pluginData);
            }

            public void onVideoModeChanged(@Nullable String channelId, boolean isVideoMode) {
                IChannelCenterService iChannelCenterService = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
                String string2 = channelId;
                if (string2 == null) {
                    string2 = "";
                }
                IChannel iChannel = iChannelCenterService.getChannel(string2);
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"ServiceManagerProxy.getS\u2026tChannel(channelId ?: \"\")");
                IPluginService iPluginService = iChannel.getPluginService();
                Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"ServiceManagerProxy.getS\u2026elId ?: \"\").pluginService");
                MediaServiceImpl.access$changeAudioAndVideoMute(this.this$0, channelId, iPluginService.getCurPluginData());
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ void access$setVoiceRoomInMic(MediaServiceImpl $this, boolean isOpen) {
        $this.setVoiceRoomInMic(isOpen);
    }

    public static final /* synthetic */ IChannel access$getChannel$p(MediaServiceImpl $this) {
        return $this.channel;
    }

    public static final /* synthetic */ VoiceModel access$getMVoiceModel$p(MediaServiceImpl $this) {
        return $this.mVoiceModel;
    }

    public static final /* synthetic */ void access$updateMyMicStatus(MediaServiceImpl $this, List seatUserList) {
        $this.updateMyMicStatus(seatUserList);
    }

    public static final /* synthetic */ void access$checkUnmute(MediaServiceImpl $this, List seatUserList) {
        $this.checkUnmute(seatUserList);
    }

    public static final /* synthetic */ void access$checkMediaTokenExpired(MediaServiceImpl $this, long expireTime) {
        $this.checkMediaTokenExpired(expireTime);
    }

    public static final /* synthetic */ MediaData access$getMMediaData$p(MediaServiceImpl $this) {
        return $this.mMediaData;
    }

    public static final /* synthetic */ HashSet access$getMOnSpeakListenerSet$p(MediaServiceImpl $this) {
        return $this.mOnSpeakListenerSet;
    }

    public static final /* synthetic */ boolean access$getMFirstAudioPlaySpectrumDataForStat$p(MediaServiceImpl $this) {
        return $this.mFirstAudioPlaySpectrumDataForStat;
    }

    public static final /* synthetic */ void access$setMFirstAudioPlaySpectrumDataForStat$p(MediaServiceImpl $this, boolean bl) {
        $this.mFirstAudioPlaySpectrumDataForStat = bl;
    }

    public static final /* synthetic */ boolean access$getMFirstAudioPlayTimestampForStat$p(MediaServiceImpl $this) {
        return $this.mFirstAudioPlayTimestampForStat;
    }

    public static final /* synthetic */ void access$setMFirstAudioPlayTimestampForStat$p(MediaServiceImpl $this, boolean bl) {
        $this.mFirstAudioPlayTimestampForStat = bl;
    }

    public static final /* synthetic */ Set access$getMVideoListener$p(MediaServiceImpl $this) {
        return $this.mVideoListener;
    }

    public static final /* synthetic */ boolean access$getMFirstMediaSizeChangeForStat$p(MediaServiceImpl $this) {
        return $this.mFirstMediaSizeChangeForStat;
    }

    public static final /* synthetic */ void access$setMFirstMediaSizeChangeForStat$p(MediaServiceImpl $this, boolean bl) {
        $this.mFirstMediaSizeChangeForStat = bl;
    }

    public static final /* synthetic */ void access$statisticMicOpenTime(MediaServiceImpl $this, boolean start, String pluginId) {
        $this.statisticMicOpenTime(start, pluginId);
    }

    public static final /* synthetic */ void access$statisticsSpeakingTime(MediaServiceImpl $this, boolean start, boolean forceUpload, String pluginId) {
        $this.statisticsSpeakingTime(start, forceUpload, pluginId);
    }

    public static final /* synthetic */ void access$changeAudioAndVideoMute(MediaServiceImpl $this, String channelId, ChannelPluginData pluginData) {
        $this.changeAudioAndVideoMute(channelId, pluginData);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0016J$\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J(\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"H\u0016J(\u0010(\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\"2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0012H\u0016J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0012H\u0016J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u0001H\u0016J\u0010\u0010/\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u0001H\u0016R\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u00060"}, d2={"Lcom/yy/hiyo/channel/service/media/MediaServiceImpl$PendingCallback;", "Lcom/yy/appbase/live/LiveCallback;", "Lcom/yy/hiyo/channel/base/service/IMediaService$IMediaPendingCallback;", "()V", "mCallback", "Ljava/lang/ref/WeakReference;", "getMCallback", "()Ljava/lang/ref/WeakReference;", "setMCallback", "(Ljava/lang/ref/WeakReference;)V", "mLock", "Ljava/lang/Object;", "getMLock", "()Ljava/lang/Object;", "setMLock", "(Ljava/lang/Object;)V", "pendingNotifyOpenUid", "", "", "getPendingNotifyOpenUid", "()Ljava/util/Set;", "setPendingNotifyOpenUid", "(Ljava/util/Set;)V", "pendingNotifyStartUid", "getPendingNotifyStartUid", "setPendingNotifyStartUid", "destroy", "", "getCallback", "onJoinChannelSuccess", "channel", "", "p1", "elapsed", "", "onVideoSizeChange", "anchorId", "width", "height", "rotation", "onVideoStart", "isCdn", "", "onVideoStop", "onVideoStreamOpen", "registerCallback", "callback", "unregisterCallback", "channel-components_release"})
    private static final class PendingCallback
    implements LiveCallback,
    IMediaService.IMediaPendingCallback {
        @Nullable
        private WeakReference<LiveCallback> mCallback;
        @NotNull
        private Set<Long> pendingNotifyOpenUid;
        @NotNull
        private Set<Long> pendingNotifyStartUid;
        @NotNull
        private Object mLock;

        @Nullable
        public final WeakReference<LiveCallback> getMCallback() {
            return this.mCallback;
        }

        public final void setMCallback(@Nullable WeakReference<LiveCallback> weakReference) {
            this.mCallback = weakReference;
        }

        @NotNull
        public final Set<Long> getPendingNotifyOpenUid() {
            return this.pendingNotifyOpenUid;
        }

        public final void setPendingNotifyOpenUid(@NotNull Set<Long> set) {
            Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
            this.pendingNotifyOpenUid = set;
        }

        @NotNull
        public final Set<Long> getPendingNotifyStartUid() {
            return this.pendingNotifyStartUid;
        }

        public final void setPendingNotifyStartUid(@NotNull Set<Long> set) {
            Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
            this.pendingNotifyStartUid = set;
        }

        @NotNull
        public final Object getMLock() {
            return this.mLock;
        }

        public final void setMLock(@NotNull Object object) {
            Intrinsics.checkParameterIsNotNull((Object)object, (String)"<set-?>");
            this.mLock = object;
        }

        public void onVideoStart(long anchorId, int width, int height, boolean isCdn) {
            WeakReference<LiveCallback> weakReference = this.mCallback;
            MLog.info((Object)MediaServiceImpl.TAG, (String)("cb-- onVideoStart uid:" + anchorId + " callback:" + (weakReference != null ? (LiveCallback)weakReference.get() : null)), (Object[])new Object[0]);
            this.pendingNotifyStartUid.add(anchorId);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, anchorId, width, height, isCdn){
                final /* synthetic */ PendingCallback this$0;
                final /* synthetic */ long $anchorId;
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ boolean $isCdn;

                public final void run() {
                    block0: {
                        LiveCallback liveCallback;
                        WeakReference<LiveCallback> weakReference = this.this$0.getMCallback();
                        if ((weakReference != null ? (LiveCallback)weakReference.get() : null) == null || (liveCallback = this.this$0.getMCallback()) == null || (liveCallback = (LiveCallback)liveCallback.get()) == null) break block0;
                        liveCallback.onVideoStart(this.$anchorId, this.$width, this.$height, this.$isCdn);
                    }
                }
                {
                    this.this$0 = pendingCallback;
                    this.$anchorId = l;
                    this.$width = n;
                    this.$height = n2;
                    this.$isCdn = bl;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onVideoStop(long anchorId) {
            WeakReference<LiveCallback> weakReference = this.mCallback;
            MLog.info((Object)MediaServiceImpl.TAG, (String)("cb-- onVideoStop uid:" + anchorId + " callback:" + (weakReference != null ? (LiveCallback)weakReference.get() : null)), (Object[])new Object[0]);
            Object object = this.mLock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                Iterator<Long> iterator = this.pendingNotifyOpenUid.iterator();
                while (iterator.hasNext()) {
                    long openUid = ((Number)iterator.next()).longValue();
                    if (anchorId != openUid) continue;
                    iterator.remove();
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, anchorId){
                    final /* synthetic */ PendingCallback this$0;
                    final /* synthetic */ long $anchorId$inlined;
                    {
                        this.this$0 = pendingCallback;
                        this.$anchorId$inlined = l;
                    }

                    public final void run() {
                        block0: {
                            LiveCallback liveCallback = this.this$0.getMCallback();
                            if (liveCallback == null || (liveCallback = (LiveCallback)liveCallback.get()) == null) break block0;
                            liveCallback.onVideoStop(this.$anchorId$inlined);
                        }
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
        }

        public void onVideoSizeChange(long anchorId, int width, int height, int rotation) {
            block0: {
                LiveCallback liveCallback = this.mCallback;
                if (liveCallback == null || (liveCallback = (LiveCallback)liveCallback.get()) == null) break block0;
                liveCallback.onVideoSizeChange(anchorId, width, height, rotation);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onVideoStreamOpen(long anchorId) {
            WeakReference<LiveCallback> weakReference = this.mCallback;
            MLog.info((Object)MediaServiceImpl.TAG, (String)("cb-- onVideoStreamOpen uid:" + anchorId + " callback:" + (weakReference != null ? (LiveCallback)weakReference.get() : null)), (Object[])new Object[0]);
            Object object = this.mLock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                this.pendingNotifyOpenUid.add(anchorId);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, anchorId){
                    final /* synthetic */ PendingCallback this$0;
                    final /* synthetic */ long $anchorId$inlined;
                    {
                        this.this$0 = pendingCallback;
                        this.$anchorId$inlined = l;
                    }

                    public final void run() {
                        block0: {
                            LiveCallback liveCallback;
                            WeakReference<LiveCallback> weakReference = this.this$0.getMCallback();
                            if ((weakReference != null ? (LiveCallback)weakReference.get() : null) == null || (liveCallback = this.this$0.getMCallback()) == null || (liveCallback = (LiveCallback)liveCallback.get()) == null) break block0;
                            liveCallback.onVideoStreamOpen(this.$anchorId$inlined);
                        }
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
        }

        public void onJoinChannelSuccess(@Nullable String channel, @Nullable String p1, int elapsed) {
        }

        public void registerCallback(@NotNull LiveCallback callback2) {
            Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
            MLog.info((Object)MediaServiceImpl.TAG, (String)("cb-- registerCallback callback:" + callback2), (Object[])new Object[0]);
            this.mCallback = new WeakReference<LiveCallback>(callback2);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                final /* synthetic */ PendingCallback this$0;

                public final void run() {
                    Iterator<E> iterator = CollectionsKt.reversed((Iterable)this.this$0.getPendingNotifyOpenUid()).iterator();
                    while (iterator.hasNext()) {
                        long openUid = ((Number)iterator.next()).longValue();
                        MLog.info((Object)"MediaServiceImpl", (String)("cb-- registerCallback onVideoStreamOpen uid: " + openUid), (Object[])new Object[0]);
                        LiveCallback liveCallback = this.this$0.getMCallback();
                        if (liveCallback == null || (liveCallback = (LiveCallback)liveCallback.get()) == null) continue;
                        liveCallback.onVideoStreamOpen(openUid);
                    }
                }
                {
                    this.this$0 = pendingCallback;
                }
            });
        }

        public void unregisterCallback(@NotNull LiveCallback callback2) {
            Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
            WeakReference<LiveCallback> weakReference = this.mCallback;
            MLog.info((Object)MediaServiceImpl.TAG, (String)("cb-- unregisterCallback same callback:" + Intrinsics.areEqual((Object)(weakReference != null ? (LiveCallback)weakReference.get() : null), (Object)callback2)), (Object[])new Object[0]);
            WeakReference<LiveCallback> weakReference2 = this.mCallback;
            if (Intrinsics.areEqual((Object)(weakReference2 != null ? (LiveCallback)weakReference2.get() : null), (Object)callback2)) {
                WeakReference<LiveCallback> weakReference3 = this.mCallback;
                if (weakReference3 != null) {
                    weakReference3.clear();
                }
                this.mCallback = null;
            }
        }

        @Nullable
        public LiveCallback getCallback() {
            WeakReference<LiveCallback> weakReference = this.mCallback;
            return weakReference != null ? (LiveCallback)weakReference.get() : null;
        }

        public void destroy() {
            MLog.info((Object)MediaServiceImpl.TAG, (String)"cb-- destroy", (Object[])new Object[0]);
            WeakReference<LiveCallback> weakReference = this.mCallback;
            if (weakReference != null) {
                weakReference.clear();
            }
            this.mCallback = null;
            this.pendingNotifyOpenUid.clear();
            this.pendingNotifyStartUid.clear();
        }

        public PendingCallback() {
            Set set;
            PendingCallback pendingCallback = this;
            boolean bl = false;
            pendingCallback.pendingNotifyOpenUid = set = (Set)new LinkedHashSet();
            pendingCallback = this;
            bl = false;
            pendingCallback.pendingNotifyStartUid = set = (Set)new LinkedHashSet();
            this.mLock = new Object();
        }

        public void onSourceChange(boolean isCdn) {
            LiveCallback.DefaultImpls.onSourceChange((LiveCallback)this, (boolean)isCdn);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/service/media/MediaServiceImpl$Companion;", "", "()V", "TAG", "", "channel-components_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

