/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.data.local;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.service.data.local.ChannelMembers;
import com.yy.hiyo.channel.service.data.local.ChannelMembersList;
import com.yy.hiyo.channel.service.data.local.ChannelMembersOld;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

@DontProguardClass
public class ChannelMembersListNew {
    private static final String FILE_NAME_OLD = "ChannelMembersList";
    private static final String FILE_NAME_PRE = "ChannelMembersListNew";
    private static final int MAX_NUM = 30;
    public HashMap<String, ChannelMembers> membersList = new HashMap();
    public long index;

    public static ChannelMembersListNew loadFromFile(long uid) {
        if (RuntimeContext.sIsDebuggable && !SettingFlags.getBoolean((String)"groupfixvererror5", (boolean)false)) {
            SettingFlags.setBoolean((String)"groupfixvererror5", (boolean)true);
            FileStorageUtils.getInstance().saveToFile(!RuntimeContext.sIsDebuggable, FILE_NAME_PRE + uid, "");
        }
        ChannelMembersListNew list2 = null;
        String fileData2 = FileStorageUtils.getInstance().getStrFromFile(!RuntimeContext.sIsDebuggable, FILE_NAME_PRE + uid);
        if (StringUtils.isNotEmpty((String)fileData2)) {
            list2 = (ChannelMembersListNew)JsonParser.parseJsonObject((String)fileData2, ChannelMembersListNew.class);
            if (!ChannelDefine.sUnEnableLog) {
                MLog.info((Object)"FTRoomGroupLocalData", (String)"ChannelMembersList loadFromFile:%s", (Object[])new Object[]{fileData2});
            }
        } else {
            fileData2 = FileStorageUtils.getInstance().getStrFromFile(!RuntimeContext.sIsDebuggable, FILE_NAME_OLD + uid);
            if (StringUtils.isNotEmpty((String)fileData2)) {
                ChannelMembersList oldList = (ChannelMembersList)JsonParser.parseJsonObject((String)fileData2, ChannelMembersList.class);
                list2 = ChannelMembersListNew.obtain(oldList);
                FileStorageUtils.getInstance().removeFile(!RuntimeContext.sIsDebuggable, FILE_NAME_OLD + uid);
            }
            if (!ChannelDefine.sUnEnableLog) {
                MLog.info((Object)"FTRoomGroupLocalData", (String)"ChannelMembersList loadFromFile empty!", (Object[])new Object[0]);
            }
        }
        return list2 == null ? new ChannelMembersListNew() : list2;
    }

    private static ChannelMembersListNew obtain(ChannelMembersList oldList) {
        if (oldList == null) {
            return null;
        }
        ChannelMembersListNew listNew = new ChannelMembersListNew();
        listNew.index = oldList.index;
        if (oldList.membersList != null) {
            listNew.membersList = new HashMap(oldList.membersList.size());
            if (oldList.membersList.size() > 0) {
                Set<String> keys = oldList.membersList.keySet();
                for (String key : keys) {
                    listNew.membersList.put(key, ChannelMembersOld.obtain(oldList.membersList.get(key)));
                }
            }
        }
        return listNew;
    }

    private static void removeExceed(ChannelMembersListNew list2) {
        if (list2 != null && list2.membersList != null && list2.membersList.size() > 30) {
            Set<String> keys = list2.membersList.keySet();
            ArrayList<String> keysToDlete = new ArrayList<String>(list2.membersList.size() - 30);
            ChannelMembers data2 = null;
            for (String key : keys) {
                data2 = list2.membersList.get(key);
                if (data2 == null || data2.index + 30L > list2.index) continue;
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroupLocalData", (String)"membersList add remove key:%s,index:%s,totalIndex:%s!", (Object[])new Object[]{key, data2.index, list2.index});
                }
                keysToDlete.add(key);
            }
            if (keysToDlete.size() > 0) {
                for (String key : keysToDlete) {
                    list2.membersList.remove(key);
                    if (ChannelDefine.sUnEnableLog) continue;
                    MLog.info((Object)"FTRoomGroupLocalData", (String)"membersList remove:%s!", (Object[])new Object[]{key});
                }
            }
        }
    }

    public static void saveFile(long uid, ChannelMembersListNew list2) {
        if (list2 == null) {
            return;
        }
        ChannelMembersListNew.removeExceed(list2);
        String fileData2 = JsonParser.toJson((Object)list2, ChannelMembersListNew.class);
        if (StringUtils.isNotEmpty((String)fileData2)) {
            FileStorageUtils.getInstance().saveToFile(!RuntimeContext.sIsDebuggable, fileData2, FILE_NAME_PRE + uid);
            if (!ChannelDefine.sUnEnableLog) {
                MLog.info((Object)"FTRoomGroupLocalData", (String)"ChannelMembersList saveToFile:%s", (Object[])new Object[]{fileData2});
            }
        } else if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)"FTRoomGroupLocalData", (String)"ChannelMembersList saveToFile empty!", (Object[])new Object[0]);
        }
    }

    public long generateIndex() {
        ++this.index;
        return this.index;
    }

    public void clearData() {
        if (this.membersList != null) {
            this.membersList.clear();
        }
    }
}

