/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.data;

import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.appbase.util.RegionUtils;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfoSelector;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.FamilyGateInfo;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.module.endpage.data.LocalEndPageData;
import com.yy.hiyo.channel.service.BaseService;
import com.yy.hiyo.channel.service.data.ChannelModel;
import com.yy.hiyo.channel.service.data.ILocalDataModel;
import com.yy.hiyo.channel.service.data.InnerUpdateInfoCallBack;
import com.yy.hiyo.channel.service.request.ChannelRequestManager;
import com.yy.hiyo.mvp.base.ExtensionsKt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class DataService
extends BaseService
implements IDataService {
    private static final String TAG = "FTRoomGroupDataService";
    private ChannelModel groupModel;
    private ChannelRequestManager requestManager = null;
    private HashMap<String, Object> channelExtra = new HashMap();
    private HashMap<String, Object> extra = new HashMap();
    private LocalEndPageData mLocalEndPageData;

    public DataService(IChannel group, ILocalDataModel localGroupDataManager) {
        super(group, localGroupDataManager);
        this.groupModel = new ChannelModel(this.getGroupId(), localGroupDataManager, () -> {
            ChannelInfo info = localGroupDataManager.getChannelInfoFromMem(this.getGroupId());
            if (info != null && !FP.empty((CharSequence)info.getParentId()) && !StringUtils.equal((String)info.getParentId(), (String)info.getChannelId())) {
                return ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getChannel(info.getParentId());
            }
            return null;
        });
        this.requestManager = new ChannelRequestManager();
    }

    public void getTopAndSubChannelInfos(IDataService.IGetTopAndSubInfosCallBack callBack) {
        this.groupModel.getTopAndSubGroupInfos(callBack, false);
    }

    public void getAcrossRecommendList(String channelId, String pid, int recommendType, @Nullable String pluginId, boolean videoMode, IDataService.IGetAcrossRecommendListCallback callback2) {
        this.requestManager.fetchAcrossRecommendList(channelId, pid, recommendType, pluginId, videoMode, callback2);
    }

    public void updateName(final String name, final IDataService.IUpdateNameCallBack callBack) {
        this.requestManager.setName(this.getGroupId(), name, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateName(DataService.this.getGroupId(), name, -1L);
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",renameSuccess:%s"), (Object[])new Object[]{name});
                }
            }

            public void updateLimit(String toast) {
                if (callBack != null) {
                    callBack.renameLimit(toast);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateLimit:%s"), (Object[])new Object[]{toast});
                }
            }

            public void limitNoToast() {
                if (callBack != null) {
                    callBack.limitNoToast();
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",limitNoToast"), (Object[])new Object[0]);
                }
            }

            public void onContainSensitiveWord() {
                if (callBack != null) {
                    callBack.onContainSensitiveWord();
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateName errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }

            public void onRecommendTagUpdate(@Nullable String tagId) {
                DataService.this.groupModel.onRecommendTagUpdate(tagId);
            }
        });
    }

    public void updateAvatar(final String url, final IDataService.IUpdateAvatarCallback callback2) {
        this.requestManager.setChannelAvatar(this.getGroupId(), url, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateChannelAvatar(DataService.this.getGroupId(), url);
                if (callback2 != null) {
                    callback2.onSuccess(url);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateAvatarSuccess:%s"), (Object[])new Object[]{url});
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callback2 != null) {
                    callback2.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateAvatar errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void updateCategory(final int firstCategory, final int secondCategory, boolean updateToIndieGameSourceIfCategoryIsGame, final @Nullable IDataService.IUpdateCategoryCallback callback2) {
        this.requestManager.updateCategory(this.getGroupId(), firstCategory, secondCategory, updateToIndieGameSourceIfCategoryIsGame, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateCategory(DataService.this.getGroupId(), firstCategory, secondCategory);
                if (callback2 != null) {
                    callback2.onSuccess(DataService.this.getGroupId(), firstCategory, secondCategory);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateCategory Success:%d %d"), (Object[])new Object[]{firstCategory, secondCategory});
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callback2 != null) {
                    callback2.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateCategory errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void updateannouncement(final String announcement, boolean withPush, final IDataService.IUpdateInfoCallBack callBack) {
        this.requestManager.setAnnouncement(this.getGroupId(), announcement, withPush, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateannouncement(DataService.this.getGroupId(), announcement, -1L);
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
            }

            public void updateLimit(String toast) {
                if (callBack != null) {
                    callBack.updateLimit(toast);
                }
            }

            public void limitNoToast() {
                if (callBack != null) {
                    callBack.limitNoToast();
                }
            }

            public void onContainSensitiveWord() {
                if (callBack != null) {
                    callBack.onContainSensitiveWord();
                }
            }

            public void onFailUnauthorized() {
                if (callBack != null) {
                    callBack.onFailUnauthorized();
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateannouncement errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void setOpenPartyPermission(final boolean forbidMember, final IDataService.IUpdateInfoCallBack callBack) {
        this.requestManager.setOpenPartyPermission(this.getGroupId(), forbidMember, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateOpenPartyPermission(DataService.this.getGroupId(), forbidMember);
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",setOpenPartyPermission success:%d"), (Object[])new Object[]{forbidMember});
                }
            }

            public void onFailUnauthorized() {
                if (callBack != null) {
                    callBack.onFailUnauthorized();
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",setOpenPartyPermission errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void updateSpeakMode(final int speakMode, final IDataService.IUpdateInfoCallBack callBack) {
        this.requestManager.setSpeakMode(this.getGroupId(), speakMode, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateSpeakMode(DataService.this.getGroupId(), speakMode, -1L);
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateSpeakMode success:%d"), (Object[])new Object[]{speakMode});
                }
            }

            public void onContainSensitiveWord() {
                if (callBack != null) {
                    callBack.onContainSensitiveWord();
                }
            }

            public void onFailUnauthorized() {
                if (callBack != null) {
                    callBack.onFailUnauthorized();
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateSpeakMode errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void updateVoiceEnterMode(final int voiceEnterMode, final IDataService.IUpdateInfoCallBack callBack) {
        this.requestManager.setVoiceEnterMode(this.getGroupId(), voiceEnterMode, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateChannelVoiceEnterMode(DataService.this.getGroupId(), voiceEnterMode, -1L);
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateVoiceEnterMode success:%d"), (Object[])new Object[]{voiceEnterMode});
                }
            }

            public void onContainSensitiveWord() {
                if (callBack != null) {
                    callBack.onContainSensitiveWord();
                }
            }

            public void onFailUnauthorized() {
                if (callBack != null) {
                    callBack.onFailUnauthorized();
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateVoiceEnterMode errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void updateGuestSpeakLimit(final int bitmask, final IDataService.IUpdateInfoCallBack callBack) {
        this.requestManager.setGuestSpeakLimit(this.getGroupId(), bitmask, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateChannelGuestSpeakLimit(DataService.this.getGroupId(), bitmask, -1L);
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateGuestSpeakLimit success:%d"), (Object[])new Object[]{bitmask});
                }
            }

            public void onContainSensitiveWord() {
                if (callBack != null) {
                    callBack.onContainSensitiveWord();
                }
            }

            public void onFailUnauthorized() {
                if (callBack != null) {
                    callBack.onFailUnauthorized();
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateGuestSpeakLimit errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void updateChannelPostPermission(final int content, final int role, final IDataService.IUpdateInfoCallBack callBack) {
        this.requestManager.updateChannelPostPermission(this.getGroupId(), content, role, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateChannelPostPermission(DataService.this.getGroupId(), role, content);
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateChannelPostSyncContent success:%s"), (Object[])new Object[]{content});
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateChannelPostSyncContent errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void updateChannelPostPermission(final int content, final int role, final int topPerm, final IDataService.IUpdateInfoCallBack callBack) {
        this.requestManager.updateChannelPostPermission(this.getGroupId(), content, role, topPerm, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateChannelPostPermission(DataService.this.getGroupId(), role, content, topPerm);
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateChannelPostSyncContent success:%s"), (Object[])new Object[]{content});
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateChannelPostSyncContent errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void updateJoinMode(final int mode, final String password, int lockEnterMode, final IDataService.IUpdateInfoCallBack callBack) {
        this.requestManager.setEnterMode(this.getGroupId(), mode, password, lockEnterMode, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateJoinMode(DataService.this.getGroupId(), password, "", mode, -1L);
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateJoinMode success:%d password:%s"), (Object[])new Object[]{mode, password});
                }
            }

            public void onContainSensitiveWord() {
                if (callBack != null) {
                    callBack.onContainSensitiveWord();
                }
            }

            public void onFailUnauthorized() {
                if (callBack != null) {
                    callBack.onFailUnauthorized();
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateJoinMode errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void updatePrivacyMode(final boolean privatePrivacy, final IDataService.IUpdateInfoCallBack callBack) {
        this.requestManager.updatePrivacyMode(this.getGroupId(), privatePrivacy, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updatePrivacyMode(DataService.this.getGroupId(), privatePrivacy);
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updatePrivacyMode success:%d"), (Object[])new Object[]{privatePrivacy ? 1 : 0});
                }
            }

            public void updateLimit(String toast) {
                if (callBack != null) {
                    callBack.updateLimit(toast);
                }
            }

            public void limitNoToast() {
                if (callBack != null) {
                    callBack.limitNoToast();
                }
            }

            public void onContainSensitiveWord() {
                if (callBack != null) {
                    callBack.onContainSensitiveWord();
                }
            }

            public void onFailUnauthorized() {
                if (callBack != null) {
                    callBack.onFailUnauthorized();
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updatePrivacyMode errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void updateLightEffect(final String lightEffect, final IDataService.IUpdateInfoCallBack callBack) {
        this.requestManager.updateLightEffect(this.getGroupId(), lightEffect, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateJoinMode success: lightEffect:%s"), (Object[])new Object[]{lightEffect});
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateJoinMode errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void updateRoleJoinMode(final int mode, final IDataService.IUpdateInfoCallBack callBack) {
        this.requestManager.updateRoleJoinMode(this.getGroupId(), mode, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateRoleJoinMode(DataService.this.getGroupId(), mode);
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateRoleJoinMode success:%d"), (Object[])new Object[]{mode});
                }
            }

            public void updateLimit(String toast) {
                if (callBack != null) {
                    callBack.updateLimit(toast);
                }
            }

            public void limitNoToast() {
                if (callBack != null) {
                    callBack.limitNoToast();
                }
            }

            public void onContainSensitiveWord() {
                if (callBack != null) {
                    callBack.onContainSensitiveWord();
                }
            }

            public void onFailUnauthorized() {
                if (callBack != null) {
                    callBack.onFailUnauthorized();
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateRoleJoinMode errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void changeFamilyGate(final FamilyGateInfo gateInfo, final IDataService.IUpdateFamilyGateCallBack callBack) {
        this.requestManager.changeFamilyGate(this.getGroupId(), gateInfo, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateFamilyGateInfo(DataService.this.getGroupId(), gateInfo);
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateannouncement errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void updateOpenVoiceChatMode(final int mode, final IDataService.IUpdateInfoCallBack callBack) {
        this.requestManager.updateOpenVoiceChatMode(this.getGroupId(), mode, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateOpenVoiceChatMode(DataService.this.getGroupId(), mode);
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateOpenVoiceChatMode success:%d"), (Object[])new Object[]{mode});
                }
            }

            public void updateLimit(String toast) {
                if (callBack != null) {
                    callBack.updateLimit(toast);
                }
            }

            public void limitNoToast() {
                if (callBack != null) {
                    callBack.limitNoToast();
                }
            }

            public void onContainSensitiveWord() {
                if (callBack != null) {
                    callBack.onContainSensitiveWord();
                }
            }

            public void onFailUnauthorized() {
                if (callBack != null) {
                    callBack.onFailUnauthorized();
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateOpenVoiceChatMode errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void updateTag(final ArrayList<String> tagIds, final IDataService.IUpdateInfoCallBack callBack) {
        if (tagIds == null || tagIds.size() <= 0) {
            callBack.onError(this.getGroupId(), -1, "", new Exception());
            return;
        }
        this.requestManager.updateTag(this.getGroupId(), tagIds, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.updateTag(DataService.this.getGroupId(), tagIds);
                if (callBack != null) {
                    callBack.onSuccess(DataService.this.channel);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateTag success:%s"), (Object[])new Object[]{tagIds});
                }
            }

            public void updateLimit(String toast) {
                if (callBack != null) {
                    callBack.updateLimit(toast);
                }
            }

            public void limitNoToast() {
                if (callBack != null) {
                    callBack.limitNoToast();
                }
            }

            public void onContainSensitiveWord() {
                if (callBack != null) {
                    callBack.onContainSensitiveWord();
                }
            }

            public void onFailUnauthorized() {
                if (callBack != null) {
                    callBack.onFailUnauthorized();
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(DataService.this.channel.getChannelId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateTag errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void linkTag(String tagId, Callback<Boolean> callback2) {
        ArrayList<String> list2 = new ArrayList<String>(1);
        list2.add(tagId);
        this.updateTag(list2, new InnerUpdateInfoCallBack(callback2));
    }

    public void unLinkTag(Callback<Boolean> callback2) {
        ArrayList<String> list2 = new ArrayList<String>(1);
        list2.add("");
        this.updateTag(list2, new InnerUpdateInfoCallBack(callback2));
    }

    public String getTagId() {
        ChannelInfo info = this.getChannelDetailInfo(null).baseInfo;
        return StringUtils.notNull((String)info.tag.getFirstTag().getTagId());
    }

    public void getInviteEnterToken(IDataService.IGetInviteTokenCallBack callBack) {
        this.requestManager.getInviteEnterToken(this.getGroupId(), callBack);
    }

    public ChannelDetailInfo getChannelDetailInfo(IDataService.IGetDetailInfoCallBack callBack) {
        return this.groupModel.getGroupDetailInfo(this.getGroupId(), callBack, false);
    }

    public void fetchChannelDetailInfo(IDataService.IGetDetailInfoCallBack callBack) {
        ChannelDetailInfo cache = this.groupModel.getGroupInfo(this.getGroupId());
        if (cache != null && cache.baseInfo != null && cache.baseInfo.ownerUid > 0L) {
            if (callBack != null) {
                callBack.onSuccess(cache.baseInfo.gid, cache);
            }
        } else {
            this.groupModel.getGroupDetailInfo(this.getGroupId(), null, callBack, false, true);
        }
    }

    public void getChannelDetailInfo(ChannelInfoSelector infoSelector, IDataService.IGetDetailInfoCallBack callBack) {
        this.groupModel.getGroupDetailInfo(this.getGroupId(), infoSelector, callBack);
    }

    public void fetchChannelDetailInfo(IDataService.IGetDetailInfoCallBack callBack, boolean needPartyBg) {
        ChannelDetailInfo cache = this.groupModel.getGroupInfo(this.getGroupId());
        if (cache != null && cache.baseInfo != null && cache.baseInfo.ownerUid > 0L && !needPartyBg) {
            if (callBack != null) {
                callBack.onSuccess(cache.baseInfo.gid, cache);
            }
        } else {
            this.groupModel.getGroupDetailInfo(this.getGroupId(), new ChannelInfoSelector(false, needPartyBg), callBack, false, true);
        }
    }

    @Nullable
    public ChannelDetailInfo getCacheDetail() {
        ChannelDetailInfo info = this.groupModel.getGroupInfo(this.getGroupId());
        if (info == null) {
            this.groupModel.getGroupDetailInfo(this.getGroupId(), null, null, false, true);
        }
        return info;
    }

    @Override
    public void onJoined(boolean rejoin2, ChannelDetailInfo info, EnterChannelData data2) {
        super.onJoined(rejoin2, info, data2);
        this.groupModel.onJoined(rejoin2, info, data2);
    }

    public void getChannelBaseInfoFromServer(IDataService.IGetGroupBaseInfoCallBack callBack) {
        this.getChannelBaseInfo(callBack, true);
    }

    public void getChannelBaseInfo(IDataService.IGetGroupBaseInfoCallBack callBack) {
        this.getChannelBaseInfo(callBack, false);
    }

    private void getChannelBaseInfo(final IDataService.IGetGroupBaseInfoCallBack callBack, boolean forceFromServer) {
        this.groupModel.getGroupDetailInfo(this.getGroupId(), null, new IDataService.IGetDetailInfoCallBack(){

            public void onSuccess(String channelId, ChannelDetailInfo info) {
                if (callBack != null) {
                    callBack.onSuccess(channelId, info != null ? info.baseInfo : null);
                }
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(channelId, errorCode, errorTips, e);
                }
            }
        }, true, forceFromServer);
    }

    public void addDataListener(IDataService.IDataUpdateListener listener2) {
        this.groupModel.addDataListener(listener2);
    }

    public void removeDataListener(IDataService.IDataUpdateListener listener2) {
        this.groupModel.removeDataListener(listener2);
    }

    public boolean useOldRoomStyle() {
        return this.groupModel.useOldRoomStyle();
    }

    public void addChannelExtra(String key, Object value) {
        if (this.getExtra(true) != null) {
            this.getExtra(true).put(key, value);
        }
    }

    public <T> T getChannelExtra(String key, T defaultValue) {
        return this.getExtraValue(key, defaultValue, true);
    }

    public void addExtra(String key, Object value) {
        if (this.getExtra(false) != null) {
            this.getExtra(false).put(key, value);
        }
    }

    public <T> T getExtra(String key, T defaultValue) {
        return this.getExtraValue(key, defaultValue, false);
    }

    @Override
    public void onSubGroupAdded(ChannelDetailInfo subGroupInfo) {
        this.groupModel.onSubGroupAdded(subGroupInfo);
    }

    @Override
    public void onSubGroupDisbanded(String groupId, long ver) {
        this.groupModel.onSubGroupDisbanded(groupId, ver);
    }

    @Override
    public void handleNotifyOnline(long onlineNum) {
        this.groupModel.updateOnline(this.getGroupId(), onlineNum);
    }

    @Override
    public void handleNotifyBanned(long operUid, boolean banned, long time) {
        this.groupModel.banned(this.getGroupId(), AccountUtil.getUid(), banned);
    }

    @Override
    public void handleNotifySetSpeakMode(NotifyDataDefine.SetSpeakMode data2) {
        this.groupModel.updateSpeakMode(this.getGroupId(), data2.mode, data2.getSignalVer());
    }

    @Override
    public void handleNotifySetVoiceEnterMode(NotifyDataDefine.SetVoiceEnterMode data2) {
        this.groupModel.updateChannelVoiceEnterMode(this.getGroupId(), data2.voiceEnterMode, data2.getSignalVer());
    }

    @Override
    public void handleNotifySetGuestSpeakLimit(NotifyDataDefine.SetGuestSpeakLimit data2) {
        this.groupModel.updateChannelGuestSpeakLimit(this.getGroupId(), data2.guestSpeakLimit, data2.getSignalVer());
    }

    @Override
    public void handleNotifySetName(NotifyDataDefine.SetName data2) {
        this.groupModel.updateName(this.getGroupId(), data2.name, data2.getSignalVer());
    }

    @Override
    public void handleNotifySetJoinMode(NotifyDataDefine.SetJoinMode data2) {
        this.groupModel.updateJoinMode(this.getGroupId(), data2.password, StringUtils.notNull((String)data2.pwdToken), data2.joinmode, data2.getSignalVer());
    }

    @Override
    public void handleNotifySetAnnouncement(NotifyDataDefine.SetAnnouncement data2) {
        this.groupModel.updateannouncement(this.getGroupId(), data2.announcement, data2.getSignalVer());
    }

    @Override
    public void handleNotifyCreateGroup(NotifyDataDefine.CreateGroup data2) {
        this.groupModel.onSubGroupAdded();
    }

    @Override
    public void onNotify(ChannelNotify notify2) {
        if (notify2.uri == ChannelNotify.Uri.UriSetVoiceOpenModeNotify) {
            NotifyDataDefine.SetVoiceOpenMode mode = notify2.notify.voiceOpenMode;
            if (mode != null && mode.mode > 0) {
                this.groupModel.updateOpenVoiceChatMode(this.getGroupId(), mode.mode);
            }
        } else if (notify2.uri == ChannelNotify.Uri.UriSetPrivacyModeNotify) {
            NotifyDataDefine.SetPrivacyMode mode = notify2.notify.privacyMode;
            if (mode != null) {
                this.groupModel.updatePrivacyMode(this.getGroupId(), mode.isPrivateMode);
            }
        } else if (notify2.uri == ChannelNotify.Uri.UriBeRoleMode) {
            NotifyDataDefine.SetJoinChannelMode mode = notify2.notify.beRoleMode;
            if (mode != null && mode.mode > 0) {
                this.groupModel.updateRoleJoinMode(this.getGroupId(), mode.mode);
            }
        } else if (notify2.uri == ChannelNotify.Uri.UriChannelUpgradeNotify) {
            NotifyDataDefine.ChannelUpgradeNotify upgradeNotify = notify2.notify.channelUpgrade;
            if (null != upgradeNotify) {
                this.groupModel.updateChannelVersion(this.getGroupId(), upgradeNotify.version, upgradeNotify.cid);
            }
        } else if (notify2.uri == ChannelNotify.Uri.UriChannelShowPermit) {
            NotifyDataDefine.ChannelShowPermit channelShowPermitNotify = notify2.notify.channelShowPermitNotify;
            if (null != channelShowPermitNotify) {
                this.groupModel.updateChannelShowPermit(this.getGroupId(), channelShowPermitNotify.channelShowPermit);
            }
        } else if (notify2.uri == ChannelNotify.Uri.UriLeaveNotify) {
            NotifyDataDefine.LeaveNotify leaveNotify = notify2.notify.levae;
            ChannelDetailInfo detailInfo = this.channel.getDataService().getCacheDetail();
            if (null != leaveNotify && null != detailInfo && detailInfo.baseInfo.isGroupParty() && leaveNotify.user == detailInfo.baseInfo.showUid) {
                this.groupModel.updateGroupPartyShowUid(this.getGroupId(), 0L);
            }
        }
    }

    @Override
    public void onWsConnect(boolean flag) {
        this.groupModel.onWsConnect(flag);
    }

    @Override
    public void onLeaved() {
        this.groupModel.onLeaveGroup();
        this.channelExtra.clear();
        super.onLeaved();
    }

    @Override
    public void onLeaveRequestFinished() {
        this.groupModel.onLeaveRequestFinished(this.getGroupId());
    }

    public void isSameRegion(long uid, final Callback<Boolean> callback2) {
        if (this.getCacheDetail() != null && uid == this.getCacheDetail().baseInfo.ownerUid) {
            ExtensionsKt.onUi(() -> {
                callback2.onResponse((Object)true);
                return null;
            });
            return;
        }
        this.getChannelBaseInfo((channelId, info) -> {
            final String chanelRegion = info.region.region;
            MLog.info((Object)TAG, (String)"channel region: %s", (Object[])new Object[]{chanelRegion});
            ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(uid, new OnProfileListCallback(){

                public void onUISuccess(List<UserInfoBean> userInfo) {
                    if (userInfo != null && !userInfo.isEmpty()) {
                        this.compareResult(userInfo.get(0).getRegion());
                    } else {
                        this.compareResult("");
                    }
                }

                public void onError(@Nullable Call call, @Nullable Exception e, int id2) {
                    this.compareResult("");
                }

                public void onResponseError(int id2, @Nullable String message, @Nullable String response) {
                    this.compareResult("");
                }

                private void compareResult(String userRegion) {
                    MLog.info((Object)DataService.TAG, (String)"isSameRegion chanelRegion: %s, userRegion: %s", (Object[])new Object[]{chanelRegion, userRegion});
                    ExtensionsKt.onUi(() -> {
                        callback2.onResponse((Object)RegionUtils.isSame((String)chanelRegion, (String)userRegion));
                        return null;
                    });
                }
            });
        });
    }

    public void updateChannelMemberSwitch(boolean switchValue) {
        if (this.groupModel != null) {
            this.groupModel.updateChannelNickSwitch(this.getGroupId(), switchValue);
        }
    }

    public void updateChannelTitleSwitch(boolean switchValue) {
        if (this.groupModel != null) {
            this.groupModel.updateChannelTitleSwitch(this.getGroupId(), switchValue);
        }
    }

    @Nullable
    public Object getLocalEndPageData() {
        return this.mLocalEndPageData;
    }

    public void setLocalEndPageData(Object data2) {
        if (data2 instanceof LocalEndPageData) {
            this.mLocalEndPageData = (LocalEndPageData)data2;
        }
        if (data2 == null) {
            this.mLocalEndPageData = null;
        }
    }

    public void updateGroupChatBg(final String bgUrl, final IDataService.IUpdateChatBgCallback callback2) {
        this.requestManager.updateGroupChatBg(this.getGroupId(), bgUrl, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                if (callback2 != null) {
                    callback2.onSuccess();
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateGroupChatBg success:%s"), (Object[])new Object[]{bgUrl});
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callback2 != null) {
                    callback2.onError(errorCode, errorTips);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",updateGroupChatBg error:%d,%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void clearGroupChatBg(final IDataService.IUpdateChatBgCallback callback2) {
        this.requestManager.clearGroupChatBg(this.getGroupId(), new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                DataService.this.groupModel.clearGroupChatBg(DataService.this.getGroupId());
                if (callback2 != null) {
                    callback2.onSuccess();
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",clearGroupChatBg success"), (Object[])new Object[0]);
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callback2 != null) {
                    callback2.onError(errorCode, errorTips);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)DataService.TAG, (String)(DataService.this.getGroupId() + ",clearGroupChatBg error:%d,%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    private HashMap<String, Object> getExtra(Boolean isClear) {
        return isClear != false ? this.channelExtra : this.extra;
    }

    private <T> T getExtraValue(String key, T defaultValue, boolean clear) {
        Object value = this.getExtra(clear).get(key);
        if (value != null && (value.getClass().isInstance(defaultValue) || defaultValue == null)) {
            return (T)value;
        }
        return defaultValue;
    }
}

