/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.data;

import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelDynamicInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfoSelector;
import com.yy.hiyo.channel.base.bean.ChannelListData;
import com.yy.hiyo.channel.base.bean.ChannelTag;
import com.yy.hiyo.channel.base.bean.ChannelTagItem;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.FamilyGateInfo;
import com.yy.hiyo.channel.base.bean.ThemeItemBean;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.module.main.enter.EnterStatsHelper;
import com.yy.hiyo.channel.service.data.ChannelListModel;
import com.yy.hiyo.channel.service.data.ILocalDataModel;
import com.yy.hiyo.channel.service.request.ChannelRequestManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class ChannelModel {
    private static final String TAG = "FTRoomGroupDataService";
    private ChannelDetailInfo curJoinData;
    private boolean useOldRoomStyle;
    private long curJoinDataHasSyncTime = -1L;
    private ChannelRequestManager requestManager = null;
    private ArrayList<WeakReference<IDataService.IDataUpdateListener>> dataListeners;
    private IGroupModelCallBack groupModelCallBack;
    private ChannelListModel mChannelListModel;
    private ILocalDataModel localGroupDataManager;
    private IDataService.IDataUpdateListener parentDataListener;
    private String channelId;

    ChannelModel(String channelId, ILocalDataModel localGroupDataManager, IGroupModelCallBack groupModelCallBack) {
        this.channelId = channelId;
        this.localGroupDataManager = localGroupDataManager;
        this.groupModelCallBack = groupModelCallBack;
        this.requestManager = new ChannelRequestManager();
    }

    private ChannelListModel getChannelListModel() {
        if (this.mChannelListModel == null) {
            this.mChannelListModel = new ChannelListModel(this.channelId, this.requestManager, this.localGroupDataManager);
        }
        return this.mChannelListModel;
    }

    @Nullable
    ChannelDetailInfo getGroupInfo(String groupId) {
        ArrayList<ChannelDetailInfo> groupList;
        if (this.curJoinData != null && StringUtils.equal((String)this.curJoinData.baseInfo.gid, (String)groupId)) {
            return this.curJoinData;
        }
        if (this.mChannelListModel != null && (groupList = this.mChannelListModel.getTopAndSubGroupInfosFromCache()) != null && groupList.size() > 0) {
            for (ChannelDetailInfo item : groupList) {
                if (!StringUtils.equal((String)item.baseInfo.gid, (String)groupId)) continue;
                return item;
            }
        }
        return null;
    }

    void getTopAndSubGroupInfos(final IDataService.IGetTopAndSubInfosCallBack callBack, boolean justBaseInfo) {
        if (this.groupModelCallBack != null && this.groupModelCallBack.getParent() != null) {
            MLog.info((Object)TAG, (String)(this.channelId + ",getTopAndSubGroupInfos by parent:%s"), (Object[])new Object[]{this.groupModelCallBack.getParent().getChannelId()});
            this.groupModelCallBack.getParent().getDataService().getTopAndSubChannelInfos(new IDataService.IGetTopAndSubInfosCallBack(){

                public void onSuccess(String channelId, ChannelListData data2, List<Integer> totalCounts, List<Integer> limitCounts, ThemeItemBean themeItemBean) {
                    if (callBack != null) {
                        callBack.onSuccess(channelId, data2, totalCounts, limitCounts, themeItemBean);
                    }
                }

                public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                    if (callBack != null) {
                        callBack.onError(channelId, errorCode, errorTips, e);
                    }
                }
            });
            if (this.parentDataListener == null) {
                this.parentDataListener = new IDataService.IDataUpdateListener(){

                    public void onTopAndSubGroupListChange(String channelId, ChannelListData data2, List<Integer> totalNumList, List<Integer> limitNumList, ThemeItemBean themeItemBean) {
                        if (ChannelModel.this.dataListeners == null || ChannelModel.this.dataListeners.size() == 0) {
                            return;
                        }
                        for (WeakReference item : ChannelModel.this.dataListeners) {
                            IDataService.IDataUpdateListener listener2;
                            if (item == null || item.get() == null || (listener2 = (IDataService.IDataUpdateListener)item.get()) == null) continue;
                            listener2.onTopAndSubGroupListChange(channelId, data2, totalNumList, limitNumList, themeItemBean);
                        }
                    }
                };
                this.groupModelCallBack.getParent().getDataService().addDataListener(this.parentDataListener);
            }
        } else {
            MLog.info((Object)TAG, (String)(this.channelId + ",getTopAndSubGroupInfos!"), (Object[])new Object[0]);
            this.getChannelListModel().getTopAndSubGroupInfos(callBack);
        }
    }

    public ChannelDetailInfo getGroupDetailInfo(String groupId, IDataService.IGetDetailInfoCallBack callBack, boolean justBase) {
        return this.getGroupDetailInfo(groupId, null, callBack, justBase, false);
    }

    public ChannelDetailInfo getGroupDetailInfo(String groupId, ChannelInfoSelector infoSelector, IDataService.IGetDetailInfoCallBack callBack) {
        return this.getGroupDetailInfo(groupId, infoSelector, callBack, false, true);
    }

    public ChannelDetailInfo getGroupDetailInfo(final String groupId, ChannelInfoSelector infoSelector, final IDataService.IGetDetailInfoCallBack callBack, boolean justBase, boolean forceFromService) {
        long showUid;
        ChannelDetailInfo info = this.getGroupInfo(groupId);
        if (this.curJoinDataHasSyncTime > 0L && info != null && !forceFromService) {
            if (callBack != null && info != null) {
                callBack.onSuccess(groupId, info);
            }
            return info;
        }
        long l = showUid = null == info ? 0L : info.baseInfo.showUid;
        if (callBack != null || info == null) {
            this.requestManager.getChannelInfo(groupId, infoSelector, new BaseRequestManager.IGetChannelInfoCallBack(){

                public void onSuccess(ChannelInfo channelInfo, int topOnline) {
                    ChannelDetailInfo info;
                    if (ChannelModel.this.curJoinData != null) {
                        if (channelInfo != null && channelInfo.isValidData()) {
                            ((ChannelModel)ChannelModel.this).curJoinData.baseInfo = channelInfo;
                        }
                    } else {
                        ChannelModel.this.curJoinData = new ChannelDetailInfo();
                        ((ChannelModel)ChannelModel.this).curJoinData.baseInfo = channelInfo;
                        ((ChannelModel)ChannelModel.this).curJoinData.dynamicInfo = new ChannelDynamicInfo();
                    }
                    if (0L == ((ChannelModel)ChannelModel.this).curJoinData.baseInfo.showUid) {
                        ((ChannelModel)ChannelModel.this).curJoinData.baseInfo.showUid = showUid;
                    }
                    if ((info = ChannelModel.this.getGroupInfo(groupId)) != null) {
                        info.dynamicInfo.topOnlines = topOnline;
                    }
                    if (info != null && info.baseInfo != null && callBack != null) {
                        callBack.onSuccess(groupId, info);
                    } else if (callBack != null) {
                        callBack.onError(groupId, -1, "", (Exception)new RuntimeException("No cid info, may be channel has deleted!"));
                    }
                    if (!ChannelDefine.sUnEnableLog) {
                        MLog.info((Object)ChannelModel.TAG, (String)(groupId + ",getChannelDetailInfo:%s"), (Object[])new Object[]{info});
                    }
                }

                public void onError(String gid, int errorCode, String errorTips, Exception e) {
                    ChannelDetailInfo detailInfo = ChannelModel.this.getGroupInfo(groupId);
                    if (detailInfo != null && callBack != null) {
                        callBack.onSuccess(groupId, detailInfo);
                    } else if (callBack != null) {
                        callBack.onError(groupId, errorCode, errorTips, e);
                    }
                    if (!ChannelDefine.sUnEnableLog) {
                        MLog.error((Object)ChannelModel.TAG, (String)(groupId + ",getChannelDetailInfo errorCode:%d,errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                    }
                }
            });
        }
        if (info == null) {
            info = new ChannelDetailInfo();
            info.baseInfo = new ChannelInfo();
            info.baseInfo.gid = groupId;
            info.dynamicInfo = new ChannelDynamicInfo();
            if (RuntimeContext.isInGray() && !forceFromService) {
                MLog.error((Object)TAG, (Throwable)new RuntimeException("\u68c0\u67e5\u8c03\u7528\u65f6\u673a\u662f\u5426\u5408\u7406 " + groupId));
            }
        }
        return info;
    }

    public void onJoined(boolean rejoin2, ChannelDetailInfo info, EnterChannelData data2) {
        ChannelDetailInfo oldJoinData = this.curJoinData;
        this.curJoinData = info;
        this.useOldRoomStyle = data2.useOldRoomStyle;
        this.curJoinDataHasSyncTime = SystemClock.uptimeMillis();
        if (oldJoinData != null) {
            this.notifyStaticDataChanged(this.curJoinData.baseInfo.gid);
            this.notifyOnlineChanged(this.curJoinData.baseInfo.gid, this.curJoinData.dynamicInfo.onlines);
        }
        this.requestTagInfo(info);
        if (oldJoinData != null && oldJoinData.baseInfo != null && info.baseInfo != null && info.baseInfo.roleCount == 0L) {
            info.baseInfo.roleCount = oldJoinData.baseInfo.roleCount;
            info.baseInfo.roleLimit = oldJoinData.baseInfo.roleLimit;
        }
    }

    private void requestTagInfo(ChannelDetailInfo info) {
        ChannelTag channelTag = info.baseInfo.tag;
        ChannelTagItem tagItem = channelTag.getFirstTag();
        if (!tagItem.getTagId().isEmpty() && tagItem.getName().isEmpty()) {
            channelTag.inflate(channelTag1 -> {
                if (this.curJoinData != null && this.curJoinData.baseInfo != null && this.curJoinData.baseInfo.gid != null) {
                    this.notifyStaticDataChanged(this.curJoinData.baseInfo.gid);
                }
                return null;
            });
        }
    }

    boolean useOldRoomStyle() {
        return this.useOldRoomStyle;
    }

    void updateName(String groupId, String name, long ver) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null || StringUtils.equal((String)name, (String)groupDetailInfo.baseInfo.name)) {
            return;
        }
        groupDetailInfo.baseInfo.name = name;
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, updateName:%s", (Object[])new Object[]{groupId, name});
        }
        this.notifyStaticDataChanged(groupId);
    }

    void updateChannelAvatar(String groupId, String avatarUrl) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null || StringUtils.equal((String)avatarUrl, (String)groupDetailInfo.baseInfo.avatar)) {
            return;
        }
        groupDetailInfo.baseInfo.avatar = avatarUrl;
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, updateAvatar:%s", (Object[])new Object[]{groupId, avatarUrl});
        }
        this.notifyStaticDataChanged(groupId);
    }

    void updateCategory(String gid, int firstType, int secondType) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(gid);
        if (groupDetailInfo == null || groupDetailInfo.baseInfo.firstType == firstType && groupDetailInfo.baseInfo.secondType == secondType) {
            return;
        }
        groupDetailInfo.baseInfo.firstType = firstType;
        groupDetailInfo.baseInfo.secondType = secondType;
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, update category firstType:%d secondType:%d", (Object[])new Object[]{gid, firstType, secondType});
        }
        this.notifyStaticDataChanged(gid);
    }

    void updateannouncement(String groupId, String announcement, long ver) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null || StringUtils.equal((String)announcement, (String)groupDetailInfo.baseInfo.announcement)) {
            return;
        }
        groupDetailInfo.baseInfo.announcement = announcement;
        this.notifyStaticDataChanged(groupId);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, announcement:%s", (Object[])new Object[]{groupId, announcement});
        }
    }

    void updateFamilyGateInfo(String groupId, FamilyGateInfo gateInfo) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null) {
            return;
        }
        if (gateInfo.getDuration() != -1L) {
            groupDetailInfo.baseInfo.joinActiveTime = gateInfo.getDuration();
        }
        if (gateInfo.getWeath() != -1L) {
            groupDetailInfo.baseInfo.joinPayLevel = gateInfo.getWeath();
        }
        this.notifyStaticDataChanged(groupId);
    }

    void updateSpeakMode(String groupId, int speakMode, long ver) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null || speakMode == groupDetailInfo.baseInfo.speakMode) {
            return;
        }
        groupDetailInfo.baseInfo.speakMode = speakMode;
        this.notifyStaticDataChanged(groupId);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, speakMode:%d", (Object[])new Object[]{groupId, speakMode});
        }
    }

    void updateOpenPartyPermission(String groupId, boolean forbidMember) {
        int permit;
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        int n = permit = forbidMember ? 5 : 1;
        if (groupDetailInfo == null || permit == groupDetailInfo.baseInfo.channelShowPermit) {
            return;
        }
        groupDetailInfo.baseInfo.channelShowPermit = permit;
        this.notifyStaticDataChanged(groupId);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, updateOpenPartyPermission:%d", (Object[])new Object[]{groupId, permit});
        }
    }

    void updateChannelVoiceEnterMode(String groupId, int voiceEnterMode, long ver) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null || voiceEnterMode == groupDetailInfo.baseInfo.voiceEnterMode) {
            return;
        }
        groupDetailInfo.baseInfo.voiceEnterMode = voiceEnterMode;
        this.notifyStaticDataChanged(groupId);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, voiceEnterMode:%d", (Object[])new Object[]{groupId, voiceEnterMode});
        }
    }

    void updateChannelGuestSpeakLimit(String groupId, int bitMask, long ver) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null || bitMask == groupDetailInfo.baseInfo.guestSpeakLimitBitmask) {
            return;
        }
        groupDetailInfo.baseInfo.guestSpeakLimitBitmask = bitMask;
        this.notifyStaticDataChanged(groupId);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, guestSpeakLimitBitmask:%d", (Object[])new Object[]{groupId, bitMask});
        }
    }

    void updateJoinMode(String groupId, String password, String pwdToken, int mode, long ver) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null || StringUtils.equal((String)password, (String)groupDetailInfo.baseInfo.password) && mode == groupDetailInfo.baseInfo.enterMode) {
            return;
        }
        groupDetailInfo.baseInfo.password = password;
        groupDetailInfo.baseInfo.enterMode = mode;
        this.notifyStaticDataChanged(groupId);
        RuntimeContext.setChannelType((String)groupId, (int)mode);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, password:%s, speakMode:%d", (Object[])new Object[]{groupId, password, mode});
        }
    }

    void updateChannelPostPermission(String gid, int role, int content) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(gid);
        groupDetailInfo.baseInfo.postSyncRole = role;
        groupDetailInfo.baseInfo.postSyncContent = content;
        this.notifyStaticDataChanged(gid);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, role:%s", (Object[])new Object[]{gid, role});
        }
    }

    void updateChannelPostPermission(String gid, int role, int content, int topPerm) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(gid);
        groupDetailInfo.baseInfo.postSyncRole = role;
        groupDetailInfo.baseInfo.postSyncContent = content;
        groupDetailInfo.baseInfo.postOperRole = topPerm;
        this.notifyStaticDataChanged(gid);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, role:%s, topPerm:%s", (Object[])new Object[]{gid, role, topPerm});
        }
    }

    void updatePrivacyMode(String groupId, boolean privatePrivacy) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null || groupDetailInfo.baseInfo.isPrivate == privatePrivacy) {
            return;
        }
        groupDetailInfo.baseInfo.isPrivate = privatePrivacy;
        this.notifyStaticDataChanged(groupId);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, updatePrivacyMode:%d", (Object[])new Object[]{groupId, privatePrivacy ? 1 : 0});
        }
    }

    void updateRoleJoinMode(String groupId, int mode) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null || groupDetailInfo.baseInfo.joinMode == mode) {
            return;
        }
        groupDetailInfo.baseInfo.joinMode = mode;
        this.notifyStaticDataChanged(groupId);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, updateRoleJoinMode:%d", (Object[])new Object[]{groupId, mode});
        }
    }

    void updateChannelVersion(String groupId, int version, String topCid) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null) {
            return;
        }
        groupDetailInfo.baseInfo.version = version;
        this.notifyStaticDataChanged(groupId);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, updateChannelVersion:%s, topCid:%s", (Object[])new Object[]{groupId, version, topCid});
        }
    }

    void updateGroupPartyShowUid(String groupId, long showUid) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null) {
            return;
        }
        groupDetailInfo.baseInfo.showUid = showUid;
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, updateGroupPartyShowUid: %s", (Object[])new Object[]{groupId, showUid});
        }
    }

    void updateChannelShowPermit(String groupId, int permit) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null) {
            return;
        }
        groupDetailInfo.baseInfo.channelShowPermit = permit;
        this.notifyStaticDataChanged(groupId);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, updateChannelShowPermit:%d", (Object[])new Object[]{permit});
        }
    }

    void updateTag(String gid, ArrayList<String> tagIds) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(gid);
        if (groupDetailInfo == null) {
            return;
        }
        if (groupDetailInfo.baseInfo.tag == null) {
            groupDetailInfo.baseInfo.tag = new ChannelTag();
        }
        if (groupDetailInfo.baseInfo.tag.getTags() == null) {
            groupDetailInfo.baseInfo.tag.setTags(new ArrayList(1));
        }
        String id2 = FP.empty(tagIds) ? "" : tagIds.get(0);
        ChannelTag tagItem = groupDetailInfo.baseInfo.tag;
        EnterStatsHelper.onTagUpdate(gid, id2);
        if (!FP.empty((CharSequence)tagItem.getFirstTag().getTagId()) && !tagItem.getFirstTag().getTagId().equals(id2)) {
            groupDetailInfo.baseInfo.tag.update(new ChannelTagItem(id2), true, channelTag -> {
                this.notifyStaticDataChanged(gid);
                return null;
            });
        } else if (FP.empty((CharSequence)tagItem.getFirstTag().getName())) {
            groupDetailInfo.baseInfo.tag.inflate(channelTag -> {
                this.notifyStaticDataChanged(gid);
                return null;
            });
        }
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, updateTag:%s", (Object[])new Object[]{gid, tagIds.toString()});
        }
    }

    void updateOpenVoiceChatMode(String groupId, int mode) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null || groupDetailInfo.baseInfo.openVoiceChatMode == mode) {
            return;
        }
        groupDetailInfo.baseInfo.openVoiceChatMode = mode;
        this.notifyStaticDataChanged(groupId);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, updateOpenVoiceChatMode:%d", (Object[])new Object[]{groupId, mode});
        }
    }

    public void banned(String groupId, long uid, boolean banned) {
    }

    void updateOnline(String groupId, long onlineNum) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        if (groupDetailInfo == null || groupDetailInfo.dynamicInfo.onlines == onlineNum) {
            return;
        }
        groupDetailInfo.dynamicInfo.onlines = onlineNum;
        this.notifyOnlineChanged(groupId, onlineNum);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, onlineNum:%d", (Object[])new Object[]{groupId, (int)onlineNum});
        }
    }

    void clearGroupChatBg(String groupId) {
        ChannelDetailInfo groupDetailInfo = this.getGroupInfo(groupId);
        groupDetailInfo.baseInfo.chatBg = null;
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"cid:%s, clearGroupChatBg", (Object[])new Object[]{groupId});
        }
        this.notifyStaticDataChanged(groupId);
    }

    void onSubGroupAdded() {
        if (this.mChannelListModel != null) {
            this.mChannelListModel.onSubGroupAdded();
        }
    }

    void onSubGroupAdded(ChannelDetailInfo subGroupInfo) {
        if (this.mChannelListModel != null) {
            this.mChannelListModel.onSubGroupAdded();
        }
    }

    void onSubGroupDisbanded(String groupId, long ver) {
        if (this.mChannelListModel != null) {
            this.mChannelListModel.onSubGroupDisbanded(groupId, ver);
        }
    }

    private void notifyStaticDataChanged(String groupId) {
        this.notifyDataUpdate(groupId);
    }

    private void notifyDataUpdate(String groupId) {
        if (this.dataListeners == null || this.dataListeners.size() == 0) {
            return;
        }
        IDataService.IDataUpdateListener listener2 = null;
        for (WeakReference<IDataService.IDataUpdateListener> item : this.dataListeners) {
            if (item == null || item.get() == null || (listener2 = (IDataService.IDataUpdateListener)item.get()) == null) continue;
            listener2.onDataUpdate(groupId, this.getGroupInfo(groupId));
        }
    }

    private void notifyOnlineChanged(String groupId, long onlineNum) {
        if (this.dataListeners == null || this.dataListeners.size() == 0) {
            return;
        }
        IDataService.IDataUpdateListener listener2 = null;
        for (WeakReference<IDataService.IDataUpdateListener> item : this.dataListeners) {
            if (item == null || (listener2 = (IDataService.IDataUpdateListener)item.get()) == null) continue;
            listener2.onOnlineNumChangeListener(groupId, onlineNum);
        }
    }

    public void addDataListener(IDataService.IDataUpdateListener listener2) {
        if (listener2 == null) {
            return;
        }
        if (this.dataListeners == null) {
            this.dataListeners = new ArrayList(2);
        } else {
            IDataService.IDataUpdateListener listenerReal = null;
            for (WeakReference<IDataService.IDataUpdateListener> item : this.dataListeners) {
                if (item == null || (listenerReal = (IDataService.IDataUpdateListener)item.get()) != listener2) continue;
                return;
            }
        }
        this.dataListeners.add(new WeakReference<IDataService.IDataUpdateListener>(listener2));
        this.getChannelListModel().addDataListener(listener2);
    }

    public void removeDataListener(IDataService.IDataUpdateListener listener2) {
        if (listener2 == null || this.dataListeners == null || this.dataListeners.size() <= 0) {
            return;
        }
        this.getChannelListModel().removeDataListener(listener2);
        for (WeakReference<IDataService.IDataUpdateListener> item : this.dataListeners) {
            IDataService.IDataUpdateListener listenerReal;
            if (item == null || (listenerReal = (IDataService.IDataUpdateListener)item.get()) != listener2) continue;
            this.dataListeners.remove(item);
            return;
        }
    }

    public void onWsConnect(boolean flag) {
        if (!flag && this.mChannelListModel != null) {
            this.mChannelListModel.onWsConnect(flag);
        }
    }

    void onLeaveGroup() {
        YYTaskExecutor.postToMainThread(() -> {
            if (this.mChannelListModel != null) {
                this.mChannelListModel.onLeaveGroup();
            }
        }, (long)1000L);
    }

    void onLeaveRequestFinished(String groupId) {
    }

    void onRecommendTagUpdate(String tagId) {
        if (FP.empty(this.dataListeners)) {
            return;
        }
        for (WeakReference<IDataService.IDataUpdateListener> item : this.dataListeners) {
            IDataService.IDataUpdateListener listener2 = (IDataService.IDataUpdateListener)item.get();
            if (listener2 == null) continue;
            listener2.onRecommendTagUpdate(this.channelId, tagId);
        }
    }

    public void updateChannelNickSwitch(String gid, boolean switchValue) {
        if (this.curJoinData.baseInfo.gid.equals(gid)) {
            MLog.info((Object)"ChannelModel", (String)"updateChannelNickSwitch gid:%s, switch:%s", (Object[])new Object[]{gid, switchValue});
            this.curJoinData.baseInfo.isShowChannelNick = switchValue;
        }
    }

    public void updateChannelTitleSwitch(String gid, boolean switchValue) {
        if (this.curJoinData.baseInfo.gid.equals(gid)) {
            MLog.info((Object)"ChannelModel", (String)"updateChannelTitleSwitch gid:%s, switch:%s", (Object[])new Object[]{gid, switchValue});
            this.curJoinData.baseInfo.isShowChannelTitle = switchValue;
        }
    }

    public static interface IGroupModelCallBack {
        public IChannel getParent();
    }
}

