/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.common;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.RandomAvatar;
import com.yy.appbase.unifyconfig.config.RandomAvatarConfig;
import com.yy.hiyo.channel.common.IRandomAvatarService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/yy/hiyo/channel/service/common/RandomAvatarService;", "Lcom/yy/hiyo/channel/common/IRandomAvatarService;", "()V", "isDataReady", "", "manAvatars", "", "Lcom/yy/appbase/unifyconfig/config/RandomAvatar;", "nextManPos", "", "nextWomanPos", "random", "Ljava/util/Random;", "womanAvatars", "ensureDataReady", "", "getAvatar", "", "getManAvatar", "getWomanAvatar", "channel-components_release"})
public final class RandomAvatarService
implements IRandomAvatarService {
    private final Random random = new Random(System.currentTimeMillis());
    private boolean isDataReady;
    private final List<RandomAvatar> manAvatars;
    private final List<RandomAvatar> womanAvatars;
    private int nextManPos;
    private int nextWomanPos;

    private final void ensureDataReady() {
        if (this.isDataReady) {
            return;
        }
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.RANDOM_AVATAR_LIST);
        if (configData instanceof RandomAvatarConfig) {
            Object object = ((RandomAvatarConfig)configData).getData();
            this.manAvatars.addAll(object != null && (object = object.getManAvatars()) != null ? (Collection)object : (Collection)CollectionsKt.emptyList());
            Object object2 = ((RandomAvatarConfig)configData).getData();
            this.womanAvatars.addAll(object2 != null && (object2 = object2.getWomanAvatars()) != null ? (Collection)object2 : (Collection)CollectionsKt.emptyList());
        }
        this.isDataReady = !this.manAvatars.isEmpty() || !this.womanAvatars.isEmpty();
    }

    @NotNull
    public String getAvatar() {
        this.ensureDataReady();
        return this.random.nextInt(2) == 0 ? this.getManAvatar() : this.getWomanAvatar();
    }

    @NotNull
    public String getManAvatar() {
        String string2;
        this.ensureDataReady();
        if (this.manAvatars.isEmpty()) {
            return "";
        }
        int pos = this.nextManPos;
        this.nextManPos = (this.nextManPos + 1) % this.manAvatars.size();
        int n = pos;
        if (0 <= n && CollectionsKt.getLastIndex(this.manAvatars) >= n) {
            string2 = this.manAvatars.get(pos).getUrl();
            if (string2 == null) {
                string2 = "";
            }
        } else {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public String getWomanAvatar() {
        String string2;
        this.ensureDataReady();
        if (this.womanAvatars.isEmpty()) {
            return "";
        }
        int pos = this.nextWomanPos;
        this.nextWomanPos = (this.nextWomanPos + 1) % this.womanAvatars.size();
        int n = pos;
        if (0 <= n && CollectionsKt.getLastIndex(this.womanAvatars) >= n) {
            string2 = this.womanAvatars.get(pos).getUrl();
            if (string2 == null) {
                string2 = "";
            }
        } else {
            string2 = "";
        }
        return string2;
    }

    public RandomAvatarService() {
        List list2;
        RandomAvatarService randomAvatarService = this;
        boolean bl = false;
        randomAvatarService.manAvatars = list2 = (List)new ArrayList();
        randomAvatarService = this;
        bl = false;
        randomAvatarService.womanAvatars = list2 = (List)new ArrayList();
    }
}

