/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import biz.CCuteInfo;
import biz.CInfo;
import biz.IMMsgItem;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.VoiceRoomHistoryDbBean;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.recommend.bean.GroupChatTab;
import com.yy.appbase.service.ICIMService;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.config.GroupChatClassificationData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.Result;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.ChannelPermissionData;
import com.yy.hiyo.channel.base.bean.ChannelPushContent;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.LastMsgAndUnreadData;
import com.yy.hiyo.channel.base.bean.MyChannelControlConfig;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.hiyo.channel.base.bean.NoticeResp;
import com.yy.hiyo.channel.base.bean.create.CreateChannelParams;
import com.yy.hiyo.channel.base.bean.plugins.RoomPlugin;
import com.yy.hiyo.channel.base.callback.IChannelInfoCallBack;
import com.yy.hiyo.channel.base.callback.IChannelNotifyListener;
import com.yy.hiyo.channel.base.callback.IMsgReceiver;
import com.yy.hiyo.channel.base.callback.IMyJoinChannelHandler;
import com.yy.hiyo.channel.base.callback.IPluginInfoCallBack;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IChannelHonorService;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IFetchFamilyConfigCallback;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.video.ILiveVideoPlayer;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.component.channelswipe.SwipeDataManager;
import com.yy.hiyo.channel.component.publicscreen.receiver.ChannelMsgReceiver;
import com.yy.hiyo.channel.component.textgroup.GroupUtils;
import com.yy.hiyo.channel.growth.IUserGuideManager;
import com.yy.hiyo.channel.module.js.ChannelJsEventModule;
import com.yy.hiyo.channel.module.recommend.base.bean.Group;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.channel.publicscreen.IChannelMsgReceiver;
import com.yy.hiyo.channel.service.Channel;
import com.yy.hiyo.channel.service.IChannelCallBack;
import com.yy.hiyo.channel.service.config.ChannelPermissionModel;
import com.yy.hiyo.channel.service.config.FamilyGroupPermitModel;
import com.yy.hiyo.channel.service.config.MyChannelConfigModel;
import com.yy.hiyo.channel.service.data.ILocalDataModel;
import com.yy.hiyo.channel.service.data.local.ChannelLocalDataManager;
import com.yy.hiyo.channel.service.discovery.DiscoveryGroupModel;
import com.yy.hiyo.channel.service.family.FamilyConfigFetcher;
import com.yy.hiyo.channel.service.growth.UserGuideManager;
import com.yy.hiyo.channel.service.msg.IChannelMsgModel;
import com.yy.hiyo.channel.service.msg.localModel.ChannelMsgLocalFactory;
import com.yy.hiyo.channel.service.msg.localModel.ChannelMsgModel;
import com.yy.hiyo.channel.service.myjoin.MyJoinedChannelModel;
import com.yy.hiyo.channel.service.notify.ChannelNotifyHandler;
import com.yy.hiyo.channel.service.notify.IChannelNotifyHandler;
import com.yy.hiyo.channel.service.notify.SingleChannelNotifyHandler;
import com.yy.hiyo.channel.service.request.ChannelRequestManager;
import com.yy.hiyo.channel.service.request.cinfo.CInfoRequestManager;
import com.yy.hiyo.channel.service.request.join.JoinRequestManager;
import com.yy.hiyo.channel.service.userjoin.UserJoinedChannelModel;
import com.yy.hiyo.channel.service.video.play.LiveVideoPlayerManager;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.webservice.event.JsEvent;
import common.Page;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.ihago.channel.srv.mgr.BatchGetCinfoReq;
import net.ihago.channel.srv.mgr.BatchGetCinfoRes;
import net.ihago.channel.srv.mgr.GetChannelPluginsReq;
import net.ihago.channel.srv.mgr.GetChannelPluginsRes;
import net.ihago.channel.srv.mgr.Notify;
import net.ihago.chatroom.srv.gameplugin.RoomPluginStatusReq;
import net.ihago.chatroom.srv.gameplugin.RoomPluginStatusRes;
import net.ihago.money.api.family.GetFamilyProfileRes;
import org.jetbrains.annotations.NotNull;

public class ChannelService
extends DefaultController
implements IChannelCenterService,
IChannelCallBack {
    private final ConcurrentHashMap<String, Channel> channels = new ConcurrentHashMap();
    private MyJoinedChannelModel myJoinedChannelModel;
    private MyChannelConfigModel myGroupConfigModel;
    private FamilyGroupPermitModel familyGroupPermitModel;
    private IChannelMsgReceiver groupMsgSourceCenter;
    private ChannelMsgModel groupMsgModel;
    private UserJoinedChannelModel mUserJoinedChannelModel;
    private ChannelPermissionModel mChannelPermissionModel;
    private DiscoveryGroupModel mDiscoveryGroupModel;
    private int channelIndex = 0;
    private UserGuideManager mUserGuideManager;
    private CopyOnWriteArrayList<WeakReference<IChannelCenterService.IControlConfigOrJoinedChannelsListener>> dataListeners;
    private ArrayList<WeakReference<IChannelCenterService.IChannelMsgListener>> globalMsgListeners;
    private ILocalDataModel localDataManager;
    private ChannelNotifyHandler groupNotifyHandler;
    private SingleChannelNotifyHandler singleChannelNotifyHandler;
    private ChannelRequestManager requestManager = new ChannelRequestManager();
    private ChannelMsgLocalFactory msgLocalFactory;
    private LiveVideoPlayerManager videoPlayerManager;
    private final Map<String, Integer> mLunMicChannels = new ConcurrentHashMap<String, Integer>();
    private final Set<String> mNonLunMicChannels = Collections.synchronizedSet(new HashSet());
    private ConcurrentHashMap<String, ICommonCallback> mChannelTypeCallbacks = new ConcurrentHashMap();

    public ChannelService(Environment env) {
        super(env);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_SUCCESS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_ON_TRIM_MEMORY, (INotify)this);
        this.msgLocalFactory = new ChannelMsgLocalFactory();
        this.groupNotifyHandler = new ChannelNotifyHandler(new ChannelNotifyHandler.ICallBack(){

            @Override
            public IChannelMsgModel getMsgModel() {
                return ChannelService.this.groupMsgModel;
            }
        });
        this.singleChannelNotifyHandler = new SingleChannelNotifyHandler(new SingleChannelNotifyHandler.ICallBack(){

            @Override
            public IChannelNotifyHandler getChannelHandler(String channelId) {
                IChannel channel = ChannelService.this.getChannel(channelId);
                if (channel instanceof Channel) {
                    return (Channel)channel;
                }
                return null;
            }
        });
        this.groupNotifyHandler.regsiter();
        this.groupNotifyHandler.addGroupNotifyHandler(this.singleChannelNotifyHandler);
    }

    @Override
    public ILocalDataModel getLocalDataManager() {
        if (this.localDataManager == null) {
            this.localDataManager = new ChannelLocalDataManager(AccountUtil.getUid());
        }
        return this.localDataManager;
    }

    private LiveVideoPlayerManager getVideoPlayerManager() {
        if (this.videoPlayerManager == null) {
            this.videoPlayerManager = new LiveVideoPlayerManager(this.mContext);
        }
        return this.videoPlayerManager;
    }

    private boolean isInSameChannelGroup(String groupId, String groupIdTwo) {
        if (StringUtils.isEmpty((String)groupId) || StringUtils.isEmpty((String)groupIdTwo)) {
            return false;
        }
        if (!groupId.startsWith("P_") || !groupIdTwo.startsWith("P_")) {
            return false;
        }
        String[] groupIds = groupId.split("_");
        String[] groupTwoIds = groupIdTwo.split("_");
        if (groupIds != null && groupTwoIds != null && groupIds.length >= 2 && groupIdTwo.length() >= 2) {
            return StringUtils.equal((String)groupIds[0], (String)groupTwoIds[0]) && StringUtils.equal((String)groupIds[1], (String)groupTwoIds[1]);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChannel getChannel(String channelId) {
        if (StringUtils.isEmpty((String)channelId)) {
            return null;
        }
        Channel group = this.findChannel(channelId);
        if (group != null) {
            return group;
        }
        MLog.info((Object)"ChannelService", (String)"getChannel cid: %s", (Object[])new Object[]{channelId});
        group = new Channel(channelId, null, this.getLocalDataManager(), this.getEnvironment());
        group.setCallBack(this);
        ConcurrentHashMap<String, Channel> concurrentHashMap = this.channels;
        synchronized (concurrentHashMap) {
            this.channels.put(channelId, group);
        }
        group.setIndex(this.channelIndex);
        ++this.channelIndex;
        return group;
    }

    public void createChannel(CreateChannelParams params, final IChannel.ICreateCallBack callBack) {
        CInfoRequestManager.createChannel(params, new IChannel.ICreateCallBack(){

            public void onSuccess(ChannelDetailInfo groupInfo) {
                if (groupInfo != null) {
                    ChannelService.this.getMyJoinedChannels().onChannelAdd(groupInfo.baseInfo.gid);
                }
                if (callBack != null) {
                    callBack.onSuccess(groupInfo);
                }
            }

            public void onFailByGroupNumLimit(String msgTip) {
                if (callBack != null) {
                    callBack.onFailByGroupNumLimit(msgTip);
                }
            }

            public void onContainSensitiveWord(CreateChannelParams params, String msgTip) {
                if (callBack != null) {
                    callBack.onContainSensitiveWord(params, msgTip);
                }
            }

            public void onNoPermission(String msgTip) {
                if (callBack != null) {
                    callBack.onNoPermission(msgTip);
                }
            }

            public void onNoUseOldVersion(String msgTip) {
                if (callBack != null) {
                    callBack.onNoUseOldVersion(msgTip);
                }
            }

            public void onOtherError(String msgTip) {
                if (callBack != null) {
                    callBack.onOtherError(msgTip);
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(errorCode, errorTips, e);
                }
            }
        });
    }

    public void queryUserInWhereChannel(boolean includePrivate, boolean onlyMember, List<Long> uids, IChannelCenterService.IQueryUsersCurChannelCallBack callBack) {
        this.queryUserInWhereChannel(includePrivate, onlyMember, false, uids, callBack);
    }

    public void queryUserInWhereChannel(boolean includePrivate, boolean onlyMember, boolean restOnline, List<Long> uids, final IChannelCenterService.IQueryUsersCurChannelCallBack callBack) {
        this.requestManager.queryUserInWhereChannel(includePrivate, onlyMember, restOnline, uids, new IRoleService.IQueryUsersInChannelCallBack(){

            public void onSuccess(HashMap<Long, String> inChannelMap) {
                if (callBack != null) {
                    callBack.onSuccess(inChannelMap);
                }
            }

            public void onSuccess(HashMap<Long, String> inChannelMap, List<Integer> onLines) {
                if (callBack != null) {
                    callBack.onSuccess(inChannelMap, onLines);
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(errorCode, errorTips, e);
                }
            }
        });
    }

    public void queryChannelPluginInfoByCid(HashSet<String> idList, final IPluginInfoCallBack callBack) {
        if (FP.empty(idList)) {
            YYTaskExecutor.postToMainThread(() -> {
                if (callBack != null) {
                    callBack.onGetPluginInfoList(Collections.EMPTY_LIST);
                }
            });
            return;
        }
        if (FP.size(idList) > 100) {
            YYTaskExecutor.postToMainThread(() -> {
                if (callBack != null) {
                    callBack.onFailed("the id max size is 100");
                }
            });
            return;
        }
        ArrayList<String> cidList = new ArrayList<String>(idList);
        GetChannelPluginsReq req = new GetChannelPluginsReq.Builder().cids(cidList).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetChannelPluginsRes>(){

            public void onResponse(@NonNull GetChannelPluginsRes message, long code, String msg) {
                MLog.info((Object)"ChannelService", (String)"queryChannelPluginInfoByCid onResponse code: %s size: %s", (Object[])new Object[]{code, FP.size((Collection)message.plugins)});
                if (ProtoManager.isSuccessCode((long)code)) {
                    if (callBack != null) {
                        callBack.onGetPluginInfoList(message.plugins);
                    }
                    BaseRequestManager.statMetric((String)"channel/queryChannelPlugins", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)-1L);
                } else {
                    BaseRequestManager.statMetric((String)"channel/queryChannelPlugins", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    if (callBack != null) {
                        callBack.onFailed(msg);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)"ChannelService", (String)"queryChannelPluginInfoByCid retryWhenTimeout", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread(() -> {
                    if (callBack != null) {
                        callBack.onFailed("retryWhenTimeout");
                    }
                    BaseRequestManager.statMetric((String)"channel/queryChannelPlugins", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)"ChannelService", (String)"queryChannelPluginInfoByCid retryWhenError code: %d  reason: %s", (Object[])new Object[]{code, reason});
                YYTaskExecutor.postToMainThread(() -> {
                    if (callBack != null) {
                        callBack.onFailed(reason);
                    }
                    BaseRequestManager.statMetric((String)"channel/queryChannelPlugins", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                });
                return false;
            }
        });
    }

    public void queryChannelInfoById(HashSet<String> channelIdList, final IChannelInfoCallBack callBack) {
        if (FP.empty(channelIdList)) {
            YYTaskExecutor.postToMainThread(() -> {
                if (callBack != null) {
                    callBack.onGetChannelInfoList(Collections.EMPTY_LIST);
                }
            });
            return;
        }
        CInfo.Builder builder = new CInfo.Builder();
        builder.cid("1").name("1").owner(Long.valueOf(1L)).ccute_info(new CCuteInfo.Builder().vcid("1").build());
        BatchGetCinfoReq req = new BatchGetCinfoReq.Builder().cids(new ArrayList<String>(channelIdList)).selector(builder.build()).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<BatchGetCinfoRes>(){

            public void onResponse(@NonNull BatchGetCinfoRes message, long code, String msg) {
                MLog.info((Object)"ChannelService", (String)"queryChannelInfoById onResponse code: %s size: %s", (Object[])new Object[]{code, FP.size((Collection)message.cinfo)});
                if (ProtoManager.isSuccessCode((long)code)) {
                    if (callBack != null) {
                        callBack.onGetChannelInfoList(message.cinfo);
                    }
                    BaseRequestManager.statMetric((String)"channel/queryChannelInfo", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)-1L);
                } else {
                    BaseRequestManager.statMetric((String)"channel/queryChannelInfo", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    if (callBack != null) {
                        callBack.onFailed(msg);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)"ChannelService", (String)"queryChannelInfoById retryWhenTimeout", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread(() -> {
                    if (callBack != null) {
                        callBack.onFailed("retryWhenTimeout");
                    }
                    BaseRequestManager.statMetric((String)"channel/queryChannelInfo", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)"ChannelService", (String)"queryChannelInfoById retryWhenError code: %d  reason: %s", (Object[])new Object[]{code, reason});
                YYTaskExecutor.postToMainThread(() -> {
                    if (callBack != null) {
                        callBack.onFailed(reason);
                    }
                    BaseRequestManager.statMetric((String)"channel/queryChannelInfo", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                });
                return false;
            }
        });
    }

    public void queryChannelPluginStatus(List<String> cids, final ICommonCallback<List<RoomPlugin>> callback2) {
        MLog.info((Object)"ChannelService", (String)("fetchRoomPluginStatus cids = " + cids), (Object[])new Object[0]);
        RoomPluginStatusReq req = new RoomPluginStatusReq.Builder().cids(cids).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<RoomPluginStatusRes>(){

            public void onResponse(@NonNull RoomPluginStatusRes res, long code, String msgTip) {
                super.onResponse((AndroidMessage)res, code, msgTip);
                boolean success = this.isSuccess(code);
                if (success && !FP.empty((Collection)res.plugins)) {
                    List resPlugins = res.plugins;
                    MLog.info((Object)"ChannelService", (String)"fetchRoomPluginStatus resPlugins = ", (Object[])new Object[]{resPlugins});
                    ArrayList<RoomPlugin> roomPlugins = new ArrayList<RoomPlugin>();
                    for (net.ihago.chatroom.srv.gameplugin.RoomPlugin plugin : resPlugins) {
                        roomPlugins.add(new RoomPlugin(plugin.cid, plugin.pid));
                    }
                    callback2.onSuccess(roomPlugins, new Object[0]);
                } else {
                    MLog.warn((Object)"ChannelService", (String)"fetchRoomPluginStatus failed code=%s msgTip=%s", (Object[])new Object[]{code, msgTip});
                    callback2.onFail((int)code, msgTip, new Object[0]);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback2 != null) {
                    MLog.error((Object)"ChannelService", (String)"fetchRoomPluginStatus failed code=%s msgTip=%s", (Object[])new Object[]{code, reason});
                    callback2.onFail(code, reason, new Object[0]);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IChannel getChannel(String parentId, String channelId) {
        if (StringUtils.isEmpty((String)channelId)) {
            throw new RuntimeException("channelId is empty!");
        }
        if (StringUtils.isEmpty((String)parentId) || StringUtils.equal((String)channelId, (String)parentId)) {
            return this.getChannel(channelId);
        }
        Channel group = this.findChannel(channelId);
        if (group != null) {
            return group;
        }
        Channel parent = null;
        ConcurrentHashMap<String, Channel> concurrentHashMap = this.channels;
        synchronized (concurrentHashMap) {
            parent = this.channels.get(parentId);
            if (parent == null) {
                MLog.info((Object)"ChannelService", (String)"createChannel parentId:%s, cid: %s", (Object[])new Object[]{parentId, channelId});
                parent = new Channel(parentId, null, this.getLocalDataManager(), this.getEnvironment());
                parent.setCallBack(this);
                this.channels.put(parentId, parent);
                parent.setIndex(this.channelIndex);
                ++this.channelIndex;
            }
        }
        group = (Channel)parent.getSubChannel(channelId);
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel findChannel(String channelId) {
        Channel channel;
        block8: {
            Channel parent;
            Collection<Channel> values;
            ConcurrentHashMap<String, Channel> concurrentHashMap = this.channels;
            synchronized (concurrentHashMap) {
                channel = this.channels.get(channelId);
            }
            if (channel != null) {
                return channel;
            }
            Object object = this.channels;
            synchronized (object) {
                values = this.channels.values();
            }
            if (values == null || values.size() <= 0) break block8;
            object = values.iterator();
            while (object.hasNext() && ((parent = (Channel)object.next()) == null || (channel = parent.findSubGroup(channelId)) == null)) {
            }
        }
        return channel;
    }

    @Override
    public void updateChannelParent(String channelId, String parentId) {
        Channel parent;
        MLog.info((Object)"ChannelService", (String)"updateChannelParent parentId:%s, cid: %s", (Object[])new Object[]{parentId, channelId});
        if (StringUtils.isEmpty((String)channelId)) {
            return;
        }
        if (StringUtils.isEmpty((String)parentId) || StringUtils.equal((String)channelId, (String)parentId)) {
            return;
        }
        Channel group = this.findChannel(channelId);
        if (group == null) {
            return;
        }
        IChannel oldParent = group.getParent();
        if (oldParent != (parent = (Channel)this.getChannel(parentId))) {
            if (oldParent != null) {
                ((Channel)oldParent).removeSubGroup(group);
            }
            parent.addSubGroup(group);
        }
    }

    public void join(final EnterParam enterParams, IChannel.IJoinCallBack callBack) {
        JoinRequestManager.joinGroup(enterParams, (IChannel.IJoinCallBack)new IChannel.JoinCallBackEx(callBack){

            public void onSuccess(EnterParam enterParam, ChannelDetailInfo info, EnterChannelData data2) {
                ChannelService.this.updateChannelParent(info.baseInfo.gid, info.baseInfo.pid);
                ChannelService.this.getChannel(info.baseInfo.pid, info.baseInfo.gid).onPreJoin(enterParams);
                ChannelService.this.getChannel(info.baseInfo.pid, info.baseInfo.gid).handleJoinSuccess(false, enterParams, info, data2);
                super.onSuccess(enterParams, info, data2);
            }
        });
    }

    public IMyJoinChannelHandler getMyJoinChannelHandler() {
        return this.getMyJoinedChannels();
    }

    public ArrayList<MyJoinChannelItem> getMyJoinedChannels(IChannelCenterService.IGetMyJoinedChannelsCallBack callBack, boolean foreFromServer) {
        Function filter2 = input -> !input.source.equals("hago.game");
        return this.getMyJoinedChannels(callBack, foreFromServer, (Function<MyJoinChannelItem, Boolean>)filter2);
    }

    public ArrayList<MyJoinChannelItem> getMyJoinedChannels(final IChannelCenterService.IGetMyJoinedChannelsCallBack callBack, boolean foreFromServer, final @Nullable Function<MyJoinChannelItem, Boolean> filter2) {
        if (AccountUtil.getUid() <= 0L) {
            if (callBack != null) {
                callBack.onError(-1, new Exception());
            }
            return new ArrayList<MyJoinChannelItem>();
        }
        this.initJoinedChannelModel();
        ArrayList<MyJoinChannelItem> cachedResult = this.myJoinedChannelModel.getMyJoinedGroups(new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

            public void onSuccess(ArrayList<MyJoinChannelItem> groupSummays) {
                if (callBack != null) {
                    callBack.onSuccess(ChannelService.this.filterJoinedChannelsBySource(groupSummays, (Function<MyJoinChannelItem, Boolean>)filter2));
                }
            }

            public void onError(int errorCode, Exception e) {
                if (callBack != null) {
                    callBack.onError(errorCode, e);
                }
            }
        }, foreFromServer);
        return this.filterJoinedChannelsBySource(cachedResult, filter2);
    }

    private ArrayList<MyJoinChannelItem> filterJoinedChannelsBySource(ArrayList<MyJoinChannelItem> channels, @Nullable Function<MyJoinChannelItem, Boolean> filter2) {
        if (channels == null) {
            return new ArrayList<MyJoinChannelItem>(0);
        }
        if (filter2 == null || channels.isEmpty()) {
            return channels;
        }
        ArrayList<MyJoinChannelItem> result = new ArrayList<MyJoinChannelItem>(channels.size());
        for (MyJoinChannelItem item : channels) {
            if (!((Boolean)filter2.apply((Object)item)).booleanValue()) continue;
            result.add(item);
            if (!(filter2 instanceof IChannelCenterService.SupFunction) || !((IChannelCenterService.SupFunction)filter2).isBreak()) continue;
            break;
        }
        return result;
    }

    private void initJoinedChannelModel() {
        if (this.myJoinedChannelModel == null) {
            this.myJoinedChannelModel = new MyJoinedChannelModel(this.requestManager, AccountUtil.getUid(), new IChannelCenterService.IControlConfigOrJoinedChannelsListener(){

                public void onMyJoinedChannelsListChange() {
                    ChannelService.this.notifyMyJoinedGroupsInfoChange();
                }

                public void onMyJoinedChannelsUnreadNumChange(HashMap<String, LastMsgAndUnreadData> datas) {
                    ChannelService.this.notifyMyJoinedGroupsUnreadsChange(datas);
                }

                public void onChannelMsgReceiveModeChange(String cid, int mode) {
                    ChannelService.this.notifyChannelMsgReceiveModeChange(cid, mode);
                }

                public void onMyJoinedChannelsUnreadNumChange(String cid, LastMsgAndUnreadData data2) {
                    if (data2 == null) {
                        return;
                    }
                    ChannelService.this.notifyMyJoinedGroupsUnreadsChange(cid, data2);
                }
            });
            this.groupNotifyHandler.addGroupNotifyHandler(this.myJoinedChannelModel);
        }
    }

    @Override
    public MyJoinedChannelModel getMyJoinedChannels() {
        if (AccountUtil.getUid() <= 0L) {
            return new MyJoinedChannelModel(this.requestManager, -1L, null);
        }
        this.initJoinedChannelModel();
        return this.myJoinedChannelModel;
    }

    @Override
    public IChannelMsgModel getMsgModel() {
        if (this.groupMsgModel == null) {
            this.groupMsgModel = new ChannelMsgModel(AccountUtil.getUid(), this.msgLocalFactory);
        }
        return this.groupMsgModel;
    }

    @Override
    public ChannelRequestManager getRequestManager() {
        return this.requestManager;
    }

    @Override
    public String getJoinedChannel() {
        Object result = this.sendMessageSync(AppbaseMsgDef.ChannelMsgDef.GET_CUR_CHANNEL);
        if (result instanceof String) {
            return (String)result;
        }
        return "";
    }

    @Override
    public boolean isInSameTopRoom(String channelId, String channelIdTwo) {
        return this.isInSameChannelGroup(channelId, channelIdTwo);
    }

    public ArrayList<MyJoinChannelItem> getUserJoinedChannels(long uid, IChannelCenterService.IGetMyJoinedChannelsCallBack callBack) {
        Function filter2 = input -> !input.source.equals("hago.game");
        return this.getUserJoinedChannels(uid, IChannelCenterService.QueryJoinChannelConfig.normalConfig(), callBack, (Function<MyJoinChannelItem, Boolean>)filter2);
    }

    public ArrayList<MyJoinChannelItem> getUserJoinedChannels(long uid, IChannelCenterService.QueryJoinChannelConfig config, IChannelCenterService.IGetMyJoinedChannelsCallBack callBack) {
        Function filter2 = input -> !input.source.equals("hago.game");
        return this.getUserJoinedChannels(uid, config, callBack, (Function<MyJoinChannelItem, Boolean>)filter2);
    }

    public ArrayList<MyJoinChannelItem> getUserJoinedChannels(long uid, IChannelCenterService.QueryJoinChannelConfig config, final IChannelCenterService.IGetMyJoinedChannelsCallBack callBack, final @Nullable Function<MyJoinChannelItem, Boolean> filter2) {
        if (AccountUtil.getUid() <= 0L) {
            if (callBack != null) {
                callBack.onError(-1, new Exception());
            }
            return new ArrayList<MyJoinChannelItem>();
        }
        this.initUserJoinedChannelModel();
        ArrayList<MyJoinChannelItem> cachedResult = this.mUserJoinedChannelModel.getUserJoinedGroups(uid, config, new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

            public void onSuccess(ArrayList<MyJoinChannelItem> groupSummays) {
                if (callBack != null) {
                    callBack.onSuccess(ChannelService.this.filterJoinedChannelsBySource(groupSummays, (Function<MyJoinChannelItem, Boolean>)filter2));
                }
            }

            public void onError(int errorCode, Exception e) {
                if (callBack != null) {
                    callBack.onError(errorCode, e);
                }
            }
        });
        return this.filterJoinedChannelsBySource(cachedResult, filter2);
    }

    @Override
    public UserJoinedChannelModel getUserJoinedChannelModel() {
        if (AccountUtil.getUid() <= 0L) {
            return new UserJoinedChannelModel(this.requestManager);
        }
        this.initUserJoinedChannelModel();
        return this.mUserJoinedChannelModel;
    }

    @Override
    public ILiveVideoPlayer getLiveVideoPlayer(IChannel channel) {
        return this.getVideoPlayerManager().getLiveVideoPlayer(channel);
    }

    private void initUserJoinedChannelModel() {
        if (this.mUserJoinedChannelModel == null) {
            this.mUserJoinedChannelModel = new UserJoinedChannelModel(this.requestManager);
        }
    }

    public void getControlConfig(IChannelCenterService.IGetControlConfigCallBack callBack) {
        if (AccountUtil.getUid() < 0L) {
            callBack.onError(-1, "is login out!", new Exception());
            return;
        }
        if (this.myGroupConfigModel == null) {
            this.myGroupConfigModel = new MyChannelConfigModel(this.requestManager, AccountUtil.getUid(), new IChannelCenterService.IControlConfigOrJoinedChannelsListener(){

                public void onMyJoinedChannelsListChange() {
                    ChannelService.this.notifyControlConfigChange();
                }

                public void onControlConfigChange() {
                    ChannelService.this.notifyControlConfigChange();
                }
            });
        }
        this.myGroupConfigModel.getControlConfig(callBack);
    }

    public MyChannelControlConfig getControlConfigCache() {
        return this.myGroupConfigModel != null ? this.myGroupConfigModel.getControlConfigCache() : null;
    }

    public void updateControlConfigFromServer(IChannelCenterService.IGetControlConfigCallBack callBack) {
        if (AccountUtil.getUid() < 0L) {
            if (null != callBack) {
                callBack.onError(-1, "is login out!", new Exception());
            }
            return;
        }
        if (this.myGroupConfigModel == null) {
            this.myGroupConfigModel = new MyChannelConfigModel(this.requestManager, AccountUtil.getUid(), new IChannelCenterService.IControlConfigOrJoinedChannelsListener(){

                public void onMyJoinedChannelsListChange() {
                    ChannelService.this.notifyControlConfigChange();
                }

                public void onControlConfigChange() {
                    ChannelService.this.notifyControlConfigChange();
                }
            });
        }
        this.myGroupConfigModel.updateControlConfigFromServer(callBack);
    }

    public void canCreteFamilyGroup(ICommonCallback<Boolean> callback2) {
        if (AccountUtil.getUid() < 0L) {
            if (callback2 != null) {
                callback2.onFail(-1, "is login out!", new Object[0]);
            }
            return;
        }
        this.getFamilyGroupPermitModel().canBeCreateFamilyGroup(callback2);
    }

    public LiveData<Result<Boolean>> canCreateGroup(boolean forceNetWork) {
        if (AccountUtil.getUid() < 0L) {
            MutableLiveData resultLiveData = new MutableLiveData();
            Result result = new Result(-1, "is login out!");
            resultLiveData.postValue((Object)result);
            return resultLiveData;
        }
        return this.getChannelPermissionModel().canCreateGroup(forceNetWork);
    }

    public boolean hasCreatedGroup() {
        return this.getChannelPermissionModel().hasCreatedGroup();
    }

    public LiveData<Result<ChannelPermissionData>> getChannelPermissionData(boolean isFromGroup, boolean forceNetwork, boolean updateInBackground) {
        if (AccountUtil.getUid() < 0L) {
            MutableLiveData resultLiveData = new MutableLiveData();
            Result result = new Result(-1, "is login out!");
            resultLiveData.postValue((Object)result);
            return resultLiveData;
        }
        return this.getChannelPermissionModel().getPermission(isFromGroup, forceNetwork, updateInBackground);
    }

    @Override
    public ChannelPermissionModel getChannelPermissionModel() {
        if (this.mChannelPermissionModel == null) {
            this.initJoinedChannelModel();
            this.mChannelPermissionModel = new ChannelPermissionModel(AccountUtil.getUid(), this.requestManager, this.myJoinedChannelModel);
        }
        return this.mChannelPermissionModel;
    }

    @Override
    public FamilyGroupPermitModel getFamilyGroupPermitModel() {
        if (this.familyGroupPermitModel == null) {
            this.initJoinedChannelModel();
            this.familyGroupPermitModel = new FamilyGroupPermitModel(AccountUtil.getUid(), this.requestManager, this.myJoinedChannelModel);
        }
        return this.familyGroupPermitModel;
    }

    public void getAllGroupTab(ICommonCallback<List<GroupChatTab>> callback2) {
        this.getDiscoveryGroupModel().getAllGroupTab(callback2);
    }

    public void getGroupTab(long tabId, Page page, ICommonCallback<GroupChatTab> callback2) {
        this.getDiscoveryGroupModel().getGroupTab(tabId, page, callback2);
    }

    public void getGroupCategory(int groupCategoryId, ICommonCallback<GroupChatClassificationData> callback2) {
        this.requestManager.getGroupCategory(groupCategoryId, callback2);
    }

    public void getAllGroupCategory(ICommonCallback<List<GroupChatClassificationData>> callback2) {
        this.requestManager.getAllGroupCategory(callback2);
    }

    @Nullable
    public GroupChatClassificationData getGroupCategoryFromCache(int groupCategoryID) {
        return this.requestManager.getGroupCategoryFromCache(groupCategoryID);
    }

    public List<GroupChatClassificationData> getAllGroupCategoryFromCache() {
        return this.requestManager.getAllGroupCategoryFromCache();
    }

    private DiscoveryGroupModel getDiscoveryGroupModel() {
        if (this.mDiscoveryGroupModel == null) {
            this.mDiscoveryGroupModel = new DiscoveryGroupModel(AccountUtil.getUid(), this.requestManager);
        }
        return this.mDiscoveryGroupModel;
    }

    public void ensureMsgHandler() {
        ((ICIMService)this.getServiceManager().getService(ICIMService.class)).initCIM();
        if (this.groupMsgSourceCenter == null) {
            this.groupMsgSourceCenter = new ChannelMsgReceiver(this.getEnvironment());
            this.groupMsgSourceCenter.registerMsgReceiver(new IMsgReceiver(){

                public void onReceiveMsg(String channel, BaseImMsg msg) {
                    ChannelService.this.handleReceiveMsg(channel, msg);
                }

                public void onReceiveMsgs(String channel, List<BaseImMsg> msgs) {
                    ChannelService.this.handleReceiveMsgs(channel, msgs);
                }

                public boolean isUnSupportBelow_3_3(IMMsgItem msg) {
                    IPublicScreenService service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
                    return service != null && service.getMsgItemFactory().isUnSupportBelow_3_3(msg);
                }

                public BaseImMsg transformMsgItem(String msgId, IMMsgItem msg, ChannelPushContent pushContent) {
                    IPublicScreenService service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
                    return service == null ? null : service.getMsgItemFactory().transformMsgItem(msgId, msg, pushContent);
                }
            });
        }
        if (this.groupMsgModel == null) {
            this.groupMsgModel = new ChannelMsgModel(AccountUtil.getUid(), this.msgLocalFactory);
        }
    }

    public void handleReceiveMsg(final String channel, final BaseImMsg msg) {
        if (msg == null) {
            return;
        }
        MLog.info((Object)"ChannelService", (String)"onReceiveMsgs cid:%s, msg:%s, inChannel:%s", (Object[])new Object[]{channel, msg, RuntimeContext.getChannelId()});
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                final boolean handle = ChannelService.this.groupNotifyHandler.handleSignalMsg(msg.getCid(), msg);
                if (handle) {
                    if (msg.getMsgType() == 1) {
                        MLog.info((Object)"ChannelService", (String)"onReceiveMsgs handleSignalMsg ESTText be handled, cid:%s, msg:%s!", (Object[])new Object[]{channel, msg, 1});
                    } else {
                        MLog.info((Object)"ChannelService", (String)"onReceiveMsgs handleSignalMsg cid:%s, msg:%s, handled!", (Object[])new Object[]{channel, msg});
                    }
                    return;
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!handle) {
                            if (ChannelService.this.groupMsgModel != null) {
                                ChannelService.this.groupMsgModel.onReceiveMsg(msg.getCid(), msg, new IChannelMsgModel.IReceiveMsgCallBack(){

                                    @Override
                                    public void onReceiveMsg(String channelId, BaseImMsg section) {
                                        MLog.info((Object)"ChannelService", (String)"notifyReceiveMsg, msg:%s", (Object[])new Object[]{msg});
                                        ChannelService.this.groupNotifyHandler.notifyReceiveMsg(msg.getCid(), msg.getMsgId(), msg);
                                    }
                                });
                            }
                            if (StringUtils.equal((String)"cim_source", (String)channel)) {
                                ChannelService.this.notifyCIMMsgReceive(msg.getCid(), msg, GroupUtils.containFlag(msg.getFlags(), 2));
                            }
                        }
                    }
                });
            }
        });
    }

    public void handleReceiveMsgs(final String channel, final List<BaseImMsg> msgs) {
        if (msgs == null || msgs.size() == 0) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                final ArrayList<BaseImMsg> msgToContinueHandle = new ArrayList<BaseImMsg>(msgs.size());
                msgToContinueHandle.addAll(msgs);
                for (BaseImMsg msg : msgs) {
                    boolean handle = ChannelService.this.groupNotifyHandler.handleSignalMsg(msg.getCid(), msg);
                    if (!handle) continue;
                    if (msg.getMsgType() == 1) {
                        MLog.info((Object)"ChannelService", (String)"onReceiveMsgs handleSignalMsg ESTText be handled, cid:%s, msg:%s!", (Object[])new Object[]{channel, msg, 1});
                    } else {
                        MLog.info((Object)"ChannelService", (String)"onReceiveMsgs handleSignalMsg cid:%s, msg:%s, handled!", (Object[])new Object[]{channel, msg});
                    }
                    msgToContinueHandle.remove(msg);
                }
                if (msgToContinueHandle.size() == 0) {
                    return;
                }
                if (ChannelService.this.groupMsgModel != null) {
                    ChannelService.this.groupMsgModel.onReceiveMsgs(msgToContinueHandle, new IChannelMsgModel.IReceiveMsgCallBack(){

                        @Override
                        public void onReceiveMsg(String channelId, BaseImMsg msg) {
                            ChannelService.this.groupNotifyHandler.notifyReceiveMsg(msg.getCid(), msg.getMsgId(), msg);
                        }
                    });
                }
                if (StringUtils.equal((String)"cim_source", (String)channel)) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            for (BaseImMsg baseImMsg : msgToContinueHandle) {
                                ChannelService.this.notifyCIMMsgReceive(baseImMsg.getCid(), baseImMsg, GroupUtils.containFlag(baseImMsg.getFlags(), 2));
                            }
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyModels() {
        Collection<Channel> values;
        if (this.localDataManager != null) {
            this.localDataManager.destroy();
            this.localDataManager = null;
        }
        if (this.groupNotifyHandler != null) {
            this.groupNotifyHandler.unRegister();
        }
        if (this.myGroupConfigModel != null) {
            this.myGroupConfigModel.updateCallBack(null);
            this.myGroupConfigModel = null;
        }
        if (this.myJoinedChannelModel != null) {
            this.myJoinedChannelModel.updateUid(AccountUtil.getUid());
        }
        if (this.groupMsgModel != null) {
            this.groupMsgModel.loginOut();
            this.groupMsgModel.destroy();
            this.groupMsgModel = null;
        }
        Object object = this.channels;
        synchronized (object) {
            values = this.channels.values();
        }
        if (values != null && values.size() > 0) {
            for (IChannel iChannel : values) {
                if (iChannel == null) continue;
                iChannel.leave(null);
                ((Channel)iChannel).destroy();
            }
        }
        object = this.channels;
        synchronized (object) {
            this.channels.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            this.destroyModels();
        } else if (notification.id == NotificationDef.N_LOGIN_SUCCESS) {
            if (!(notification.extObj instanceof Boolean) || !((Boolean)notification.extObj).booleanValue()) {
                this.destroyModels();
                this.groupNotifyHandler.regsiter();
            }
            if (this.groupMsgModel == null) {
                this.groupMsgModel = new ChannelMsgModel(AccountUtil.getUid(), this.msgLocalFactory);
            }
        } else if (notification.id == NotificationIdDef.WEBSOCKET_DISCONNECT || notification.id == NotificationIdDef.WEBSOCKET_CONNECT) {
            Collection<Channel> values;
            ConcurrentHashMap<String, Channel> concurrentHashMap = this.channels;
            synchronized (concurrentHashMap) {
                values = this.channels.values();
            }
            if (values != null && values.size() > 0) {
                for (IChannel iChannel : values) {
                    if (iChannel == null) continue;
                    ((Channel)iChannel).onWsConnect(notification.id == NotificationIdDef.WEBSOCKET_CONNECT);
                }
            }
            if (this.myJoinedChannelModel != null) {
                this.myJoinedChannelModel.onWsConnect(notification.id == NotificationIdDef.WEBSOCKET_CONNECT);
            }
        } else if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            if (notification.extObj != null) {
                this.handleForeGround((Boolean)notification.extObj);
            }
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED) {
            NotificationCenter.getGlobalInstance().register(NotificationIdDef.WEBSOCKET_DISCONNECT, (INotify)this);
            NotificationCenter.getGlobalInstance().register(NotificationIdDef.WEBSOCKET_CONNECT, (INotify)this);
            this.getVideoPlayerManager().onStartUpFinished();
        } else if (notification.id == NotificationDef.N_ON_TRIM_MEMORY) {
            if (this.localDataManager != null) {
                this.localDataManager.onTrimMemory();
            }
            List<String> curChannelsId = this.getCurChannelsId();
            MLog.info((Object)"ChannelService", (String)("onTrimMemory, curChannelsId " + curChannelsId), (Object[])new Object[0]);
            ConcurrentHashMap<String, Channel> concurrentHashMap = this.channels;
            synchronized (concurrentHashMap) {
                Set set = this.channels.keySet();
                if (set != null && set.size() > 0) {
                    for (String key : set) {
                        Channel group;
                        if (curChannelsId.contains(key) || (group = this.channels.get(key)) == null || group.getIndex() >= this.channelIndex - 10) continue;
                        MLog.info((Object)"ChannelService", (String)("onTrimMemory, remove channel " + key), (Object[])new Object[0]);
                        this.channels.remove(key);
                    }
                }
            }
            if (this.groupMsgModel != null) {
                this.groupMsgModel.onTrimMemory();
            }
            ((IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)).onTrimMemory();
        }
    }

    public List<String> getCurChannelsId() {
        ArrayList<String> channelIdList = new ArrayList<String>(3);
        this.getChannelsId(RuntimeContext.getCurMainChannel(), channelIdList);
        this.getChannelsId(RuntimeContext.getCoexistenceChannel(), channelIdList);
        return channelIdList;
    }

    private void getChannelsId(RuntimeContext.ChannelHeartItem item, List<String> outputIdList) {
        String channelId;
        if (item != null && outputIdList != null && !FP.empty((CharSequence)(channelId = item.getRoomId()))) {
            String pid;
            IChannel parentChannel;
            Channel channel;
            if (!outputIdList.contains(channelId)) {
                outputIdList.add(channelId);
            }
            if ((channel = this.findChannel(channelId)) != null && (parentChannel = channel.getParent()) != null && !FP.empty((CharSequence)(pid = parentChannel.getChannelId())) && !outputIdList.contains(pid)) {
                outputIdList.add(pid);
            }
        }
    }

    private void handleForeGround(boolean fore) {
        if (this.myJoinedChannelModel != null) {
            this.myJoinedChannelModel.handleForeGround(fore);
        }
    }

    public synchronized void addConfigOrMyJoinedChannelsListener(IChannelCenterService.IControlConfigOrJoinedChannelsListener listener2) {
        if (listener2 == null) {
            return;
        }
        if (this.dataListeners == null) {
            this.dataListeners = new CopyOnWriteArrayList(new ArrayList(2));
        } else {
            for (WeakReference<IChannelCenterService.IControlConfigOrJoinedChannelsListener> item : this.dataListeners) {
                if (item == null || item.get() != listener2) continue;
                return;
            }
        }
        this.dataListeners.add(new WeakReference<IChannelCenterService.IControlConfigOrJoinedChannelsListener>(listener2));
    }

    public void addGroupCIMMsgListener(IChannelCenterService.IChannelMsgListener listener2) {
        if (listener2 == null) {
            return;
        }
        if (this.globalMsgListeners == null) {
            this.globalMsgListeners = new ArrayList(2);
        } else {
            for (WeakReference<IChannelCenterService.IChannelMsgListener> item : this.globalMsgListeners) {
                if (item == null || item.get() != listener2) continue;
                return;
            }
        }
        this.globalMsgListeners.add(new WeakReference<IChannelCenterService.IChannelMsgListener>(listener2));
    }

    public void addNotifyListener(IChannelNotifyListener listener2) {
        this.groupNotifyHandler.addNotifyListener(listener2);
    }

    public void removeNotifyListener(IChannelNotifyListener listener2) {
        this.groupNotifyHandler.removeNotifyListener(listener2);
    }

    private void notifyCIMMsgReceive(String groupId, BaseImMsg msg, boolean isHiddenMsg) {
        if (this.globalMsgListeners == null || this.globalMsgListeners.size() == 0) {
            return;
        }
        for (WeakReference<IChannelCenterService.IChannelMsgListener> item : this.globalMsgListeners) {
            IChannelCenterService.IChannelMsgListener listener2;
            if (item == null || (listener2 = (IChannelCenterService.IChannelMsgListener)item.get()) == null) continue;
            listener2.onReceiveCIMMsg(groupId, msg, isHiddenMsg);
        }
    }

    private void notifyMyJoinedGroupsInfoChange() {
        if (this.dataListeners == null || this.dataListeners.size() == 0) {
            return;
        }
        for (WeakReference<IChannelCenterService.IControlConfigOrJoinedChannelsListener> item : this.dataListeners) {
            IChannelCenterService.IControlConfigOrJoinedChannelsListener listener2;
            if (item == null || (listener2 = (IChannelCenterService.IControlConfigOrJoinedChannelsListener)item.get()) == null) continue;
            listener2.onMyJoinedChannelsListChange();
        }
    }

    private void notifyChannelMsgReceiveModeChange(String cid, int mode) {
        if (this.dataListeners == null || this.dataListeners.size() == 0) {
            return;
        }
        for (WeakReference<IChannelCenterService.IControlConfigOrJoinedChannelsListener> item : this.dataListeners) {
            IChannelCenterService.IControlConfigOrJoinedChannelsListener listener2;
            if (item == null || (listener2 = (IChannelCenterService.IControlConfigOrJoinedChannelsListener)item.get()) == null) continue;
            listener2.onChannelMsgReceiveModeChange(cid, mode);
        }
    }

    private void notifyMyJoinedGroupsUnreadsChange(HashMap<String, LastMsgAndUnreadData> unreadNums) {
        if (this.dataListeners == null || this.dataListeners.size() == 0) {
            return;
        }
        for (WeakReference<IChannelCenterService.IControlConfigOrJoinedChannelsListener> item : this.dataListeners) {
            IChannelCenterService.IControlConfigOrJoinedChannelsListener listener2;
            if (item == null || (listener2 = (IChannelCenterService.IControlConfigOrJoinedChannelsListener)item.get()) == null) continue;
            listener2.onMyJoinedChannelsUnreadNumChange(unreadNums);
        }
    }

    private void notifyMyJoinedGroupsUnreadsChange(String cid, LastMsgAndUnreadData data2) {
        if (this.dataListeners == null || this.dataListeners.size() == 0) {
            return;
        }
        for (WeakReference<IChannelCenterService.IControlConfigOrJoinedChannelsListener> item : this.dataListeners) {
            IChannelCenterService.IControlConfigOrJoinedChannelsListener listener2;
            if (item == null || (listener2 = (IChannelCenterService.IControlConfigOrJoinedChannelsListener)item.get()) == null) continue;
            listener2.onMyJoinedChannelsUnreadNumChange(cid, data2);
        }
    }

    private void notifyControlConfigChange() {
        if (this.dataListeners == null || this.dataListeners.size() == 0) {
            return;
        }
        for (WeakReference<IChannelCenterService.IControlConfigOrJoinedChannelsListener> item : this.dataListeners) {
            IChannelCenterService.IControlConfigOrJoinedChannelsListener listener2;
            if (item == null || (listener2 = (IChannelCenterService.IControlConfigOrJoinedChannelsListener)item.get()) == null) continue;
            listener2.onControlConfigChange();
        }
    }

    public JsEvent[] getJsEvent(Environment environment) {
        return new ChannelJsEventModule(this.getEnvironment()).allJsEvent();
    }

    public void getChannelAB(String cid, String key, long ownerId, IChannelCenterService.IGetChannelABCallback callBack) {
        this.requestManager.getChannelAB(cid, key, ownerId, callBack);
    }

    public void getLocalVoiceRoomHistory(final IChannelCenterService.DBCallBack<List<String>> callBack) {
        final ArrayList roomIds = new ArrayList();
        MyBox box = ((IDBService)this.mServiceManager.getService(IDBService.class)).boxForCurUser(VoiceRoomHistoryDbBean.class);
        if (null == box) {
            callBack.onResult(roomIds);
            return;
        }
        box.getAll((MyBox.IGetItemsCallBack)new MyBox.IGetItemsCallBack<VoiceRoomHistoryDbBean>(){

            public void onLoaded(ArrayList<VoiceRoomHistoryDbBean> datas) {
                Collections.sort(datas);
                FeatureLog.i((String)"FTVoiceRoom", (String)("getHistoryRoomDbDataResult" + datas.size()), (Object[])new Object[0]);
                ArrayList data1 = ChannelService.this.handeMax(datas);
                FeatureLog.i((String)"FTVoiceRoom", (String)("getHistoryRoomDbDataResultMax" + data1.size()), (Object[])new Object[0]);
                ArrayList data2 = ChannelService.this.handleServenData(data1);
                FeatureLog.i((String)"FTVoiceRoom", (String)("getHistoryRoomDbDataSeven" + data2.size()), (Object[])new Object[0]);
                if (data2.size() > 0) {
                    for (int i = 0; i < data2.size(); ++i) {
                        VoiceRoomHistoryDbBean bean2 = (VoiceRoomHistoryDbBean)data2.get(i);
                        String roomId = bean2.getRoomId();
                        roomIds.add(roomId);
                    }
                }
                callBack.onResult((Object)roomIds);
            }
        });
    }

    private ArrayList<VoiceRoomHistoryDbBean> handeMax(ArrayList<VoiceRoomHistoryDbBean> datas) {
        if (datas.size() > 100) {
            ArrayList<VoiceRoomHistoryDbBean> newDatas = new ArrayList<VoiceRoomHistoryDbBean>();
            for (int i = 0; i < 100; ++i) {
                VoiceRoomHistoryDbBean dbBean = datas.get(i);
                newDatas.add(dbBean);
            }
            return newDatas;
        }
        return datas;
    }

    private ArrayList<VoiceRoomHistoryDbBean> handleServenData(ArrayList<VoiceRoomHistoryDbBean> datas) {
        ArrayList<VoiceRoomHistoryDbBean> newDatas = new ArrayList<VoiceRoomHistoryDbBean>();
        for (int i = 0; i < datas.size(); ++i) {
            VoiceRoomHistoryDbBean bean2 = datas.get(i);
            boolean isSeven = this.isSevenInner(bean2.getTimestamp());
            if (!isSeven) continue;
            newDatas.add(bean2);
        }
        return newDatas;
    }

    private boolean isSevenInner(long time) {
        long current = System.currentTimeMillis();
        int sub = (int)((current - time) / 86400000L);
        return sub < 7;
    }

    public void switchChannelLbs(String cid, boolean open, double longitude, double latitude, ICommonCallback<Boolean> callBack) {
        this.requestManager.switchLbs(cid, open, longitude, latitude, callBack);
    }

    public void getMyJoinedFamilyChannel(ICommonCallback<MyJoinChannelItem> callback2) {
        this.requestManager.getMyJoinedFamilyChannel(callback2);
    }

    public void getFamilyInfo(String fid, ICommonCallback<GetFamilyProfileRes> callback2) {
        this.requestManager.getFamilyInfo(fid, callback2);
    }

    public void getChannelNotice(long offset, long limit, long snap, ICommonCallback<NoticeResp> callback2) {
        this.requestManager.getChannelNotice(offset, limit, snap, callback2);
    }

    public void transformNotifyToBizInfo(ArrayList<Notify> notify2, ICommonCallback<List<ChannelNotify>> callback2) {
        if (callback2 == null) {
            return;
        }
        YYTaskExecutor.execute(() -> callback2.onSuccess(ChannelNotifyHandler.parseRoleMsgNotifys(notify2), new Object[0]));
    }

    @NotNull
    public IUserGuideManager getNewGuideManager() {
        if (this.mUserGuideManager == null) {
            this.mUserGuideManager = new UserGuideManager();
        }
        return this.mUserGuideManager;
    }

    public ChannelDetailInfo transformChannelInfo(CInfo info, int onlines, List<String> list2) {
        ChannelDetailInfo detailInfo = new ChannelDetailInfo();
        detailInfo.baseInfo = BaseRequestManager.obtianChannelInfo((CInfo)info);
        detailInfo.dynamicInfo.onlines = onlines;
        detailInfo.userAvatorList = list2;
        return detailInfo;
    }

    public void getSongChannels(int limit, IChannelCenterService.IGetSongChannelCallback callback2) {
        this.requestManager.getSongChannels(limit, callback2);
    }

    public boolean isSupportSubjectCollection(Group group) {
        return SwipeDataManager.INSTANCE.isSupportSubjectCollection(group);
    }

    public void addSubjectChannelData(Group group, List<com.yy.appbase.recommend.bean.Channel> list2) {
        if (SwipeDataManager.INSTANCE.isSupportSubjectCollection(group)) {
            SwipeDataManager.INSTANCE.clearSubjectChannelData();
            SwipeDataManager.INSTANCE.addSubjectChannelData(list2);
        }
    }

    public void addSubjectChannelDataByLoadMore(Group group, List<com.yy.appbase.recommend.bean.Channel> list2) {
        if (SwipeDataManager.INSTANCE.isSupportSubjectCollection(group)) {
            SwipeDataManager.INSTANCE.addSubjectChannelDataByLoadMore(list2);
        }
    }

    public void updateCurrentTab(Long tabId, List<com.yy.appbase.recommend.bean.Channel> list2) {
        SwipeDataManager.INSTANCE.updateCurrentTab(tabId, list2);
    }

    public void addChannelData(boolean isLoadMore, Long tabId, List<com.yy.appbase.recommend.bean.Channel> list2) {
        if (!isLoadMore) {
            SwipeDataManager.INSTANCE.addChannelData(tabId, list2, false, false);
        } else {
            SwipeDataManager.INSTANCE.addChannelDataByLoadMore(tabId, list2);
        }
    }

    public void requestFamilyConfig(IFetchFamilyConfigCallback callback2) {
        FamilyConfigFetcher.INSTANCE.requestConfig(callback2);
    }

    public void appendLunMicChannel(String cid, int type) {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info((Object)"appendLunMicChannel", (String)"lunmic channel cid:%s, type:%s", (Object[])new Object[]{cid, type});
        }
        this.mNonLunMicChannels.remove(cid);
        this.mLunMicChannels.put(cid, type);
        this.onCallback(cid, true);
    }

    public boolean isLunMicChannel(String cid) {
        return this.mLunMicChannels.containsKey(cid);
    }

    public void appendNonLunMicChannel(String cid) {
        this.mLunMicChannels.remove(cid);
        this.mNonLunMicChannels.add(cid);
        this.onCallback(cid, true);
    }

    public boolean hasExactlyChannelType(String cid) {
        return this.mNonLunMicChannels.contains(cid) || this.mLunMicChannels.containsKey(cid);
    }

    public void getChannelType(String cid, ICommonCallback<Boolean> callback2) {
        this.mChannelTypeCallbacks.put(cid, callback2);
        this.getChannel(cid).getDataService().getChannelDetailInfo(null, new IDataService.IGetDetailInfoCallBack(){

            public void onSuccess(String channelId, ChannelDetailInfo info) {
                ChannelService.this.onCallback(channelId, true);
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                ChannelService.this.onCallback(channelId, false);
            }
        });
    }

    private void onCallback(String cid, boolean success) {
        ICommonCallback remove = success ? this.mChannelTypeCallbacks.remove(cid) : this.mChannelTypeCallbacks.get(cid);
        if (remove != null) {
            if (success) {
                remove.onSuccess((Object)success, new Object[0]);
            } else {
                remove.onFail(-1, "", new Object[0]);
            }
        }
    }
}

