/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.amongus;

import android.content.Context;
import android.os.SystemClock;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.OnLifecycleEvent;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.common.Callback;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.amongus.base.IAmongUsService;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.seat.holder.SeatItemHolder;
import com.yy.hiyo.channel.component.seat.seatview.NormalSeatViewWrapper;
import com.yy.hiyo.channel.plugins.voiceroom.base.AbsRoomSeatPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.amongus.AmongUsPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.amongus.AmongUsSeatHolder;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import java.util.List;
import me.drakeet.multitype.ItemViewBinder;
import net.ihago.channel.srv.amongus.SeatReportType;
import net.ihago.room.srv.follow.EPath;

public class AmongUsSeatPresenter
extends AbsRoomSeatPresenter<NormalSeatViewWrapper> {
    private static final String TAG = "AmongUsSeatPresenter";
    private IRelationService mRelationService;
    private IAmongUsService mAmongUsService;
    private int lastOnSeatSize = 0;
    private long lastTipTeamCodeTime = 0L;

    @Override
    protected NormalSeatViewWrapper createSeatViewWrapper() {
        NormalSeatViewWrapper seatViewWrapper = new NormalSeatViewWrapper();
        IServiceManager manager = ServiceManagerProxy.getServiceManager();
        if (manager != null) {
            this.mRelationService = (IRelationService)manager.getService(IRelationService.class);
            this.mAmongUsService = (IAmongUsService)manager.getService(IAmongUsService.class);
        }
        seatViewWrapper.getAdapter().register(SeatItem.class, (ItemViewBinder)new BaseItemBinder<SeatItem, SeatItemHolder<SeatItem>>(){

            @NonNull
            protected SeatItemHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new AmongUsSeatHolder(this.createItemView(inflater, parent, R.layout.among_us_seat_item), (IChannelPageContext<AbsPage>)((IChannelPageContext)AmongUsSeatPresenter.this.getMvpContext()));
            }

            protected void onBindViewHolder(@NonNull SeatItemHolder holder, @NonNull SeatItem item) {
                super.onBindViewHolder((BaseItemBinder.ViewHolder)holder, (Object)item);
                holder.setRoomId(AmongUsSeatPresenter.this.getRoomId());
                holder.setOnSeatItemListener(AmongUsSeatPresenter.this);
                View followButton = holder.itemView.findViewById(R.id.followIcon);
                followButton.setOnClickListener(v -> {
                    if (AmongUsSeatPresenter.this.mRelationService != null) {
                        RelationInfo relationInfo = AmongUsSeatPresenter.this.mRelationService.getRelationLocal(item.uid);
                        AmongUsSeatPresenter.this.mRelationService.requestFollow(relationInfo, EPath.PATH_VOICE.getValue(), (ICommonCallback)new ICommonCallback<Boolean>(){

                            public void onSuccess(Boolean aBoolean, Object ... ext) {
                                MLog.debug((Object)AmongUsSeatPresenter.TAG, (String)"AmongUsSeatPresenter requestFollow success", (Object[])new Object[0]);
                                ToastUtils.showToast((Context)AmongUsSeatPresenter.this.getContext(), (int)R.string.tips_subscr_success);
                            }

                            public void onFail(int errCode, String msg, Object ... ext) {
                                MLog.error((Object)AmongUsSeatPresenter.TAG, (String)("AmongUsSeatPresenter requestFollow fail,cause = " + msg), (Object[])new Object[0]);
                            }
                        });
                    }
                });
            }

            protected long getItemId(@NonNull SeatItem item) {
                return item.index;
            }
        });
        return seatViewWrapper;
    }

    @Override
    public boolean onSitDown(int index, Callback<Integer> callback2) {
        return super.onSitDown(index, (Callback<Integer>)((Callback)data2 -> {
            if (callback2 != null) {
                callback2.onResponse(data2);
            }
        }));
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    void onWindowStart() {
        MLog.info((Object)TAG, (String)"onWindowStart", (Object[])new Object[0]);
        this.reportSeatStatus(SeatReportType.REPORT_TYPE_FRONT);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    void onWindowStop() {
        MLog.info((Object)TAG, (String)"onWindowStop", (Object[])new Object[0]);
        this.reportSeatStatus(SeatReportType.REPORT_TYPE_BACKEND);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.reportSeatStatus(SeatReportType.REPORT_TYPE_LEAVE);
    }

    private void reportSeatStatus(SeatReportType type) {
        if (this.mAmongUsService != null) {
            this.mAmongUsService.reportSeatStatus(this.getChannelId(), type, 1L, this.getMySeatIndex(), null);
        } else {
            MLog.error((Object)TAG, (String)"reportSeatStatus fail mAmongUsService is null", (Object[])new Object[0]);
        }
    }

    private int getMySeatIndex() {
        List<SeatItem> seatItems = this.getSeatItems();
        int index = 0;
        for (SeatItem seatItem : seatItems) {
            if (seatItem.uid != AccountUtil.getUid()) continue;
            index = seatItem.index;
        }
        return index;
    }

    @Override
    protected boolean isNeedLock() {
        return false;
    }

    @Override
    public void onSeatUpdate(List seatUserList) {
        super.onSeatUpdate(seatUserList);
        int size = this.getSeatService().getSeatData().getHasUserSeatList().size();
        if (this.checkNeedShowCodeMsg(size)) {
            ((AmongUsPresenter)this.getPresenter(AmongUsPresenter.class)).pushRobotMsg(ResourceUtils.getString((int)R.string.short_tips_among_us_create_guide));
        }
        this.lastOnSeatSize = size;
        MLog.info((Object)TAG, (String)("seat size change size = " + size), (Object[])new Object[0]);
    }

    private boolean checkNeedShowCodeMsg(int size) {
        if (this.lastOnSeatSize <= 3 && size > 3) {
            long currentTime = SystemClock.elapsedRealtime();
            long delta = currentTime - this.lastTipTeamCodeTime;
            MLog.debug((Object)TAG, (String)"create_guide delta time $delta", (Object[])new Object[0]);
            if (delta > 30000L) {
                this.lastTipTeamCodeTime = currentTime;
                return true;
            }
        }
        return false;
    }
}

