/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby;

import android.content.Context;
import android.os.Message;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.GameChannelInfoPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.GameChannelOnlineView;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.GameChannelPCView;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.GameLobbyPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.IGameChannelFollowView;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.OnViewCallback;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.entity.ChallengeItemEntity;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.entity.ChannelUserStatusInfo;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.entity.TableListItemEntity;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.entity.TeamItemEntity;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class GameChannelFollow {
    private static final String TAG = "GameChannelFollow";
    private IGameChannelFollowView mView;
    private ChannelUserStatusInfo mInfo;
    private OnGameChannelFollow mCallback;
    private final KvoBinder mBinder = new KvoBinder((Object)this);
    private OnViewCallback mOnViewCallback = new OnViewCallback(){

        @Override
        public void clickFollowChannel() {
            if (GameChannelFollow.this.mCallback != null && GameChannelFollow.this.mCallback.interceptClick()) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_can_not_click_in_game);
                return;
            }
            String channelId = GameChannelFollow.this.mInfo != null ? GameChannelFollow.this.mInfo.getChannelId() : null;
            MLog.info((Object)GameChannelFollow.TAG, (String)"clickFollowChannel:%s", (Object[])new Object[]{channelId});
            if (StringUtils.isNotEmpty((String)channelId)) {
                EnterParam enterParam = EnterParam.of((String)channelId).build();
                Message msg = Message.obtain();
                msg.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
                msg.obj = enterParam;
                MsgDispatcher.getInstance().sendMessage(msg);
                if (GameChannelFollow.this.mCallback != null) {
                    GameChannelFollow.this.mCallback.hideSelfIfNeed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clickGame() {
            long otherUid;
            String roomId;
            String gid;
            boolean success;
            block30: {
                IGameService service1;
                GameInfo gameInfoByGid;
                GameLobbyPresenter presenter;
                TableListItemEntity entity;
                block29: {
                    block28: {
                        IGameInfoService service;
                        block27: {
                            block26: {
                                block25: {
                                    if (GameChannelFollow.this.mCallback != null && GameChannelFollow.this.mCallback.interceptClick()) {
                                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_can_not_click_in_game);
                                        return;
                                    }
                                    success = false;
                                    gid = "";
                                    roomId = "";
                                    otherUid = 0L;
                                    try {
                                        entity = GameChannelFollow.this.mInfo != null ? GameChannelFollow.this.mInfo.getEntity() : null;
                                        MLog.info((Object)GameChannelFollow.TAG, (String)"clickGame info:%s", (Object[])new Object[]{entity});
                                        if (entity != null) break block25;
                                    }
                                    catch (Throwable throwable) {
                                        MLog.info((Object)GameChannelFollow.TAG, (String)"result type:%b", (Object[])new Object[]{success});
                                        if (GameChannelFollow.this.mView != null) {
                                            IGameChannelFollowView.ViewType contentViewType = GameChannelFollow.this.mView.getContentViewType();
                                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", contentViewType == IGameChannelFollowView.ViewType.ONLINE_LIST ? "online_enter_game_but_click" : "pic_enter_game_but_click").put("room_id", roomId).put("gid", gid).put("other_uid", otherUid + ""));
                                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", contentViewType == IGameChannelFollowView.ViewType.ONLINE_LIST ? "online_enter_game_but_click_result" : "pic_enter_game_but_click_result").put("room_id", roomId).put("gid", gid).put("other_uid", otherUid + "").put("result_type", success ? "1" : "2"));
                                        }
                                        throw throwable;
                                    }
                                    MLog.info((Object)GameChannelFollow.TAG, (String)"result type:%b", (Object[])new Object[]{success});
                                    if (GameChannelFollow.this.mView != null) {
                                        IGameChannelFollowView.ViewType contentViewType = GameChannelFollow.this.mView.getContentViewType();
                                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", contentViewType == IGameChannelFollowView.ViewType.ONLINE_LIST ? "online_enter_game_but_click" : "pic_enter_game_but_click").put("room_id", roomId).put("gid", gid).put("other_uid", otherUid + ""));
                                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", contentViewType == IGameChannelFollowView.ViewType.ONLINE_LIST ? "online_enter_game_but_click_result" : "pic_enter_game_but_click_result").put("room_id", roomId).put("gid", gid).put("other_uid", otherUid + "").put("result_type", success ? "1" : "2"));
                                    }
                                    return;
                                }
                                gid = entity.getGid();
                                otherUid = GameChannelInfoPresenter.Companion.getUid(entity);
                                presenter = null;
                                if (GameChannelFollow.this.mCallback != null && GameChannelFollow.this.mCallback.getPageMvpContext() != null) break block26;
                                MLog.error((Object)GameChannelFollow.TAG, (String)"mcallback or context null", (Object[])new Object[0]);
                                MLog.info((Object)GameChannelFollow.TAG, (String)"result type:%b", (Object[])new Object[]{success});
                                if (GameChannelFollow.this.mView != null) {
                                    IGameChannelFollowView.ViewType contentViewType = GameChannelFollow.this.mView.getContentViewType();
                                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", contentViewType == IGameChannelFollowView.ViewType.ONLINE_LIST ? "online_enter_game_but_click" : "pic_enter_game_but_click").put("room_id", roomId).put("gid", gid).put("other_uid", otherUid + ""));
                                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", contentViewType == IGameChannelFollowView.ViewType.ONLINE_LIST ? "online_enter_game_but_click_result" : "pic_enter_game_but_click_result").put("room_id", roomId).put("gid", gid).put("other_uid", otherUid + "").put("result_type", success ? "1" : "2"));
                                }
                                return;
                            }
                            presenter = (GameLobbyPresenter)GameChannelFollow.this.mCallback.getPageMvpContext().getPresenter(GameLobbyPresenter.class);
                            if (presenter != null) {
                                roomId = presenter.getChannelId();
                            }
                            if ((service = (IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class)) != null) break block27;
                            MLog.error((Object)GameChannelFollow.TAG, (String)"IGameInfoService null", (Object[])new Object[0]);
                            MLog.info((Object)GameChannelFollow.TAG, (String)"result type:%b", (Object[])new Object[]{success});
                            if (GameChannelFollow.this.mView != null) {
                                IGameChannelFollowView.ViewType contentViewType = GameChannelFollow.this.mView.getContentViewType();
                                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", contentViewType == IGameChannelFollowView.ViewType.ONLINE_LIST ? "online_enter_game_but_click" : "pic_enter_game_but_click").put("room_id", roomId).put("gid", gid).put("other_uid", otherUid + ""));
                                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", contentViewType == IGameChannelFollowView.ViewType.ONLINE_LIST ? "online_enter_game_but_click_result" : "pic_enter_game_but_click_result").put("room_id", roomId).put("gid", gid).put("other_uid", otherUid + "").put("result_type", success ? "1" : "2"));
                            }
                            return;
                        }
                        gameInfoByGid = service.getGameInfoByGid(entity.getGid());
                        if (gameInfoByGid != null) break block28;
                        MLog.error((Object)GameChannelFollow.TAG, (String)"gameInfoByGid:%s null", (Object[])new Object[]{entity.getGid()});
                        MLog.info((Object)GameChannelFollow.TAG, (String)"result type:%b", (Object[])new Object[]{success});
                        if (GameChannelFollow.this.mView != null) {
                            IGameChannelFollowView.ViewType contentViewType = GameChannelFollow.this.mView.getContentViewType();
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", contentViewType == IGameChannelFollowView.ViewType.ONLINE_LIST ? "online_enter_game_but_click" : "pic_enter_game_but_click").put("room_id", roomId).put("gid", gid).put("other_uid", otherUid + ""));
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", contentViewType == IGameChannelFollowView.ViewType.ONLINE_LIST ? "online_enter_game_but_click_result" : "pic_enter_game_but_click_result").put("room_id", roomId).put("gid", gid).put("other_uid", otherUid + "").put("result_type", success ? "1" : "2"));
                        }
                        return;
                    }
                    service1 = (IGameService)ServiceManagerProxy.getService(IGameService.class);
                    if (service1 != null) break block29;
                    MLog.error((Object)GameChannelFollow.TAG, (String)"IGameService null", (Object[])new Object[0]);
                    MLog.info((Object)GameChannelFollow.TAG, (String)"result type:%b", (Object[])new Object[]{success});
                    if (GameChannelFollow.this.mView != null) {
                        IGameChannelFollowView.ViewType contentViewType = GameChannelFollow.this.mView.getContentViewType();
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", contentViewType == IGameChannelFollowView.ViewType.ONLINE_LIST ? "online_enter_game_but_click" : "pic_enter_game_but_click").put("room_id", roomId).put("gid", gid).put("other_uid", otherUid + ""));
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", contentViewType == IGameChannelFollowView.ViewType.ONLINE_LIST ? "online_enter_game_but_click_result" : "pic_enter_game_but_click_result").put("room_id", roomId).put("gid", gid).put("other_uid", otherUid + "").put("result_type", success ? "1" : "2"));
                    }
                    return;
                }
                boolean gameValid = service1.isGameValid(gameInfoByGid);
                MLog.info((Object)GameChannelFollow.TAG, (String)"gid:%s, gameValid:%b,", (Object[])new Object[]{gameInfoByGid, gameValid});
                if (gameValid) {
                    if (entity instanceof TeamItemEntity) {
                        boolean hasJoined = ((TeamItemEntity)entity).getHasJoined();
                        String teamId = entity.getTeamId();
                        if (!hasJoined) {
                            success = true;
                            presenter.joinTeam(teamId, entity.getGid(), false, 2);
                            GameChannelFollow.this.mCallback.hideSelfIfNeed();
                        } else {
                            MLog.error((Object)GameChannelFollow.TAG, (String)"has join!!!,teamId:%s", (Object[])new Object[]{teamId});
                        }
                    } else if (entity instanceof ChallengeItemEntity) {
                        if (((ChallengeItemEntity)entity).getDefenderUid() != AccountUtil.getUid()) {
                            success = true;
                            presenter.requestChallenge((ChallengeItemEntity)entity);
                            GameChannelFollow.this.mCallback.hideSelfIfNeed();
                        } else {
                            MLog.error((Object)GameChannelFollow.TAG, (String)"self in defenderUid", (Object[])new Object[0]);
                        }
                    }
                    break block30;
                }
                if (GameChannelFollow.this.mView != null) {
                    GameChannelFollow.this.mView.showDownloadingView(gameInfoByGid);
                }
                GameChannelFollow.this.mBinder.singleBindSourceTo((KvoSource)gameInfoByGid.downloadInfo);
                service1.downloadGame(gameInfoByGid, GameDownloadInfo.DownloadType.no_pause);
            }
            MLog.info((Object)GameChannelFollow.TAG, (String)"result type:%b", (Object[])new Object[]{success});
            if (GameChannelFollow.this.mView != null) {
                IGameChannelFollowView.ViewType contentViewType = GameChannelFollow.this.mView.getContentViewType();
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", contentViewType == IGameChannelFollowView.ViewType.ONLINE_LIST ? "online_enter_game_but_click" : "pic_enter_game_but_click").put("room_id", roomId).put("gid", gid).put("other_uid", otherUid + ""));
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", contentViewType == IGameChannelFollowView.ViewType.ONLINE_LIST ? "online_enter_game_but_click_result" : "pic_enter_game_but_click_result").put("room_id", roomId).put("gid", gid).put("other_uid", otherUid + "").put("result_type", success ? "1" : "2"));
            }
        }
    };

    public boolean canShowEntry() {
        return this.mInfo != null && (this.mInfo.getEntity() != null || StringUtils.isNotEmpty((String)this.mInfo.getChannelId()));
    }

    public void destroy() {
        this.mBinder.clearAllKvoConnections();
        this.mCallback = null;
    }

    public GameChannelFollow(OnGameChannelFollow callback2) {
        this.mCallback = callback2;
        if (RuntimeContext.sIsDebuggable && this.mCallback == null) {
            throw new NullPointerException("OnGameChannelFollow callback can not be null!!!");
        }
    }

    public void setView(IGameChannelFollowView view) {
        this.mView = view;
        if (this.mView != null) {
            this.mView.setOnViewCallback(this.mOnViewCallback);
        }
    }

    public void bindInfo(ChannelUserStatusInfo info) {
        if (this.mView == null) {
            MLog.error((Object)TAG, (String)"must bind view first!!!", (Object[])new Object[0]);
            return;
        }
        if (this.mInfo != info) {
            if (info != null) {
                this.mBinder.clearAllKvoConnections();
            }
            this.mView.resetAllView();
            this.mInfo = info;
            if (this.mInfo != null) {
                this.mBinder.singleBindSourceTo((KvoSource)this.mInfo);
            }
        }
    }

    @KvoMethodAnnotation(sourceClass=ChannelUserStatusInfo.class, name="channelId", thread=1)
    public void onChannelIdChange(KvoEventIntent event) {
        String channelId = (String)event.newValue();
        MLog.info((Object)TAG, (String)"onChannelIdChange:%s", (Object[])new Object[]{channelId});
        if (this.mView != null) {
            this.mView.showChannelEntry(channelId, StringUtils.isNotEmpty((String)channelId));
        }
        if (null != this.mCallback) {
            this.mCallback.updateView();
        }
    }

    @KvoMethodAnnotation(sourceClass=ChannelUserStatusInfo.class, name="entity", thread=1)
    public void onGamePlayInfoChange(KvoEventIntent event) {
        TableListItemEntity entity = (TableListItemEntity)event.newValue();
        MLog.info((Object)TAG, (String)"onGamePlayInfoChange:%s", (Object[])new Object[]{entity});
        if (this.mView != null) {
            this.mView.showGameEntry(entity, entity != null);
        }
        if (null != this.mCallback) {
            this.mCallback.updateView();
        }
    }

    @KvoMethodAnnotation(name="progress", sourceClass=GameDownloadInfo.class)
    public void onUpdateProgress(KvoEventIntent event) {
        GameDownloadInfo info = (GameDownloadInfo)event.source();
        MLog.debug((Object)TAG, (String)"onUpdateProgress gid: %s, state: %s, cur: %s, total: %s", (Object[])new Object[]{info.gameId, info.getState(), info.getProgress(), info.getTotalBytes()});
        if (info.getState() != GameDownloadInfo.DownloadState.downloading) {
            return;
        }
        if (this.mView != null) {
            this.mView.updateProgress(info.getTotalBytes(), info.getProgress());
        }
    }

    @KvoMethodAnnotation(name="state", sourceClass=GameDownloadInfo.class)
    public void onState(KvoEventIntent event) {
        GameDownloadInfo info = (GameDownloadInfo)event.source();
        MLog.debug((Object)TAG, (String)"onState gid: %s,  state: %s, type: %s", (Object[])new Object[]{info.gameId, info.getState(), info.downloadType});
        if (this.mView == null) {
            return;
        }
        if (info.getState() == GameDownloadInfo.DownloadState.download_fail) {
            String msg = StringUtils.formatWitUSLocal((String)"download failed with error: %s", (Object[])new Object[]{info.downloadErrInfo});
            MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
            this.mView.showGameEntry(this.mInfo.getEntity(), this.mInfo.getEntity() != null);
        } else if (info.getState() == GameDownloadInfo.DownloadState.download_finish) {
            this.mView.showGameEntry(this.mInfo.getEntity(), this.mInfo.getEntity() != null);
        }
    }

    public static IGameChannelFollowView getChannelGameFollowView(IGameChannelFollowView.ViewType from) {
        if (from == IGameChannelFollowView.ViewType.ONLINE_LIST) {
            return new GameChannelOnlineView(from);
        }
        if (from == IGameChannelFollowView.ViewType.PROFILE_CARD) {
            return new GameChannelPCView(from);
        }
        return null;
    }

    public static interface OnGameChannelFollow {
        public IMvpContext getPageMvpContext();

        public void updateView();

        default public void hideSelfIfNeed() {
        }

        public String getCurChannelId();

        public boolean interceptClick();
    }
}

