/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.notice;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.os.SystemClock;
import android.view.View;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.bean.JoinApproveData;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.module.notice.ChannelMessageCreator;
import com.yy.hiyo.channel.module.notice.ChannelNoticeReceiver;
import com.yy.hiyo.channel.module.notice.ChannelNoticeWindow;
import com.yy.hiyo.channel.service.notify.ChannelNotifyHandler;
import com.yy.hiyo.im.base.ChannelNoticeMessage;
import com.yy.hiyo.im.base.ITitleBarListener;
import com.yy.hiyo.mvp.base.ExtensionsKt;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.user.base.profilesource.ProfileReportBean;
import common.Page;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.ihago.channel.srv.mgr.AcceptMemberInviteGuestReq;
import net.ihago.channel.srv.mgr.AcceptMemberInviteGuestRes;
import net.ihago.channel.srv.mgr.AckNoticeReq;
import net.ihago.channel.srv.mgr.AckNoticeRes;
import net.ihago.channel.srv.mgr.ClearNoticeReq;
import net.ihago.channel.srv.mgr.ClearNoticeRes;
import net.ihago.channel.srv.mgr.ECode;
import net.ihago.channel.srv.mgr.GetNoticeReq;
import net.ihago.channel.srv.mgr.GetNoticeRes;
import net.ihago.channel.srv.mgr.GetUnreadNoticeCountsReq;
import net.ihago.channel.srv.mgr.GetUnreadNoticeCountsRes;
import net.ihago.channel.srv.mgr.NoticeItem;
import net.ihago.channel.srv.mgr.Notify;

public class ChannelNoticeController
extends DefaultWindowController
implements ITitleBarListener,
ChannelNoticeWindow.IChannelNoticeListener {
    private ChannelNoticeWindow mWindow;
    private List<ChannelNoticeMessage> mChannelNoticeItemList = new ArrayList<ChannelNoticeMessage>();
    private long mSnap = 0L;
    private final long mLimitCount = 20L;
    private long mMaxSeqId = 0L;
    private long mMinSeqId = 0L;
    private long mOffset = 0L;
    private boolean mHasScrollToEnd = false;
    private List<Long> mSeqIdList = new CopyOnWriteArrayList<Long>();
    private boolean mIsWindowShow = false;
    private ChannelNoticeReceiver mChannelNoticeReceiver;

    public ChannelNoticeController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == BaseMsgDef.OPEN_CHANNEL_NOTICE_PAGE) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            if (this.mWindow == null) {
                this.mWindow = new ChannelNoticeWindow(this.mContext, (UICallBacks)this, this, this);
            }
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
            this.resetData();
            this.pullMsg();
        } else if (msg.what == BaseMsgDef.DELETE_CHANNEL_NOTICE_MSG) {
            this.ackNotice();
            this.deleteMsg();
        }
    }

    private void resetData() {
        this.mMinSeqId = 0L;
        this.mMaxSeqId = 0L;
        this.mOffset = 0L;
        this.mSnap = 0L;
        this.mHasScrollToEnd = false;
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        this.mIsWindowShow = true;
        this.ackNotice();
    }

    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
        this.mIsWindowShow = false;
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_EXIT_NOTICE_LIST));
        if (this.mWindow == abstractWindow) {
            this.mWindow = null;
        }
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationIdDef.CHANNEL_NOTICE_NEW_MSG) {
            final ChannelNoticeMessage channelNoticeMessage = (ChannelNoticeMessage)notification.extObj;
            if (channelNoticeMessage == null) {
                return;
            }
            if (this.mChannelNoticeItemList.contains(channelNoticeMessage)) {
                int index = this.mChannelNoticeItemList.indexOf(channelNoticeMessage);
                ChannelNoticeMessage currentMsg = this.mChannelNoticeItemList.get(index);
                if (currentMsg.getSeqId() <= channelNoticeMessage.getSeqId()) {
                    channelNoticeMessage.setChannelOwnerAvatar(currentMsg.getChannelOwnerAvatar());
                    this.mChannelNoticeItemList.set(index, channelNoticeMessage);
                }
            } else {
                if (!this.mSeqIdList.contains(channelNoticeMessage.getSeqId())) {
                    this.mSeqIdList.add(channelNoticeMessage.getSeqId());
                }
                ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(channelNoticeMessage.getChannelOwnerId(), new OnProfileCallback(){
                    ChannelNoticeMessage mChannelNoticeMessage;
                    {
                        this.mChannelNoticeMessage = channelNoticeMessage;
                    }

                    public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                        if (userInfoKSList != null && userInfoKSList.size() > 0) {
                            this.mChannelNoticeMessage.setChannelOwnerAvatar(userInfoKSList.get(0).getAvatar());
                            ChannelNoticeController.this.mChannelNoticeItemList.add(this.mChannelNoticeMessage);
                            ChannelNoticeController.this.sortData();
                        }
                    }

                    public void onFail(int id2, String msg, String response) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ChannelNoticeController.this.mChannelNoticeItemList.add(mChannelNoticeMessage);
                                ChannelNoticeController.this.sortData();
                            }
                        });
                    }
                });
            }
            if (this.mMaxSeqId < channelNoticeMessage.getSeqId()) {
                this.mMaxSeqId = channelNoticeMessage.getSeqId();
            }
            if (this.mMinSeqId > channelNoticeMessage.getSeqId()) {
                this.mMinSeqId = channelNoticeMessage.getSeqId();
            }
            if (this.mWindow == null) {
                this.mWindow = new ChannelNoticeWindow(this.mContext, (UICallBacks)this, this, this);
            }
            this.mWindow.setData(this.mChannelNoticeItemList);
            if (this.mIsWindowShow) {
                FeatureLog.i((String)"FTChannelNotice", (String)"ackNotice windowShow", (Object[])new Object[0]);
                this.ackNotice();
            }
            this.setClearStatus();
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS || notification.id == NotificationIdDef.N_CHANNEL_SDK_INIT_CHANNEL_NOTICE_MSG) {
            if (AccountUtil.getUid() > 0L) {
                this.initChannelNoticeReceiver();
                this.fetchChannelNoticeUnreadCount();
            }
        } else if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED && AccountUtil.getUid() > 0L) {
            this.initChannelNoticeReceiver();
            this.fetchChannelNoticeUnreadCount();
        }
    }

    private void fetchChannelNoticeUnreadCount() {
        GetUnreadNoticeCountsReq getUnreadNoticeCountsReq = new GetUnreadNoticeCountsReq.Builder().build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)getUnreadNoticeCountsReq, (IProtoCallback)new IProtoCallback<GetUnreadNoticeCountsRes>(){

            public void onResponse(final @NonNull GetUnreadNoticeCountsRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (!ProtoManager.isSuccessCode((long)code)) {
                    FeatureLog.i((String)"FTChannelNotice", (String)"fetchChannelNoticeUnreadCount error, code:%s, msg:%s", (Object[])new Object[]{code, msg});
                    return;
                }
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ChannelNoticeMessage channelNoticeMessage;
                        if (message == null) {
                            return;
                        }
                        NoticeItem noticeItem = message.latest_notice;
                        ArrayList<Notify> notifyList = new ArrayList<Notify>();
                        if (noticeItem == null) {
                            return;
                        }
                        try {
                            Notify notify2 = (Notify)Notify.ADAPTER.decode(noticeItem.payload);
                            notifyList.add(notify2);
                        }
                        catch (Exception e) {
                            FeatureLog.i((String)"FTChannelNotice", (String)"parseRoleMsgNotify error:%s", (Object[])new Object[]{e.toString()});
                        }
                        ArrayList<ChannelNotify> channelNotifyList = ChannelNotifyHandler.parseRoleMsgNotifys(notifyList);
                        if (channelNotifyList.size() == 0) {
                            FeatureLog.i((String)"FTChannelNotice", (String)"Notify null", (Object[])new Object[0]);
                            return;
                        }
                        ChannelNoticeMessage validMsg = null;
                        for (ChannelNotify notify3 : channelNotifyList) {
                            ChannelNoticeMessage msg = ChannelMessageCreator.createNoticeMessageFrom(notify3, true);
                            if (msg == null) continue;
                            validMsg = msg;
                            break;
                        }
                        if ((channelNoticeMessage = validMsg) == null) {
                            FeatureLog.i((String)"FTChannelNotice", (String)"createNoticeMessageFrom null", (Object[])new Object[0]);
                            ChannelNoticeMessage noticeMessage = new ChannelNoticeMessage();
                            noticeMessage.setExtCounts(0);
                            ExtensionsKt.onUi(() -> {
                                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_FETCH_MSG, (Object)noticeMessage));
                                return null;
                            });
                            return;
                        }
                        FeatureLog.i((String)"FTChannelNotice", (String)"fetchChannelNoticeUnreadCount unreadCount:%s", (Object[])new Object[]{message.total_unread_counts});
                        channelNoticeMessage.setExtCounts(message.total_unread_counts.intValue());
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_FETCH_MSG, (Object)channelNoticeMessage));
                            }
                        });
                    }
                });
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.i((String)"FTChannelNotice", (String)"fetchChannelNoticeUnreadCount timeout", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                FeatureLog.i((String)"FTChannelNotice", (String)"fetchChannelNoticeUnreadCount reason:%s, code:%s", (Object[])new Object[]{reason, code});
                return false;
            }
        });
    }

    private void initChannelNoticeReceiver() {
        this.mChannelNoticeReceiver = new ChannelNoticeReceiver();
        this.mChannelNoticeReceiver.register();
    }

    private void sortData() {
        Comparator<ChannelNoticeMessage> comparator = new Comparator<ChannelNoticeMessage>(){

            @Override
            public int compare(ChannelNoticeMessage o1, ChannelNoticeMessage o2) {
                if (o1 == null || o2 == null) {
                    return -1;
                }
                if (o1.getTs() < o2.getTs()) {
                    return 1;
                }
                return -1;
            }
        };
        Collections.sort(this.mChannelNoticeItemList, comparator);
    }

    public void onLeftBtnClick(View v) {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        }
    }

    public void onRightBtnClick(View v) {
        this.showCleanDialog();
        ChannelTrack.INSTANCE.onClearNotifyClick();
    }

    private void showCleanDialog() {
        OkCancelDialog okCancelDialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_notice_clean), (CharSequence)ResourceUtils.getString((int)R.string.btn_voice_room_history_sure), (CharSequence)ResourceUtils.getString((int)R.string.btn_voice_room_history_cancel), true, false, new OkCancelDialogListener(){

            public void onCancel() {
                ChannelNoticeController.this.mDialogLinkManager.dismissDialog();
            }

            public void onOk() {
                ChannelNoticeController.this.mDialogLinkManager.dismissDialog();
                ChannelNoticeController.this.deleteMsg();
            }
        });
        okCancelDialog2.setCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog2) {
                ChannelNoticeController.this.mDialogLinkManager.dismissDialog();
            }
        });
        this.mDialogLinkManager.showDialog((BaseDialog)okCancelDialog2);
    }

    private void deleteMsg() {
        FeatureLog.i((String)"FTChannelNotice", (String)"deleteMsg minSeqId:%s, maxSeqId:%s", (Object[])new Object[]{this.mMinSeqId, this.mMaxSeqId});
        ClearNoticeReq clearNoticeReq = new ClearNoticeReq.Builder().min_seqid(Long.valueOf(this.mMinSeqId)).max_seqid(Long.valueOf(this.mMaxSeqId)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)clearNoticeReq, (IProtoCallback)new IProtoCallback<ClearNoticeRes>(){

            public void onResponse(@NonNull ClearNoticeRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (!ProtoManager.isSuccessCode((long)code)) {
                    FeatureLog.i((String)"FTChannelNotice", (String)"deleteMsg error, code:%s, msg:%s", (Object[])new Object[]{code, msg});
                    ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.check_network_and_retry);
                    return;
                }
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_finish_clean);
                FeatureLog.i((String)"FTChannelNotice", (String)"deleteMsg success", (Object[])new Object[0]);
                ChannelNoticeController.this.mChannelNoticeItemList.clear();
                if (ChannelNoticeController.this.mWindow != null) {
                    ChannelNoticeController.this.mWindow.clearData();
                    ChannelNoticeController.this.setClearStatus();
                }
                ChannelNoticeMessage channelNoticeMessage = new ChannelNoticeMessage();
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_FETCH_MSG, (Object)channelNoticeMessage));
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.i((String)"FTChannelNotice", (String)"deleteMsg timeout", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.check_network_and_retry);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                FeatureLog.i((String)"FTChannelNotice", (String)"deleteMsg reason:%s, code:%s", (Object[])new Object[]{reason, code});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.check_network_and_retry);
                    }
                });
                return false;
            }
        });
    }

    private void pullMsg() {
        this.setClearStatus();
        if (this.mHasScrollToEnd && this.mWindow != null) {
            FeatureLog.i((String)"FTChannelNotice", (String)"pullMsg hasScrollToEnd:%s", (Object[])new Object[]{this.mHasScrollToEnd});
            this.mWindow.finishLoad();
            return;
        }
        ProtoManager.Page page = new ProtoManager.Page();
        page.offset = this.mOffset;
        page.limit = 20L;
        page.snap = this.mSnap;
        GetNoticeReq getNoticeReq = new GetNoticeReq.Builder().page(ProtoManager.obtainPage((ProtoManager.Page)page)).build();
        ProgressDialog progressDialog2 = new ProgressDialog();
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.showDialog((BaseDialog)progressDialog2);
        }
        ProtoManager.getInstance().sendRpc((AndroidMessage)getNoticeReq, (IProtoCallback)new IProtoCallback<GetNoticeRes>(){

            public void onResponse(final @NonNull GetNoticeRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (ChannelNoticeController.this.mDialogLinkManager != null) {
                    ChannelNoticeController.this.mDialogLinkManager.dismissDialog();
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    FeatureLog.i((String)"FTChannelNotice", (String)"pullMsg error, code:%s, msg:%s", (Object[])new Object[]{code, msg});
                    ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.check_network_and_retry);
                    return;
                }
                if (!message.page.__isDefaultInstance() && !message.result.__isDefaultInstance()) {
                    FeatureLog.i((String)"FTChannelNotice", (String)"pullMsg success", (Object[])new Object[0]);
                    Page resultPage = message.page;
                    if (ChannelNoticeController.this.mSnap == 0L) {
                        ChannelNoticeController.this.mChannelNoticeItemList.clear();
                    }
                    ChannelNoticeController.this.mOffset = resultPage.offset;
                    ChannelNoticeController.this.mSnap = resultPage.snap;
                    FeatureLog.i((String)"FTChannelNotice", (String)"result offset:%s, snap:%s, totalCount:%s", (Object[])new Object[]{resultPage.offset, resultPage.snap, resultPage.total});
                    if (resultPage.offset.equals(message.page.total)) {
                        ChannelNoticeController.this.mHasScrollToEnd = true;
                        if (ChannelNoticeController.this.mWindow != null) {
                            ChannelNoticeController.this.mWindow.stopLoadMore();
                        }
                        FeatureLog.d((String)"FTChannelNotice", (String)"pullMsg not data", (Object[])new Object[0]);
                    }
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        @SuppressLint(value={"LoopUsage"})
                        public void run() {
                            List msgItemList = message.items;
                            ArrayList<Notify> notifyList = new ArrayList<Notify>(msgItemList.size());
                            for (NoticeItem item : msgItemList) {
                                if (!ChannelNoticeController.this.mSeqIdList.contains(item.seqid) && !item.has_read.booleanValue()) {
                                    ChannelNoticeController.this.mSeqIdList.add(item.seqid);
                                }
                                if (ChannelNoticeController.this.mMaxSeqId < item.seqid) {
                                    ChannelNoticeController.this.mMaxSeqId = item.seqid;
                                }
                                if (ChannelNoticeController.this.mMinSeqId > item.seqid) {
                                    ChannelNoticeController.this.mMinSeqId = item.seqid;
                                }
                                try {
                                    Notify notify2 = (Notify)Notify.ADAPTER.decode(item.payload);
                                    notifyList.add(notify2);
                                }
                                catch (Exception e) {
                                    FeatureLog.i((String)"FTChannelNotice", (String)"parseNotify error:%s", (Object[])new Object[]{e.toString()});
                                }
                            }
                            final ArrayList<ChannelNotify> channelNotifyList = ChannelNotifyHandler.parseRoleMsgNotifys(notifyList);
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    ArrayList<Long> channelNotifyUidList = new ArrayList<Long>();
                                    for (ChannelNotify channelNotify : channelNotifyList) {
                                        ChannelNoticeMessage channelNoticeMessage;
                                        if (channelNotify == null || (channelNoticeMessage = ChannelMessageCreator.createNoticeMessageFrom(channelNotify, true)) == null) continue;
                                        channelNotifyUidList.add(channelNoticeMessage.getChannelOwnerId());
                                        ChannelNoticeController.this.mChannelNoticeItemList.add(channelNoticeMessage);
                                    }
                                    FeatureLog.d((String)"FTChannelNotice", (String)"pull msg data:%s", (Object[])new Object[]{ChannelNoticeController.this.mChannelNoticeItemList});
                                    ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(channelNotifyUidList, new OnProfileCallback(){

                                        public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                                            ArrayList temp = new ArrayList(ChannelNoticeController.this.mChannelNoticeItemList);
                                            block0: for (ChannelNoticeMessage channelNoticeMessage : temp) {
                                                if (channelNoticeMessage == null) continue;
                                                for (UserInfoKS userInfoKS : userInfoKSList) {
                                                    if (userInfoKS == null || channelNoticeMessage.getChannelOwnerId() != userInfoKS.getUid()) continue;
                                                    channelNoticeMessage.setChannelOwnerAvatar(userInfoKS.getAvatar());
                                                    ChannelNoticeController.this.mChannelNoticeItemList.set(ChannelNoticeController.this.mChannelNoticeItemList.indexOf(channelNoticeMessage), channelNoticeMessage);
                                                    continue block0;
                                                }
                                            }
                                            if (ChannelNoticeController.this.mChannelNoticeItemList.size() > 0) {
                                                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_FETCH_MSG, ChannelNoticeController.this.mChannelNoticeItemList.get(0)));
                                            }
                                            ChannelNoticeController.this.ackNotice();
                                            if (ChannelNoticeController.this.mWindow != null) {
                                                ChannelNoticeController.this.setClearStatus();
                                                ChannelNoticeController.this.mWindow.setData(ChannelNoticeController.this.mChannelNoticeItemList);
                                            }
                                        }

                                        public void onFail(int id2, final String msg, String response) {
                                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                                @Override
                                                public void run() {
                                                    FeatureLog.i((String)"FTChannelNotice", (String)"fetch userInfo error:%s", (Object[])new Object[]{msg});
                                                    if (ChannelNoticeController.this.mChannelNoticeItemList.size() > 0) {
                                                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_FETCH_MSG, ChannelNoticeController.this.mChannelNoticeItemList.get(0)));
                                                    }
                                                    ChannelNoticeController.this.ackNotice();
                                                    if (ChannelNoticeController.this.mWindow != null) {
                                                        ChannelNoticeController.this.setClearStatus();
                                                        ChannelNoticeController.this.mWindow.setData(ChannelNoticeController.this.mChannelNoticeItemList);
                                                    }
                                                }
                                            });
                                        }
                                    });
                                }
                            });
                        }
                    });
                } else {
                    FeatureLog.i((String)"FTChannelNotice", (String)"pullMsg not page or not result", (Object[])new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (ChannelNoticeController.this.mDialogLinkManager != null) {
                    ChannelNoticeController.this.mDialogLinkManager.dismissDialog();
                }
                FeatureLog.i((String)"FTChannelNotice", (String)"pullMsg timeout", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.check_network_and_retry);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (ChannelNoticeController.this.mDialogLinkManager != null) {
                    ChannelNoticeController.this.mDialogLinkManager.dismissDialog();
                }
                FeatureLog.i((String)"FTChannelNotice", (String)"pullMsg code:%s, reason:%s", (Object[])new Object[]{code, reason});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.check_network_and_retry);
                    }
                });
                return false;
            }
        });
    }

    private void setClearStatus() {
        boolean canClick;
        boolean bl = canClick = this.mChannelNoticeItemList.size() > 0;
        if (this.mWindow != null) {
            this.mWindow.setClearStatus(canClick);
        }
    }

    private void ackNotice() {
        if (this.mSeqIdList.size() == 0) {
            return;
        }
        final long startTime = SystemClock.uptimeMillis();
        ArrayList<Long> seqList = new ArrayList<Long>(this.mSeqIdList);
        FeatureLog.i((String)"FTChannelNotice", (String)"ackNotice seqList:%s", (Object[])new Object[]{seqList});
        AckNoticeReq ackNoticeReq = new AckNoticeReq.Builder().seqids(seqList).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)ackNoticeReq, (IProtoCallback)new IProtoCallback<AckNoticeRes>(){

            public void onResponse(@NonNull AckNoticeRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (!ProtoManager.isSuccessCode((long)code)) {
                    FeatureLog.i((String)"FTChannelNotice", (String)"ackNotice fail, code:%s, msg:%s", (Object[])new Object[]{code, msg});
                    BaseRequestManager.statMetric((String)"channel/getnotices", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    return;
                }
                BaseRequestManager.statMetric((String)"channel/getnotices", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)0L);
                ChannelNoticeController.this.mSeqIdList.clear();
                FeatureLog.i((String)"FTChannelNotice", (String)"ackNotice success", (Object[])new Object[0]);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                BaseRequestManager.statMetric((String)"channel/getnotices", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                FeatureLog.i((String)"FTChannelNotice", (String)"ackNotice timeout", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                BaseRequestManager.statMetric((String)"channel/getnotices", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                FeatureLog.i((String)"FTChannelNotice", (String)"ackNotice code:%s, reason:%s", (Object[])new Object[]{code, reason});
                return false;
            }
        });
    }

    @Override
    public void onRefuse(int index) {
        this.handleMsgOperator(index, false);
    }

    private IChannelCenterService getChannelService() {
        return (IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class);
    }

    private void acceptRole(final int index, final boolean accept) {
        FeatureLog.i((String)"FTChannelNotice", (String)"acceptRole, accept:%s", (Object[])new Object[]{accept});
        ChannelNoticeMessage item = this.mChannelNoticeItemList.get(index);
        this.getChannelService().getChannel(item.getChannelId()).getRoleService().acceptRole(item.getSetId(), accept, new IRoleService.IAcceptRoleInviteCallBack(){
            boolean mAccept;
            int mIndex;
            {
                this.mAccept = accept;
                this.mIndex = index;
            }

            public void onSuccess(String cId, ChannelUser user) {
                FeatureLog.i((String)"FTChannelNotice", (String)"acceptRole success, accept:%s", (Object[])new Object[]{this.mAccept});
                int status = this.mAccept ? 2 : 1;
                ChannelNoticeController.this.updateStatus(this.mIndex, status);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_INVITATION_HANDLE_RESULT, (Object)this.mAccept));
            }

            public void onInviteAlreadyInvalidError(String cId, String inviteId) {
                FeatureLog.i((String)"FTChannelNotice", (String)"acceptRole onInviteAlreadyInvalidError, cid:%s, inviteId:%s", (Object[])new Object[]{cId, inviteId});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_already_changed);
            }

            public void onError(String cId, int errorCode, String errorTips, Exception e) {
                FeatureLog.i((String)"FTChannelNotice", (String)"acceptRole onError, cid:%s, errorCode:%s, errorTips:%s", (Object[])new Object[]{cId, errorCode, errorTips});
                if (errorCode == ECode.INVITE_EXPIRE.getValue()) {
                    ChannelNoticeController.this.updateStatus(this.mIndex, 3);
                } else {
                    ChannelNoticeController.this.showErrorToast(errorCode);
                }
            }

            public void onFailByMemberReachLimit(String cid, String inviteId) {
                FeatureLog.i((String)"FTChannelNotice", (String)"acceptRole onFailByMemberReachLimit, cid:%s, inviteId:%s", (Object[])new Object[]{cid, inviteId});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_num_limit);
            }

            public void onFailByJoinedChannelLimit(String cid, String inviteId) {
                FeatureLog.i((String)"FTChannelNotice", (String)"acceptRole onFailByJoinedChannelLimit, cid:%s, inviteId:%s", (Object[])new Object[]{cid, inviteId});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_join_num_limit);
            }

            public void onAlreadyJoined(String cid, String inviteId) {
                FeatureLog.i((String)"FTChannelNotice", (String)"acceptRole onFailByJoinedChannelLimit, cid:%s, inviteId:%s", (Object[])new Object[]{cid, inviteId});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_still_in_channel);
            }

            public void onFailByJoinedFrozeLimit(String applyCId, int leftFrozeTime) {
                FeatureLog.i((String)"FTChannelNotice", (String)"acceptRole onFailByJoinedFrozeLimit, applyCId:%s, leftFrozeTime:%s", (Object[])new Object[]{applyCId, leftFrozeTime});
                int hour = (int)TimeUtils.MINUTES.toCeilHours((long)leftFrozeTime);
                if (hour <= 0) {
                    hour = 1;
                }
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_join_family_froze, (Object[])new Object[]{hour}), (int)0);
            }

            public void onChannelNoExit(String cid, long errorCode) {
                FeatureLog.i((String)"FTChannelNotice", (String)"acceptRole onChannelNoExit, cid:%s, code:%s", (Object[])new Object[]{cid, errorCode});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_not_exist);
            }

            public void onChannelBanned(String cid, long code) {
                FeatureLog.i((String)"FTChannelNotice", (String)"acceptRole onChannelBanned, cid:%s, code:%s", (Object[])new Object[]{cid, code});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_has_been_ban);
            }

            public void onChannelJoinBanForever(String cid, long code) {
                FeatureLog.i((String)"FTChannelNotice", (String)"acceptRole onChannelJoinBanForever, cid:%s, code:%s", (Object[])new Object[]{cid, code});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_join_ban_forver);
            }

            public void onNotInChannel(String cid, long code) {
                FeatureLog.i((String)"FTChannelNotice", (String)"acceptRole onNotInChannel, cid:%s, code:%s", (Object[])new Object[]{cid, code});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_not_in_channel);
            }

            public void onOtherRejected(String cid, long code) {
                FeatureLog.i((String)"FTChannelNotice", (String)"acceptRole onOtherRejected, cid:%s, code:%s", (Object[])new Object[]{cid, code});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_other_rejected);
            }

            public void onNoArrow(String cid, long code) {
                FeatureLog.i((String)"FTChannelNotice", (String)"acceptRole onNoArrow, cid:%s, code:%s", (Object[])new Object[]{cid, code});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_no_arrow);
            }
        });
    }

    private void apply(final int index, final boolean accept) {
        FeatureLog.i((String)"FTChannelNotice", (String)"apply, accept:%s", (Object[])new Object[]{accept});
        ChannelNoticeMessage item = this.mChannelNoticeItemList.get(index);
        JoinApproveData joinApproveData = new JoinApproveData();
        joinApproveData.accept = accept;
        joinApproveData.applyId = item.getApplyId();
        joinApproveData.reason = "";
        this.getChannelService().getChannel(item.getChannelId()).getRoleService().joinApprove(joinApproveData, new IRoleService.IJoinApproveCallBack(){
            int mIndex;
            boolean mAccept;
            {
                this.mIndex = index;
                this.mAccept = accept;
            }

            public void onSuccess(String cId, String applyId, ChannelUser user) {
                FeatureLog.i((String)"FTChannelNotice", (String)"apply success, accept:%s", (Object[])new Object[]{this.mAccept});
                int status = this.mAccept ? 2 : 1;
                ChannelNoticeController.this.updateStatus(this.mIndex, status);
            }

            public void onNoPermissionError(String cId, String applyId) {
                FeatureLog.i((String)"FTChannelNotice", (String)"apply onNoPermissionError, cid:%s, applyId:%s", (Object[])new Object[]{cId, applyId});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_no_permit);
            }

            public void onFailByMemberReachLimit(String cId, String applyId) {
                FeatureLog.i((String)"FTChannelNotice", (String)"apply onFailByMemberReachLimit, cid:%s, applyId:%s", (Object[])new Object[]{cId, applyId});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_num_limit);
            }

            public void onApplyAlreadyInvalidError(String cId, String applyId) {
                FeatureLog.i((String)"FTChannelNotice", (String)"apply onApplyAlreadyInvalidError, cid:%s, applyId:%s", (Object[])new Object[]{cId, applyId});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_already_changed);
            }

            public void onFailByJoinedChannelLimit(String cId, String applyId) {
                FeatureLog.i((String)"FTChannelNotice", (String)"apply onFailByJoinedChannelLimit, cid:%s, applyId:%s", (Object[])new Object[]{cId, applyId});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_join_num_limit);
            }

            public void onAlreadyJoined(String cId, String applyId) {
                FeatureLog.i((String)"FTChannelNotice", (String)"apply onAlreadyJoined, cid:%s, applyId:%s", (Object[])new Object[]{cId, applyId});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_still_in_channel);
            }

            public void onError(String cId, int errorCode, String errorTips, Exception e) {
                FeatureLog.i((String)"FTChannelNotice", (String)"apply onError, cid:%s, errorCode:%s, errorTips:%s", (Object[])new Object[]{cId, errorCode, errorTips});
                if (errorCode == ECode.INVITE_EXPIRE.getValue()) {
                    ChannelNoticeController.this.updateStatus(this.mIndex, 3);
                } else {
                    ChannelNoticeController.this.showErrorToast(errorCode);
                }
            }

            public void onChannelNoExit(String cid, long errorCode) {
                FeatureLog.i((String)"FTChannelNotice", (String)"apply onChannelNoExit, cid:%s, code:%s", (Object[])new Object[]{cid, errorCode});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_not_exist);
            }

            public void onChannelBanned(String cid, long code) {
                FeatureLog.i((String)"FTChannelNotice", (String)"apply onChannelBanned, cid:%s, code:%s", (Object[])new Object[]{cid, code});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_has_been_ban);
            }

            public void onChannelJoinBanForever(String cid, long code) {
                FeatureLog.i((String)"FTChannelNotice", (String)"apply onChannelJoinBanForever, cid:%s, code:%s", (Object[])new Object[]{cid, code});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_join_ban_forver);
            }

            public void onNotInChannel(String cid, long code) {
                FeatureLog.i((String)"FTChannelNotice", (String)"apply onNotInChannel, cid:%s, code:%s", (Object[])new Object[]{cid, code});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_not_in_channel);
            }

            public void onOtherRejected(String cid, long code) {
                FeatureLog.i((String)"FTChannelNotice", (String)"apply onOtherRejected, cid:%s, code:%s", (Object[])new Object[]{cid, code});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_other_rejected);
            }

            public void onNoArrow(String cid, long code) {
                FeatureLog.i((String)"FTChannelNotice", (String)"apply onNoArrow, cid:%s, code:%s", (Object[])new Object[]{cid, code});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_channel_notice_no_arrow);
            }

            public void onFailAlreadHaveFamily(String cid, long code) {
                FeatureLog.i((String)"FTChannelNotice", (String)"apply onFailAlreadHaveFamily, cid:%s, code:%s", (Object[])new Object[]{cid, code});
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.tips_already_in_other_family);
            }
        });
    }

    private void updateStatus(int index, int status) {
        if (this.mWindow != null) {
            this.mWindow.updateStatus(index, status);
        }
    }

    @Override
    public void onAgree(int index) {
        this.handleMsgOperator(index, true);
    }

    private void showErrorToast(int code) {
        if (code == ECode.CHANNEL_BANNED.getValue()) {
            ToastUtils.showToast((Context)this.mContext, (int)R.string.tips_channel_has_been_ban);
        } else if (code == ECode.CHANNEL_NOT_EXISTS.getValue()) {
            ToastUtils.showToast((Context)this.mContext, (int)R.string.tips_channel_not_exist);
        } else if (code == ECode.JOIN_BAN_FOREVER.getValue()) {
            ToastUtils.showToast((Context)this.mContext, (int)R.string.tips_channel_notice_join_ban_forver);
        } else if (code == ECode.NOT_IN_CHANNEL.getValue()) {
            ToastUtils.showToast((Context)this.mContext, (int)R.string.tips_channel_notice_not_in_channel);
        } else if (code == ECode.OTHER_REJECTED.getValue()) {
            ToastUtils.showToast((Context)this.mContext, (int)R.string.tips_channel_notice_other_rejected);
        } else if (code == ECode.NO_ARROW.getValue()) {
            ToastUtils.showToast((Context)this.mContext, (int)R.string.tips_channel_notice_no_arrow);
        } else {
            ToastUtils.showToast((Context)this.mContext, (int)R.string.check_network_and_retry);
        }
    }

    private void handleMsgOperator(int index, boolean accept) {
        if (this.mChannelNoticeItemList == null || this.mChannelNoticeItemList.size() <= index) {
            return;
        }
        ChannelNoticeMessage channelNoticeItem = this.mChannelNoticeItemList.get(index);
        if (channelNoticeItem.getType() == 1) {
            this.acceptRole(index, accept);
            ChannelTrack.INSTANCE.onMemberJoinClick("5");
        } else if (channelNoticeItem.getType() == 2) {
            this.apply(index, accept);
            ChannelTrack.INSTANCE.onMemberJoinClick("3");
        } else if (channelNoticeItem.getType() == 7) {
            this.inviteAgree(index, accept);
        }
    }

    private void inviteAgree(final int index, final boolean accept) {
        ChannelNoticeMessage item = this.mChannelNoticeItemList.get(index);
        AcceptMemberInviteGuestReq req = new AcceptMemberInviteGuestReq.Builder().accept(Boolean.valueOf(accept)).set_id(String.valueOf(item.getSetId())).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<AcceptMemberInviteGuestRes>(){
            int mIndex;
            boolean mAccept;
            {
                this.mIndex = index;
                this.mAccept = accept;
            }

            public void onResponse(@NonNull AcceptMemberInviteGuestRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    int status = this.mAccept ? 2 : 1;
                    ChannelNoticeController.this.updateStatus(this.mIndex, status);
                } else {
                    ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.check_network_and_retry);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.check_network_and_retry);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                ToastUtils.showToast((Context)ChannelNoticeController.this.mContext, (int)R.string.check_network_and_retry);
                return false;
            }
        });
    }

    @Override
    public void onJumpToChannel(String channelId, String pwd) {
        Message message = Message.obtain();
        message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
        message.obj = EnterParam.obtain((String)channelId, (int)22, (String)pwd);
        this.sendMessage(message);
    }

    @Override
    public void onJumpToProfile(long uid, String channelId) {
        MLog.info((Object)"ChannelNoticeController", (String)"open profile window:%s", (Object[])new Object[]{String.valueOf(uid)});
        ProfileReportBean bean2 = new ProfileReportBean();
        bean2.setUid(Long.valueOf(uid));
        bean2.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getChannel()));
        bean2.setSource(18);
        this.sendMessage(BaseMsgDef.MSG_OPEN_PROFILE_NEW_WINDOW, -1, -1, bean2);
    }

    @Override
    public void onLoad() {
        this.pullMsg();
    }
}

