/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.myjoined.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.JoinedChannelInfo;
import com.yy.hiyo.channel.base.callback.IAdapterNotify;
import java.util.ArrayList;
import java.util.List;

public class JoinedChannelListAdapter
extends RecyclerView.Adapter<JoinedGroupViewHolder>
implements IAdapterNotify {
    private List<JoinedChannelInfo> mData = new ArrayList<JoinedChannelInfo>();
    private OnGroupClickListener mGroupClickListener;

    public void setData(List<JoinedChannelInfo> data2) {
        this.mData.clear();
        if (data2 != null) {
            this.mData.addAll(data2);
        }
    }

    public void setGroupClickListener(OnGroupClickListener groupClickListener) {
        this.mGroupClickListener = groupClickListener;
    }

    @NonNull
    public JoinedGroupViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_joined_group_channel, parent, false);
        return new JoinedGroupViewHolder(itemView);
    }

    public void onBindViewHolder(@NonNull JoinedGroupViewHolder holder, int position) {
        if (position < 0 || position >= this.mData.size()) {
            return;
        }
        JoinedChannelInfo info = this.mData.get(position);
        holder.setData(info);
        holder.setItemClickListener(v -> {
            if (this.mGroupClickListener != null) {
                this.mGroupClickListener.onGroupClick(info);
            }
        });
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public void notifyItem(int position) {
        if (position < this.getItemCount()) {
            this.notifyItemChanged(position);
        }
    }

    public static interface OnGroupClickListener {
        public void onGroupClick(JoinedChannelInfo var1);
    }

    static class JoinedGroupViewHolder
    extends RecyclerView.ViewHolder {
        private RoundImageView mIvAvatar;
        private TextView mTvName;
        private TextView mRedPoint;

        public JoinedGroupViewHolder(View itemView) {
            super(itemView);
            this.mIvAvatar = (RoundImageView)itemView.findViewById(R.id.iv_avatar);
            this.mTvName = (TextView)itemView.findViewById(R.id.tv_name);
            this.mRedPoint = (TextView)itemView.findViewById(R.id.view_red_point);
        }

        public void setData(JoinedChannelInfo info) {
            this.mTvName.setText((CharSequence)info.name);
            if (info.unreadCount > 0L) {
                this.mRedPoint.setVisibility(0);
                if (info.unreadCount <= 99L) {
                    this.mRedPoint.setText((CharSequence)String.valueOf(info.unreadCount));
                } else {
                    this.mRedPoint.setText((CharSequence)"99+");
                }
            } else {
                this.mRedPoint.setVisibility(4);
            }
            String avatarUrl = info.avatar + YYImageUtils.getThumbnailPostfix((int)45);
            ImageLoader.loadImage((ImageView)this.mIvAvatar, (String)avatarUrl, (int)0, (int)AvatarUtils.getDefaultAvatar((int)0));
        }

        public void setItemClickListener(View.OnClickListener listener2) {
            this.itemView.setOnClickListener(listener2);
        }
    }
}

