/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.myjoined.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.JoinedChannelInfo;
import com.yy.hiyo.channel.base.callback.IAdapterNotify;
import com.yy.hiyo.channel.base.service.JoinChannelUnreadManager;
import com.yy.hiyo.channel.module.myjoined.ui.JoinedChannelsUiCallback;
import com.yy.hiyo.channel.module.myjoined.ui.adapter.JoinedChannelListAdapter;
import java.util.List;

public class JoinedChannelsWindow
extends DefaultWindow {
    private static final String NAME = "SelfChatRoomWindow";
    private JoinedChannelsUiCallback mUiCallback;
    private SimpleTitleBar mTitleBar;
    private RecyclerView mRvList;
    private CommonStatusLayout mCommonStatusLayout;
    private JoinedChannelListAdapter mAdapter = new JoinedChannelListAdapter();
    private JoinChannelUnreadManager mUnreadManager = new JoinChannelUnreadManager();

    public JoinedChannelsWindow(Context context, JoinedChannelsUiCallback callBacks) {
        super(context, (UICallBacks)callBacks, NAME);
        this.mUiCallback = callBacks;
        this.createViews();
    }

    private void createViews() {
        View rootView = JoinedChannelsWindow.inflate((Context)this.getContext(), (int)R.layout.layout_joined_group_list_page_channel, (ViewGroup)this.getBaseLayer());
        this.mTitleBar = (SimpleTitleBar)rootView.findViewById(R.id.titlebar);
        this.mRvList = (RecyclerView)rootView.findViewById(R.id.rv_list);
        this.mCommonStatusLayout = (CommonStatusLayout)rootView.findViewById(R.id.common_status);
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, v -> {
            if (this.mUiCallback != null) {
                this.mUiCallback.closeWindow(this);
            }
        });
        this.mTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.title_my_groups));
        this.mRvList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mRvList.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mCommonStatusLayout.showLoading();
        this.mAdapter.setGroupClickListener(groupInfo -> {
            if (this.mUiCallback != null) {
                this.mUiCallback.onGroupClick(groupInfo);
            }
        });
    }

    public void updateData(List<JoinedChannelInfo> data2) {
        if (this.mCommonStatusLayout.isShowLoading()) {
            this.mCommonStatusLayout.hideLoading();
        }
        this.mAdapter.setData(data2);
        this.mAdapter.notifyDataSetChanged();
        this.mUnreadManager.init(data2, (IAdapterNotify)this.mAdapter);
    }
}

