/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.game;

import android.os.Message;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.base.SeatStatusUtils;
import com.yy.hiyo.channel.base.callback.IChannelMiniListener;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.game.base.FilterRunnable;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.gamemode.IGameFliterInterface;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.hiyo.game.service.callback.ILeaveGameCallback;

public class MyChannelGameFilter {
    private FilterRunnable filterRunnable = null;
    private boolean needRecoverVoice;
    private boolean lastMicOn = false;
    private String logTag = "ChannelWindowController";
    private ICallback callback = null;
    private IGameFliterInterface gameFilter = new IGameFliterInterface(){

        public int getFilterPriority() {
            return 0;
        }

        public boolean filter(FilterRunnable runnable2) {
            return MyChannelGameFilter.this.callback.handleGameFilter(runnable2);
        }
    };

    public MyChannelGameFilter(String logTag, ICallback callBack) {
        this.logTag = logTag;
        this.callback = callBack;
    }

    public void exitChannel(FilterRunnable runnable2) {
        YYTaskExecutor.postToMainThread(() -> {
            this.filterRunnable = runnable2;
            IChannel channel = this.getChannel();
            if (channel != null && runnable2.gameContext != null && runnable2.gameContext.mFrom == GameContextDef.JoinFrom.FROM_HAGO_GROUP && channel.getPluginService().getCurPluginData() != null && channel.getPluginService().getCurPluginData().mode == 1) {
                MLog.info((Object)this.logTag, (String)"handle filter exit, but not leave channel!", (Object[])new Object[0]);
                if (channel != null) {
                    this.lastMicOn = SeatStatusUtils.isMicOpen((long)channel.getSeatService().getSeatStatus(AccountUtil.getUid()));
                    channel.getMediaService().disablePublishMic(1);
                    channel.getMediaService().exitRoom();
                }
                this.onExitChannel();
                this.needRecoverVoice = true;
            } else {
                MLog.info((Object)this.logTag, (String)"handle filter from:%s", (Object[])new Object[]{runnable2.gameContext != null ? runnable2.gameContext.mFrom : ""});
                this.callback.exit();
            }
        });
    }

    private void addGameFilter() {
        MLog.info((Object)this.logTag, (String)"GameFilter addGameFilter!", (Object[])new Object[0]);
        ((IGameCenterService)ServiceManagerProxy.getInstance().getService(IGameCenterService.class)).removeFilter(28, this.gameFilter);
        ((IGameCenterService)ServiceManagerProxy.getInstance().getService(IGameCenterService.class)).addFilter(28, this.gameFilter);
    }

    private void removeGameFilter() {
        MLog.info((Object)this.logTag, (String)"GameFilter removeGameFilter!", (Object[])new Object[0]);
        ((IGameCenterService)ServiceManagerProxy.getInstance().getService(IGameCenterService.class)).removeFilter(28, this.gameFilter);
    }

    public void onEnterChannel() {
        this.addGameFilter();
    }

    public void onChannelWindowShown() {
        if (this.needRecoverVoice) {
            this.addGameFilter();
            IChannel channel = this.getChannel();
            if (channel != null) {
                channel.getMediaService().joinMultiRoom(channel.getPluginService().getCurPluginData());
                if (channel.getSeatService().isMeInSeat() && this.lastMicOn) {
                    channel.getMediaService().enablePublishMic(1);
                }
            }
            this.needRecoverVoice = false;
        }
    }

    public void onExitChannel() {
        MLog.info((Object)this.logTag, (String)"onExitChannel!", (Object[])new Object[0]);
        this.exitGame(new Callback<Boolean>(){

            public void onResponse(Boolean data2) {
                MLog.info((Object)MyChannelGameFilter.this.logTag, (String)"onExitChannel callBack exited:%s!", (Object[])new Object[]{data2 != null && data2 != false ? "true" : "false"});
                FilterRunnable runnable2 = MyChannelGameFilter.this.filterRunnable;
                if (runnable2 != null) {
                    YYTaskExecutor.postToMainThread((Runnable)runnable2);
                    FeatureLog.i((String)"FTVoiceRoom", (String)"run game filter delay", (Object[])new Object[0]);
                }
                MyChannelGameFilter.this.filterRunnable = null;
                MyChannelGameFilter.this.removeGameFilter();
            }
        });
    }

    private IChannel getChannel() {
        if (this.callback != null) {
            return this.callback.getChannel();
        }
        return null;
    }

    public void exitGame(final Callback<Boolean> callback2) {
        ((IGameCenterService)ServiceManagerProxy.getInstance().getService(IGameCenterService.class)).leaveCurrentGame(new ILeaveGameCallback(){

            public void onGameLeaved(GameInfo gameInfo, GamePlayContext context) {
                if (callback2 != null) {
                    callback2.onResponse((Object)true);
                }
            }
        });
    }

    public static boolean shouldHandle(FilterRunnable runnable2) {
        return runnable2 != null && runnable2.gameInfo != null && !runnable2.gameInfo.isPopupGame() && runnable2.gameInfo.getGameMode() != 8 && runnable2.gameInfo.getGameMode() != 10;
    }

    public static boolean handleGameFilterInner(final MyChannelGameFilter gameFilter, final FilterRunnable runnable2) {
        MLog.info((Object)"MyChannelGameFilter", (String)"GameFilter filter!, gameInfo:%s", (Object[])new Object[]{runnable2 == null ? "" : runnable2.gameInfo});
        if (MyChannelGameFilter.shouldHandle(runnable2)) {
            if (runnable2.gameContext instanceof GameMatchContext || runnable2.gameContext instanceof GameTeamMatchContext) {
                IChannelMiniListener listener2 = new IChannelMiniListener(){

                    public void onClickExitChannel(boolean exit, boolean afterShowDialog) {
                        if (exit) {
                            gameFilter.exitChannel(runnable2);
                        }
                    }
                };
                Message showDialogMsg = Message.obtain();
                showDialogMsg.what = BaseMsgDef.SHOW_MINI_EXIT_CHANNEL_DIALOG;
                showDialogMsg.obj = listener2;
                MsgDispatcher.getInstance().sendMessage(showDialogMsg);
            } else {
                gameFilter.exitChannel(runnable2);
            }
            return true;
        }
        return false;
    }

    public static interface ICallback {
        public IChannel getChannel();

        public boolean handleGameFilter(FilterRunnable var1);

        public void exit();
    }
}

