/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.exit;

import android.net.Uri;
import biz.SourceEntry;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.deeplink.data.DeepLinkChannelParam;
import com.yy.appbase.recommend.bean.TopTab;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.home.IHomeService;
import com.yy.appbase.service.home.LiveParam;
import com.yy.appbase.service.home.PartyParam;
import com.yy.appbase.service.home.PlayTabParam;
import com.yy.appbase.service.home.PlayTabType;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.ChannelJumpBackConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.hiido.ChannelBaseTrack;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.AbsPlugin;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.module.main.web.ChannelLifecycle;
import com.yy.hiyo.channel.module.recommend.base.PartyPageDef;

public class MiniHelper {
    private String logTag = "ChannelWindowController";
    private static final int ONE_MINUTE = 60000;
    private static final int FIVE_MINUTE = 300000;
    private ICallback callback = null;
    private long lastRadioGuideMills = 0L;

    public MiniHelper(String logTag, ICallback callBack) {
        this.logTag = logTag;
        this.callback = callBack;
    }

    public void minimize() {
        MLog.info((Object)this.logTag, (String)"minimize", (Object[])new Object[0]);
        final IChannel channel = this.callback.getChannel();
        if (channel == null) {
            MLog.info((Object)this.logTag, (String)"minimize channel null!", (Object[])new Object[0]);
            return;
        }
        Runnable miniCommand = new Runnable(){

            @Override
            public void run() {
                if (MiniHelper.this.callback.getPlugin() != null) {
                    MiniHelper.this.callback.getPlugin().prePopWindow(aBoolean -> {
                        MiniHelper.this.callback.getPlugin().preMinimize();
                        MiniHelper.this.backToRoomList();
                        MiniHelper.this.backToChannelList();
                        MiniHelper.this.fromDeepLinkBackTest();
                        if (YYTaskExecutor.isMainThread()) {
                            MiniHelper.this.callback.popWindow(true);
                        } else {
                            YYTaskExecutor.postToMainThread(() -> MiniHelper.this.callback.popWindow(true));
                        }
                        if (MiniHelper.this.callback.getChannel() != null) {
                            ChannelLifecycle.INSTANCE.onMinimize(channel);
                        }
                        return null;
                    });
                }
            }
        };
        if (channel.getPluginService().getCurPluginData() != null && channel.getPluginService().getCurPluginData().mode != 1) {
            miniCommand.run();
        } else {
            ChannelDetailInfo channelDetailInfo = channel.getDataService().getCacheDetail();
            if (channelDetailInfo != null && channelDetailInfo.dynamicInfo != null && channelDetailInfo.dynamicInfo.mBgmPlaying) {
                miniCommand.run();
            } else if (channel.getSeatService().hasUserInSeat() && (channel.getEnterParam() == null || !EnterParam.isGameOpenEntry((int)channel.getEnterParam().entry))) {
                miniCommand.run();
            } else {
                this.callback.exitChannel(this.callback.getChannelId());
            }
        }
    }

    private void backToRoomList() {
        EnterParam enterParams = this.getEnterParam();
        if (enterParams != null && enterParams.isBackToList) {
            MLog.info((Object)this.logTag, (String)"backToRoomList!", (Object[])new Object[0]);
            ChannelBaseTrack.INSTANCE.onVoiceRoomListVisit("4");
            IHomeService homeService = (IHomeService)ServiceManagerProxy.getService(IHomeService.class);
            if (homeService != null) {
                boolean isRadioLive = this.callback.getChannel().getPluginService().getCurPluginData().isVideoMode();
                if (isRadioLive) {
                    DeepLinkChannelParam param2 = new DeepLinkChannelParam();
                    param2.setTargetChannelTopBar(TopTab.TYPE_SHOW);
                    homeService.toPlay(PlayTabType.LIVE, (PlayTabParam)new LiveParam(1, param2, 0));
                } else if (enterParams.entry == 5 || enterParams.entry == 26) {
                    int targetTab = 1;
                    AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.CHANNEL_JUMP_BACK_CONFIG);
                    if (aConfigData != null && aConfigData instanceof ChannelJumpBackConfig) {
                        ChannelJumpBackConfig config = (ChannelJumpBackConfig)aConfigData;
                        if (enterParams.gameInfo != null && !config.needBackToRecommend(enterParams.gameInfo.gid, true)) {
                            targetTab = 2;
                        }
                    }
                    homeService.toPlay(PlayTabType.PARTY, (PlayTabParam)new PartyParam(targetTab, null, 0));
                } else {
                    if (RuntimeContext.isHagoPartySdk()) {
                        if (!SettingFlags.getBoolean((String)"key_first_into_party_page", (boolean)false)) {
                            homeService.toPlay(PlayTabType.PARTY, (PlayTabParam)new PartyParam(15, null, 0));
                        } else {
                            homeService.toPlay(PlayTabType.PARTY, (PlayTabParam)new PartyParam(1, null, 0));
                        }
                    }
                    homeService.toPlay(PlayTabType.PARTY, (PlayTabParam)new PartyParam(1, null, 0));
                }
            }
            if (enterParams.entry == 1 || enterParams.entry == 5) {
                if (this.callback.getChannel().getPluginService().getCurPluginData().isVideoMode()) {
                    MLog.debug((Object)"MiniHelper", (String)"go back to radio", (Object[])new Object[0]);
                    MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.ChannelOrRoomListMsgDef.FOCUS_TAB_BY_TYPE, 5);
                } else {
                    String gid = this.callback.getChannel().getPluginService().getCurPluginData().getId();
                    MLog.debug((Object)"MiniHelper", (String)("go back to gid: " + gid), (Object[])new Object[0]);
                    MsgDispatcher.getInstance().sendMessage(PartyPageDef.FOCUS_TAB_BY_GID, (Object)gid);
                }
            } else if (enterParams.entry == 141 || enterParams.entry == SourceEntry.SE_GAME_EXIT_POPUP_NEW_USER.getValue() || enterParams.entry == SourceEntry.SE_GAME_EXIT_POPUP_OLD_USER.getValue()) {
                if (this.callback.getChannel().getPluginService().getCurPluginData().isVideoMode()) {
                    MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.ChannelOrRoomListMsgDef.FOCUS_TOP_TAB_AND_SUB_TAB, TopTab.TYPE_SHOW, 1);
                } else {
                    MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.ChannelOrRoomListMsgDef.FOCUS_TOP_TAB_AND_SUB_TAB, TopTab.TYPE_PARTY, 1);
                }
            }
        }
    }

    private void backToChannelList() {
        EnterParam enterParams = this.getEnterParam();
        if (enterParams != null && enterParams.backToChannelList) {
            long id2 = (Long)enterParams.getExtra("group_style4_module_id", (Object)0L);
            MLog.info((Object)this.logTag, (String)("backToChannelList! module id: " + id2), (Object[])new Object[0]);
            if (id2 > 0L) {
                MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.ChannelMsgDef.OPEN_MODULE_CHANNEL_LIST_WINDOW, -1, -1, (Object)id2);
                enterParams.backToChannelList = false;
            }
        }
    }

    private void fromDeepLinkBackTest() {
        String isBackListOrTeamUpTest;
        Uri deepLinkUri;
        EnterParam enterParams = this.getEnterParam();
        if (enterParams != null && !enterParams.backToChannelList && (deepLinkUri = (Uri)enterParams.getExtra("deep_link", null)) != null && "1".equals(isBackListOrTeamUpTest = deepLinkUri.getQueryParameter("isBackToListOrTeamUp"))) {
            if (NAB.A.equals((Object)NewABDefine.DEEPLINK_TO_CHANNEL_BACK_TEST.getTest())) {
                MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.ChannelOrRoomListMsgDef.FOCUS_TOP_TAB_AND_SUB_TAB, TopTab.TYPE_PARTY, 1);
            } else if (NAB.B.equals((Object)NewABDefine.DEEPLINK_TO_CHANNEL_BACK_TEST.getTest())) {
                MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.TeamUpListDef.OPEN_TEAM_UP_LIST_PAGE);
            }
        }
    }

    EnterParam getEnterParam() {
        return this.callback.getEnterParam();
    }

    public static interface ICallback {
        public void exitChannel(String var1);

        public IChannel getChannel();

        public String getChannelId();

        public EnterParam getEnterParam();

        public void popWindow(boolean var1);

        public AbsPlugin<AbsPage, IChannelPageContext<AbsPage>> getPlugin();
    }
}

