/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter;

import android.content.Context;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.base.bean.ChannelBannedData;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.multivideo.view.ForceLeaveDialog;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import net.ihago.channel.srv.mgr.ECode;

public class MyChannelJoinCallback {
    private String logTag = "ChannelWindowController";
    private ICallBack callback = null;
    private Context context;

    public MyChannelJoinCallback(Context context, String logTag, ICallBack callBack) {
        this.logTag = logTag;
        this.callback = callBack;
        this.context = context;
    }

    public IChannel.IJoinCallBack getJoinCallBack() {
        return new IChannel.IJoinCallBack(){

            public void onSuccess(EnterParam requestParams, ChannelDetailInfo info, EnterChannelData data2) {
                if (data2 == null || data2.pluginData == null || data2.mediaToken == null) {
                    MLog.error((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack success cid:%s, but data is invalid!", (Object[])new Object[]{info.baseInfo.gid});
                } else {
                    MLog.info((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack success, cid:%s, pmode:%d,pluginId:%s!", (Object[])new Object[]{info.baseInfo.gid, data2.pluginData.getMode(), data2.pluginData.getId()});
                }
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onSuccess(MyChannelJoinCallback.this.getEnterParam(), info, data2);
                }
                MyChannelJoinCallback.this.callback.onJoinSuccess(requestParams, data2, ((IChannelCenterService)ServiceManagerProxy.getInstance().getService(IChannelCenterService.class)).getChannel(info.baseInfo.gid));
            }

            public void onFailByOnlineLimit(EnterParam requestParams, String msgTip) {
                MLog.error((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack onFailByOnlineLimit,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onFailByOnlineLimit(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onFailByNeedPassword(EnterParam requestParams, String msgTip) {
                MLog.error((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack onFailByNeedPassword,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onFailByNeedPassword(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onFailByPasswordError(EnterParam requestParams, String msgTip) {
                MLog.error((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack onFailByPasswordError,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onFailByPasswordError(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onKickOffFrozenError(EnterParam requestParams, String msgTip) {
                MLog.error((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack onKickOffFrozenError,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onKickOffFrozenError(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onFailByChannelNotExist(EnterParam requestParams, String msgTip) {
                MLog.error((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack onFailByChannelNotExist,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onFailByChannelNotExist(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onChannelBanned(EnterParam requestParams, ChannelBannedData bannedData, String msgTip) {
                MLog.error((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack onChannelBanned,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onChannelBanned(requestParams, bannedData, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onFailByPasswordTryTooFrequently(EnterParam requestParams, String msgTip) {
                MLog.error((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack onFailByPasswordTryTooFrequently,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onFailByPasswordTryTooFrequently(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onPrivateChannel(EnterParam requestParams, String msgTip) {
                MLog.error((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack onPrivateChannel,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onPrivateChannel(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onFailByInviteExpire(EnterParam requestParams, String msgTip) {
                MLog.error((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack onFailByInviteExpire,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onFailByInviteExpire(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onFailByInviteClickMaxLimit(EnterParam requestParams, String msgTip) {
                MLog.error((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack onFailByInviteClickMaxLimit,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onFailByInviteClickMaxLimit(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onFailChannelMatchFail(EnterParam requestParams, String msgTip) {
                MLog.error((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack onChannelNoMatch,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onFailChannelMatchFail(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onFailChannelAllDisBand(EnterParam requestParams, String msgTip) {
                MLog.error((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack onChannelNoMatch,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onFailChannelAllDisBand(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onRetryUnBannedChannel(String channelId, EnterParam requestParams, String msgTip) {
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onRetryUnBannedChannel(channelId, requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onCrossRegionNotAllow(EnterParam requestParams, String msgTip) {
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onCrossRegionNotAllow(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onFailEnterMultiVideoRoom(EnterParam requestParams, String msgTip) {
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onFailEnterMultiVideoRoom(requestParams, msgTip);
                    if (requestParams.entry == 67 || requestParams.entry == 68) {
                        EnterParam enterParam = EnterParam.of((String)"multivideo", (int)-1, null).entry(66).build();
                        ((IRoomService)ServiceManagerProxy.getServiceManager().getService(IRoomService.class)).enterRoom(enterParam);
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.multi_video_match_room_finish), (int)0);
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20045525").put("function_id", "automatically_match_toast_show").put("uid", String.valueOf(AccountUtil.getUid())));
                        return;
                    }
                    if (requestParams.entry == 24) {
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_FORCE_LIVE_MSG, requestParams.extra.get("multivideo_swipe_type")));
                        return;
                    }
                    ForceLeaveDialog dialog2 = new ForceLeaveDialog();
                    DialogLinkManager dialogLinkManager = new DialogLinkManager(MyChannelJoinCallback.this.context);
                    dialog2.setOnDialogListener(() -> {
                        dialogLinkManager.dismissDialog();
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20045047").put("function_id", "room_enter_click"));
                        EnterParam enterParam = EnterParam.of((String)"multivideo", (int)-1, null).entry(66).build();
                        ((IRoomService)ServiceManagerProxy.getService(IRoomService.class)).enterRoom(enterParam);
                    });
                    dialogLinkManager.showDialog((BaseDialog)dialog2);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onFailClientHardwareBad(EnterParam requestParams, String msgTip) {
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onFailClientHardwareBad(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onFailNumberNoArrow(EnterParam requestParams, String msgTip) {
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onFailNumberNoArrow(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(ECode.ONLY_ARROW_MEMBER_ENTER.getValue(), "");
            }

            public void onFailChannelShowNumLimit(EnterParam requestParams, String msgTip) {
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onFailChannelShowNumLimit(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onInBlackList(EnterParam requestParams, String msgTip) {
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onInBlackList(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onInOwnerBlackList(EnterParam requestParams, String msgTip) {
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onInOwnerBlackList(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onFailSensitive(EnterParam requestParams, String msgTip) {
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onFailSensitive(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onOtherError(EnterParam requestParams, String msgTip) {
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onOtherError(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onError(EnterParam requestParams, int errorCode, String errorTips, Exception e) {
                MLog.error((Object)MyChannelJoinCallback.this.logTag, (String)"JoinCallBack on other error,cid:%s,gameid:%s,errorCode:%d,errorTips:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : "", errorCode, errorTips});
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onError(requestParams, errorCode, errorTips, e);
                }
                MyChannelJoinCallback.this.onJoinError(errorCode, "");
            }

            public void onNotMatchChannel(EnterParam param2) {
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onNotMatchChannel(param2);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onEnterLimitPopWindow(EnterParam param2, String errmsg) {
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onEnterLimitPopWindow(param2, errmsg);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onModifyChannelLimit() {
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onModifyChannelLimit();
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }

            public void onAgeLimit(EnterParam requestParams, String msgTip) {
                if (MyChannelJoinCallback.this.callback != null && !MyChannelJoinCallback.this.callback.isDestroy()) {
                    MyChannelJoinCallback.this.callback.getJoinErrorHandler(MyChannelJoinCallback.this.getEnterParam()).onAgeLimit(requestParams, msgTip);
                }
                MyChannelJoinCallback.this.onJoinError(-1, "");
            }
        };
    }

    private void onJoinError(int errorCode, String errorTips) {
        if (this.callback != null) {
            this.callback.onJoinError(errorCode, errorTips);
        }
    }

    EnterParam getEnterParam() {
        return this.callback.getEnterParam();
    }

    public static interface ICallBack {
        public boolean isDestroy();

        public EnterParam getEnterParam();

        public IChannel.IJoinCallBack getJoinErrorHandler(EnterParam var1);

        public void onJoinSuccess(EnterParam var1, EnterChannelData var2, IChannel var3);

        public void onJoinError(int var1, String var2);
    }
}

