/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.text.TextUtils;
import com.bumptech.glide.load.DecodeFormat;
import com.yy.appbase.common.CommonCallback;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.transform.BlurTransformation;
import com.yy.base.imageloader.transform.YYBitmapTransformation;
import com.yy.base.imageloader.transform.YYCenterCrop;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.EnterParam;
import javax.annotation.Nullable;

public class LoadingBgHellper {
    public static final int BG_BLUR_RADIUS = 20;
    private static final String TAG = "LoadingBgHellper";
    private static String sCacheCoverUrl = "";

    private LoadingBgHellper() {
    }

    public static int getLoadingBgDefaultResId() {
        MLog.debug((Object)TAG, (String)"getLoadingBgDefaultResId", (Object[])new Object[0]);
        return R.drawable.icon_end_page_bg;
    }

    public static void preloadLoadingBgBy(Context context, EnterParam param2) {
        if (param2 == null) {
            return;
        }
        String url = (String)param2.getExtra("live_cover_url", (Object)"");
        if (StringUtils.isEmpty((String)url)) {
            MLog.debug((Object)TAG, (String)"preloadLoadingBgBy url is empty", (Object[])new Object[0]);
            return;
        }
        LoadingBgHellper.preloadLoadingBg(context, url, null);
    }

    public static void removedBgFromCacheBy(@Nullable String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        LoadingBgHellper.removeBgFromCache(url);
    }

    public static void preloadLoadingBg(Context context, String url, CommonCallback callback2) {
        BitmapDrawable bitmap = ImageLoader.getBitmapFromCache((String)url);
        if (bitmap != null && bitmap.getBitmap() != null && !bitmap.getBitmap().isRecycled()) {
            MLog.debug((Object)TAG, (String)"preloadLoadingBg has cache", (Object[])new Object[0]);
            if (callback2 != null) {
                callback2.onFinish();
            }
            return;
        }
        LoadingBgHellper.preloadLoadingBgInner(context, url, callback2);
    }

    public static void removeBgFromCache(String url) {
    }

    public static BitmapDrawable getBitmapDrawableFromCache(String url) {
        BitmapDrawable result;
        MLog.debug((Object)TAG, (String)"getBitmap from cache url: %s, lastUrl: %s", (Object[])new Object[]{url, sCacheCoverUrl});
        if (!TextUtils.isEmpty((CharSequence)sCacheCoverUrl) && !sCacheCoverUrl.equals(url)) {
            LoadingBgHellper.removedBgFromCacheBy(sCacheCoverUrl);
        }
        if ((result = ImageLoader.getBitmapFromCache((String)url)) != null) {
            MLog.info((Object)TAG, (String)"getBitmapDrawableFromCache success:%s!", (Object[])new Object[]{url});
            sCacheCoverUrl = url;
            return result;
        }
        MLog.info((Object)TAG, (String)"getBitmapDrawableFromCache fail:%s!", (Object[])new Object[]{url});
        return null;
    }

    private static void preloadLoadingBgInner(Context context, final String url, final CommonCallback callback2) {
        int bitmapWidth = ScreenUtils.getInstance().getWidthPixels() / 2;
        MLog.info((Object)TAG, (String)("preloadLoadingBgInner url: " + url), (Object[])new Object[0]);
        ImageLoader.withBitmap((Context)context, (String)url, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onLoadFailed(Exception e) {
                MLog.info((Object)LoadingBgHellper.TAG, (String)"preload fail:%s, reason:%s!", (Object[])new Object[]{url, e != null ? e.toString() : ""});
                if (callback2 != null) {
                    callback2.onFinish();
                }
            }

            public void onResourceReady(Bitmap bitmap) {
                MLog.info((Object)LoadingBgHellper.TAG, (String)("preload success url: " + url), (Object[])new Object[0]);
                if (callback2 != null) {
                    callback2.onFinish();
                }
            }
        }).useCacheForOrigin(true).setSize(bitmapWidth, bitmapWidth).setDecodeFormat(DecodeFormat.PREFER_RGB_565).setTransform(new YYBitmapTransformation[]{new YYCenterCrop(), new BlurTransformation(20)}).load();
    }
}

