/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter;

import android.content.Context;
import android.os.Message;
import android.text.TextUtils;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.ConfirmDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.dialog.OkCancelTitleDialog;
import com.yy.appbase.ui.dialog.OkDialogListener;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.bean.ChannelBannedData;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.create.CreateChannelParams;
import com.yy.hiyo.channel.base.hiido.ChannelBaseTrack;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.model.bean.LockInfo;
import com.yy.hiyo.channel.component.lock.LockPresenter;
import com.yy.hiyo.channel.module.recommend.base.IChannelPermitService;
import com.yy.hiyo.channel.module.recommend.base.bean.RoomCreatePermitBean;
import com.yy.hiyo.proto.ProtoManager;
import net.ihago.channel.srv.mgr.ECode;

public class ChannelJoinErrorHandler
implements IChannel.IJoinCallBack {
    private static final String TAG = "ChannelJoinErrorHandler";
    private Environment environment;
    private LockPresenter mLockPresenter;

    public ChannelJoinErrorHandler(Environment environment) {
        this.environment = environment;
    }

    private void handleJoinChannelFailedByNeedPassword(final EnterParam enterChannelParams) {
        if (this.mLockPresenter == null) {
            this.mLockPresenter = new LockPresenter(this.environment.getContext());
        }
        this.mLockPresenter.setChannelId(enterChannelParams.roomId);
        this.mLockPresenter.showDialog(1, ResourceUtils.getString((int)R.string.tips_room_lock_incorrect_pwd), new LockPresenter.LockCallback(){

            @Override
            public void unlockEnterRoom(String str) {
                ChannelJoinErrorHandler.this.mLockPresenter.hideIme();
                enterChannelParams.pwdToken = "";
                enterChannelParams.password = str;
                Message msg = Message.obtain();
                msg.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
                msg.obj = enterChannelParams;
                MsgDispatcher.getInstance().sendMessage(msg);
            }

            @Override
            public void updateLockInfo(LockInfo lockInfo) {
            }
        });
        RoomTrack.INSTANCE.showUserLock(enterChannelParams.roomId);
    }

    public void onSuccess(EnterParam requestParams, ChannelDetailInfo info, EnterChannelData data2) {
        if (this.mLockPresenter != null) {
            this.mLockPresenter.dissmissDialog();
        }
        if (data2 != null && data2.pluginData != null) {
            if (data2.pluginData.mode == 1 && info != null && info.baseInfo != null && info.baseInfo.isFamily()) {
                MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.ChannelMsgDef.CLOSE_CHANNEL_CREATE_WINDOW);
            } else {
                if (requestParams != null && info.baseInfo != null && AccountUtil.getUid() == info.baseInfo.ownerUid) {
                    SettingFlags.setStringValue((String)("key_last_entry_room" + AccountUtil.getUid()), (String)requestParams.roomId);
                }
                MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.ChannelMsgDef.CLOSE_ROOM_CREATE_WINDOW);
            }
        }
    }

    public void onFailByOnlineLimit(EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else if (!requestParams.isRoom) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_members_reach_limit), (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_room_members_reach_limit), (int)0);
        }
    }

    public void onFailByNeedPassword(EnterParam requestParams, String msgTip) {
        this.handleJoinChannelFailedByNeedPassword(requestParams);
    }

    public void onFailByPasswordError(EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        }
        this.handleJoinChannelFailedByNeedPassword(requestParams);
    }

    public void onKickOffFrozenError(EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else if (!requestParams.isRoom) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_kickoff_can_not_enter), (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_room_kickoff_can_not_enter), (int)0);
        }
    }

    public void onFailByChannelNotExist(EnterParam requestParams, String msgTip) {
        if (requestParams != null) {
            this.handleRoomEnterError(requestParams.roomId, msgTip);
        }
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else if (!requestParams.isRoom) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_not_exist), (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_room_not_exist), (int)0);
        }
    }

    private void handleRoomEnterError(String entryRoomId, String msgTip) {
        String roomId = SettingFlags.getStringValue((String)("key_last_entry_room" + AccountUtil.getUid()));
        if (!FP.empty((CharSequence)entryRoomId) && entryRoomId.equals(roomId)) {
            SettingFlags.removeKey((String)("key_last_entry_room" + AccountUtil.getUid()));
        }
    }

    public void onChannelBanned(EnterParam requestParams, ChannelBannedData bannedData, String msgTip) {
        if (requestParams != null) {
            this.handleRoomEnterError(requestParams.roomId, msgTip);
        }
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else if (!requestParams.isRoom) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_has_been_ban), (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_room_has_been_ban), (int)0);
        }
    }

    public void onFailByPasswordTryTooFrequently(EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_password_try_too_many), (int)0);
        }
    }

    public void onPrivateChannel(EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else if (!requestParams.isRoom) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_private_channel_can_not_enter), (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_private_room_can_not_enter), (int)0);
        }
    }

    public void onFailByInviteExpire(EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_enter_invalid_invitation), (int)0);
        }
    }

    public void onFailByInviteClickMaxLimit(EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_invitation_click_reach_limit), (int)0);
        }
    }

    public void onFailChannelMatchFail(EnterParam requestParams, String msgTip) {
        MLog.info((Object)TAG, (String)"join channel not match channel and show tip", (Object[])new Object[0]);
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else if (!requestParams.isRoom) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_no_match), (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_room_no_match), (int)0);
        }
    }

    public void onFailChannelAllDisBand(EnterParam requestParams, String msgTip) {
        RoomCreatePermitBean bean2;
        if (this.mLockPresenter != null) {
            this.mLockPresenter.dissmissDialog();
        }
        boolean hasCreateMultiVideoRoom = false;
        if (ServiceManagerProxy.getServiceManager() != null && (bean2 = (RoomCreatePermitBean)((IChannelPermitService)ServiceManagerProxy.getServiceManager().getService(IChannelPermitService.class)).getCreatePermit().getValue()) != null) {
            hasCreateMultiVideoRoom = bean2.isCanCreateMulti();
        }
        Message message = Message.obtain();
        message.what = AppbaseMsgDef.ChannelMsgDef.OPEN_ROOM_CREATE;
        message.obj = CreateChannelParams.obtain((String)"", (int)CreateChannelParams.From.channel_list_panel);
        message.arg1 = hasCreateMultiVideoRoom ? 1 : -1;
        MsgDispatcher.getInstance().sendMessage(message);
        ChannelBaseTrack.INSTANCE.reportNewRoomClick(3);
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_all_disband), (int)0);
        }
    }

    public void onRetryUnBannedChannel(String channelId, EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        }
        EnterParam enterParam = EnterParam.of((String)channelId).build();
        Message msg = Message.obtain();
        msg.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
        msg.obj = enterParam;
        MsgDispatcher.getInstance().sendMessage(msg);
    }

    public void onCrossRegionNotAllow(EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.short_tips_gloabal_force_leave), (int)0);
        }
    }

    public void onFailEnterMultiVideoRoom(EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        }
    }

    public void onFailClientHardwareBad(EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_multi_video_error), (int)0);
        }
    }

    public void onFailNumberNoArrow(EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_join_number_no_arrow), (int)0);
        }
    }

    public void onFailChannelShowNumLimit(EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_join_number_no_arrow), (int)0);
        }
    }

    public void onInBlackList(EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        }
        ConfirmDialog dialog2 = ConfirmDialog.newBuilder().canceledOnClickOutside(true).withCloseBtn(true).confirmLabel((CharSequence)ResourceUtils.getString((int)R.string.tips_black_enter_ok)).message((CharSequence)ResourceUtils.getString((int)R.string.tips_black_enter)).build();
        new DialogLinkManager(this.environment.getContext()).showDialog((BaseDialog)dialog2);
    }

    public void onInOwnerBlackList(EnterParam requestParams, String msgTip) {
        String tips = ResourceUtils.getString((int)R.string.tips_enter_channel_fail_by_black, (Object[])new Object[]{""});
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            tips = msgTip;
        }
        ConfirmDialog dialog2 = ConfirmDialog.newBuilder().canceledOnClickOutside(true).withCloseBtn(true).confirmLabel((CharSequence)ResourceUtils.getString((int)R.string.tips_black_enter_ok)).message((CharSequence)tips).build();
        new DialogLinkManager(this.environment.getContext()).showDialog((BaseDialog)dialog2);
    }

    public void onFailSensitive(EnterParam requestParams, String msgTip) {
        if (!TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)msgTip, (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_contain_sensitive_word), (int)0);
        }
    }

    public void onOtherError(EnterParam requestParams, String msgTip) {
        if (TextUtils.isEmpty((CharSequence)msgTip)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_server_error), (int)0);
        }
    }

    public void onError(EnterParam requestParams, int errorCode, String msgTip, Exception e) {
        MLog.info((Object)TAG, (String)("error code: " + errorCode), (Object[])new Object[0]);
        if (requestParams.entry == 41) {
            if (!requestParams.isRoom) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_user_not_in_channel), (int)0);
            } else {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_user_not_in_room), (int)0);
            }
        } else if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.str_network_not_capable), (int)0);
        } else if (!ProtoManager.getInstance().isWSConnected()) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
        } else if (errorCode == ECode.SEAT_FULL.getValue()) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.short_tips_seat_full), (int)0);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_unknown_error), (int)0);
        }
    }

    public void onNotMatchChannel(final EnterParam param2) {
        MLog.info((Object)TAG, (String)"join channel not match channel and show dialog", (Object[])new Object[0]);
        OkCancelTitleDialog dialog2 = new OkCancelTitleDialog.Builder().okLabel((CharSequence)ResourceUtils.getString((int)R.string.dialog_ok)).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_cancel)).message((CharSequence)ResourceUtils.getString((int)R.string.tip_create_game_room)).listener(new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                Message msg = Message.obtain();
                msg.what = AppbaseMsgDef.ChannelMsgDef.CREATE_GAME_MATCH_ROOM;
                msg.obj = param2.gameInfo.gid;
                MsgDispatcher.getInstance().sendMessage(msg);
            }
        }).build();
        new DialogLinkManager(this.environment.getContext()).showDialog((BaseDialog)dialog2);
    }

    public void onEnterLimitPopWindow(EnterParam param2, String errmsg) {
        MLog.error((Object)TAG, (String)"onEnterLimitPopWindow param:%s, msgh:%s", (Object[])new Object[]{param2, errmsg});
        ConfirmDialog dialog2 = ConfirmDialog.newBuilder().confirmLabel((CharSequence)ResourceUtils.getString((int)R.string.dialog_ok)).message((CharSequence)errmsg).confirmListener(new OkDialogListener(){

            public void onOk() {
            }
        }).build();
        new DialogLinkManager(this.environment.getContext()).showDialog((BaseDialog)dialog2);
    }

    public void onModifyChannelLimit() {
        MLog.error((Object)TAG, (String)"onModifyChannelLimit ", (Object[])new Object[0]);
    }

    public void onAgeLimit(EnterParam requestParams, String msgTip) {
        if (TextUtils.isEmpty((CharSequence)msgTip)) {
            MLog.error((Object)TAG, (String)"The tip of onAgeLimit is empty", (Object[])new Object[0]);
            return;
        }
        TopToastUtils.showToast((CharSequence)msgTip, (int)ResourceUtils.getColor((int)R.color.error_toast_bg), (long)4000L, (int)20, (float)0.0f, (boolean)false);
    }
}

