/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main;

import android.content.Context;
import android.text.TextUtils;
import biz.PluginInfo;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.AbsChannelDrawerWindow;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.module.main.IChannelWindowCallback;

public class ChannelWindow
extends AbsChannelDrawerWindow {
    private static final String TAG = "ChannelWindow";
    public AbsPage curPage;
    private boolean shown;
    private boolean attached;
    private String mChannelId;
    private int pluginType = -1;

    public ChannelWindow(Context context, EnterParam enterParam, IChannelWindowCallback callBacks, boolean slide) {
        super(context, (UICallBacks)callBacks, TAG, slide);
        this.setIsNeedDetachWatch(false);
        this.setWindowType(114);
        this.shown = false;
        this.mChannelId = enterParam.roomId;
        this.checkHIdeNavBar(enterParam);
        this.setCoverSlidingMode(this.isRadioMode(enterParam));
    }

    public void setMainPage(AbsPage absPage) {
        AbsPage fCurPage;
        MLog.info((Object)TAG, (String)"setMainPage %s, attached %b, shown %b", (Object[])new Object[]{absPage, this.attached, this.shown});
        boolean isFirstAttach = this.curPage == null;
        this.curPage = absPage;
        this.curPage.beforeWindowShow();
        super.setMainPage(absPage);
        this.curPage.onAttach();
        if (this.shown) {
            fCurPage = this.curPage;
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (fCurPage == ChannelWindow.this.curPage && fCurPage != null) {
                        fCurPage.onWindowShown();
                    }
                }
            });
        }
        if (!this.attached && !isFirstAttach) {
            fCurPage = this.curPage;
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (fCurPage == ChannelWindow.this.curPage && fCurPage != null) {
                        fCurPage.onDetached();
                    }
                }
            });
        }
    }

    public void removeCurPage() {
        try {
            if (this.curPage != null) {
                this.getDrawerLayout().removeViewInLayout(this.curPage.getPageView());
                this.curPage = null;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void handleForeground(boolean isForeground) {
        MLog.info((Object)TAG, (String)"handleForeground %b", (Object[])new Object[]{isForeground});
        if (this.curPage != null && this.attached) {
            if (isForeground) {
                this.onShown();
            } else {
                this.onHidden();
            }
        }
    }

    public void onShown() {
        super.onShown();
        this.shown = true;
        MLog.info((Object)("ChannelWindow__" + this.mChannelId), (String)("onShown " + this.shown), (Object[])new Object[0]);
        if (this.curPage != null) {
            this.curPage.onWindowShown();
        }
    }

    public void beforeHide() {
        super.beforeHide();
        if (this.curPage != null) {
            this.curPage.beforeWindowHide();
        }
    }

    public void onHidden() {
        super.onHidden();
        MLog.info((Object)("ChannelWindow__" + this.mChannelId), (String)("onHidden " + this.shown), (Object[])new Object[0]);
        this.shown = false;
        if (this.curPage != null) {
            this.curPage.onWindowHidden();
        }
    }

    public void onDetached() {
        super.onDetached();
        MLog.info((Object)("ChannelWindow__" + this.mChannelId), (String)("onDetached " + this.attached), (Object[])new Object[0]);
        this.attached = false;
        if (this.curPage != null) {
            this.curPage.onDetached();
        }
    }

    public void onAttach() {
        super.onAttach();
        this.attached = true;
        MLog.info((Object)("ChannelWindow__" + this.mChannelId), (String)("onAttach " + this.attached), (Object[])new Object[0]);
        if (this.curPage != null) {
            this.curPage.onAttach();
        }
    }

    public String getName() {
        return TAG;
    }

    public String getCoexistenceVoiceChannel() {
        if (this.mCallBacks != null && this.mCallBacks instanceof IChannelWindowCallback) {
            return ((IChannelWindowCallback)this.mCallBacks).getCoexistenceVoiceChannel();
        }
        return "";
    }

    public boolean isTranslucentBar() {
        return true;
    }

    private boolean isBaseMode() {
        int mode = -1;
        IChannel channel = ((IChannelCenterService)ServiceManagerProxy.getInstance().getService(IChannelCenterService.class)).getChannel(this.mChannelId);
        if (channel != null) {
            mode = channel.getPluginService().getCurPluginData().getMode();
        }
        return mode == 1;
    }

    private boolean isRadioMode(EnterParam enterParam) {
        int mode = (Integer)enterParam.getExtra("pluginType", (Object)-1);
        return mode == 14;
    }

    public boolean isDarkMode() {
        return this.isBaseMode();
    }

    private void checkHIdeNavBar(EnterParam enterParam) {
        PluginInfo pluginInfo;
        if (enterParam.showInfo != null && (pluginInfo = enterParam.showInfo.plugin_info) != null) {
            this.pluginType = pluginInfo.type;
        }
        boolean isVideoMode = this.pluginType == 14 || this.pluginType == 15;
        boolean isFirstCreateVoiceRoom = SettingFlags.getBoolean((String)"first_crate_voice", (boolean)true);
        if (!isVideoMode && TextUtils.isEmpty((CharSequence)this.mChannelId) && isFirstCreateVoiceRoom) {
            this.mWindowInfo.setsNeedHideNavigationBar(false);
            SettingFlags.setBoolean((String)"first_crate_voice", (boolean)false);
        } else {
            this.mWindowInfo.setsNeedHideNavigationBar(NAB.B.equals((Object)NewABDefine.HIDE_NAV_BAR.getTest()));
        }
        if (this.pluginType == 1 || this.isBaseMode()) {
            this.mWindowInfo.setsNeedHideNavigationBar(false);
        }
    }
}

